/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.Serializable;
import java.util.Map;

public class Activity
implements Serializable {
    static final long serialVersionUID = 2749063857421365209L;
    public static final String ACTIVITY_CALL_INBOUND = "inbound";
    public static final String ACTIVITY_CALL_OUTBOUND = "outbound";
    public static final String ACTIVITY_CALL_MISSED = "missed";
    public static final String ACTIVITY_CALLBACK = "callback";
    public static final String ACTIVITY_WEB_CHAT = "WebChat";
    public static final String ACTIVITY_FILE_SENT = "sent";
    public static final String ACTIVITY_FILE_RECEIVED = "received";
    public static final String ACTIVITY_EMAIL_IN = "Email";
    public static final String ACTIVITY_EMAIL_OUT = "EmailOut";
    public static final String ACTIVITY_MEETING = "meeting";
    public static final String ACTIVITY_MAIL = "mail";
    public static final String ACTIVITY_TASK = "task";
    public static final String ACTIVITY_UPDATE = "update";
    public static final String ACTIVITY_COMMENT = "comment";
    public static final String ACTIVITY_MESSENGER = "FacebookMessenger";
    public static final String ACTIVITY_FACEBOOK = "Facebook";
    public static final String ACTIVITY_TELEGRAM = "Telegram";
    public static final String ACTIVITY_TWITTER = "Twitter";
    public static final String ACTIVITY_SKYPE = "Skype";
    public static final String ACTIVITY_VIBER = "Viber";
    public static final int SUBJECT_INTERNAL = 0;
    public static final int SUBJECT_ACTIVITY = 1;
    public static final int SUBJECT_EMAIL = 2;
    public static final int SUBJECT_MESS = 3;
    private String id;
    private String type;
    private String userid;
    private long timestart;
    private long timestop;
    private long timedue;
    private long timeassign;
    private long queuetime;
    private long updated;
    private String owner;
    private String ownerid;
    private String channel;
    private String comment;
    private String subject;
    private String ext;
    private String group;
    private String sessionid;
    private String messageid;
    private String refsrc;
    private String file;
    private String ref;

    protected Activity(String type) {
        this.type = type;
    }

    protected Activity(Map map) {
        Number duration;
        Number ts;
        this.id = (String)map.get("activityid");
        if (this.id == null) {
            this.id = (String)map.get("id");
        }
        this.type = (String)map.get("type");
        this.ownerid = (String)map.get("owner");
        this.channel = (String)map.get("channel");
        this.subject = (String)map.get("subject");
        if (this.subject == null) {
            this.subject = (String)map.get("content");
        }
        if (this.subject != null) {
            this.subject = this.subject.replace("\\\"", "\"");
        }
        this.comment = (String)map.get(ACTIVITY_COMMENT);
        if (this.comment != null) {
            this.comment = this.comment.replace("\\r", "\r");
            this.comment = this.comment.replace("\\n", "\n");
            this.comment = this.comment.replace("\\\"", "\"");
        }
        if ((ts = (Number)map.get("timestart")) != null) {
            this.timestart = ts.longValue();
        }
        if ((ts = (Number)map.get("timedue")) != null) {
            this.timedue = ts.longValue();
        }
        if ((ts = (Number)map.get("timestop")) != null) {
            this.timestop = ts.longValue();
        }
        if ((ts = (Number)map.get("timeassign")) != null) {
            this.timeassign = ts.longValue();
        }
        if ((ts = (Number)map.get("queuetime")) != null) {
            this.queuetime = ts.longValue();
        }
        if ((ts = (Number)map.get("updated")) != null) {
            this.updated = ts.longValue();
        }
        if ((duration = (Number)map.get("duration")) != null && this.timestop == 0L) {
            if (this.timedue == 0L) {
                this.timedue = this.timestart;
            }
            this.timestop = this.timedue + duration.longValue() * 1000L;
        }
        this.ext = (String)map.get("ext");
        if (this.ext == null) {
            this.ext = this.type.equals(ACTIVITY_CALL_INBOUND) ? (String)map.get("caller") : (this.type.equals(ACTIVITY_CALL_OUTBOUND) ? (String)map.get("called") : (String)map.get("phone"));
        }
        this.group = (String)map.get("group");
        this.sessionid = (String)map.get("sessionid");
        this.messageid = (String)map.get("messageid");
        this.file = (String)map.get("file");
        this.ref = (String)map.get("ref");
        this.refsrc = (String)map.get("refsrc");
    }

    protected long getLastUpdatedTime() {
        return Math.max(Math.max(this.updated, this.timestop), this.timestart);
    }

    protected void setUserId(String userid) {
        this.userid = userid;
    }

    protected String getUserId() {
        return this.userid;
    }

    public String getType() {
        return this.type;
    }

    public String getOwnerId() {
        return this.ownerid;
    }

    protected void setChannel(String str) {
        this.channel = str;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setSubject(String str) {
        this.subject = str;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getOwnerName() {
        return this.owner;
    }

    protected void setOwnerName(String str) {
        this.owner = str;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getRef() {
        return this.ref;
    }

    public void setComment(String txt) {
        this.comment = txt;
    }

    public String getComment() {
        return this.comment;
    }

    protected void setTimestart(long ts) {
        this.timestart = ts;
    }

    public long getTimestart() {
        return this.timestart;
    }

    protected void setTimestop(long ts) {
        this.timestop = ts;
    }

    public long getTimestop() {
        return this.timestop;
    }

    protected void setTimeAssign(long ts) {
        this.timeassign = ts;
    }

    public long getTimeAssign() {
        return this.timeassign;
    }

    public long getAssignedDuration() {
        if (this.timeassign == 0L) {
            return 0L;
        }
        if (this.timestop != 0L) {
            return this.timestop - this.timeassign;
        }
        return System.currentTimeMillis() - this.timeassign;
    }

    public long getTotalDuration() {
        if (this.timestop != 0L) {
            return this.timestop - this.timestart;
        }
        return System.currentTimeMillis() - this.timestart;
    }

    public void setTimedue(long ts) {
        this.timedue = ts;
    }

    public long getTimedue() {
        return this.timedue;
    }

    protected void setExtInfo(String txt) {
        this.ext = txt;
    }

    public String getExtInfo() {
        return this.ext;
    }

    public String getGroup() {
        return this.group;
    }

    protected void setSessionId(String txt) {
        this.sessionid = txt;
    }

    protected String getSessionId() {
        return this.sessionid;
    }

    protected void setMessageId(String txt) {
        this.messageid = txt;
    }

    public String getMessageId() {
        return this.messageid;
    }

    public String getApplicationUrl() {
        return this.refsrc;
    }

    public String getServiceId() {
        int n;
        if (this.ref != null && (n = this.ref.indexOf("@")) != -1) {
            return this.ref.substring(n + 1);
        }
        return null;
    }

    public String getFile() {
        return this.file;
    }

    protected void update(Activity activity) {
        this.timedue = activity.timedue;
        this.subject = activity.subject;
        this.comment = activity.comment;
    }

    public boolean equals(Object obj) {
        return obj instanceof Activity && this.id.equals(((Activity)obj).id);
    }

    public String toString() {
        return "Activity " + this.type + " subject=" + this.subject + " owner=" + this.owner + " sid=" + this.sessionid;
    }
}

