/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.File;
import smile.cti.client.FileInfo;

public class CloudFile
extends File {
    public static final File ROOT = new CloudFile("Cloud");
    private long size;
    private String name;
    private String owner;
    private boolean canwrite;

    protected CloudFile(String dir) {
        super(dir);
        this.name = dir;
    }

    protected CloudFile(File dir, String owner) {
        super(dir, owner);
        this.name = owner;
        this.owner = owner;
    }

    protected CloudFile(File dir, String name, String owner, boolean canwrite) {
        super(dir, owner + "-" + name);
        this.name = name;
        this.owner = owner;
        this.canwrite = canwrite;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getResourceName() {
        String resource = this.owner + "-" + this.name;
        if (!this.exists() && FileInfo.isImage(this.name)) {
            resource = resource + ".jpg";
        }
        return resource;
    }

    protected void setTimestamp(long timestamp) {
        if (super.exists()) {
            if (timestamp - this.lastModified() > 1001L) {
                this.setLastModified(timestamp - 1001L);
            }
        } else {
            try {
                this.createNewFile();
                this.setLastModified(timestamp - 1001L);
            }
            catch (Exception e) {
                System.out.println(this.getPath() + " - " + e.toString());
            }
        }
    }

    protected void setSize(long size) {
        this.size = size;
    }

    @Override
    public boolean canWrite() {
        return this.canwrite;
    }

    @Override
    public boolean exists() {
        return super.exists() && super.length() > 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.size == ((File)obj).length();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

