/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import smile.cti.client.Activity;
import smile.cti.client.ContactEventListener;
import smile.cti.client.MessageInfo;
import smile.util.CountryCodes;
import smile.util.Utils;

public class ContactInfo
implements Comparable,
Serializable,
Cloneable {
    static final long serialVersionUID = 2385198523581235015L;
    public static final int STATE_OFFLINE = 0;
    public static final int STATE_ONLINE = 1;
    public static final int STATE_AWAY = 2;
    public static final int STATE_BUSY = 3;
    public static final int STATE_INVISIBLE = 4;
    public static final int STATE_FOLLOWME = 5;
    public static final int STATE_DIALING = 6;
    public static final int STATE_RINGING = 7;
    public static final int STATE_CONNECTED = 8;
    public static final int STATE_UNDEFINED = -1;
    public static final int STATUS_NOTAUTH = 0;
    public static final int STATUS_REQUESTED = 1;
    public static final int STATUS_WAITING = 2;
    public static final int STATUS_DISABLED = 3;
    public static final int STATUS_APPROVED = 4;
    public static final int STATUS_WHITELIST = 5;
    public static final int STATUS_CHANNEL = 10;
    public static final int STATUS_FAVORITE = 16;
    public static final int STATUS_CONTACT = 0;
    public static final int STATUS_USER_ADMIN = 126;
    public static final int STATUS_APPLICATION = 127;
    public static final int STATUS_APPLICATION_ADMIN = 128;
    public static final int STATUS_SYSTEM_ADMIN = 129;
    public static final String USERID = "User ID";
    public static final String GROUP = "Group";
    public static final String ABOUT = "About";
    public static final String LOGIN = "login";
    public static final String DISPLAYNAME = "displayname";
    public static final String FIRSTNAME = "FirstName";
    public static final String LASTNAME = "LastName";
    public static final String FULLNAME = "FullName";
    public static final String NICKNAME = "NickName";
    public static final String PREFIX = "Prefix";
    public static final String SUFFIX = "Suffix";
    public static final String JOBTITLE = "JobTitle";
    public static final String POSITION = "Position";
    public static final String ORGANIZATION = "Organization";
    public static final String COMPANY = "Company";
    public static final String BRANCH = "Branch";
    public static final String DEPARTMENT = "Department";
    public static final String COUNTRY = "Country";
    public static final String STATE = "State";
    public static final String CITY = "City";
    public static final String STREET = "Street";
    public static final String POSTALCODE = "PostalCode";
    public static final String LANGUAGE = "Language";
    public static final String BIRTHDAY = "Birthday";
    public static final String GENDER = "Gender";
    public static final String BALANCE = "Balance";
    public static final String TAGS = "Tags";
    public static final String LINK = "Link";
    public static final String SIP = "SIP";
    public static final String MOBILE = "Mobile";
    public static final String PHONE = "Phone";
    public static final String FAX = "Fax";
    public static final String EMAIL = "Email";
    public static final String WEB = "Web";
    public static final String SOCIAL = "SocialNetwork";
    public static final String BUSINESSPHONE = "BusinessPhone";
    public static final String PRIVATEPHONE = "PrivatePhone";
    public static final String BUSINESSMOBILE = "BusinessMobile";
    public static final String PRIVATEMOBILE = "PrivateMobile";
    public static final String BUSINESSFAX = "BusinessFax";
    public static final String PRIVATEFAX = "PrivateFax";
    public static final String BUSINESSEMAIL = "BusinessEmail";
    public static final String PRIVATEEMAIL = "PrivateEmail";
    public static final String BUSINESSWEB = "BusinessWeb";
    public static final String PRIVATEWEB = "PrivateWeb";
    public static final String ADDRESS = "Address";
    public static final String BUSINESSADDRESS = "BusinessAddress";
    public static final String PRIVATEADDRESS = "PrivateAddress";
    public static final String[] KEYS = new String[]{"Organization", "JobTitle", "Company", "Department", "Position", "Mobile", "BusinessMobile", "PrivateMobile", "BusinessPhone", "PrivatePhone", "Phone", "SIP", "Email", "BusinessEmail", "PrivateEmail", "Web", "Fax"};
    public static final String[] MESSENGER_KEYS = new String[]{"FacebookMessenger", "Skype", "Viber", "Telegram"};
    private static HashMap keys = new HashMap();
    private String id;
    private String userid;
    private String number;
    private int state = -1;
    private long stime;
    private String note;
    private File imageFile;
    private int status = -1;
    private int userStatus;
    private long sttime;
    private boolean owner;
    private Map settings;
    private Map properties;
    private List<Detail> userDetails = new Vector<Detail>();
    private List<Detail> customDetails = new Vector<Detail>();
    private transient Set<ContactEventListener> listeners = new HashSet<ContactEventListener>();
    private transient Map tmpvalues = new HashMap();
    private transient String conferenceStatus;
    private transient int conferenceState;
    private String countryCode;
    private String localid;
    private long imgdate = -1L;
    private long hash;
    private List<Activity> activities = new Vector<Activity>();
    private List<String> tags = new Vector<String>();
    private List<String> utags = new Vector<String>();
    private Map links = new HashMap();
    private boolean updating;
    private boolean customsd;
    private boolean gsmdial;
    private String speeddial;

    public static ContactInfo createContact(String id) {
        ContactInfo contactInfo = new ContactInfo();
        contactInfo.setLocalId(id);
        return contactInfo;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new HashSet<ContactEventListener>();
        this.tmpvalues = new HashMap();
        if (this.activities == null) {
            this.activities = new Vector<Activity>();
        }
        if (this.tags == null) {
            this.tags = new Vector<String>();
        }
        if (this.utags == null) {
            this.utags = new Vector<String>();
        }
        if (this.links == null) {
            this.links = new HashMap();
        }
        if (this.settings == null) {
            this.settings = new HashMap();
        }
    }

    protected ContactInfo() {
        this.settings = new HashMap();
        this.properties = new HashMap();
    }

    protected ContactInfo(String uid) {
        this.userid = uid;
        this.settings = new HashMap();
        this.properties = new HashMap();
    }

    protected ContactInfo(Map map) {
        this(map, false);
    }

    protected ContactInfo(Map map, boolean owner) {
        this((String)map.get("userid"), map, owner);
    }

    protected ContactInfo(String uid, Map map) {
        this(uid, map, false);
    }

    protected ContactInfo(String uid, Map map, boolean owner) {
        this.owner = owner;
        this.userid = uid;
        if ("".equals(this.userid)) {
            this.userid = null;
        }
        this.id = (String)map.get("id");
        if (this.id == null) {
            this.id = (String)map.get("oid");
        }
        if (this.id == null) {
            this.id = (String)map.get("contactid");
        }
        this.settings = new HashMap();
        this.properties = new HashMap();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            this.setProperty(key, val);
        }
    }

    protected void buildUserDetails(Map map) {
        this.userDetails.clear();
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (obj instanceof List) {
                int i;
                List array = (List)obj;
                if (key.equalsIgnoreCase(TAGS)) {
                    this.utags = new Vector<String>(array);
                    continue;
                }
                if (key.equalsIgnoreCase(LINK)) {
                    for (i = 0; i < array.size(); ++i) {
                        Map m = (Map)array.get(i);
                        this.links.put(m.get("title"), m.get("value"));
                    }
                    continue;
                }
                for (i = 0; i < array.size(); ++i) {
                    this.userDetails.add(new Detail(key, array.get(i), true));
                }
                continue;
            }
            if (key.equals("settings")) {
                if (!(obj instanceof Map)) continue;
                this.settings = (Map)obj;
                continue;
            }
            this.userDetails.add(new Detail(key, obj, true));
        }
    }

    protected void buildCustomDetails(Map map) {
        this.customDetails.clear();
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (obj instanceof List) {
                int i;
                List array = (List)obj;
                if (key.equalsIgnoreCase(TAGS)) {
                    this.tags = new Vector<String>(array);
                    continue;
                }
                if (key.equalsIgnoreCase(LINK)) {
                    for (i = 0; i < array.size(); ++i) {
                        Map m = (Map)array.get(i);
                        this.links.put(m.get("title"), m.get("value"));
                    }
                    continue;
                }
                for (i = 0; i < array.size(); ++i) {
                    this.customDetails.add(new Detail(key, array.get(i)));
                }
                continue;
            }
            this.customDetails.add(new Detail(key, obj));
        }
    }

    protected void updateUserDetails(Map map) {
        for (String key : map.keySet()) {
            Object value = map.get(key);
            this.setUserDetail(key, value);
        }
    }

    public void restoreCustomDetails() {
        Map usinfo = (Map)this.properties.get("usinfo");
        if (usinfo != null) {
            this.buildCustomDetails(usinfo);
        }
    }

    protected Map getLinks() {
        return this.links;
    }

    protected Map getSettings() {
        return this.settings;
    }

    public Set<ContactEventListener> getContactEventListeners() {
        return this.listeners;
    }

    public void addListener(ContactEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ContactEventListener listener) {
        this.listeners.remove(listener);
    }

    protected File getImageFile() {
        return this.imageFile;
    }

    public boolean hasAvatar() {
        return this.imageFile != null;
    }

    public String getName() {
        String name = (String)this.properties.get("name");
        if (name == null || name.length() == 0) {
            name = this.getDisplayName();
        }
        if (name == null || name.length() == 0) {
            name = this.getFullName();
        }
        if (name == null || name.length() == 0) {
            name = this.getUsername();
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public String getFullName() {
        Object name = null;
        String name1 = (String)this.getFirstNameDetail().value;
        String name2 = (String)this.getLastNameDetail().value;
        if (name1 != null && name1.length() > 0) {
            name = name1;
            if (name2 != null && name2.length() > 0) {
                name = (String)name + " " + name2;
            }
        } else if (name2 != null && name2.length() > 0) {
            name = name2;
        }
        return name;
    }

    public String getFirstName() {
        return (String)this.getFirstNameDetail().value;
    }

    public String getLastName() {
        return (String)this.getLastNameDetail().value;
    }

    public String getDisplayName() {
        Detail detail;
        String name = (String)this.properties.get(DISPLAYNAME);
        if ((name == null || name.length() == 0) && (detail = this.getUserDetail(DISPLAYNAME)) != null) {
            name = detail.toString();
        }
        return name;
    }

    public boolean matches(String filter) {
        String name = (String)this.properties.get("name");
        if (name != null && name.toLowerCase().startsWith(filter.toLowerCase())) {
            return true;
        }
        String name1 = (String)this.getFirstNameDetail().value;
        if (name1 != null && name1.toLowerCase().startsWith(filter.toLowerCase())) {
            return true;
        }
        String name2 = (String)this.getLastNameDetail().value;
        if (name2 != null && name2.toLowerCase().startsWith(filter.toLowerCase())) {
            return true;
        }
        String diplayname = this.getDisplayName();
        if (diplayname != null && diplayname.toLowerCase().startsWith(filter.toLowerCase())) {
            return true;
        }
        Detail detail = this.getUserDetail(LOGIN);
        return detail != null && (name = detail.toString()) != null && name.toLowerCase().startsWith(filter.toLowerCase());
    }

    public String findPhoneNumbers(String phone) {
        Detail detail;
        int i;
        Object str = "";
        String ext = (String)this.properties.get("extension");
        if (ext == null) {
            ext = (String)this.properties.get("ext");
        }
        if (ext != null && ext.contains(phone)) {
            str = (String)str + ext + " ";
        }
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            if (!detail.isPhoneNumber() || !detail.pn.contains(phone)) continue;
            str = (String)str + detail.pn + " ";
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            if (!detail.isPhoneNumber() || !detail.pn.contains(phone)) continue;
            str = (String)str + detail.pn + " ";
        }
        return str;
    }

    public String getLocation() {
        Object name = null;
        String name1 = (String)this.getUserDetail((String)COUNTRY).value;
        String name2 = (String)this.getUserDetail((String)CITY).value;
        if (name1 != null && name1.length() > 0) {
            name = name1;
            if (name2 != null && name2.length() > 0) {
                name = (String)name + ", " + name2;
            }
        } else if (name2 != null && name2.length() > 0) {
            name = name2;
        }
        return name;
    }

    public String getCreated() {
        Detail detail = this.getUserDetail("created");
        if (detail == null) {
            return "";
        }
        return DateFormat.getDateInstance(2).format(new Date(((Number)detail.getValue()).longValue()));
    }

    public String getBirthday() {
        Object value = this.properties.get(BIRTHDAY);
        if (value == null) {
            Detail detail = this.getUserDetail(BIRTHDAY);
            if (detail == null) {
                return null;
            }
            value = detail.getValue();
        }
        if (value instanceof Number) {
            return DateFormat.getDateInstance(2).format(new Date(((Number)value).longValue()));
        }
        return value.toString();
    }

    public Date getBirthdayDate() {
        Detail detail = this.getUserDetail(BIRTHDAY);
        if (detail == null) {
            return null;
        }
        return new Date(((Number)detail.getValue()).longValue());
    }

    public void setBirthdayDate(Date date) {
        Detail detail = this.getUserDetail(BIRTHDAY);
        if (detail == null) {
            detail = new Detail(BIRTHDAY, date.getTime(), true);
            this.userDetails.add(detail);
        } else {
            detail.setValue(date.getTime());
        }
    }

    public int getGenderValue() {
        Object value = this.properties.get(BIRTHDAY);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        Detail detail = this.getUserDetail(GENDER);
        if (detail == null) {
            return 0;
        }
        return ((Number)detail.getValue()).intValue();
    }

    public void setGenderValue(int value) {
        Detail detail = this.getUserDetail(GENDER);
        if (detail == null) {
            detail = new Detail(GENDER, value, true);
            this.userDetails.add(detail);
        } else {
            detail.setValue(value);
        }
    }

    public String getCountry() {
        Object value = this.properties.get(COUNTRY);
        if (value != null) {
            return value.toString();
        }
        Detail detail = this.getUserDetail(COUNTRY);
        if (detail == null) {
            return null;
        }
        return detail.toString();
    }

    public void setCountry(String value) {
        this.setUserDetail(COUNTRY, value);
    }

    public String getLanguage() {
        Object value = this.properties.get(LANGUAGE);
        if (value != null) {
            return value.toString();
        }
        Detail detail = this.getUserDetail(LANGUAGE);
        if (detail == null) {
            return null;
        }
        return detail.toString();
    }

    public void setLanguage(String value) {
        this.setUserDetail(LANGUAGE, value);
    }

    public String getDescription() {
        Detail detail;
        int i;
        String group = (String)this.properties.get("group");
        if (group != null) {
            return group;
        }
        String about = null;
        String position = null;
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            if (ORGANIZATION.equalsIgnoreCase(detail.getLabel()) || COMPANY.equalsIgnoreCase(detail.getLabel())) {
                return detail.toString();
            }
            if (JOBTITLE.equalsIgnoreCase(detail.getLabel()) || POSITION.equalsIgnoreCase(detail.getLabel())) {
                position = detail.toString();
            }
            if (!ABOUT.equalsIgnoreCase(detail.getLabel())) continue;
            about = detail.toString();
        }
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            if (ORGANIZATION.equalsIgnoreCase(detail.getLabel()) || COMPANY.equalsIgnoreCase(detail.getLabel())) {
                return detail.toString();
            }
            if (position == null && (JOBTITLE.equalsIgnoreCase(detail.getLabel()) || POSITION.equalsIgnoreCase(detail.getLabel()))) {
                position = detail.toString();
            }
            if (about != null || !ABOUT.equalsIgnoreCase(detail.getLabel())) continue;
            about = detail.toString();
        }
        if (about != null) {
            return about;
        }
        if (position != null) {
            return position;
        }
        return null;
    }

    public Detail getDescriptionDetail() {
        Detail detail = this.getUserDetail(ABOUT);
        if (detail == null) {
            detail = new Detail(ABOUT, "");
        }
        return detail;
    }

    public Detail getFirstNameDetail() {
        return this.getDetail(FIRSTNAME);
    }

    public Detail getLastNameDetail() {
        return this.getDetail(LASTNAME);
    }

    public Detail getGroupNameDetail() {
        return this.getDetail(GROUP);
    }

    public List getList(String key) {
        Vector<Object> list = new Vector<Object>();
        Object object = this.properties.get(key);
        if (object instanceof List) {
            List value = (List)object;
            for (int i = 0; i < value.size(); ++i) {
                list.add(value.get(i));
            }
        } else if (object != null) {
            list.add(object);
        }
        return list;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    protected Map getPropertiesMap(String key) {
        Object object = this.properties.get(key);
        if (object == null) {
            return new HashMap();
        }
        if (object instanceof Map) {
            return new HashMap((Map)object);
        }
        HashMap map = new HashMap();
        map.put(key, object);
        return map;
    }

    protected List getPropertiesList(String key) {
        Object object = this.properties.get(key);
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return (List)object;
        }
        Vector list = new Vector();
        list.add(object);
        return list;
    }

    public String getUsername() {
        Detail detail;
        String login = (String)this.properties.get(LOGIN);
        if (login == null && (detail = this.getUserDetail(LOGIN)) != null) {
            login = detail.toString();
        }
        return login;
    }

    public String getOwnerId() {
        return (String)this.getProperty("ownerid");
    }

    public List<Map> getUserInfo() {
        return (List)this.properties.get("props");
    }

    public List<Detail> getUserInfoDetails() {
        return this.getUserInfoDetails(null);
    }

    public List<Detail> getUserInfoDetails(String language) {
        List userInfo = (List)this.properties.get("props");
        if (userInfo == null || userInfo.isEmpty()) {
            return null;
        }
        ArrayList<Detail> details = new ArrayList<Detail>();
        for (int i = 0; i < userInfo.size(); ++i) {
            Map map = (Map)userInfo.get(i);
            String lang = (String)map.get("lang");
            if (lang != null && language != null && !lang.equals(language)) continue;
            String label = (String)map.get("label");
            if (label == null) {
                label = (String)map.get("image");
            }
            String text = (String)map.get("text");
            Detail detail = new Detail(label, text);
            details.add(detail);
        }
        return details;
    }

    public List<Detail> getUserDetails() {
        return this.userDetails;
    }

    public List getUserDetails(String key) {
        Vector<Detail> list = new Vector<Detail>();
        for (int i = 0; i < this.userDetails.size(); ++i) {
            Detail detail = this.userDetails.get(i);
            if (!key.equalsIgnoreCase(detail.getLabel())) continue;
            list.add(detail);
        }
        return list;
    }

    public Detail getUserDetail(String key) {
        if (key.equalsIgnoreCase(TAGS)) {
            return this.getUserTagsDetail();
        }
        for (int i = 0; i < this.userDetails.size(); ++i) {
            Detail detail = this.userDetails.get(i);
            if (!key.equalsIgnoreCase(detail.getLabel())) continue;
            return detail;
        }
        return null;
    }

    public void setUserDetail(String key, Object value) {
        if (key.equalsIgnoreCase(TAGS)) {
            this.utags = this.toTags(value.toString());
            return;
        }
        Detail detail = this.getUserDetail(key);
        if (detail == null) {
            detail = new Detail(key, value, true);
            this.userDetails.add(detail);
        } else {
            detail.setValue(value);
        }
    }

    public void addUserDetail(Detail detail) {
        detail.checkUpdate();
        this.userDetails.add(detail);
    }

    public void addUserDetail(String key, Object value) {
        Detail detail = new Detail(key, value);
        this.userDetails.add(detail);
    }

    public void removeUserDetail(Detail detail) {
        this.userDetails.remove(detail);
    }

    public void setUserDetails(List<Detail> details) {
        ArrayList<Detail> list = new ArrayList<Detail>();
        for (int i = 0; i < details.size(); ++i) {
            Detail detail = details.get(i);
            if (detail.getLabel().equalsIgnoreCase(TAGS)) {
                this.utags = this.toTags(detail.toString());
                continue;
            }
            list.add(detail);
        }
        this.userDetails.clear();
        this.userDetails.addAll(list);
    }

    public List<Detail> getCustomDetails() {
        return this.customDetails;
    }

    public void setCustomDetails(List<Detail> details) {
        this.customDetails.clear();
        for (int i = 0; i < details.size(); ++i) {
            Detail detail = details.get(i);
            if (detail.getLabel().equalsIgnoreCase(TAGS)) {
                this.tags = this.toTags(detail.toString());
                continue;
            }
            this.customDetails.add(detail);
        }
    }

    public void setCustomDetails(String key, List details) {
        int i;
        for (i = this.customDetails.size() - 1; i >= 0; --i) {
            Detail detail = this.customDetails.get(i);
            if (!key.equalsIgnoreCase(detail.getLabel())) continue;
            this.customDetails.remove(i);
        }
        for (i = 0; i < details.size(); ++i) {
            this.addCustomDetail(key, details.get(i));
        }
    }

    public List getCustomDetails(String key) {
        Vector<Detail> list = new Vector<Detail>();
        for (int i = 0; i < this.customDetails.size(); ++i) {
            Detail detail = this.customDetails.get(i);
            if (!key.equalsIgnoreCase(detail.getLabel())) continue;
            list.add(detail);
        }
        return list;
    }

    public Detail getCustomDetail(String key) {
        if (key.equalsIgnoreCase(TAGS)) {
            return this.getCustomTagsDetail();
        }
        for (int i = 0; i < this.customDetails.size(); ++i) {
            Detail detail = this.customDetails.get(i);
            if (!key.equalsIgnoreCase(detail.getLabel())) continue;
            return detail;
        }
        return null;
    }

    public void setCustomDetail(String key, Object value) {
        if (key.equalsIgnoreCase(TAGS)) {
            this.tags = this.toTags(value.toString());
            return;
        }
        Detail detail = this.getCustomDetail(key);
        if (detail == null) {
            detail = new Detail(key, value, false);
            this.customDetails.add(detail);
        } else {
            detail.setValue(value);
        }
    }

    private Detail getDetail(String key) {
        Detail detail;
        String name = (String)this.properties.get(key.toLowerCase());
        if (name != null) {
            return new Detail(key, name, true);
        }
        if (this.state == -1) {
            detail = this.getCustomDetail(key);
            if (detail == null || detail.toString().equals("")) {
                detail = this.getUserDetail(key);
            }
        } else {
            detail = this.getUserDetail(key);
            if (detail == null || detail.toString().equals("")) {
                detail = this.getCustomDetail(key);
            }
        }
        if (detail == null) {
            detail = new Detail(key, null, this.state != -1);
        }
        return detail;
    }

    public Detail getUserTagsDetail() {
        return this.getTagsDetail(this.utags, true);
    }

    public Detail getCustomTagsDetail() {
        return this.getTagsDetail(this.tags, false);
    }

    private Detail getTagsDetail(List list, boolean b) {
        Object str = "";
        for (int i = 0; i < list.size(); ++i) {
            str = (String)str + "#" + list.get(i) + " ";
        }
        return new Detail(TAGS, str, b);
    }

    public Detail getPrefix() {
        return this.state == -1 ? this.getCustomDetail(PREFIX) : this.getUserDetail(PREFIX);
    }

    public Detail getSuffix() {
        return this.state == -1 ? this.getCustomDetail(SUFFIX) : this.getUserDetail(SUFFIX);
    }

    public List<String> getPhoneNumbers() {
        String number;
        Detail detail;
        int i;
        Vector<String> list = new Vector<String>();
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            number = detail.getPhoneNumber();
            if (number == null || number.length() <= 0) continue;
            list.add(number);
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            number = detail.getPhoneNumber();
            if (number == null || number.length() <= 0) continue;
            list.add(number);
        }
        return list;
    }

    public List<String> getPhoneNumbersList() {
        String value;
        String label;
        Detail detail;
        int i;
        Vector<String> list = new Vector<String>();
        String ext = (String)this.getProperty("extension");
        if (ext == null) {
            ext = (String)this.getProperty("ext");
        }
        if (ext != null && ext.length() > 0) {
            list.add(ext);
        }
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.contains("phone") && !label.contains("mobile") && !label.contains("fax") || (value = detail.toString()).length() <= 0 || list.contains(value)) continue;
            list.add(value);
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.contains("phone") && !label.contains("mobile") && !label.contains("fax") || (value = detail.toString()).length() <= 0 || list.contains(value)) continue;
            list.add(value);
        }
        return list;
    }

    public List<String> getPhoneNumbersList(MessageInfo message) {
        List<String> numbers = this.getPhoneNumbersList();
        if (message != null && numbers.size() > 1) {
            String content = message.getContent();
            for (int i = 0; i < numbers.size(); ++i) {
                String number = numbers.get(i);
                if (!content.contains(number)) continue;
                numbers.remove(number);
                numbers.add(0, number);
                break;
            }
        }
        if (numbers.isEmpty()) {
            String ext = (String)this.getProperty("extension");
            if (ext == null) {
                ext = (String)this.getProperty("ext");
            }
            if (ext != null && ext.length() > 0) {
                numbers.add(ext);
            } else if (this.number != null) {
                numbers.add(this.number);
            } else if (this.userid != null) {
                numbers.add(this.userid);
            }
        }
        return numbers;
    }

    public List<Detail> getPhoneDetails() {
        String label;
        Detail detail;
        int i;
        Vector<Detail> list = new Vector<Detail>();
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.contains("phone") && !label.contains("mobile") && !label.contains("fax") && !label.equals("sip")) continue;
            list.add(detail);
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.contains("phone") && !label.contains("mobile") && !label.contains("fax") && !label.equals("sip") || list.contains(detail)) continue;
            list.add(detail);
        }
        return list;
    }

    public List<Detail> getEmailDetails() {
        String label;
        Detail detail;
        int i;
        Vector<Detail> list = new Vector<Detail>();
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.contains("email")) continue;
            list.add(detail);
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.contains("email")) continue;
            list.add(detail);
        }
        return list;
    }

    public List<Detail> getFaxDetails() {
        String label;
        Detail detail;
        int i;
        Vector<Detail> list = new Vector<Detail>();
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.contains("fax")) continue;
            list.add(detail);
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.contains("fax")) continue;
            list.add(detail);
        }
        return list;
    }

    public List<Detail> getMessengerDetails() {
        int j;
        String label;
        Detail detail;
        int i;
        Vector<Detail> list = new Vector<Detail>();
        block0: for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            label = detail.getLabel();
            for (j = 0; j < MESSENGER_KEYS.length; ++j) {
                if (!label.equals(MESSENGER_KEYS[j])) continue;
                list.add(detail);
                continue block0;
            }
        }
        block2: for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            label = detail.getLabel().toLowerCase();
            for (j = 0; j < MESSENGER_KEYS.length; ++j) {
                if (!label.equals(MESSENGER_KEYS[j])) continue;
                list.add(detail);
                continue block2;
            }
        }
        return list;
    }

    public List<Detail> getCustomContacts() {
        Vector<Detail> list = new Vector<Detail>();
        for (int i = 0; i < this.customDetails.size(); ++i) {
            Detail detail = this.customDetails.get(i);
            String label = detail.getLabel().toLowerCase();
            if (!label.contains("phone") && !label.contains("mobile") && !label.contains("email") && !label.contains("fax") && !label.contains("web") && !label.equals(SIP)) continue;
            list.add(detail);
        }
        return list;
    }

    public String getPrimaryPhoneNumber() {
        String label;
        Detail detail;
        int i;
        String phone = (String)this.properties.get("extension");
        if (phone == null) {
            phone = (String)this.properties.get("ext");
        }
        if (phone != null && phone.length() > 0) {
            return phone;
        }
        String fax = null;
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (label.contains("mobile")) {
                return detail.toString();
            }
            if (label.contains("phone") && phone == null) {
                phone = detail.toString();
                continue;
            }
            if (!label.contains("fax") || fax != null) continue;
            fax = detail.toString();
        }
        if (phone != null) {
            return phone;
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (label.contains("mobile")) {
                return detail.toString();
            }
            if (label.contains("phone") && phone == null) {
                phone = detail.toString();
                continue;
            }
            if (!label.contains("fax") || fax != null) continue;
            fax = detail.toString();
        }
        if (phone != null) {
            return phone;
        }
        return fax;
    }

    public String getPrimaryEmail() {
        for (int i = 0; i < this.userDetails.size(); ++i) {
            Detail detail = this.userDetails.get(i);
            if (!detail.isEmail()) continue;
            return detail.toString();
        }
        String email = null;
        for (int i = 0; i < this.customDetails.size(); ++i) {
            Detail detail = this.customDetails.get(i);
            if (!detail.isEmail()) continue;
            String label = detail.getLabel().toLowerCase();
            if (detail.getLabel().equals(BUSINESSEMAIL)) {
                return detail.toString();
            }
            email = detail.toString();
        }
        return email;
    }

    public void addCustomDetail(Detail detail) {
        detail.checkUpdate();
        this.customDetails.add(detail);
    }

    public void addCustomDetail(String key, Object value) {
        Detail detail = new Detail(key, value);
        this.customDetails.add(detail);
    }

    public void removeCustomDetail(Detail detail) {
        this.customDetails.remove(detail);
        if (detail.uid) {
            this.userid = null;
            if (detail.phone && detail.toString().equals(this.number)) {
                this.number = null;
            }
        }
    }

    public boolean isUser() {
        String kind = (String)this.properties.get("kind");
        return this.userStatus > 0 || this.state != -1 && (kind == null || "user".equals(kind));
    }

    public boolean isPhone() {
        return "phone".equals(this.properties.get("kind"));
    }

    public boolean isSlot() {
        return "slot".equals(this.properties.get("kind"));
    }

    public boolean isBlf() {
        return "blf".equals(this.properties.get("kind"));
    }

    public boolean isSpeedDial() {
        return this.speeddial != null;
    }

    public boolean isCustomSpeedDial() {
        return this.customsd;
    }

    protected void deleteCustomSpeedDial() {
        for (int i = 0; i < this.customDetails.size(); ++i) {
            Detail detail = this.customDetails.get(i);
            if (!"phone-sc".equals(detail.getLabel())) continue;
            this.customDetails.remove(detail);
        }
        this.speeddial = null;
        this.customsd = false;
        this.gsmdial = false;
    }

    public boolean isEmergencyNumber() {
        return this.gsmdial;
    }

    public boolean isFeature() {
        return this.isBlf() || this.isSlot() || this.isSpeedDial() && !this.isUser() && !this.isPhone() && this.getPhoneNumbers().isEmpty();
    }

    public boolean isChannel() {
        return this.status == 10;
    }

    public boolean isCustom() {
        return this.state == -1 && this.status == -1;
    }

    public boolean isLocal() {
        return this.hash == 0L;
    }

    public boolean isGlobal() {
        return this.id != null;
    }

    public boolean isAdmin() {
        return this.userStatus == 126;
    }

    public boolean isChatbot() {
        return this.userStatus == 127;
    }

    public boolean isSystem() {
        return this.userStatus == 128 || this.userStatus == 129;
    }

    public boolean isValid() {
        return this.id != null || this.localid != null;
    }

    public int getState() {
        return this.state;
    }

    public long getStateTimestamp() {
        return this.stime;
    }

    public String getNote() {
        return this.note;
    }

    public int getStatus() {
        return this.status;
    }

    public void setFavorite(boolean b) {
        if (this.status < 0) {
            throw new IllegalStateException("Contsct status " + this.status);
        }
        this.status = b ? (this.status |= 0x10) : (this.status &= 0xF);
    }

    public boolean isFavorite() {
        return this.status > 0 && (this.status & 0x10) != 0;
    }

    public boolean isDeleted() {
        return this.status == 3 && this.getName().equals("Deleted");
    }

    public long getStatusTimestamp() {
        return this.sttime;
    }

    public int getUserStatus() {
        return this.userStatus;
    }

    public String getId() {
        return this.id != null ? this.id : this.localid;
    }

    public String getGlobalId() {
        return this.id;
    }

    public String getLocalId() {
        return this.localid;
    }

    public String getUserID() {
        return this.userid;
    }

    protected String getImageId() {
        return (this.userid != null ? this.userid : this.localid) + "ava";
    }

    public String getSpeedDialNumber() {
        return this.speeddial;
    }

    protected void setSpeedDialNumber(String value) {
        this.setCustomDetail("phone-sc", value);
    }

    public String getNumber() {
        List<Detail> phones;
        if (this.state != -1) {
            if (this.number != null) {
                return this.number;
            }
            if (this.userid != null) {
                return this.userid;
            }
        }
        if (!(phones = this.getPhoneDetails()).isEmpty()) {
            return String.valueOf(phones.get(0).getValue());
        }
        return this.userid;
    }

    protected void setImageFile(File file) {
        this.imageFile = file;
        this.imgdate = file != null ? file.lastModified() : -1L;
        Iterator<ContactEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().imageLoaded(this);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    protected void setGlobalId(String str) {
        this.id = str;
    }

    protected void setUserId(String str) {
        this.userid = str;
    }

    public void setNumber(String str) {
        this.number = str;
    }

    public void setName(String name) {
        this.properties.put("name", name);
    }

    protected void setProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
            return;
        }
        if (key.equals("settings")) {
            this.settings = (Map)value;
            this.properties.remove(key);
            return;
        }
        if (key.equals("userid")) {
            this.setUserId((String)value);
        } else if (key.equals("id") || key.equals("contactid")) {
            this.id = (String)value;
        } else if (key.equals("ext")) {
            this.number = (String)value;
        } else if (key.equals("extid")) {
            this.localid = (String)value;
        } else if (key.equals("state")) {
            this.setState((Integer)value);
        } else if (key.equals("note")) {
            this.note = (String)value;
        } else if (key.equals("status")) {
            this.setStatus((Integer)value);
        } else if (key.equals("sttime")) {
            this.sttime = ((Number)value).longValue();
        } else if (key.equals("stime")) {
            this.stime = ((Number)value).longValue();
        } else if (key.equals("ustatus")) {
            this.userStatus = (Integer)value;
        }
        if (key.equals("info")) {
            this.buildUserDetails((Map)value);
        } else if (key.equals("usinfo")) {
            this.buildCustomDetails((Map)value);
        } else if (key.equals("contacts")) {
            this.buildCustomDetails((Map)value);
        } else if (key.equals("imgdate")) {
            this.imgdate = ((Number)value).longValue();
        }
        this.properties.put(key, value);
    }

    public void setKeyValue(String key, Object value) {
        this.tmpvalues.put(key, value);
    }

    public Object getKeyValue(String key) {
        return this.tmpvalues.get(key);
    }

    private List toTags(String ts) {
        ArrayList<String> list = new ArrayList<String>();
        if (ts.startsWith("[")) {
            ts = ts.substring(1, ts.length() - 1);
        }
        StringTokenizer stz = new StringTokenizer(ts, "# ,");
        while (stz.hasMoreTokens()) {
            String tag = stz.nextToken().trim();
            if (tag.length() <= 0) continue;
            list.add(tag);
        }
        return list;
    }

    public void setCustomTags(List<String> list) {
        this.tags = new Vector<String>(list);
    }

    public List<String> getCustomTags() {
        return this.tags;
    }

    public void setUserTags(List<String> list) {
        this.utags = new Vector<String>(list);
    }

    public List<String> getUserTags() {
        return this.utags;
    }

    public void setLawfulBase(int i) {
        this.properties.put("consent", i);
    }

    public int getLawfulBase() {
        Integer i = (Integer)this.properties.get("consent");
        if (i == null) {
            i = 0;
        }
        return i;
    }

    public boolean hasLawfulBaseDoc() {
        return this.properties.get("consby") != null;
    }

    protected void updateProperties(Map map) {
        for (String key : map.keySet()) {
            Object value = map.get(key);
            this.setProperty(key, value);
        }
        this.notifyDataChanged();
    }

    private void notifyDataChanged() {
        Iterator<ContactEventListener> itr = this.listeners.iterator();
        while (itr.hasNext()) {
            try {
                itr.next().dataChanged(this);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    protected void update(ContactInfo contactInfo) {
        String label;
        Detail detail;
        int i;
        this.updateProperties(contactInfo.getProperties());
        if (contactInfo.imgdate > this.imgdate) {
            this.setImageFile(contactInfo.getImageFile());
        }
        for (i = this.userDetails.size() - 1; i >= 0; --i) {
            detail = this.userDetails.get(i);
            if (!this.customDetails.contains(detail)) continue;
            this.userDetails.remove(i);
        }
        this.speeddial = null;
        this.customsd = false;
        this.gsmdial = false;
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.equals("phone-sd") && !label.equals("phone-em")) continue;
            if (label.equals("phone-em")) {
                this.gsmdial = true;
            }
            this.speeddial = detail.toString();
            return;
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            label = detail.getLabel().toLowerCase();
            if (!label.equals("phone-sc") && !label.equals("phone-sd") && !label.equals("phone-em")) continue;
            if (label.equals("phone-sc")) {
                this.customsd = true;
            } else if (label.equals("phone-em")) {
                this.gsmdial = true;
            }
            this.speeddial = detail.toString();
            return;
        }
    }

    protected void setCustomDetails(Map map) {
        this.buildCustomDetails(map);
        this.notifyDataChanged();
    }

    protected void setState(int s) {
        if (s == this.state) {
            return;
        }
        if (s >= 6) {
            if (this.state == 8) {
                return;
            }
        } else {
            this.conferenceState = 0;
            this.conferenceStatus = null;
        }
        this.state = s;
        this.notifyStateChanged();
    }

    protected void notifyStateChanged() {
        Iterator<ContactEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().stateChanged(this);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    protected void setStateTime(long millis) {
        this.stime = millis;
    }

    protected void setNote(String s) {
        this.note = s;
    }

    public void setStatus(int s) {
        this.status = s;
        Iterator<ContactEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().statusChanged(this);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    protected void setConferenceStatus(String stat) {
        this.conferenceStatus = stat;
    }

    public String getConferenceStatus() {
        return this.conferenceStatus;
    }

    protected void setConferenceState(int stat) {
        this.conferenceState = stat;
        this.notifyStateChanged();
    }

    public int getConferenceState() {
        return this.conferenceState;
    }

    public boolean canBeDeleted() {
        return !this.properties.containsKey("kind");
    }

    public boolean canReceiveMessages() {
        if (this.status < 3) {
            return false;
        }
        String kind = (String)this.getProperty("kind");
        return kind == null && this.state != -1 || "user".equals(kind) || !this.getMessengerDetails().isEmpty();
    }

    public boolean canReceiveCalls() {
        return this.userid != null && this.state != -1 || !this.getPhoneDetails().isEmpty();
    }

    public boolean canMakeCalls() {
        return this.canReceiveCalls() && (!this.isSlot() || this.state == 8);
    }

    public boolean canReceiveVideoCalls() {
        if (this.isSlot() || this.isFeature()) {
            return false;
        }
        if (this.state != -1) {
            return true;
        }
        List<Detail> details = this.getPhoneDetails();
        for (int i = 0; i < details.size(); ++i) {
            if (!details.get(i).getLabel().equalsIgnoreCase(SIP)) continue;
            return true;
        }
        return false;
    }

    protected boolean canCallPickup() {
        Integer pmask = (Integer)this.getProperty("pmask");
        return pmask == null || (pmask & 4) != 0;
    }

    protected boolean canCallBargein() {
        Integer pmask = (Integer)this.getProperty("pmask");
        return pmask == null || (pmask & 0x10) != 0;
    }

    protected boolean canCallMonitor() {
        Integer pmask = (Integer)this.getProperty("pmask");
        return pmask == null || (pmask & 0x20) != 0;
    }

    protected boolean callPickupAllowed() {
        Integer fmask = (Integer)this.getProperty("fmask");
        return this.state == 7 && (fmask == null || (fmask & 0x40) == 0);
    }

    protected boolean callBargeinAllowed() {
        Integer fmask = (Integer)this.getProperty("fmask");
        return this.state == 8 && (fmask == null || (fmask & 0x80) == 0);
    }

    protected boolean callMonitorAllowed() {
        Integer fmask = (Integer)this.getProperty("fmask");
        return this.state == 8 && (fmask == null || (fmask & 0x200) == 0);
    }

    protected long getImageTimestamp() {
        return this.imgdate;
    }

    protected void setImageTimestamp(long timestamp) {
        this.imgdate = timestamp;
    }

    protected long getHash() {
        return this.hash;
    }

    protected long setHash() {
        this.hash = this.calculateHash();
        return this.hash;
    }

    protected long calculateHash() {
        return (this.toString() + this.getCustomDetailsMap().toString()).hashCode();
    }

    protected void setCountryCode(String code) {
        this.countryCode = code;
    }

    protected String getCountryCode() {
        return this.countryCode;
    }

    public void setLocalId(String id) {
        this.localid = id;
    }

    protected void setUpdating(boolean b) {
        this.updating = b;
    }

    protected boolean isUpdating() {
        return this.updating;
    }

    public void updateCustomDetails(ContactInfo contactInfo) {
        List<Detail> details = contactInfo.customDetails;
        for (int i = 0; i < details.size(); ++i) {
            Detail detail = details.get(i);
            if (this.customDetails.contains(detail)) continue;
            this.addCustomDetail(detail);
        }
    }

    protected boolean matches(List<String> numbers) {
        for (int i = 0; i < numbers.size(); ++i) {
            if (!this.hasPhoneNumber(numbers.get(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean hasTag(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String tag = list.get(i);
            if (!this.tags.contains(tag) && !this.utags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            name = this.getPrimaryPhoneNumber();
        }
        if (name == null || name.length() == 0) {
            name = this.getPrimaryEmail();
        }
        if (name == null || name.length() == 0) {
            name = this.number;
        }
        if (name == null || name.length() == 0 || name.equals("null") || name.equals("0")) {
            name = "Unknown";
        }
        return name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContactInfo)) {
            return false;
        }
        if (this.userid != null) {
            return this.userid.equals(((ContactInfo)obj).userid);
        }
        if (this.id != null) {
            return this.id.equals(((ContactInfo)obj).id);
        }
        return this.localid != null && this.localid.equals(((ContactInfo)obj).localid);
    }

    public int compareTo(Object contact) {
        return this.toString().compareToIgnoreCase(contact.toString());
    }

    public boolean hasPhoneNumber(String phone) {
        return this.hasPhoneNumber(phone, false);
    }

    public boolean hasPhoneNumber(String phone, boolean checked) {
        Detail detail;
        int i;
        if (phone.equals(this.number) || phone.equals(this.userid)) {
            return true;
        }
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            if (!detail.hasPhoneNumber(phone) || checked && !detail.isChecked()) continue;
            return true;
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            if (!detail.hasPhoneNumber(phone) || checked && !detail.isChecked()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPhoneNumber() {
        Detail detail;
        int i;
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            if (!detail.isPhoneNumber()) continue;
            return true;
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            if (!detail.isPhoneNumber()) continue;
            return true;
        }
        return false;
    }

    public boolean hasEmail(String email) {
        Detail detail;
        int i;
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            if (!detail.isEmail() || !email.equals(detail.toString())) continue;
            return true;
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            if (!detail.isEmail() || !email.equals(detail.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEmail() {
        Detail detail;
        int i;
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            if (!detail.isEmail()) continue;
            return true;
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            if (!detail.isEmail()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSMSNumber() {
        Detail detail;
        int i;
        if (this.isPhone()) {
            return true;
        }
        for (i = 0; i < this.userDetails.size(); ++i) {
            detail = this.userDetails.get(i);
            if (!detail.isPhoneNumber() && !detail.getLabel().equals(SIP)) continue;
            return true;
        }
        for (i = 0; i < this.customDetails.size(); ++i) {
            detail = this.customDetails.get(i);
            if (!detail.isPhoneNumber() && !detail.getLabel().equals(SIP)) continue;
            return true;
        }
        return false;
    }

    public List<Activity> getActivities() {
        ArrayList<Activity> list = new ArrayList<Activity>();
        for (int i = this.activities.size() - 1; i >= 0; --i) {
            Activity activity = this.activities.get(i);
            if (activity.getType().equals("update")) continue;
            list.add(activity);
        }
        return list;
    }

    protected void addActivities(List<Activity> activities) {
        for (int i = 0; i < activities.size(); ++i) {
            this.addActivity(activities.get(i));
        }
        this.notifyDataChanged();
    }

    protected void addActivity(Activity activity) {
        int n = this.activities.indexOf(activity);
        if (n == -1) {
            this.activities.add(activity);
        } else {
            this.activities.set(n, activity);
        }
        activity.setUserId(this.userid);
    }

    protected Map getCustomContactsMap() {
        return this.getDetailsMap(this.customDetails, true);
    }

    protected Map getCustomDetailsMap() {
        Map map = this.getDetailsMap(this.customDetails, false);
        if (!this.tags.isEmpty()) {
            map.put("tags", this.tags);
        }
        return map;
    }

    protected Map getUserDetailsMap() {
        Map map = this.getDetailsMap(this.userDetails, false);
        if (!this.settings.isEmpty()) {
            map.put("settings", this.settings);
        }
        if (!this.utags.isEmpty()) {
            map.put("tags", this.utags);
        }
        return map;
    }

    private Map getDetailsMap(List<Detail> list, boolean contactsOnly) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < list.size(); ++i) {
            Detail detail = list.get(i);
            if (contactsOnly && !detail.phone && !detail.email) continue;
            String key = detail.getLabel().toLowerCase();
            Vector<Object> value = detail.getValue();
            Object obj = map.get(key);
            if (obj instanceof Vector) {
                ((Vector)obj).add(value);
                value = obj;
            } else if (obj != null) {
                Vector<Object> v = new Vector<Object>();
                v.add(obj);
                v.add(value);
                value = v;
            }
            map.put(key, value);
        }
        return map;
    }

    public String toVcard() {
        return this.toVcard(null);
    }

    public String toVcard(String base64image) {
        StringBuilder stringBuilder = new StringBuilder("BEGIN:VCARD\r\nVERSION:2.1\r\n");
        stringBuilder.append("N:").append(this.getName()).append("\r\n");
        stringBuilder.append("FN:").append(this.getFullName()).append("\r\n");
        Detail detail = this.getDetail(ORGANIZATION);
        if (detail != null && detail.getValue() != null) {
            stringBuilder.append("ORG:").append(detail).append("\r\n");
        }
        if ((detail = this.getDetail(JOBTITLE)) != null && detail.getValue() != null) {
            stringBuilder.append("TITLE:").append(detail).append("\r\n");
        }
        List<Detail> emails = this.getEmailDetails();
        for (int j = 0; j < emails.size(); ++j) {
            stringBuilder.append("EMAIL");
            detail = emails.get(j);
            String label = detail.getLabel().toLowerCase();
            if (label.contains("business")) {
                stringBuilder.append(";WORK");
            } else if (label.contains("private")) {
                stringBuilder.append(";HOME");
            }
            stringBuilder.append(":").append(detail.getValue()).append("\r\n");
        }
        List<Detail> phones = this.getPhoneDetails();
        for (int j = 0; j < phones.size(); ++j) {
            String label = phones.get(j).getLabel().toLowerCase();
            if (label.startsWith("phone-")) continue;
            stringBuilder.append("TEL");
            if (label.contains("mobile")) {
                stringBuilder.append(";CELL");
            } else if (label.startsWith("business")) {
                stringBuilder.append(";WORK");
            } else if (label.contains("private")) {
                stringBuilder.append(";HOME");
            }
            stringBuilder.append(":").append(phones.get(j).toString()).append("\r\n");
        }
        List<Detail> fax = this.getFaxDetails();
        for (int j = 0; j < fax.size(); ++j) {
            detail = fax.get(j);
            String label = detail.getLabel().toLowerCase();
            stringBuilder.append("TEL");
            if (label.contains("private")) {
                stringBuilder.append(";HOME");
            } else if (label.contains("private")) {
                stringBuilder.append(";WORK");
            }
            stringBuilder.append(";FAX").append(":").append(detail.getValue()).append("\r\n");
        }
        detail = this.getDetail(WEB);
        if (detail != null && detail.getValue() != null) {
            stringBuilder.append("URL").append(":").append(detail.getValue()).append("\r\n");
        }
        if (base64image != null) {
            try {
                stringBuilder.append("PHOTO;JPEG;ENCODING=BASE64:").append(base64image).append("\r\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringBuilder.append("END:VCARD\r\n");
        return stringBuilder.toString();
    }

    public List<Detail> getAvailableCustomDetails() {
        Vector<Detail> details = new Vector<Detail>();
        if (this.getCustomDetail(ORGANIZATION) == null) {
            details.add(new Detail(ORGANIZATION, ""));
        }
        if (this.getCustomDetail(DEPARTMENT) == null) {
            details.add(new Detail(DEPARTMENT, ""));
        }
        if (this.getCustomDetail(JOBTITLE) == null) {
            details.add(new Detail(JOBTITLE, ""));
        }
        details.add(new Detail(MOBILE, ""));
        details.add(new Detail(BUSINESSMOBILE, ""));
        details.add(new Detail(PRIVATEMOBILE, ""));
        details.add(new Detail(PHONE, ""));
        details.add(new Detail(BUSINESSPHONE, ""));
        details.add(new Detail(EMAIL, ""));
        details.add(new Detail(BUSINESSEMAIL, ""));
        details.add(new Detail(PRIVATEEMAIL, ""));
        details.add(new Detail(FAX, ""));
        details.add(new Detail(BUSINESSFAX, ""));
        details.add(new Detail(PRIVATEFAX, ""));
        details.add(new Detail(WEB, ""));
        details.add(new Detail(SIP, ""));
        details.add(new Detail("Facebook", ""));
        details.add(new Detail(ADDRESS, ""));
        details.add(new Detail(BUSINESSADDRESS, ""));
        details.add(new Detail(PRIVATEADDRESS, ""));
        if (this.getCustomDetail(BIRTHDAY) == null) {
            details.add(new Detail(BIRTHDAY, ""));
        }
        if (this.getCustomDetail(LANGUAGE) == null) {
            details.add(new Detail(LANGUAGE, ""));
        }
        return details;
    }

    public List<Detail> getAvailableCustomDetails(String[] labels) {
        Vector<Detail> details = new Vector<Detail>();
        for (int i = 0; i < labels.length; ++i) {
            if ((labels[i].equals(ORGANIZATION) || labels[i].equals(DEPARTMENT) || labels[i].equals(JOBTITLE) || labels[i].equals(COMPANY) || labels[i].equals(POSITION) || labels[i].equals(ABOUT) || labels[i].equals(BIRTHDAY) || labels[i].equals(COUNTRY) || labels[i].equals(LANGUAGE)) && (this.getCustomDetail(labels[i]) != null || this.getUserDetail(labels[i]) != null || labels[i].equals(JOBTITLE) && this.getUserDetail(POSITION) != null || labels[i].equals(COMPANY) && this.getUserDetail(ORGANIZATION) != null)) continue;
            details.add(new Detail(labels[i], ""));
        }
        return details;
    }

    private String getNormalizedLabel(String label) {
        for (int i = 0; i < KEYS.length; ++i) {
            if (!label.equalsIgnoreCase(KEYS[i])) continue;
            return KEYS[i];
        }
        return label;
    }

    static {
        for (int i = 0; i < KEYS.length; ++i) {
            keys.put(KEYS[i], i);
        }
    }

    public class Detail
    implements Comparable,
    Serializable,
    Cloneable {
        static final long serialVersionUID = 5938571027415039254L;
        String label;
        Object value;
        boolean editable;
        boolean hidden;
        boolean header;
        boolean mobile;
        boolean phone;
        boolean email;
        boolean fax;
        boolean uid;
        boolean p;
        boolean n;
        int priority;
        String pn;

        protected Detail(String l, Object v) {
            this(l, v, false);
        }

        protected Detail(String l, Object v, boolean fromOwner) {
            this.label = ContactInfo.this.getNormalizedLabel(l);
            this.header = this.label.equalsIgnoreCase(ContactInfo.FULLNAME) || this.label.equalsIgnoreCase(ContactInfo.FIRSTNAME) || this.label.equalsIgnoreCase(ContactInfo.LASTNAME) || this.label.equalsIgnoreCase(ContactInfo.DISPLAYNAME);
            this.mobile = this.label.equals(ContactInfo.MOBILE) || this.label.equals(ContactInfo.BUSINESSMOBILE) || this.label.equals(ContactInfo.PRIVATEMOBILE);
            this.phone = this.mobile || this.label.equals(ContactInfo.PHONE) || this.label.equals(ContactInfo.BUSINESSPHONE) || this.label.equals(ContactInfo.PRIVATEPHONE);
            this.fax = this.label.equals(ContactInfo.FAX) || this.label.equals(ContactInfo.BUSINESSFAX) || this.label.equals(ContactInfo.PRIVATEFAX);
            this.email = this.label.equals(ContactInfo.EMAIL) || this.label.equals(ContactInfo.BUSINESSEMAIL) || this.label.equals(ContactInfo.PRIVATEEMAIL);
            this.uid = v != null && v.equals(ContactInfo.this.userid);
            this.setValue(v);
            Object p = keys.get(this.label);
            this.priority = p != null ? (Integer)p : Integer.MAX_VALUE;
            boolean bl = this.editable = (!fromOwner && (!this.label.equals(ContactInfo.TAGS) || !ContactInfo.this.isUser()) || ContactInfo.this.owner) && !this.label.equals(ContactInfo.USERID);
            if (this.label.equals("phone-sc")) {
                ContactInfo.this.speeddial = v.toString();
                ContactInfo.this.customsd = true;
                this.hidden = true;
            } else if (this.label.equals("phone-sd")) {
                ContactInfo.this.speeddial = v.toString();
                this.hidden = true;
            } else if (this.label.equals("phone-em")) {
                ContactInfo.this.speeddial = v.toString();
                ContactInfo.this.gsmdial = true;
                this.hidden = true;
            } else if (p == null) {
                this.hidden = true;
            }
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public String getLabel() {
            return this.label;
        }

        public Object getValue() {
            return this.phone ? this.pn : this.value;
        }

        public void setValue(Object v) {
            this.value = v;
            if (this.uid) {
                ContactInfo.this.userid = (String)this.value;
            }
            if (this.phone) {
                if (this.value instanceof Map) {
                    Integer nlevel;
                    Map m = (Map)this.value;
                    this.pn = Utils.normalizePhoneNumber((String)m.get("value"));
                    Integer plevel = (Integer)m.get("plevel");
                    if (plevel != null && plevel > 0) {
                        this.p = true;
                    }
                    if ((nlevel = (Integer)m.get("nlevel")) != null && nlevel > 0) {
                        this.n = true;
                    }
                } else {
                    this.pn = Utils.normalizePhoneNumber(this.value.toString());
                }
            } else if (this.email) {
                if (this.value instanceof Map) {
                    Integer nlevel;
                    Map m = (Map)this.value;
                    Integer plevel = (Integer)m.get("plevel");
                    if (plevel != null && plevel > 0) {
                        this.p = true;
                    }
                    if ((nlevel = (Integer)m.get("nlevel")) != null && nlevel > 0) {
                        this.n = true;
                    }
                }
            } else if (this.label.equals(ContactInfo.SIP)) {
                this.value = this.value.toString().toLowerCase();
            }
        }

        public boolean isEditable() {
            return this.editable && !ContactInfo.this.isAdmin() && !ContactInfo.this.isSystem() && !ContactInfo.this.isChatbot();
        }

        public boolean isHeadInfo() {
            return this.header;
        }

        public boolean isMobileNumber() {
            return this.mobile;
        }

        public boolean isPhoneNumber() {
            return this.phone;
        }

        public boolean isFaxNumber() {
            return this.fax;
        }

        public boolean isEmail() {
            return this.email;
        }

        public boolean isPrimary() {
            return this.p;
        }

        public boolean isChecked() {
            return this.p || this.n;
        }

        protected boolean hasPhoneNumber(String number) {
            return this.phone && (number.equals(this.pn) || number.endsWith(this.pn) && this.pn.length() > 8);
        }

        protected String getPhoneNumber() {
            return this.pn;
        }

        protected void checkUpdate() {
            if (this.phone) {
                this.pn = Utils.normalizePhoneNumber(this.value.toString());
            }
        }

        public String toString() {
            if (this.value == null) {
                return "";
            }
            if (this.phone) {
                if (ContactInfo.this.countryCode != null) {
                    return CountryCodes.formatToString(this.pn, ContactInfo.this.countryCode);
                }
                if (this.value instanceof Map) {
                    return Utils.normalizePhoneNumber((String)((Map)this.value).get("value"));
                }
                return this.value.toString();
            }
            if (this.value instanceof String) {
                return (String)this.value;
            }
            if (this.value instanceof Map) {
                return String.valueOf(((Map)this.value).get("value"));
            }
            if (this.label.equalsIgnoreCase(ContactInfo.BIRTHDAY)) {
                return DateFormat.getDateInstance(2).format(new Date(((Number)this.value).longValue()));
            }
            return this.value.toString();
        }

        public int compareTo(Object another) {
            if (this.uid) {
                return -1;
            }
            Detail det = (Detail)another;
            if (det.uid) {
                return 1;
            }
            return this.priority <= det.priority ? -1 : 1;
        }

        public boolean equals(Object another) {
            Detail det = (Detail)another;
            return this.label.equalsIgnoreCase(det.label) && (this.phone && this.pn.equals(det.pn) || !this.phone && this.toString().equals(det.toString()));
        }

        public Detail clone() {
            try {
                return (Detail)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return this;
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (!keys.containsKey(this.label)) {
                this.hidden = true;
            }
        }
    }
}

