/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import com.smile.mail.MimeMessageParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.json.smile.JSONObject;
import smile.cti.client.FileInfo;
import smile.util.ResourceStore;
import smile.util.Utils;

public class EmailInfo
extends FileInfo {
    static final long serialVersionUID = 7384126109453657102L;
    private String to;
    private String cc;
    private String bcc;
    private String from;
    private String replyto;
    private String subject;
    private String text;
    private String html;
    private String filename;
    private List<File> attachments;
    private String target;

    public EmailInfo() {
        this.setType(5);
        this.attachments = new ArrayList<File>();
    }

    protected EmailInfo(String id, String orig, String content, int type, int status, long time) {
        super(id, orig, content, type, status, time);
        try {
            this.setContent(content);
        }
        catch (Exception e) {
            ResourceStore.error("EmailInfo: " + content, e);
            this.from = orig;
            this.subject = content;
        }
    }

    private void setContent(String content) throws Exception {
        String messageText = content.replace("\r\n", "\\r\\n");
        messageText = messageText.replace("\n", "\\n");
        Map map = new JSONObject(messageText).getMap();
        this.to = (String)map.get("to");
        this.cc = (String)map.get("cc");
        this.bcc = (String)map.get("bcc");
        this.from = (String)map.get("from");
        this.replyto = (String)map.get("replyto");
        this.subject = (String)map.get("subject");
        this.text = (String)map.get("text");
        this.html = (String)map.get("html");
        this.filename = (String)map.get("file");
        if (this.text != null) {
            this.text = this.text.replace("\\r", "\r");
            this.text = this.text.replace("\\n", "\n");
            this.text = this.text.replace("\\\"", "\"");
        }
        this.target = (String)map.get("target");
    }

    protected EmailInfo(String to, String cc, String bcc, String from, String subject, String text, String html, List<File> attachments) throws Exception {
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.from = from;
        this.subject = subject;
        this.text = text;
        this.html = html;
        this.attachments = attachments;
        this.setType(5);
    }

    @Override
    protected Map getMap() {
        Map map = super.getMap();
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("to", this.to);
        if (this.cc != null && this.cc.length() > 0) {
            content.put("cc", this.cc);
        }
        if (this.bcc != null && this.bcc.length() > 0) {
            content.put("bcc", this.bcc);
        }
        content.put("from", this.from);
        content.put("subject", this.subject);
        content.put("file", this.filename);
        map.put("content", content);
        return map;
    }

    @Override
    public String toString() {
        return this.subject;
    }

    @Override
    public boolean isLoaded() {
        return !(!super.isLoaded() && this.filename != null || this.html == null && this.text == null && this.attachments != null);
    }

    @Override
    public void setFile(File file) {
        super.setFile(file);
        this.attachments = null;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    public String getPartyName() {
        String name = this.getStatus() == 2 || this.getStatus() == 1 ? this.from : this.to;
        if (name == null) {
            return "Unknown";
        }
        int n = name.indexOf(60);
        if (n != -1 && (name = name.substring(0, name.indexOf(60)).trim()).startsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public String getBodyAsHtml() {
        if (this.attachments == null) {
            File emlfile = this.getFile();
            try {
                this.parseEml(emlfile);
            }
            catch (Exception e) {
                ResourceStore.error("EmailInfo: parse " + emlfile, e);
            }
        }
        if (this.html != null) {
            return this.html;
        }
        return this.textToHtml(this.text);
    }

    public String getReplyAddress() {
        return this.target != null ? this.target : this.to;
    }

    public String getTo() {
        return this.to;
    }

    public String getCc() {
        return this.cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public String getFrom() {
        return this.from;
    }

    public String getReplyTo() {
        return this.replyto;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            if (this.html != null) {
                return Utils.htmlToText(this.html);
            }
            this.parse();
            if (this.text == null && this.html != null) {
                return Utils.htmlToText(this.html);
            }
        }
        return this.text;
    }

    public String getHtml() {
        if (this.html == null) {
            this.parse();
        }
        return this.html;
    }

    public List<File> getAttachments() {
        if (this.attachments == null) {
            this.parse();
        }
        return this.attachments;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setTo(String text) {
        this.to = text;
    }

    public void setCc(String text) {
        this.cc = text;
    }

    public void setBcc(String text) {
        this.bcc = text;
    }

    public void setFrom(String text) {
        this.from = text;
    }

    public void setSubject(String text) {
        this.subject = text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public void setAttachments(List<File> files) {
        this.attachments = files;
    }

    @Override
    protected void setFileName(String name) {
        this.setContent(name, 5);
    }

    private void parse() {
        File emlfile = super.getFile();
        ResourceStore.toLog("EmailInfo: parse " + emlfile);
        try {
            this.parseEml(emlfile);
        }
        catch (Exception e) {
            ResourceStore.error("EmailInfo: parse " + emlfile, e);
        }
    }

    private void parseEml(File emlfile) throws Exception {
        if (emlfile == null) {
            return;
        }
        Properties props = new Properties();
        props.put("mail.host", "smtp.dummydomain.com");
        props.put("mail.transport.protocol", "smtp");
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        FileInputStream source = new FileInputStream(emlfile);
        MimeMessage message = new MimeMessage(mailSession, (InputStream)source);
        MimeMessageParser mimeMessageParser = new MimeMessageParser(message);
        HashMap<String, String> embedded = new HashMap<String, String>();
        this.attachments = new ArrayList<File>();
        File filedir = emlfile.getParentFile();
        List<MimePart> attachmentsList = mimeMessageParser.getAttachments();
        for (int i = 0; i < attachmentsList.size(); ++i) {
            MimePart mp = attachmentsList.get(i);
            String contentType = mp.getContentType();
            Object filename = mp.getFileName();
            if (filename == null) {
                filename = mp.getDataHandler().getDataSource().getName();
                if (filename == null) {
                    String ext = contentType.substring(contentType.indexOf(47) + 1);
                    if (ext.equals("rfc822")) {
                        ext = "eml";
                    } else {
                        int k = ext.indexOf(59);
                        if (k != -1) {
                            ext = ext.substring(0, k);
                        }
                    }
                    filename = Utils.generateDigitString(10) + "." + ext;
                }
            } else {
                filename = Utils.decodeRFC2047((String)filename);
            }
            int j = 1;
            File attachment = new File(filedir, (String)filename);
            while (attachment.exists()) {
                File dir;
                if (!(dir = new File(filedir, String.valueOf(j++))).exists()) {
                    dir.mkdir();
                }
                attachment = new File(dir, (String)filename);
            }
            try {
                FileOutputStream fos = new FileOutputStream(attachment);
                InputStream is = mp.getInputStream();
                byte[] b = new byte[4096];
                int n = 0;
                while ((n = is.read(b)) != -1) {
                    fos.write(b, 0, n);
                }
                fos.close();
            }
            catch (Exception e) {
                continue;
            }
            String disposition = mp.getDisposition();
            String cid = mp.getContentID();
            if (!"attachment".equals(disposition) && cid != null) {
                embedded.put(cid, attachment.getAbsolutePath());
                continue;
            }
            this.attachments.add(attachment);
        }
        String body = mimeMessageParser.getBodyText();
        if (mimeMessageParser.isHtml()) {
            if (!embedded.isEmpty()) {
                body = this.embedFiles(body, embedded);
            }
            this.setHtml(body);
        } else {
            this.setText(body);
        }
    }

    private String embedFiles(String html, Map files) {
        Object newhtml = html;
        for (Object cid : files.keySet()) {
            String fileurl = "file:" + File.separator + File.separator + files.get(cid);
            cid = "cid:" + ((String)cid).substring(1, ((String)cid).length() - 1);
            int n = 0;
            while ((n = ((String)newhtml).indexOf((String)cid, n)) != -1) {
                newhtml = ((String)newhtml).substring(0, n) + fileurl + ((String)newhtml).substring(n + ((String)cid).length());
            }
        }
        return newhtml;
    }

    private String htmlToText(String html) {
        String str = html.replace("</p>", "\r\n");
        str = str.replace("<br", "\r\n<br");
        Pattern pattern = Pattern.compile("<[^>]*>");
        Matcher matcher = pattern.matcher(str);
        StringBuffer sb = new StringBuffer(str.length());
        while (matcher.find()) {
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        String txt = sb.toString().trim();
        txt = txt.replace("&nbsp;", " ");
        txt = txt.replace("&amp;", "&");
        txt = txt.replace("&lt;", "<");
        txt = txt.replace("&gt;", ">");
        return txt;
    }

    private String textToHtml(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastWasBlankChar = true;
                sb.append(' ');
                continue;
            }
            lastWasBlankChar = false;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\n') {
                sb.append("<br>");
                continue;
            }
            if (c == '\r') continue;
            int ci = 0xFFFF & c;
            if (ci < 160) {
                sb.append(c);
                continue;
            }
            sb.append("&#");
            sb.append(new Integer(ci).toString());
            sb.append(';');
        }
        Object text = sb.toString();
        int n = ((String)text).indexOf("http://");
        if (n == -1) {
            n = ((String)text).indexOf("https://");
        }
        if (n == -1) {
            n = ((String)text).indexOf("www.");
        }
        if (n != -1) {
            int m = ((String)text).indexOf(32, n);
            if (m == -1) {
                m = ((String)text).indexOf("<br>", n);
            }
            if (m != -1) {
                String url = ((String)text).substring(n, m);
                text = ((String)text).substring(0, n) + "<a href=\"" + url + "\">" + url + "</a>" + ((String)text).substring(m);
            } else {
                String url = ((String)text).substring(n);
                text = ((String)text).substring(0, n) + "<a href=\"" + url + "\">" + url + "</a>";
            }
        }
        return text;
    }

    protected void writeTo(File emlfile) throws Exception {
        if (this.from == null) {
            throw new Exception("No sender address in \"From\" field");
        }
        Properties props = new Properties();
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(mailSession);
        String charset = "UTF-8";
        msg.setFrom((Address)new InternetAddress(this.from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
        if (this.cc != null && this.cc.length() > 0) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cc, (boolean)false));
        }
        if (this.bcc != null && this.bcc.length() > 0) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.bcc, (boolean)false));
        }
        msg.setSubject(this.subject, charset);
        msg.setHeader("X-Mailer", "Smile");
        msg.setSentDate(new Date());
        if (this.html == null && this.attachments.isEmpty()) {
            msg.setText(this.text, charset, "plain");
        } else {
            MimeMultipart mpalt = null;
            if (this.html != null) {
                mpalt = new MimeMultipart("alternative");
                MimeBodyPart mbp2 = new MimeBodyPart();
                mpalt.addBodyPart((BodyPart)mbp2);
                mbp2.setText(this.htmlToText(this.html), charset, "plain");
                MimeBodyPart mbp1 = new MimeBodyPart();
                mpalt.addBodyPart((BodyPart)mbp1);
                mbp1.setText(this.html, charset, "html");
            }
            if (this.attachments.isEmpty()) {
                msg.setContent((Multipart)mpalt);
            } else {
                MimeBodyPart mbp;
                MimeMultipart mp = new MimeMultipart();
                if (mpalt != null) {
                    mbp = new MimeBodyPart();
                    mbp.setContent((Multipart)mpalt);
                    mp.addBodyPart((BodyPart)mbp);
                } else {
                    mbp = new MimeBodyPart();
                    mbp.setText(this.getText(), charset, "text");
                    mp.addBodyPart((BodyPart)mbp);
                }
                for (int i = 0; i < this.attachments.size(); ++i) {
                    File file = this.attachments.get(i);
                    MimeBodyPart mbp2 = new MimeBodyPart();
                    FileDataSource ds = new FileDataSource(file);
                    mbp2.setDataHandler(new DataHandler((DataSource)ds));
                    mbp2.setFileName(file.getName());
                    mp.addBodyPart((BodyPart)mbp2);
                }
                msg.setContent((Multipart)mp);
            }
        }
        FileOutputStream fos = new FileOutputStream(emlfile);
        msg.writeTo((OutputStream)fos);
        fos.close();
    }
}

