/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import com.smile.telephony.AudioConverter;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import smile.cti.client.FileTransferListener;
import smile.cti.client.MessageInfo;
import smile.web.client.Tracker;

public class FileInfo
extends MessageInfo
implements Tracker,
FileTransferListener {
    static final long serialVersionUID = 9123124885932124777L;
    private File file;
    private long fileLength;
    private long loadedBytes;
    private long loadingStart;
    private boolean loading;
    private boolean cancelled;
    private String errorMessage;
    private long lastLoadedBytes;
    private long lastLoadingTime;
    private boolean owner;
    private long mediaDuration;
    private Map properties = new HashMap();
    private transient List<FileTransferListener> listeners = new Vector<FileTransferListener>();
    public static final String[] EXEC = new String[]{"ACTION", "APK", "APP", "BAT", "BIN", "CMD", "COM", "COMMAND", "CPL", "CSH", "EXE", "GADGET", "INF1", "INS", "INX", "IPA", "ISU", "JOB", "JSE", "KSH", "LNK", "MSC", "MSI", "MSP", "MST", "OSX", "OUT", "PAF", "PIF", "PRG", "PS1", "REG", "RGS", "RUN", "SCR", "SCT", "SHB", "SHS", "U3P", "VB", "VBE", "VBS", "VBSCRIPT", "WORKFLOW", "WS", "WSF", "WSH", "SH", "DLL"};
    public static final String[] VIDEO = new String[]{"webm", "mkv", "flv", "vob", "avi", "qt", "mov", "wmv", "mp4", "m4p", "m4v", "mpg", "mpeg", "3gp", "3g2", "amv", "svi"};
    public static final String[] AUDIO = new String[]{"aif", "iff", "m3u", "m4a", "mid", "mp3", "mpa", "wma", "wav"};
    public static final String[] IMAGE = new String[]{"png", "gif", "jpg", "jpeg", "heic"};

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new Vector<FileTransferListener>();
    }

    protected FileInfo() {
        this.owner = true;
    }

    protected FileInfo(String id, String orig, String content, int type, int status, long time) {
        super(id, orig, content, type, status, time);
    }

    protected Map getProperties() {
        return this.properties;
    }

    @Override
    protected Map getMap() {
        Map prms = super.getMap();
        if (this.file != null) {
            prms.put("length", this.file.length());
        }
        return prms;
    }

    public void addTransfrerListener(FileTransferListener listener) {
        if (!(this.listeners.contains(listener) || listener instanceof FileInfo && ((FileInfo)listener).listeners.contains(this))) {
            this.listeners.add(listener);
        }
    }

    public void removeTransfrerListener(FileTransferListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isOwner() {
        return this.owner;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean b) {
        this.loading = b;
    }

    public void cancel() {
        this.cancel("");
    }

    protected void cancel(String message) {
        this.cancelled = true;
        this.loading = false;
        this.errorMessage = message;
        if (this.file != null) {
            this.file.delete();
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).transferEnded(this);
        }
    }

    @Override
    public void onload(int bytes) {
        this.loadedBytes += (long)bytes;
        if (this.cancelled) {
            throw new IllegalStateException("cancelled");
        }
        if (!this.loading) {
            this.onTransferStarted();
        } else {
            this.onTransferProgress();
        }
    }

    private void onTransferStarted() {
        this.cancelled = false;
        this.loading = true;
        this.lastLoadingTime = this.loadingStart = System.currentTimeMillis();
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).transferStarted(this);
        }
    }

    private void onTransferProgress() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).transferProgress(this);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getLoadedBytes() {
        return this.loadedBytes;
    }

    public float getLoadingPercent() {
        if (this.fileLength == 0L) {
            return 0.0f;
        }
        return (float)this.loadedBytes * 1.0f / (float)this.fileLength;
    }

    public int getLoadingRate() {
        long now = System.currentTimeMillis();
        if (now == this.lastLoadingTime) {
            return 0;
        }
        int rate = (int)((this.loadedBytes - this.lastLoadedBytes) * 1000L / (now - this.lastLoadingTime));
        this.lastLoadedBytes = this.loadedBytes;
        this.lastLoadingTime = now;
        return rate;
    }

    public int getLoadingTime() {
        return (int)((System.currentTimeMillis() - this.loadingStart) / 1000L);
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public boolean isLoaded() {
        return this.file != null && !this.loading && this.fileLength > 0L && this.loadedBytes >= this.fileLength && this.file.length() > 0L;
    }

    public boolean isThumbnail() {
        return this.isImage() && this.file.getName().endsWith(this.getFilename() + ".jpg");
    }

    @Override
    public void setFileLength(long length) {
        this.fileLength = length;
        this.cancelled = false;
    }

    public boolean exists() {
        return this.file != null && this.file.length() > 0L;
    }

    protected void setFileName(String filename) {
        this.setContent(filename, 2);
    }

    public String getFilename() {
        String str;
        int n;
        if (this.getType() == 20 && (n = (str = this.getContent()).indexOf("\"content\":\"")) != -1 && (n = (str = str.substring(n + 11)).indexOf("\"")) != -1) {
            str = str.substring(0, n);
            if (this.owner) {
                str = str.substring(str.indexOf(45) + 1);
            }
            return str;
        }
        return this.getContent();
    }

    public String getFilePath() {
        return this.file.getAbsolutePath();
    }

    protected void setLoaded() {
        this.loading = false;
        if (this.loadedBytes > this.fileLength) {
            this.fileLength = this.loadedBytes;
        } else {
            this.loadedBytes = this.fileLength;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).transferEnded(this);
        }
    }

    protected void setLoadedBytes(long bytes) {
        this.loadedBytes = bytes;
    }

    protected void setFile(File file) {
        this.file = file;
        if (file == null) {
            this.fileLength = -1L;
        } else {
            this.setFileLength(file.length());
            this.loadedBytes = this.fileLength;
            if (this.getType() == 13 || file.getName().toLowerCase().endsWith(".wav")) {
                try {
                    this.mediaDuration = AudioConverter.getMediaDuration(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void setMediaDuration(long duration) {
        this.mediaDuration = duration;
    }

    protected File getFile() {
        return this.file;
    }

    public String getFileName() {
        String filename = this.getFilename();
        if (this.owner) {
            return filename;
        }
        if (filename == null) {
            return null;
        }
        int n = filename.indexOf(45);
        if (n != -1) {
            filename = filename.substring(n + 1);
        }
        return filename;
    }

    @Override
    public String toString() {
        return this.getFileName();
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public long getMediaDuration() {
        return this.mediaDuration;
    }

    public boolean isImage() {
        return this.matchSuffixes(IMAGE);
    }

    public boolean isAudio() {
        return this.matchSuffixes(AUDIO);
    }

    public boolean isVideo() {
        return this.matchSuffixes(VIDEO);
    }

    private boolean matchSuffixes(String[] suffixes) {
        String filename = this.getFilename();
        if (filename == null) {
            return false;
        }
        filename = filename.toLowerCase();
        for (int i = 0; i < suffixes.length; ++i) {
            if (!filename.endsWith("." + suffixes[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isSound() {
        return this.getType() == 13 || this.getType() == 20 && this.getFilename().endsWith(".wav");
    }

    public boolean isExecutable() {
        return FileInfo.isExecutable(this.getFilename());
    }

    @Override
    public void transferStarted(FileInfo fileInfo) {
        this.loadedBytes = fileInfo.getLoadedBytes();
        this.onTransferStarted();
    }

    @Override
    public void transferProgress(FileInfo fileInfo) {
        this.loadedBytes = fileInfo.getLoadedBytes();
        this.onTransferProgress();
    }

    @Override
    public void transferEnded(FileInfo fileInfo) {
        if (fileInfo.isCancelled()) {
            this.cancel(fileInfo.getErrorMessage());
            this.setFile(null);
        } else {
            this.setFile(fileInfo.getFile());
            this.setLoaded();
        }
    }

    public static boolean isExecutable(String filename) {
        int n = filename.lastIndexOf(46);
        if (n == -1) {
            return true;
        }
        String ext = filename.substring(n + 1).toUpperCase();
        for (int i = 0; i < EXEC.length; ++i) {
            if (!ext.equals(EXEC[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isAudio(String filename) {
        return FileInfo.match(filename, AUDIO);
    }

    public static boolean isImage(String filename) {
        return FileInfo.match(filename, IMAGE);
    }

    public static boolean isVideo(String filename) {
        return FileInfo.match(filename, VIDEO);
    }

    private static boolean match(String filename, String[] suffixes) {
        int n = filename.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String ext = filename.substring(n + 1).toLowerCase();
        for (int i = 0; i < suffixes.length; ++i) {
            if (!ext.equals(suffixes[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasFile() {
        return this.file != null;
    }
}

