/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import org.json.smile.JSONObject;
import org.json.smile.Utility;
import smile.util.ResourceStore;
import smile.web.client.HttpRequest;
import smile.web.client.SocketChannel;
import smile.web.client.Tracker;

public class HttpConnection {
    private boolean secure;
    private String address;
    private String username;
    private String password;
    private String proxy;
    private Set channels = new HashSet();

    public HttpConnection(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.clearChannels();
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public Map sendCommand(String method, Map params) throws Exception {
        Map<String, Integer> res;
        int responseCode;
        String url = (this.secure ? "https" : "http") + "://" + this.address;
        if (this.username == null && this.address.indexOf(47) == -1) {
            url = url + "/public";
        }
        HttpRequest request = new HttpRequest(url, this.proxy);
        request.setCredentials(this.username, this.password);
        if (this.username == null) {
            request.setHeader("Connection", "close");
        }
        if (params.containsKey("file")) {
            params.put("method", method);
            responseCode = request.postFile(params);
        } else {
            Object prms = "";
            for (String key : params.keySet()) {
                prms = (String)prms + "\"" + key + "\":\"" + params.get(key) + "\",";
            }
            prms = ((String)prms).substring(0, ((String)prms).length() - 1);
            String json = "{\"method\":\"" + method + "\", \"params\":{" + (String)prms + "}}";
            request.setHeader("Content-Type", "application/json");
            responseCode = request.post(json);
        }
        if (responseCode == 200) {
            String ch = request.getResponseHeader("Content-Length");
            int length = ch != null ? Integer.parseInt(ch) : 1024;
            byte[] buffer = new byte[length];
            request.getInputStream().read(buffer);
            String str = new String(buffer);
            JSONObject jsonres = Utility.parseJson(str);
            JSONObject result = (JSONObject)jsonres.get("result");
            if (result == null) {
                result = (JSONObject)jsonres.get("error");
            }
            res = result != null ? result.getMap() : jsonres.getMap();
        } else {
            res = new HashMap<String, Integer>();
            res.put("code", responseCode);
        }
        request.close();
        return res;
    }

    public int getFile(String resource, File file, Tracker tracker, Map properties, Cipher cipher) throws Exception {
        Exception exception = new Exception("Unexpected Error");
        for (int i = this.channels.size(); i >= 0; --i) {
            HttpRequest request = this.createRequest(resource);
            request.setHeader("Connection", "Keep-Alive");
            Number ts = (Number)properties.get("timestamp");
            if (ts != null) {
                request.setHeader("X-Timestamp", String.valueOf(ts));
            }
            try {
                int n;
                String cdh;
                int status = request.get(file, tracker, cipher);
                this.releaseRequest(request);
                String lastModified = request.getResponseHeader("Last-Modified");
                if (lastModified != null && lastModified.length() != 0) {
                    try {
                        file.setLastModified(HttpRequest.TIME_FORMAT.parse(lastModified).getTime());
                    }
                    catch (Exception ee) {
                        ResourceStore.error("getFile " + resource + " lastModified=" + lastModified, ee);
                    }
                }
                if (status == 200) {
                    properties.put("file-content-type", request.getResponseHeader("Content-Type"));
                    properties.put("file-encrypted", cipher != null);
                }
                if ((cdh = request.getResponseHeader("Content-Disposition")) != null && (n = cdh.indexOf("filename=")) != -1) {
                    String filename = cdh.substring(n + 9);
                    if (filename.startsWith("\"")) {
                        filename = filename.substring(1, filename.length() - 1);
                    }
                    properties.put("filename", filename);
                }
                return status;
            }
            catch (Exception e) {
                ResourceStore.error("getFile " + resource, e);
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public int postFile(String resource, Map params) throws Exception {
        Exception exception = new Exception("Unexpected Error");
        for (int i = this.channels.size(); i >= 0; --i) {
            HttpRequest request = this.createRequest(resource);
            try {
                int status = request.postFile(params);
                this.releaseRequest(request);
                return status;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public int putFile(String resource, File file, Tracker tracker) throws Exception {
        Exception exception = new Exception("Unexpected Error");
        for (int i = this.channels.size(); i >= 0; --i) {
            HttpRequest request = this.createRequest(resource);
            request.setHeader("X-Timestamp", String.valueOf(file.lastModified()));
            try {
                int status = request.put(file, tracker);
                this.releaseRequest(request);
                return status;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    public int deleteFile(String resource) throws Exception {
        Exception exception = new Exception("Unexpected Error");
        for (int i = this.channels.size(); i >= 0; --i) {
            HttpRequest request = this.createRequest(resource);
            try {
                int status = request.delete();
                this.releaseRequest(request);
                return status;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw exception;
    }

    private synchronized HttpRequest createRequest(String resource) throws Exception {
        String url = (this.secure ? "https" : "http") + "://" + this.address + "/" + resource;
        HttpRequest request = new HttpRequest(url, this.proxy);
        request.setCredentials(this.username, this.password);
        if (!this.channels.isEmpty()) {
            try {
                SocketChannel channel = (SocketChannel)this.channels.iterator().next();
                this.channels.remove(channel);
                if (channel.isConnected()) {
                    request.setChannel(channel);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ResourceStore.toLog("createRequest " + url + " channel=" + request.getChannel() + " channels=" + this.channels.size());
        return request;
    }

    private void releaseRequest(HttpRequest request) {
        SocketChannel channel = request.getChannel();
        if (channel != null) {
            if (this.channels.size() < 5) {
                this.channels.add(channel);
            } else {
                channel.close();
            }
        }
        ResourceStore.toLog("releaseRequest channel=" + channel + " channels=" + this.channels.size());
    }

    private synchronized void clearChannels() {
        for (SocketChannel channel : this.channels) {
            channel.close();
        }
        this.channels.clear();
    }
}

