/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import smile.cti.client.Activity;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineEventListener;
import smile.cti.client.SessionInfo;
import smile.cti.phone.LinePane;
import smile.util.ResourceStore;

public class LineInfo
implements LinePane {
    private String lineName;
    private SessionInfo session;
    private Set<ContactInfo> parties;
    private int state;
    private String description;
    private String connectedNumber;
    private boolean video;
    private boolean recording;
    private boolean autoanswer;
    private long connectionStart;
    private Set<LineEventListener> listeners = new HashSet<LineEventListener>();
    private String conferenceId;
    private String conferenceOwner;
    private String callId;
    private String callerName;
    private String calledName;
    private boolean inbound;
    private Map callInfo;
    private Activity activity;
    private int lastDisconnectCause;
    private int previousState;
    private boolean mute;

    protected LineInfo(String name) {
        this.lineName = name;
        this.parties = new HashSet<ContactInfo>();
    }

    public void addLineEventListener(LineEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeLineEventListener(LineEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners() {
        Iterator<LineEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().stateChanged(this);
            }
            catch (Exception e) {
                ResourceStore.error(this + " notifyListeners: " + e);
                break;
            }
        }
    }

    public String getName() {
        return this.lineName;
    }

    public Set<ContactInfo> getContacts() {
        return this.parties;
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.session != null && this.session.isGroup()) {
            return this.session.toString();
        }
        Set<ContactInfo> set = this.parties;
        synchronized (set) {
            switch (this.parties.size()) {
                case 0: {
                    return this.description != null ? this.description : this.lineName;
                }
                case 1: {
                    return this.parties.iterator().next().toString();
                }
            }
            Object str = "";
            Iterator<ContactInfo> it = this.parties.iterator();
            while (it.hasNext()) {
                str = (String)str + it.next() + ", ";
            }
            return ((String)str).length() > 0 ? ((String)str).substring(0, ((String)str).length() - 2) : str;
        }
    }

    public String getDescription() {
        if (this.conferenceId != null && !this.parties.isEmpty()) {
            return this.toString();
        }
        return this.description;
    }

    public boolean isVideoEnabled() {
        return this.video;
    }

    public int getConnectionTime() {
        if (this.connectionStart == 0L) {
            return 0;
        }
        return (int)(System.currentTimeMillis() - this.connectionStart) / 1000;
    }

    public long getConnectionStartTimestamp() {
        return this.connectionStart;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean rec) {
        this.recording = rec;
        Iterator<LineEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().setRecording(this, rec);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setActive(boolean mode) {
        if (mode && this.state == 4) {
            this.state = 3;
            this.notifyListeners();
        } else if (!mode && this.state == 3) {
            this.state = 4;
            this.notifyListeners();
        }
    }

    @Override
    public void setState(int state, String description) {
        this.description = description;
        if (state == 2 || state == 1) {
            this.connectedNumber = description;
        } else if (state == 8) {
            this.video = false;
            try {
                this.lastDisconnectCause = Integer.parseInt(description);
            }
            catch (Exception e) {
                this.lastDisconnectCause = this.connectionStart > 0L ? 16 : 0;
            }
        }
        this.setState(state);
    }

    @Override
    public void setState(int s) {
        this.previousState = this.state;
        this.state = s;
        if (this.state == 2) {
            this.inbound = true;
        } else if (this.state == 1) {
            this.inbound = false;
            if (this.connectedNumber == null || this.connectedNumber.startsWith("PICKUP*")) {
                return;
            }
        } else if (this.state == 3 && this.connectionStart == 0L) {
            this.connectionStart = System.currentTimeMillis();
        } else if (this.state == 0) {
            this.mute = false;
            this.recording = false;
            this.autoanswer = false;
            this.connectionStart = 0L;
            this.conferenceId = null;
            this.conferenceOwner = null;
            this.connectedNumber = null;
            this.description = null;
            this.calledName = null;
            this.callerName = null;
            this.callId = null;
            this.callInfo = null;
            this.activity = null;
            this.session = null;
            this.parties.clear();
        }
        this.notifyListeners();
        if (this.state == 9) {
            this.state = this.isConference() ? 5 : 3;
        }
    }

    @Override
    public void setStateDescription(String desc) {
        this.description = desc;
        if (desc != null && desc.startsWith("push")) {
            this.autoanswer = true;
        }
    }

    @Override
    public void setCallProperties(Map map) {
        this.video = map.get("cti.VideoCodec") != null;
        this.callId = (String)map.get("cti.CallID");
        boolean isInbound = Boolean.FALSE.equals(map.get("cti.OffHook"));
        if (isInbound) {
            this.callerName = (String)map.get("cti.CallingName");
            this.calledName = (String)map.get("cti.CalledName");
        }
        this.autoanswer = map.get("cti.AUTOANSWER") != null;
        ResourceStore.toLog(this + " setCallProperties isInbound=" + isInbound + " video=" + this.video + " callId=" + this.callId + " callerName=" + this.callerName + " calledName=" + this.calledName);
    }

    public String getCalledName() {
        return this.calledName;
    }

    public String getCallerName() {
        return this.callerName;
    }

    public String getPartyName() {
        String name = this.toString();
        String number = this.getConnectedNumber();
        if (this.callerName != null && this.callerName.length() > 0 && number != null && (name.endsWith(number) || number.endsWith(name) || this.callerName.endsWith(name))) {
            name = this.callerName;
        }
        return name;
    }

    public String getPartyNumber() {
        String number = this.getConnectedNumber();
        if (this.callerName != null && this.callerName.endsWith(number) && !this.callerName.equals(this.getPartyName())) {
            number = this.callerName;
        }
        return number;
    }

    @Override
    public void setVideo(boolean on) {
        this.video = on;
    }

    @Override
    public void fireAction(String cmd) {
    }

    @Override
    public void showActionMenu(int x, int y, Vector menuItems) {
    }

    @Override
    public void showAnswerActionMenu(int x, int y, Vector fwdNumbers) {
    }

    public boolean isAutoanswer() {
        return this.autoanswer;
    }

    protected void setSessionInfo(SessionInfo sessionInfo, String number) {
        this.description = number;
        this.connectedNumber = number;
        this.callerName = sessionInfo.getName();
        if (this.state == 3 || this.state == 5) {
            this.previousState = this.state;
        }
        this.setSessionInfo(sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSessionInfo(SessionInfo sessionInfo) {
        this.session = sessionInfo;
        if (this.session == null) {
            return;
        }
        Set<ContactInfo> set = this.parties;
        synchronized (set) {
            this.parties.clear();
        }
        if (!this.session.isGroup() && this.session.getParties().size() == 1) {
            ContactInfo contact = this.session.getParties().iterator().next();
            this.addContactInfo(contact);
            if (this.connectedNumber == null || this.connectedNumber.equals(contact.getUserID())) {
                String ext = (String)contact.getProperty("extension");
                if (ext == null) {
                    ext = (String)contact.getProperty("ext");
                }
                if (ext != null) {
                    this.connectedNumber = ext;
                }
            }
        }
        Iterator<LineEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().identityChanged(this);
            }
            catch (Exception e) {
                ResourceStore.error(this + " notifyListeners: " + e);
                break;
            }
        }
    }

    public SessionInfo getSessionInfo() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContactInfo(ContactInfo contact) {
        Set<ContactInfo> set = this.parties;
        synchronized (set) {
            this.parties.add(contact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeContactInfo(ContactInfo contact) {
        Set<ContactInfo> set = this.parties;
        synchronized (set) {
            return this.parties.remove(contact);
        }
    }

    protected boolean containsParty(String userid) {
        if (this.session == null) {
            return false;
        }
        Iterator<ContactInfo> itr = this.session.getParties().iterator();
        while (itr.hasNext()) {
            if (!userid.equals(itr.next().getUserID())) continue;
            return true;
        }
        return false;
    }

    protected boolean containsParty(ContactInfo contact) {
        if (this.session == null) {
            return false;
        }
        Iterator<ContactInfo> itr = this.session.getParties().iterator();
        while (itr.hasNext()) {
            if (!contact.equals(itr.next())) continue;
            return true;
        }
        return false;
    }

    protected void setConnectedNumber(String number) {
        this.connectedNumber = number;
    }

    public String getConnectedNumber() {
        return this.connectedNumber != null ? this.connectedNumber : this.description;
    }

    public void setConferenceId(String id, String owner) {
        this.conferenceId = id;
        this.conferenceOwner = owner;
        if (id == null && this.state == 5) {
            this.state = 3;
            if (this.parties.size() == 1) {
                this.connectedNumber = this.parties.iterator().next().getPrimaryPhoneNumber();
            }
        }
        if (this.state != 0) {
            this.notifyListeners();
        }
    }

    public String getConferenceId() {
        return this.conferenceId;
    }

    public String getConferenceOwner() {
        return this.conferenceOwner;
    }

    public String getCallId() {
        return this.callId;
    }

    public int getLastDisconnectCause() {
        return this.lastDisconnectCause;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    public boolean isExternal() {
        return this.session != null && this.session.isExternal();
    }

    @Override
    public boolean isConference() {
        return this.conferenceId != null || this.parties.size() > 1;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public Activity getActivity() {
        if (this.activity == null) {
            this.activity = new Activity(this.inbound ? "inbound" : "outbound");
            if (!this.parties.isEmpty()) {
                this.activity.setUserId(this.parties.iterator().next().getUserID());
            }
            if (this.session != null) {
                this.activity.setSessionId(this.session.getSessionId());
            }
        }
        return this.activity;
    }

    protected void setActivity(Activity activity) {
        this.activity = activity;
    }

    protected void setActivity(Map activityMap) {
        this.activity = new Activity(activityMap);
        String userid = (String)activityMap.get("userid");
        if (userid != null) {
            for (ContactInfo contactInfo : this.session.getParties()) {
                if (!userid.equals(contactInfo.getUserID())) continue;
                if (this.activity.getId() == null) break;
                contactInfo.addActivity(this.activity);
                if (this.activity.getSessionId() != null) break;
                this.activity.setSessionId(this.session.getSessionId());
                break;
            }
        }
    }

    public Map getCallInfo() {
        if (this.callInfo == null) {
            return null;
        }
        Map actmap = (Map)this.callInfo.get("activity");
        actmap.put("subject", this.activity.getSubject());
        actmap.put("comment", this.activity.getComment());
        return this.callInfo;
    }

    protected boolean setCallInfo(Map params) {
        String userid;
        if (this.session == null) {
            return false;
        }
        Map actmap = (Map)params.get("activity");
        this.callInfo = params;
        this.activity = new Activity(actmap);
        if (this.activity.getSessionId() == null) {
            this.activity.setSessionId(this.session.getSessionId());
        }
        if ((userid = (String)actmap.get("userid")) != null) {
            for (ContactInfo contactInfo : this.session.getParties()) {
                if (!userid.equals(contactInfo.getUserID())) continue;
                if (this.activity.getId() == null) break;
                contactInfo.addActivity(this.activity);
                break;
            }
        }
        this.notifyListeners();
        return true;
    }

    public void setMute(boolean mode) {
        this.mute = mode;
    }

    public boolean getMute() {
        return this.mute;
    }
}

