/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.util.List;
import java.util.Map;
import org.json.smile.JSONObject;
import smile.cti.client.MessageInfo;

public class MenuInfo
extends MessageInfo {
    static final long serialVersionUID = 7465663742342543894L;
    private List<Map> menu;
    private String title;
    private int rows = 1;
    private int columns = 3;
    private int rowHeight = 60;
    private int fontSize = 10;
    private int imageSize = 20;

    protected MenuInfo() {
    }

    protected MenuInfo(String id, String senderid, String content, int type, int status, long time) {
        super(id, senderid, content, type, status, time);
        this.title = content;
        try {
            Integer n;
            Integer r;
            Map m = new JSONObject(this.getContent()).getMap();
            this.menu = (List)m.get("menu");
            this.title = (String)m.get("title");
            this.setContent(this.title, type);
            Integer f = (Integer)m.get("font_size");
            if (f != null) {
                this.fontSize = f;
            }
            if ((r = (Integer)m.get("row_height")) != null) {
                this.rowHeight = r;
            }
            if ((n = (Integer)m.get("columns")) != null) {
                this.columns = n;
            }
            this.columns = Math.min(this.menu.size(), this.columns);
            this.rows = (int)Math.ceil((double)this.menu.size() / (double)this.columns);
            Integer w = (Integer)m.get("image_size");
            if (w != null) {
                this.imageSize = w;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTitle() {
        return this.title;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public int getRowHeight() {
        return this.menu != null ? this.rowHeight : 0;
    }

    public int getHeight() {
        return this.menu != null ? this.rows * this.rowHeight : 0;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public List<Map> getMenu() {
        return this.menu;
    }

    public void removeMenu() {
        this.menu = null;
    }

    public int getItemCount() {
        return this.menu != null ? this.menu.size() : 0;
    }

    public Map getItem(int index) {
        return this.menu.get(index);
    }
}

