/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.Serializable;
import java.util.Hashtable;

public class PbxFeature
implements Serializable {
    static final long serialVersionUID = 8634569349562352303L;
    public static final int MAX_NUMBER_DIGITS = 2;
    public static final String DND_OVER = "1";
    public static final String CALL_WAIT = "8";
    public static final String BUSY_OVER = "7";
    public static final String MONITOR = "9";
    public static final String MESSAGE = "6";
    public static String[] DEFAULT_NUMBERS = new String[]{"00", "11", "01", "02", "03", "04", "14", "05", "15", "06", "07", "20", "21", "22", "23", "24", "25", "08", "28", "29", "09", "16", "17", "26", "27", "10", "12", "13", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "18", "19"};
    public static String[] SERVICE_NAMES = new String[]{"Log-out from ICD Group", "Log-in to ICD Group", "Hurry-up Transfer (+ ICD Group No)", "Group Call Pickup", "Directed Call Pickup (+ Phone No)", "Call Park", "Call Park Retrieve (+ Phone No)", "Call Park (+ Zone No)", "Call Park Retrieve (+ Zone No)", "User Code Dialing", "Executive Busy Override (Barge-in)", "Executive Busy Override Deny", "Executive Busy Override Allow", "Call Pickup Deny", "Call Pickup Allow", "Do Not Disturb Set", "Do Not Disturb Cancel", "Answering a Call Waiting", "Call Waiting Set", "Call Waiting Cancel", "Call Monitoring", "Call Monitoring Deny", "Call Monitoring Allow", "Phone Lock Set", "Phone Lock Cancel", "Change PIN", "Caller ID Restriction Set", "Caller ID Restriction Cancel", "Forwarding N/A Number", "Forwarding N/A Time", "Forwarding N/A Set", "Forwarding N/A Cancel", "Forwarding Busy Number", "Forwarding Busy Set", "Forwarding Busy Cancel", "Forwarding All Number", "Forwarding All Set", "Forwarding All Cancel", "Follow Me Set", "Follow Me Cancel"};
    public static final int ICD_LOGOUT = 0;
    public static final int ICD_LOGIN = 1;
    public static final int HURRYUP_TRANSFER = 2;
    public static final int PICKUP_GROUP = 3;
    public static final int PICKUP_DIRECT = 4;
    public static final int PARK = 5;
    public static final int PARK_RETRIEVE = 6;
    public static final int PARK_ZONE = 7;
    public static final int PARK_ZONE_RETRIEVE = 8;
    public static final int USER_CODE_DIALING = 9;
    public static final int EXECUTIVE_BUSY_OVERRIDE = 10;
    public static final int EXECUTIVE_BUSY_OVERRIDE_DENY = 11;
    public static final int EXECUTIVE_BUSY_OVERRIDE_ALLOW = 12;
    public static final int PICKUP_DENY = 13;
    public static final int PICKUP_ALLOW = 14;
    public static final int DND_SET = 15;
    public static final int DND_CANCEL = 16;
    public static final int CALL_WAITING = 17;
    public static final int CALL_WAITING_SET = 18;
    public static final int CALL_WAITING_CANCEL = 19;
    public static final int CALL_MONITOR = 20;
    public static final int CALL_MONITOR_DENY = 21;
    public static final int CALL_MONITOR_ALLOW = 22;
    public static final int PHONE_LOCK_SET = 23;
    public static final int PHONE_LOCK_CANCEL = 24;
    public static final int CHANGE_PIN = 25;
    public static final int CLIR_SET = 26;
    public static final int CLIR_CANCEL = 27;
    public static final int FORWARDING_NANS_NUMBER = 28;
    public static final int FORWARDING_NANS_TIME = 29;
    public static final int FORWARDING_NANS_SET = 30;
    public static final int FORWARDING_NANS_CANCEL = 31;
    public static final int FORWARDING_BUSY_NUMBER = 32;
    public static final int FORWARDING_BUSY_SET = 33;
    public static final int FORWARDING_BUSY_CANCEL = 34;
    public static final int FORWARDING_ALL_NUMBER = 35;
    public static final int FORWARDING_ALL_SET = 36;
    public static final int FORWARDING_ALL_CANCEL = 37;
    public static final int FOLLOW_ME_SET = 38;
    public static final int FOLLOW_ME_CANCEL = 39;
    public static final int STATUS = 40;
    public static final int OPERATOR = 41;
    public static final int VOICEMAIL_SET = 42;
    public static final int VOICEMAIL_CANCEL = 43;
    private static Hashtable SPNAMES = new Hashtable();
    public static final String MONITOR_ = "MONITOR";
    public static final String OVERRIDE_ = "OVERRIDE";
    public static final String PICKUP_ = "PICKUP";
    public static final String PARK_ = "PARK";
    public static final String CONFERENCE_ = "CONFERENCE";
    public static final String VIDEOCONFERENCE_ = "VIDEOCONFERENCE";
    public static final String STATUS_ = "0";
    public static final String OPERATOR_ = "9";
    private int type;
    private String number;
    private String description = "";

    public static Object getByAlias(String alias) {
        return SPNAMES.get(alias);
    }

    public static PbxFeature[] getDefaultFeatures() {
        PbxFeature[] features = new PbxFeature[SERVICE_NAMES.length];
        for (int i = 0; i < SERVICE_NAMES.length; ++i) {
            PbxFeature feature = new PbxFeature(i);
            feature.setNumber(DEFAULT_NUMBERS[i]);
            feature.setDescription(SERVICE_NAMES[i]);
            features[i] = feature;
        }
        return features;
    }

    public static Hashtable getDefaultFeatureNumbers() {
        Hashtable<Integer, String> features = new Hashtable<Integer, String>();
        PbxFeature[] pbxFeatures = PbxFeature.getDefaultFeatures();
        for (int i = 0; i < pbxFeatures.length; ++i) {
            features.put(pbxFeatures[i].getType(), pbxFeatures[i].getNumber());
        }
        return features;
    }

    public static int getFeaturesCount() {
        return SERVICE_NAMES.length;
    }

    public static PbxFeature[] updateFeatures(PbxFeature[] features) {
        int i;
        PbxFeature[] newfeatures = new PbxFeature[SERVICE_NAMES.length];
        for (i = 0; i < features.length; ++i) {
            newfeatures[i] = features[i];
        }
        while (i < newfeatures.length) {
            PbxFeature feature = new PbxFeature(i);
            feature.setNumber(DEFAULT_NUMBERS[i]);
            feature.setDescription(SERVICE_NAMES[i]);
            newfeatures[i] = feature;
            ++i;
        }
        return newfeatures;
    }

    public PbxFeature(int stype) {
        this.type = stype;
    }

    public boolean equals(Object obj) {
        return obj instanceof PbxFeature && this.type == ((PbxFeature)obj).getType();
    }

    public int getType() {
        return this.type;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDescription() {
        return this.description;
    }

    public void setNumber(String num) {
        this.number = num;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String toString() {
        return this.description;
    }

    static {
        SPNAMES.put(OVERRIDE_, new PbxFeature(10));
        SPNAMES.put(MONITOR_, new PbxFeature(20));
        SPNAMES.put(PICKUP_, new PbxFeature(4));
        SPNAMES.put(PARK_, new PbxFeature(7));
        SPNAMES.put(STATUS_, new PbxFeature(40));
    }
}

