/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import smile.cti.client.Activity;
import smile.cti.client.ClientConnector;
import smile.cti.client.ConferenceGroup;
import smile.cti.client.ContactGroup;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineInfo;
import smile.cti.client.SIPMessageConnector;
import smile.cti.client.ServiceManager;
import smile.cti.client.SessionInfo;
import smile.cti.phone.Line;
import smile.util.ResourceStore;
import smile.util.Utils;

public class PbxServiceManager
extends ServiceManager {
    private List<ContactGroup> groups = new ArrayList<ContactGroup>();
    private String forwardedExtension;
    private Map serverLines = new HashMap();
    private List trunks = new ArrayList();
    public static final String METHOD_OBJECT_CREATED = "objectCreated";
    public static final String METHOD_OBJECT_UPDATED = "objectUpdated";
    public static final String METHOD_OBJECT_DELETED = "objectDeleted";
    public static final String METHOD_EXTENSION_CREATED = "extensionCreated";
    public static final String METHOD_EXTENSION_DELETED = "extensionDeleted";
    public static final String METHOD_CONFERENCE_UPDATE = "conferenceUpdate";
    public static final int PICKUP = 4;
    public static final int DNDOVER = 8;
    public static final int BUSYOVER = 16;
    public static final int MONITOR = 32;
    public static final int PICKUPDENY = 64;
    public static final int BUSYOVERDENY = 128;
    public static final int MONITORDENY = 512;
    public static final int RECORDING = 16384;
    public static final int VOICEMAIL = 32768;
    public static final String VMAIL_GREETING = "$voicemail_greeting$.wav";
    public static final int GROUP_PICKUPDENY = 256;
    public static final int GROUP_BUSYOVERDENY = 1024;
    public static final int GROUP_MONITORDENY = 2048;
    public static final String MONITOR_ = "MONITOR*";
    public static final String OVERRIDE_ = "OVERRIDE*";
    public static final String PICKUP_ = "PICKUP*";
    public static final String PARK_ = "PARK*";
    public static final String CONFERENCE_ = "CONFERENCE";
    public static final String VIDEOCONFERENCE_ = "VIDEOCONFERENCE";
    public static final String STATUS_ = "0";
    public static final String OPERATOR_ = "9";
    public static final String CALLED = "Call in progress";
    public static final String CONNECTED = "Connected";
    public static final String LEADING = "Leading";
    public static final String SPEAKING = "Speaking";
    public static final String REQUEST = "Requested";
    public static final String MUTED = "Muted";
    public static final String DISCONNECT = "Disconnected";

    public PbxServiceManager(ClientConnector client) throws Exception {
        super(client);
        this.setServerConnector(new SIPMessageConnector(this, "SERVER"));
        this.setAllowAutoanswer(true);
        this.toLog("PbxServiceManager created");
    }

    @Override
    public void processCommand(String method, Map parameters) throws Exception {
        if (method.equals("stateChanged")) {
            String user = (String)parameters.get("userid");
            if (user != null) {
                Map map;
                List list;
                Integer state;
                Boolean b;
                if (user.equals(this.getUserId()) && (b = (Boolean)this.getOwnerProperties().get("fwdall")) != null && b.booleanValue() && ((state = (Integer)parameters.get("state")) == 7 || state == 8) && (list = (List)parameters.get(state == 7 ? "alerted" : "connected")) != null && (map = (Map)list.get(0)) != null) {
                    String string = (String)map.get("party");
                }
                super.processCommand("state", parameters);
            } else {
                String oid = (String)parameters.get("oid");
                Integer state = (Integer)parameters.get("state");
                ContactGroup group = this.getGroup(oid);
                if (group instanceof ConferenceGroup) {
                    ((ConferenceGroup)group).setState(state);
                }
            }
        } else if (method.equals(METHOD_CONFERENCE_UPDATE)) {
            String oid = (String)parameters.get("oid");
            ContactGroup group = this.getGroup(oid);
            if (group instanceof ConferenceGroup) {
                String number = (String)parameters.get("number");
                String status = (String)parameters.get("status");
                Integer state = (Integer)parameters.get("state");
                if (state != null) {
                    ((ConferenceGroup)group).setState(state);
                }
                if (status != null) {
                    ((ConferenceGroup)group).setPartyStatus(number, status);
                }
            } else {
                super.processConferenceUpdate(parameters);
            }
        } else if (method.equals(METHOD_EXTENSION_CREATED)) {
            String kind = (String)parameters.get("kind");
            if ("channel".equals(kind) || "hunting".equals(kind) || "unit".equals(kind) || "selector".equals(kind)) {
                this.addContactInfo(parameters);
            }
        } else if (method.equals(METHOD_OBJECT_CREATED)) {
            String kind = (String)parameters.get("kind");
            if ("user".equals(kind) || "phone".equals(kind)) {
                this.addContactInfo(parameters);
            } else if ("users".equals(kind) || "unit".equals(kind) || "equipment".equals(kind) || "hunting".equals(kind) || "chatchannel".equals(kind) || "selector".equals(kind)) {
                ContactGroup group = new ContactGroup(parameters);
                group.setPermanent(true);
                List list = (List)parameters.get("members");
                if (list != null) {
                    this.updateGroupMembers(group, list);
                    parameters.put("members", list);
                }
                this.addGroup(group);
            }
        } else if (method.equals(METHOD_OBJECT_UPDATED)) {
            String kind = (String)parameters.get("kind");
            if ("user".equals(kind) || "phone".equals(kind)) {
                String userid = (String)parameters.get("userid");
                ContactInfo contact = this.findContact(userid);
                if (contact == null) {
                    this.addContactInfo(parameters);
                } else {
                    if (!userid.equals(this.getUserId())) {
                        String groupid = (String)parameters.get("groupid");
                        String prevgroupid = (String)contact.getProperty("groupid");
                        if (groupid != null && !groupid.equals(prevgroupid)) {
                            ContactGroup group = this.getGroup(groupid);
                            if (group != null) {
                                group.add(contact);
                            }
                            if (prevgroupid != null && (group = this.getGroup(prevgroupid)) != null) {
                                group.remove(contact);
                            }
                        }
                    }
                    contact.updateProperties(parameters);
                    this.client.contactStatusChanged(contact);
                }
            } else if ("users".equals(kind) || "unit".equals(kind) || "equipment".equals(kind) || "hunting".equals(kind) || "chatchannel".equals(kind) || "selector".equals(kind)) {
                boolean isnew;
                String oid = (String)parameters.get("oid");
                ContactGroup group = this.getGroup(oid);
                boolean bl = isnew = group == null;
                if (isnew) {
                    group = new ContactGroup(parameters);
                    group.setPermanent(true);
                } else {
                    group.setProperties(parameters);
                    if (group.getId().equals(this.getOwner().getProperty("groupid"))) {
                        this.updateContactProperties(this.getOwner(), group);
                    }
                }
                List list = (List)parameters.get("members");
                if (list != null) {
                    group.getMembers().clear();
                    this.updateGroupMembers(group, list);
                    parameters.put("members", list);
                }
                if (isnew) {
                    this.addGroup(group);
                }
            } else if ("channel".equals(kind)) {
                String oid = (String)parameters.get("oid");
                ContactInfo contact = this.findContact(oid);
                if (contact == null) {
                    this.addContactInfo(parameters);
                } else {
                    List list = (List)parameters.get("members");
                    if (list != null && !list.contains(this.getUserId())) {
                        this.removeContact(oid);
                    }
                }
            }
        } else if (method.equals(METHOD_OBJECT_DELETED)) {
            String kind = (String)parameters.get("kind");
            if ("user".equals(kind) || "phone".equals(kind)) {
                this.contactDeleted(parameters);
            } else if ("users".equals(kind) || "unit".equals(kind) || "equipment".equals(kind) || "selector".equals(kind)) {
                String oid = (String)parameters.get("oid");
                this.removeGroup(oid);
            } else if ("channel".equals(kind)) {
                this.removeContact((String)parameters.get("oid"));
            }
        } else if (method.equals(METHOD_EXTENSION_DELETED)) {
            this.removeContact((String)parameters.get("oid"));
        } else {
            super.processCommand(method, parameters);
        }
    }

    private void updateContactProperties(ContactInfo contact, ContactGroup group) {
        Integer pmask = (Integer)group.getProperty("pmask");
        if (pmask == null) {
            return;
        }
        contact.setProperty("pmask", pmask);
        Map features = contact.getPropertiesMap("features");
        if (features != null) {
            if ((pmask & 0x100) == 0) {
                features.remove("pickupdeny");
            }
            if ((pmask & 0x400) == 0) {
                features.remove("busyoverdeny");
            }
            if ((pmask & 0x800) == 0) {
                features.remove("monitordeny");
            }
            if ((pmask & 0x4000) == 0) {
                features.remove("recording");
            }
            if ((pmask & 0x8000) == 0) {
                features.remove("voicemail");
            }
        }
    }

    private void addContactInfo(Map map) {
        ContactInfo contact = new ContactInfo(map);
        contact.setStatus(4);
        this.setContactGroup(contact);
        super.addContactInfo(contact, true);
    }

    protected void setContactGroup(ContactInfo contact) {
        String groupid = (String)contact.getProperty("groupid");
        if (groupid == null) {
            ContactGroup group;
            if (contact.getProperty("kind") != null && (group = this.getGroup("Telephones")) != null) {
                group.add(contact);
            }
        } else {
            for (int i = 0; i < this.groups.size(); ++i) {
                ContactGroup group = this.groups.get(i);
                if (group.getId().equals(groupid)) {
                    contact.setProperty("group", group.getName());
                    group.add(contact);
                    continue;
                }
                List parties = (List)group.getProperty("parties");
                if (parties == null || !parties.contains(contact.getNumber())) continue;
                group.add(contact);
            }
        }
    }

    @Override
    protected void initObjects(Map map) throws Exception {
        int state;
        List selectors;
        super.initObjects(map);
        List groups = (List)map.get("groups");
        if (groups != null) {
            this.initGroups(groups);
        }
        if ((selectors = (List)map.get("selectors")) != null) {
            this.initSelectors(selectors);
        }
        if ((state = super.getUserState()) == 1 || state == 4) {
            this.client.stateChanged(this.isTrunksDisabled() ? 5 : state);
        }
    }

    @Override
    protected ContactInfo addContactInfo(ContactInfo contactInfo, boolean b) {
        ContactInfo contact = super.addContactInfo(contactInfo, b);
        int status = contact.getStatus();
        if (status == -1 && (contact.isUser() || contact.isPhone())) {
            contact.setStatus(4);
        }
        return contact;
    }

    protected void initGroups(List list) {
        this.groups.clear();
        for (Map map : list) {
            ContactGroup group = new ContactGroup(map);
            this.groups.add(group);
            if (!group.getId().equals(this.getOwner().getProperty("groupid"))) continue;
            this.updateContactProperties(this.getOwner(), group);
        }
        ContactGroup phones = new ContactGroup("Telephones");
        phones.setPermanent(true);
        this.groups.add(phones);
    }

    private void initSelectors(List selectors) {
        for (int i = 0; i < selectors.size(); ++i) {
            Map map = (Map)selectors.get(i);
            ConferenceGroup group = new ConferenceGroup(map);
            group.setPermanent(true);
            List list = (List)map.get("members");
            if (list != null) {
                this.updateGroupMembers(group, list);
                map.put("members", list);
            }
            this.groups.add(group);
        }
    }

    @Override
    public List<ContactGroup> getGroups() {
        return this.groups;
    }

    @Override
    protected ContactGroup getGroup(String groupid) {
        if (groupid == null) {
            return null;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            ContactGroup group = this.groups.get(i);
            if (!group.getId().equals(groupid)) continue;
            return group;
        }
        return null;
    }

    protected void addGroup(ContactGroup group) {
        this.groups.add(group);
        this.client.groupAdded(group);
    }

    protected void removeGroup(String groupid) {
        for (int i = 0; i < this.groups.size(); ++i) {
            ContactGroup group = this.groups.get(i);
            if (!group.getId().equals(groupid)) continue;
            this.groups.remove(i);
            this.client.groupRemoved(group);
            break;
        }
    }

    private void updateGroupMembers(ContactGroup group, List list) {
        group.getMembers().clear();
        String prefix = this.getBranchPrefix();
        for (int j = 0; j < list.size(); ++j) {
            String party = prefix + (String)list.get(j);
            if (party.equals(this.getUserId())) continue;
            ContactInfo contact = this.findContact(party);
            if (contact != null) {
                group.add(contact);
                continue;
            }
            group.add(new ContactInfo(party));
        }
    }

    public String getBranchPrefix() {
        ContactInfo myInfo = this.getOwner();
        int n = myInfo.getUserID().indexOf(myInfo.getNumber());
        return n > 0 ? myInfo.getUserID().substring(0, n) : "";
    }

    @Override
    public String createContact(ContactInfo contact, boolean shared) throws Exception {
        if (contact.getStatus() == -1) {
            contact.setStatus(4);
        }
        return super.createContact(contact, shared);
    }

    @Override
    public void updateContact(ContactInfo contact) throws Exception {
        if (contact.getStatus() == 3) {
            contact.setStatus(4);
        }
        super.updateContact(contact);
    }

    @Override
    public ContactInfo getContactInfo(ContactInfo contact) throws Exception {
        if (contact.getProperty("ext") == null) {
            return super.getContactInfo(contact);
        }
        contact.setProperty("info", this.getUserInfo(contact.getUserID()));
        return contact;
    }

    @Override
    protected ContactInfo findContact(String uid) {
        int n = uid.indexOf(CONFERENCE_);
        if (n != -1) {
            uid = uid.substring(n + CONFERENCE_.length() + 1);
        }
        return super.findContact(uid);
    }

    @Override
    public void dropFromConference(ContactInfo contact) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("party", contact.getUserID());
        for (LineInfo line : this.getLines()) {
            String confid = line.getConferenceId();
            if (confid == null || !line.containsParty(contact)) continue;
            prms.put("confid", confid);
            break;
        }
        this.sendIndication("dropConnectedParty", prms);
    }

    @Override
    public void transferCall(String number, LineInfo line) {
        this.server.transferCall(number, line.getName());
    }

    public void callPickup(ContactInfo contact) {
        super.makeCall(PICKUP_ + contact.getNumber());
    }

    public void callBargein(ContactInfo contact) {
        super.makeCall("OVERRIDE**" + contact.getNumber());
    }

    public void callMonitor(ContactInfo contact) {
        super.makeCall("MONITOR**" + contact.getNumber());
    }

    @Override
    public void setDeviceProperties() throws Exception {
        super.setDeviceProperties();
        if (this.getOwner() != null) {
            this.sendIndication("setProfile", this.getOwner().getProperties());
        }
    }

    @Override
    public void connectionSet() {
        this.serverLines.clear();
        this.forwardedExtension = null;
        super.connectionSet();
    }

    @Override
    public void lineStateChanged(int state, String number, String description, Line line) {
        block13: {
            LineInfo lineInfo;
            block18: {
                block17: {
                    block16: {
                        Activity activity;
                        block15: {
                            block14: {
                                lineInfo = (LineInfo)line.getLinePane();
                                this.toLog("lineStateChanged state=" + state + " number=" + number + " description=" + description + " line=" + lineInfo.getName() + " activity=" + lineInfo.getActivity() + " session=" + lineInfo.getSessionInfo() + " serverLines=" + this.serverLines);
                                if (!number.startsWith(PICKUP_)) break block14;
                                if (state != 1) break block13;
                                for (Line ln : this.serverLines.values()) {
                                    if (ln.getState() != 2) continue;
                                    LineInfo lnInfo = (LineInfo)ln.getLinePane();
                                    lineInfo.setActivity(lnInfo.getActivity());
                                }
                                break block13;
                            }
                            if (state != 1 && state != 2) break block15;
                            if (lineInfo.getSessionInfo() != null) break block13;
                            this.setLineSession(lineInfo, number);
                            break block13;
                        }
                        if (state != 3) break block16;
                        if (number.indexOf(44) != -1) {
                            ArrayList<ContactInfo> contacts = new ArrayList<ContactInfo>();
                            String[] numbers = number.split(",");
                            for (int i = 0; i < numbers.length; ++i) {
                                contacts.add(super.findContact(numbers[i]));
                            }
                            SessionInfo session = null;
                            if (contacts.size() > 1) {
                                try {
                                    session = super.findSession(contacts);
                                    if (session != null) {
                                        lineInfo.setSessionInfo(session);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (session != null) {
                                description = session.toString();
                            } else {
                                description = ((Object)contacts).toString();
                                description = description.substring(1, description.length() - 1);
                            }
                            lineInfo.setStateDescription(description);
                        }
                        if ((activity = lineInfo.getActivity()) == null) break block13;
                        activity.setTimeAssign(this.getServerTime());
                        break block13;
                    }
                    if (state != 18) break block17;
                    lineInfo.setStateDescription(description);
                    break block13;
                }
                if (state != 8) break block18;
                Activity activity = lineInfo.getActivity();
                if (activity == null) break block13;
                activity.setTimestop(this.getServerTime());
                break block13;
            }
            if (state == 0) {
                Iterator itr = this.serverLines.keySet().iterator();
                while (itr.hasNext()) {
                    try {
                        String sline = (String)itr.next();
                        Line line2 = (Line)this.serverLines.get(sline);
                        if (!line2.getName().equals(lineInfo.getName())) continue;
                        this.serverLines.remove(sline);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }

    @Override
    protected void myStateChanged(Map map) {
        super.myStateChanged(map);
        String ext = (String)map.get("ext");
        List obj = (List)map.get("disconnected");
        if (obj != null) {
            this.processLineState(obj, 8, map);
        }
        if ((obj = (List)map.get("alerted")) != null) {
            this.processLineState(obj, 2, map);
            this.forwardedExtension = ext;
        }
        if ((obj = (List)map.get("dialed")) != null) {
            this.processLineState(obj, 1, map);
        }
        if ((obj = (List)map.get("connected")) != null) {
            this.processLineState(obj, 3, map);
        }
    }

    private void processLineState(List list, int state, Map params) {
        String ext = (String)params.get("ext");
        boolean assisted = !this.getOwner().getNumber().equals(ext);
        for (int i = 0; i < list.size(); ++i) {
            String party;
            Map map = (Map)list.get(i);
            String sline = (String)map.get("line");
            Line line = (Line)this.serverLines.get(sline);
            String description = party = (String)map.get("party");
            ResourceStore.toLog("processLineState line=" + line + " party=" + party + " state=" + state + " assisted=" + assisted + " serverLines=" + this.serverLines);
            if (state == 2 || state == 1) {
                if (line == null || state == 2) {
                    if (assisted) {
                        line = this.server.getLine();
                        line.setConnectedNumber(party);
                    } else if (line == null) {
                        line = this.server.findLine(party);
                    }
                    if (line == null) {
                        ResourceStore.toLog("processLineState No line available params=" + params);
                        return;
                    }
                    this.serverLines.put(sline, line);
                }
            } else if (state == 3) {
                description = CONNECTED;
                if (line == null) {
                    for (Line ln : this.server.getLines().getLines()) {
                        String cnumber = ln.getConnectedNumber();
                        if (cnumber.startsWith(PICKUP_) || cnumber.startsWith(OVERRIDE_) || cnumber.startsWith(MONITOR_)) {
                            line = ln;
                            line.setConnectedNumber(party);
                            this.setConnectedLine(line, party);
                            if (!assisted) {
                                this.server.lineStateChanged(state, party, description, line);
                            }
                        } else if (party.startsWith(CONFERENCE_)) {
                            party = party.substring(party.indexOf(42) + 1);
                            line = ln;
                            line.setConnectedNumber(party);
                            this.serverLines.put(sline, line);
                        } else {
                            if (!cnumber.equals(party)) continue;
                            line = ln;
                            this.setConnectedLine(line, party);
                            this.serverLines.put(sline, line);
                        }
                        break;
                    }
                } else if (!party.equals(line.getConnectedNumber()) && !party.startsWith(CONFERENCE_)) {
                    SessionInfo sessionInfo;
                    LineInfo lineInfo = (LineInfo)line.getLinePane();
                    ResourceStore.toLog("processLineState line=" + line + " party=" + party + " number=" + line.getConnectedNumber() + " session=" + lineInfo.getSessionInfo() + " time=" + lineInfo.getConnectionTime());
                    line.setConnectedNumber(party);
                    if (party.contains(",")) {
                        Set<ContactInfo> parties = lineInfo.getContacts();
                        parties.clear();
                        String[] numbers = party.split(",");
                        for (int j = 0; j < numbers.length; ++j) {
                            parties.add(this.findContact(numbers[j].trim()));
                        }
                    } else if (lineInfo.getConnectionTime() > 0 && ((sessionInfo = lineInfo.getSessionInfo()) == null || sessionInfo.getStatus() <= 0)) {
                        this.setLineSession(lineInfo, party);
                    }
                    if (!(assisted || line.getState() != 3 && line.getState() != 5)) {
                        if (state == 3 && party.indexOf(",") != -1) {
                            state = 5;
                        }
                        this.server.lineStateChanged(state, party, description, line);
                    }
                }
            } else if (state == 8) {
                description = "Disconnect";
                this.serverLines.remove(sline);
            }
            if (line == null) {
                return;
            }
            if (!assisted) continue;
            if (state != line.getState()) {
                this.server.lineStateChanged(state, party, description, line);
            }
            if (state != 8) continue;
            this.server.lineStateChanged(0, "", "", line);
        }
    }

    private void setConnectedLine(Line line, String number) {
        LineInfo li;
        Map callInfo;
        LineInfo lineInfo = (LineInfo)line.getLinePane();
        this.setLineSession(lineInfo, number);
        Iterator it = this.serverLines.values().iterator();
        while (it.hasNext() && ((callInfo = (li = (LineInfo)((Line)it.next()).getLinePane()).getCallInfo()) == null || !lineInfo.setCallInfo(callInfo))) {
        }
    }

    private void initPhoneCall(String number) throws Exception {
        HashMap<String, String> prms = new HashMap<String, String>();
        prms.put("number", number);
        this.sendIndication("initCall", prms);
        Line line = this.server.getLine();
        line.setConnectedNumber(number);
        this.server.lineStateChanged(1, number, number, line);
    }

    private boolean checkFollowMe(String number) {
        String followme = (String)this.getOwner().getProperty("followme");
        if (followme != null && followme.length() > 0 && !followme.equals(this.getOwner().getNumber())) {
            try {
                this.initPhoneCall(number);
                return true;
            }
            catch (Exception e) {
                ResourceStore.error("initCall", e);
            }
        }
        return false;
    }

    @Override
    public void makeCall(String number) {
        if (!this.checkFollowMe(number)) {
            super.makeCall(number);
        }
    }

    @Override
    public void makeVideoCall(String number) {
        if (!this.checkFollowMe(number)) {
            super.makeVideoCall(number);
        }
    }

    @Override
    public void answerCall(String lineName, boolean video) {
        Line line = this.findLine(lineName);
        if (line != null && line.getCallId() == null) {
            if (video) {
                super.makeVideoCall(PICKUP_ + this.forwardedExtension);
            } else {
                super.makeCall(PICKUP_ + this.forwardedExtension);
            }
        } else {
            super.answerCall(lineName, video);
        }
    }

    @Override
    public void dropCall(LineInfo lineInfo) {
        if (lineInfo.getCallId() == null) {
            this.dropCall(lineInfo, null);
        }
        super.dropCall(lineInfo);
    }

    @Override
    public void dropCall(LineInfo lineInfo, String number) {
        String sline = this.findServerPort(lineInfo.getName());
        if (sline != null && !this.isMobileVersion()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("line", sline);
            map.put("party", number);
            try {
                this.server.sendIndication("dropCall", map);
                Line line = (Line)this.serverLines.get(sline);
                if (number != null) {
                    line.dropParty(number);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (number != null) {
            super.dropCall(lineInfo, number);
        } else {
            Line line = this.server.getLines().getLine(lineInfo.getName());
            this.server.lineStateChanged(8, "", "", line);
            this.server.lineStateChanged(0, "", "", line);
        }
    }

    @Override
    public List getTrunks(String number) {
        if (this.getServiceProperty("mod") == null) {
            return super.getTrunks(number);
        }
        ArrayList list = new ArrayList();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("number", Utils.normalizePhoneNumber(number));
            this.trunks = (List)this.sendCommand("getTrunks", params);
        }
        catch (Exception e) {
            this.trunks = new ArrayList();
        }
        for (int i = 0; i < this.trunks.size(); ++i) {
            Map trunk = (Map)this.trunks.get(i);
            list.add(trunk.get("name"));
        }
        return list;
    }

    @Override
    public void makeCall(String number, String trunk, boolean video) {
        String followme;
        if (this.trunks.isEmpty()) {
            super.makeCall((String)number, trunk, video);
            return;
        }
        if (trunk == null) {
            if (video) {
                this.makeVideoCall((String)number);
            } else {
                this.makeCall((String)number);
            }
            return;
        }
        for (int i = 0; i < this.trunks.size(); ++i) {
            Map m = (Map)this.trunks.get(i);
            if (!trunk.equals(m.get("name"))) continue;
            String cc = (String)m.get("country");
            if (cc == null) {
                cc = this.client.getCountryCode();
            }
            number = Utils.normalizePhoneNumber((String)number, cc) + "_" + m.get("oid");
            break;
        }
        if ((followme = (String)this.getOwner().getProperty("followme")) != null && followme.length() > 0 && !followme.equals(this.getOwner().getNumber())) {
            try {
                this.initPhoneCall((String)number);
                return;
            }
            catch (Exception e) {
                ResourceStore.error("initCall", e);
            }
        }
        this.server.makeCall((String)number, video);
    }

    private Line findLine(String lineName) {
        for (Line line : this.serverLines.values()) {
            if (!line.getName().equals(lineName)) continue;
            return line;
        }
        return null;
    }

    private String findServerPort(String lineName) {
        for (String sline : this.serverLines.keySet()) {
            Line line = (Line)this.serverLines.get(sline);
            if (!line.getName().equals(lineName)) continue;
            return sline;
        }
        return null;
    }

    @Override
    protected void trunkState(Map params) {
        super.trunkState(params);
        Integer state = (Integer)params.get("state");
        if (state == null) {
            state = (Boolean)params.get("enabled") != false ? 1 : 0;
        }
        int currentState = super.getUserState();
        boolean off = state == 0 && (currentState == 1 || currentState == 4);
        this.client.stateChanged(off ? 5 : currentState);
        ContactInfo info = this.getUserInfo();
        if (info != null) {
            info.notifyStateChanged();
        }
    }

    @Override
    public int getUserState() {
        int state = super.getUserState();
        if ((state == 1 || state == 4) && this.isTrunksDisabled()) {
            state = 5;
        }
        return state;
    }

    @Override
    public void stateChanged(int state) {
        if ((state == 1 || state == 4) && this.isTrunksDisabled()) {
            ContactInfo info = this.getUserInfo();
            if (info != null) {
                info.setState(state);
            }
            this.client.stateChanged(5);
        } else {
            super.stateChanged(state);
        }
    }
}

