/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.json.smile.JSONArray;
import org.json.smile.JSONException;
import org.json.smile.JSONObject;
import org.json.smile.Utility;
import smile.cti.client.ServerConnector;
import smile.cti.client.ServiceManager;
import smile.util.MimeMessage;

public class SIPMessageConnector
extends ServerConnector {
    private Random random = new Random();
    private HashMap rpcs = new HashMap();
    private String serviceName;

    public SIPMessageConnector(ServiceManager manager, String serviceName) throws Exception {
        super(manager);
        this.serviceName = serviceName;
    }

    @Override
    public Object sendCommand(String method, Map params, long timeout) throws Exception {
        RPC rpc = new RPC(this.serviceName, method, params, true);
        rpc.setCommandTimeout(timeout);
        Object result = rpc.call();
        if (result instanceof JSONArray) {
            return ((JSONArray)result).getList();
        }
        if (result instanceof JSONObject) {
            return ((JSONObject)result).getMap();
        }
        return result;
    }

    @Override
    public void sendIndication(String method, Map params) throws Exception {
        RPC rpc = new RPC(this.serviceName, method, params, false);
        rpc.call();
    }

    @Override
    public int processMessage(MimeMessage mimeMessage) {
        String message;
        byte[] content = mimeMessage.getContentBytes();
        try {
            message = new String(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            message = new String(content);
        }
        try {
            JSONObject json = Utility.parseJson(message);
            Object id = json.get("id");
            if (id != null) {
                RPC rpc = (RPC)this.rpcs.remove(id);
                if (rpc != null) {
                    Object result = json.get("result");
                    if (result != null) {
                        rpc.setResult(result);
                    } else {
                        JSONObject error = (JSONObject)json.get("error");
                        rpc.setError(error != null ? error.get("message") : error.toString());
                    }
                }
            } else {
                new CommandHandler(json);
            }
        }
        catch (Throwable e) {
            this.toLog(e + ": " + message);
            return 400;
        }
        return 200;
    }

    @Override
    public boolean processResponse(String messageId, int messageStatus) {
        RPC rpc = (RPC)this.rpcs.remove(messageId);
        if (rpc != null) {
            rpc.processResponse(messageStatus);
        }
        return true;
    }

    @Override
    public boolean processTimeout(String messageId) {
        RPC rpc = (RPC)this.rpcs.remove(messageId);
        if (rpc != null) {
            rpc.processTimeout();
        }
        return true;
    }

    @Override
    public void connectionLost() {
        super.connectionLost();
        try {
            for (RPC rpc : this.rpcs.values()) {
                rpc.setError("socket closed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rpcs.clear();
    }

    class RPC {
        int id = -1;
        private String to;
        private String from;
        private String message;
        private String contentType;
        private String contentSubtype;
        private Object result;
        private boolean error;
        private long timeout;

        public RPC(String to, String method, Map params, boolean ret) throws Exception {
            this.to = to;
            this.from = SIPMessageConnector.this.getUserId();
            this.contentType = "application";
            this.contentSubtype = "json";
            this.timeout = 10000L;
            HashMap<String, Object> jobj = new HashMap<String, Object>();
            jobj.put("method", method);
            jobj.put("params", params);
            if (ret) {
                this.id = SIPMessageConnector.this.random.nextInt();
                jobj.put("id", this.id);
            }
            this.message = new JSONObject(jobj).toString();
        }

        public synchronized void processResponse(int messageStatus) {
            if (messageStatus < 200) {
                return;
            }
            if (messageStatus >= 300) {
                if (this.result == null) {
                    this.result = "Response status " + messageStatus;
                    this.error = true;
                }
            } else if (messageStatus >= 200 && this.id == -1 && this.result == null) {
                this.result = messageStatus;
            }
            this.notify();
        }

        public synchronized void processTimeout() {
            this.error = true;
            this.notify();
        }

        public synchronized void setResult(Object result) {
            this.result = result;
            this.notify();
        }

        public synchronized void setError(Object result) {
            this.result = result;
            this.error = true;
            this.notify();
        }

        public synchronized Object call() throws Exception {
            byte[] data = this.message.getBytes("UTF-8");
            String mid = SIPMessageConnector.this.sendMessage(this.to, this.from, data, data.length, this.contentType, this.contentSubtype);
            SIPMessageConnector.this.rpcs.put(mid, this);
            if (this.id != -1) {
                SIPMessageConnector.this.rpcs.put(this.id, this);
            }
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SIPMessageConnector.this.rpcs.remove(mid);
            if (this.result == null) {
                if (this.id == -1) {
                    throw new Exception("Request timeout");
                }
                if (this.error) {
                    SIPMessageConnector.this.rpcs.remove(this.id);
                    throw new Exception("Request timeout");
                }
                try {
                    this.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            SIPMessageConnector.this.rpcs.remove(this.id);
            if (this.result == null) {
                throw new Exception("Request timeout");
            }
            if (this.error) {
                throw new Exception(this.result.toString());
            }
            return this.result;
        }

        public void setCommandTimeout(long t) {
            this.timeout = t;
        }
    }

    class CommandHandler
    implements Runnable {
        String method;
        Map parameters;

        public CommandHandler(JSONObject json) throws JSONException {
            this.method = (String)json.get("method");
            JSONObject jobj = (JSONObject)json.get("params");
            this.parameters = jobj.getMap();
            new Thread(this).start();
        }

        @Override
        public void run() {
            SIPMessageConnector.this.processCommand(this.method, this.parameters);
        }
    }
}

