/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.client;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;
import smile.cti.client.ConferenceEventListener;
import smile.cti.client.ContactEventListener;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.MenuInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionEventListener;
import smile.util.ResourceStore;
import smile.util.Utils;

public class SessionInfo
implements Comparable,
Serializable,
Cloneable,
ContactEventListener,
FileTransferListener {
    static final long serialVersionUID = 4235834605436340253L;
    public static final int SESSION_STATUS_EXT_CHANNEL = -6;
    public static final int SESSION_STATUS_EXT_REQUEST = -5;
    public static final int SESSION_STATUS_EXT_CHAT = -4;
    public static final int SESSION_STATUS_EXT = -3;
    public static final int SESSION_STATUS_ADS = -2;
    public static final int SESSION_STATUS_SYSTEM = -1;
    public static final int SESSION_STATUS_CLIENT = 0;
    public static final int SESSION_STATUS_MASTER = 1;
    public static final int SESSION_STATUS_GROUP_CLIENT = 2;
    public static final int SESSION_STATUS_GROUP_MASTER = 3;
    public static final int SESSION_STATUS_REMOVED = 4;
    public static final int SESSION_STATUS_LEFT = 5;
    public static final int SESSION_STATUS_NOTAUTH = 6;
    public static final int SESSION_STATUS_DELETED = 10;
    public static final int DIALOG_TYPE_PRIVATE = 0;
    public static final int DIALOG_TYPE_CHANNEL = 1;
    public static final int DIALOG_TYPE_PUBLIC = 2;
    public static final int DIALOG_TYPE_GROUP = 3;
    public static final int DIALOG_TYPE_BRANCH = 4;
    public static final int DIALOG_TYPE_BRANCH_GROUP = 5;
    public static final int EVENT_CONFERENCE_ADD = 1;
    public static final int EVENT_CONFERENCE_REMOVE = 2;
    public static final int EVENT_CONFERENCE_DROPPED = 3;
    public static final int MESSAGE_GROUP_MODE_1 = 1;
    public static final int MESSAGE_GROUP_MODE_2 = 2;
    public static final String NODISTURB = "nodisturb";
    public static final String BLOCKED = "blocked";
    public static final String PUSH = "push";
    public static final String AUTOPLAY = "autoplay";
    public static final String ALLOWGEO = "allowgeo";
    public static final String NOSOUND = "nosound";
    public static final String NOPHOTO = "nophoto";
    public static final String MESSAGE_TTL = "messageTTL";
    private String sessionid;
    private String dialogid;
    private String name = "";
    private File imageFile;
    private int status;
    private int msgLifetime = -1;
    private long created;
    private long lastUpdated;
    private String createdby;
    private String description;
    private String subject;
    private String imageid;
    private long imgdate = -1L;
    private int type;
    private List<String> admins = new Vector<String>();
    private Map properties = new HashMap();
    private List<ContactInfo> parties = new Vector<ContactInfo>();
    private transient List<MessageInfo> messages = new Vector<MessageInfo>();
    private transient Set<SessionEventListener> listeners = new HashSet<SessionEventListener>();
    private transient Set<FileTransferListener> filelisteners = new HashSet<FileTransferListener>();
    private transient Set<ConferenceEventListener> conflisteners = new HashSet<ConferenceEventListener>();
    private transient int conferenceState;
    private transient int total;
    private transient int nm;
    private transient int mc;
    private transient boolean read;
    private transient boolean nomore;
    private transient int compareType;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.messages = new Vector<MessageInfo>();
        this.listeners = new HashSet<SessionEventListener>();
        this.filelisteners = new HashSet<FileTransferListener>();
        this.conflisteners = new HashSet<ConferenceEventListener>();
    }

    public SessionInfo clone() throws CloneNotSupportedException {
        return (SessionInfo)super.clone();
    }

    public synchronized void addSessionEventListener(SessionEventListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeSessionEventListener(SessionEventListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void notifySessionListeners(int event) {
        Iterator<SessionEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().sessionEvent(event, this);
            }
            catch (Exception e) {
                ResourceStore.error(this + ": sessionEvent " + event, e);
                break;
            }
        }
    }

    private synchronized void notifyMessagesLoaded(List<MessageInfo> messages) {
        Iterator<SessionEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().messagesLoaded(messages, this);
            }
            catch (Exception e) {
                ResourceStore.error(this + ": messagesLoaded " + messages.size(), e);
                break;
            }
        }
    }

    private synchronized void notifyMessageReceived(MessageInfo messageInfo) {
        Iterator<SessionEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().messageReceived(messageInfo, this);
            }
            catch (Exception e) {
                ResourceStore.error(this + ": messageReceived " + messageInfo, e);
                break;
            }
        }
    }

    private synchronized void notifyMessageRemoved(MessageInfo messageInfo) {
        Iterator<SessionEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().messageRemoved(messageInfo, this);
            }
            catch (Exception e) {
                ResourceStore.error(this + ": messageRemoved " + messageInfo, e);
                break;
            }
        }
    }

    protected synchronized void notifyMessageUpdated(MessageInfo messageInfo) {
        Iterator<SessionEventListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().messageUpdated(messageInfo, this);
            }
            catch (Exception e) {
                ResourceStore.error(this + ": messageUpdated " + messageInfo, e);
                break;
            }
        }
    }

    public Set<SessionEventListener> getSessionEventListeners() {
        return this.listeners;
    }

    protected void setSessionEventListeners(Set<SessionEventListener> set) {
        this.listeners = set;
    }

    public void addConferenceListener(ConferenceEventListener listener) {
        this.conflisteners.add(listener);
    }

    public void removeConferenceListener(ConferenceEventListener listener) {
        this.conflisteners.remove(listener);
    }

    public int getConferenceState() {
        return this.conferenceState;
    }

    protected void setConferenceState(int s) {
        this.conferenceState = s;
        this.notifySessionListeners(5);
    }

    protected void setConferenceState(Map map) {
        Boolean video = (Boolean)map.get("video");
        List list = (List)map.get("parties");
        Integer state = (Integer)map.get("state");
        if (state == null) {
            state = 0;
        }
        if (state != 0 && video != null) {
            state = video != false ? 2 : 1;
        }
        this.setConferenceState(state);
        for (ContactInfo contactInfo : this.parties) {
            contactInfo.setConferenceState(contactInfo.getState() == 8 ? 1 : 0);
        }
        Iterator<ConferenceEventListener> it = this.conflisteners.iterator();
        while (it.hasNext()) {
            try {
                it.next().stateChanged(state);
            }
            catch (Exception exception) {}
        }
    }

    protected void processConferenceUpdate(Map params) {
        String party = (String)params.get("number");
        String ps = (String)params.get("status");
        Integer state = (Integer)params.get("state");
        for (ContactInfo contactInfo : this.parties) {
            if (!party.equals(contactInfo.getNumber())) continue;
            if (ps != null) {
                contactInfo.setConferenceStatus(ps);
                Iterator<ConferenceEventListener> it = this.conflisteners.iterator();
                while (it.hasNext()) {
                    try {
                        it.next().partyStatusChanged(contactInfo, ps);
                    }
                    catch (Exception exception) {}
                }
            }
            contactInfo.setConferenceState(contactInfo.getState() == 8 ? 1 : 0);
            break;
        }
        if (state != null) {
            Iterator<ConferenceEventListener> it = this.conflisteners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().stateChanged(state);
                }
                catch (Exception exception) {}
            }
        }
    }

    protected List<MessageInfo> addMessages(List<MessageInfo> list, boolean notify) {
        Vector<MessageInfo> inserted = new Vector<MessageInfo>();
        for (int i = 0; i < list.size(); ++i) {
            MessageInfo message = list.get(i);
            if (this.insertMessage(message) == -1) continue;
            inserted.add(message);
        }
        if (notify) {
            if (!inserted.isEmpty()) {
                this.notifyMessagesLoaded(inserted);
            } else {
                this.messageNotLoaded();
            }
        }
        return inserted;
    }

    protected boolean addMessage(MessageInfo messageInfo) {
        MessageInfo info;
        int position = this.insertMessage(messageInfo);
        if (position == -1) {
            return false;
        }
        this.notifyMessageReceived(messageInfo);
        if (position > 0 && (info = this.messages.get(position - 1)).getType() == 14 && messageInfo.getSenderId().equals(info.getSenderId())) {
            this.messages.remove(position - 1);
            this.notifyMessageRemoved(info);
        }
        return true;
    }

    private int insertMessage(MessageInfo messageInfo) {
        if (messageInfo.getContent() == null && messageInfo.getType() == 1) {
            return -1;
        }
        int j = 0;
        for (int i = this.messages.size(); i > 0; --i) {
            MessageInfo message = this.messages.get(i - 1);
            if (message.equals(messageInfo)) {
                if (messageInfo.getStatus() == 1) {
                    int result = messageInfo.getStatus() == message.getStatus() ? -1 : i - 1;
                    messageInfo.setStatus(message.getStatus());
                    this.messages.set(i - 1, messageInfo);
                    this.notifyMessageUpdated(messageInfo);
                    return result;
                }
                if (messageInfo.getStatus() == 8) {
                    this.messages.remove(i - 1);
                    this.notifyMessageRemoved(message);
                } else if (message.getType() != 8 && message.update(messageInfo)) {
                    this.notifyMessageUpdated(message);
                }
                return -1;
            }
            if (j != 0 || messageInfo.getTime() <= message.getTime()) continue;
            j = i;
            if (!(message instanceof MenuInfo)) continue;
            ((MenuInfo)message).removeMenu();
            this.notifyMessageUpdated(message);
        }
        if (messageInfo.getStatus() == 8) {
            return -1;
        }
        this.messages.add(j, messageInfo);
        if (messageInfo.getTime() > this.lastUpdated) {
            this.setLastUpdated(messageInfo.getTime());
        }
        if (messageInfo.getLifetime() > 0L) {
            final MessageInfo msg = messageInfo;
            Utils.getTimer().schedule(new TimerTask(){

                @Override
                public void run() {
                    SessionInfo.this.messages.remove(msg);
                    SessionInfo.this.notifyMessageRemoved(msg);
                }
            }, messageInfo.getLifetime() * 1000L);
        }
        return j;
    }

    public int getNewMessagesCount() {
        return this.getNewMessagesCount(this.canMakeCall());
    }

    public int getNewMessagesCount(boolean b) {
        if (this.status >= 4) {
            return 0;
        }
        int n = 0;
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            int status = this.messages.get(i).getStatus();
            if (status != 1 && (!b || status != 12)) continue;
            ++n;
        }
        return n;
    }

    public int getMissedCallsCount() {
        if (this.status >= 4) {
            return 0;
        }
        int n = 0;
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            if (this.messages.get(i).getStatus() != 12) continue;
            ++n;
        }
        return n;
    }

    public int getMessagesCount() {
        return Math.max(this.messages.size(), this.total);
    }

    protected void setMessagesCount(int c) {
        this.total = c;
    }

    protected void setNewMessagesCount(int c) {
        this.nm = c;
    }

    protected void setMissesCallsCount(int c) {
        this.mc = c;
    }

    protected void addParty(ContactInfo contactInfo) {
        for (int i = 0; i < this.parties.size(); ++i) {
            if (!contactInfo.equals(this.parties.get(i))) continue;
            if (this.parties.size() == 1 && this.status == 4) {
                this.setStatus(0);
            }
            return;
        }
        this.parties.add(contactInfo);
        contactInfo.addListener(this);
        this.notifySessionListeners(1);
    }

    protected ContactInfo removeParty(String userId) {
        ContactInfo party = null;
        for (int i = 0; i < this.parties.size(); ++i) {
            if (!userId.equals(this.parties.get(i).getUserID())) continue;
            if (this.parties.size() > 1) {
                party = this.parties.remove(i);
                party.removeListener(this);
                this.notifySessionListeners(1);
                break;
            }
            this.status = 4;
            this.notifySessionListeners(5);
            break;
        }
        return party;
    }

    public ContactInfo getParty(String userId) {
        for (int i = 0; i < this.parties.size(); ++i) {
            ContactInfo contactInfo = this.parties.get(i);
            if (!userId.equals(contactInfo.getUserID())) continue;
            return contactInfo;
        }
        return null;
    }

    protected void setMessageLifetime(int time) {
        this.msgLifetime = time;
    }

    public int getMessageLifetime() {
        return this.msgLifetime;
    }

    public String getName() {
        return this.name;
    }

    public String getCreatedBy() {
        return this.createdby;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubject() {
        return this.subject;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public List<ContactInfo> getParties() {
        return this.parties;
    }

    public List<MessageInfo> getMessages() {
        return this.messages;
    }

    protected void setMessages(List<MessageInfo> list) {
        this.messages = list;
    }

    public MessageInfo getFirstMessage() {
        if (this.messages.size() == 0) {
            return null;
        }
        return this.messages.get(0);
    }

    public MessageInfo getLastMessage() {
        if (this.messages.size() == 0) {
            return null;
        }
        return this.messages.get(this.messages.size() - 1);
    }

    public MessageInfo getLastChatMessage() {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            MessageInfo m = this.messages.get(i);
            if (m.getType() == 8) continue;
            return m;
        }
        return null;
    }

    public MessageInfo getLastMessage(int type) {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            MessageInfo m = this.messages.get(i);
            if (m.getType() != type || (m.getCode() & 0x100) != 0) continue;
            return m;
        }
        return null;
    }

    public MessageInfo getLastEmail() {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            MessageInfo m = this.messages.get(i);
            if (m.getType() != 5) continue;
            return m;
        }
        return null;
    }

    public MessageInfo getLastCall() {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            MessageInfo m = this.messages.get(i);
            if (m.getType() != 8 || (m.getCode() & 0x100) != 0) continue;
            return m;
        }
        return null;
    }

    public MessageInfo getLastCall(String partyNumber) {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            String callPartyNumber;
            MessageInfo m = this.messages.get(i);
            if (m.getType() != 8 || (m.getCode() & 0x100) != 0 || (callPartyNumber = m.getCallPartyNumber()) == null || !callPartyNumber.endsWith(partyNumber)) continue;
            return m;
        }
        return null;
    }

    protected List removeCallHistory() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            MessageInfo m = this.messages.get(i);
            if (m.getType() != 8) continue;
            m.setCode(256);
            list.add(m.getId());
        }
        return list;
    }

    public String getSessionId() {
        return this.sessionid;
    }

    public int getStatus() {
        if (this.status == 0 && this.parties.size() == 1) {
            int ps = this.parties.get(0).getStatus();
            if (ps == -1) {
                return -3;
            }
            if (ps == 3) {
                return 5;
            }
            if (ps < 3) {
                return 6;
            }
        }
        return this.status;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    protected void setCreatedBy(String str) {
        this.createdby = str;
    }

    public void setDescription(String str) {
        this.description = str;
    }

    public void setSubject(String str) {
        this.subject = str;
    }

    protected void messageTyped(String userid, boolean state) {
        MessageInfo messageInfo;
        for (int i = 0; i < this.messages.size(); ++i) {
            messageInfo = this.messages.get(i);
            if (messageInfo.getType() != 14 || !messageInfo.getSenderId().equals(userid)) continue;
            TimerTask task = messageInfo.getExpiredTask();
            if (task != null) {
                task.cancel();
            }
            if (!state) {
                this.messages.remove(i);
                this.notifyMessageRemoved(messageInfo);
            } else {
                Object s = messageInfo.getContent();
                s = ((String)s).length() > 5 ? ".." : (String)s + ".";
                messageInfo.setContent((String)s, 14);
                final String mid = messageInfo.getId();
                task = new TimerTask(){

                    @Override
                    public void run() {
                        SessionInfo.this.removeMessage(mid);
                    }
                };
                messageInfo.setExpiredTask(task);
                Utils.getTimer().schedule(task, 7000L);
            }
            return;
        }
        if (state) {
            final String mid = Utils.createCallId();
            messageInfo = new MessageInfo();
            messageInfo.setId(mid);
            messageInfo.setTime(System.currentTimeMillis());
            messageInfo.setSenderId(userid);
            messageInfo.setContent("..", 14);
            this.messages.add(messageInfo);
            this.notifyMessageReceived(messageInfo);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    SessionInfo.this.removeMessage(mid);
                }
            };
            messageInfo.setExpiredTask(task);
            Utils.getTimer().schedule(task, 7000L);
        }
    }

    protected List messageRead(Map map) {
        long time = ((Number)map.get("time")).longValue();
        List messageids = (List)map.get("messageids");
        Vector<MessageInfo> mess = new Vector<MessageInfo>();
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageInfo messageInfo = this.messages.get(i);
            int ms = messageInfo.getStatus();
            if (messageids == null || messageids.remove(messageInfo.getId())) {
                if (ms == 0 || ms == 3) {
                    messageInfo.setStatus(4);
                    messageInfo.setDeliveryTime(time);
                } else if (messageInfo.getStatus() == 1) {
                    messageInfo.setStatus(2);
                    messageInfo.setDeliveryTime(time);
                } else {
                    if (messageInfo.getStatus() != 12) continue;
                    messageInfo.setStatus(5);
                }
                this.notifyMessageUpdated(messageInfo);
                mess.add(messageInfo);
            }
            if (messageids != null && messageids.isEmpty()) break;
        }
        return mess;
    }

    protected Object messageDelivered(Map map) {
        Number time = (Number)map.get("time");
        Object object = map.get("messageid");
        if (object instanceof List) {
            return this.messageDelivered((List)object, time.longValue());
        }
        return this.messageDelivered((String)object, time.longValue());
    }

    private MessageInfo messageDelivered(String messageid, long time) {
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageInfo messageInfo = this.messages.get(i);
            if (!messageid.equals(messageInfo.getId())) continue;
            if (messageInfo.getStatus() == 0) {
                messageInfo.setStatus(3);
                messageInfo.setDeliveryTime(time);
                this.notifyMessageUpdated(messageInfo);
            }
            return messageInfo;
        }
        return null;
    }

    private List messageDelivered(List messageids, long time) {
        Vector<MessageInfo> mess = new Vector<MessageInfo>();
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageInfo messageInfo = this.messages.get(i);
            if (!messageids.contains(messageInfo.getId()) || messageInfo.getStatus() != 0) continue;
            messageInfo.setStatus(3);
            messageInfo.setDeliveryTime(time);
            this.notifyMessageUpdated(messageInfo);
            mess.add(messageInfo);
        }
        return mess;
    }

    protected MessageInfo messageUpdated(Map map, String messageid) {
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageInfo messageInfo = this.messages.get(i);
            if (!messageid.equals(messageInfo.getId())) continue;
            this.updateMessage(messageInfo, map);
            return messageInfo;
        }
        return null;
    }

    protected List messageUpdated(Map map, List mids) {
        Vector<MessageInfo> mess = new Vector<MessageInfo>();
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageInfo messageInfo = this.messages.get(i);
            if (!mids.contains(messageInfo.getId())) continue;
            this.updateMessage(messageInfo, map);
            mess.add(messageInfo);
        }
        return mess;
    }

    protected List setRead(long time) {
        Vector<MessageInfo> mess = new Vector<MessageInfo>();
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageInfo messageInfo = this.messages.get(i);
            if (messageInfo.getStatus() == 1 && (messageInfo.getType() != 5 || this.isChannel()) && messageInfo.getType() != 19) {
                messageInfo.setStatus(2);
                messageInfo.setDeliveryTime(time);
                mess.add(messageInfo);
                continue;
            }
            if (messageInfo.getStatus() != 12) continue;
            messageInfo.setStatus(5);
            mess.add(messageInfo);
        }
        if (mess.size() > 0) {
            this.read = true;
        }
        this.nm = 0;
        this.mc = 0;
        return mess;
    }

    protected void readSent() {
        this.read = false;
    }

    protected boolean hasRead() {
        return this.read;
    }

    protected List<MessageInfo> clearMissedCalls() {
        ArrayList<MessageInfo> list = new ArrayList<MessageInfo>();
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageInfo messageInfo = this.messages.get(i);
            if (messageInfo.getStatus() != 12) continue;
            messageInfo.setStatus(5);
            list.add(messageInfo);
        }
        this.mc = 0;
        return list;
    }

    private void updateMessage(MessageInfo messageInfo, Map map) {
        List mentions;
        Object content;
        List dest;
        Integer ms;
        Integer code = (Integer)map.get("code");
        if (code != null) {
            if (code == 128) {
                code = code | messageInfo.getCode();
            }
            messageInfo.setCode(code);
        }
        if ((ms = (Integer)map.get("status")) != null) {
            messageInfo.setStatus(ms);
        }
        if ((dest = (List)map.get("dest")) != null) {
            messageInfo.setRecepients(dest);
        }
        if ((content = (String)map.get("content")) != null) {
            Integer type = (Integer)map.get("type");
            if (type == null) {
                type = 1;
            }
            if (map.get("append") != null) {
                content = messageInfo.getContent() + (String)content;
            }
            messageInfo.setContent((String)content, type);
            if (messageInfo.getType() != 8) {
                messageInfo.setCode(messageInfo.getCode() | 0x200);
            }
        }
        if ((mentions = (List)map.get("mentions")) != null) {
            messageInfo.setRecepients(mentions);
        }
        this.notifyMessageUpdated(messageInfo);
    }

    protected MessageInfo removeMessage(String messageId) {
        for (int i = 0; i < this.messages.size(); ++i) {
            File file;
            if (!messageId.equals(this.messages.get(i).getId())) continue;
            MessageInfo messageInfo = this.messages.remove(i);
            if (messageInfo instanceof FileInfo && (file = ((FileInfo)messageInfo).getFile()) != null) {
                file.delete();
            }
            this.notifyMessageRemoved(messageInfo);
            return messageInfo;
        }
        return null;
    }

    protected void removeAllMessages() {
        if (this.messages.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.messages.size(); ++i) {
            File file;
            MessageInfo messageInfo = this.messages.get(i);
            if (!(messageInfo instanceof FileInfo) || (file = ((FileInfo)messageInfo).getFile()) == null) continue;
            file.delete();
        }
        this.messages.clear();
        this.notifySessionListeners(7);
    }

    protected List getCalls() {
        ArrayList<MessageInfo> list = new ArrayList<MessageInfo>();
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            MessageInfo messageInfo = this.messages.get(i);
            if (messageInfo.getType() != 8) continue;
            list.add(messageInfo);
        }
        return list;
    }

    protected void removeCalls() {
        for (int i = this.messages.size() - 1; i >= 0; --i) {
            MessageInfo messageInfo = this.messages.get(i);
            if (messageInfo.getType() != 8) continue;
            this.messages.remove(i).getId();
        }
    }

    protected boolean containsMessage(MessageInfo messageInfo) {
        return this.messages.contains(messageInfo);
    }

    public MessageInfo getMessage(String id) {
        for (int i = this.messages.size(); i > 0; --i) {
            MessageInfo message = this.messages.get(i - 1);
            if (!id.equals(message.getId())) continue;
            return message;
        }
        return null;
    }

    public void setName(String s) {
        this.name = s;
        this.notifySessionListeners(4);
    }

    public void setParties(List<ContactInfo> list) {
        int i;
        for (i = 0; i < this.parties.size(); ++i) {
            this.parties.get(i).removeListener(this);
        }
        this.parties = list;
        for (i = 0; i < this.parties.size(); ++i) {
            this.parties.get(i).addListener(this);
        }
        this.notifySessionListeners(1);
    }

    protected void setLastUpdated(long l) {
        this.lastUpdated = l;
    }

    protected void setSessionId(String id) {
        this.sessionid = id;
    }

    protected void setDialogId(String id) {
        this.dialogid = id;
    }

    public String getDialogId() {
        return this.dialogid;
    }

    public void setStatus(int s) {
        this.status = s;
        this.notifySessionListeners(5);
    }

    public String toString() {
        Object cname;
        ContactInfo contactInfo;
        if (this.name == null || this.name.length() == 0) {
            String str = this.parties.toString();
            return str.substring(1, str.length() - 1);
        }
        if (this.type == 3 && !this.parties.isEmpty()) {
            ContactInfo contactInfo2;
            String cname2;
            int n = this.name.lastIndexOf("(");
            if (n != -1 && !this.parties.isEmpty() && (cname2 = (contactInfo2 = this.parties.get(0)).getName()) != null && cname2.length() > 0) {
                return cname2 + " " + this.name.substring(n);
            }
        } else if (!this.isGroup() && this.parties.size() == 1 && (contactInfo = this.parties.get(0)).getStatus() == 0 && (cname = contactInfo.getName()) != null && !((String)cname).isEmpty()) {
            int n = this.name.indexOf(35);
            if (n == -1) {
                n = this.name.indexOf(58);
            }
            if (n != -1) {
                cname = this.name.substring(0, n + 1) + (String)cname;
            }
            return cname;
        }
        return this.name;
    }

    protected void setCompareType(int type) {
        this.compareType = type;
    }

    public int compareTo(Object object) {
        if (object instanceof SessionInfo) {
            MessageInfo messageInfo1 = null;
            for (int i = this.messages.size() - 1; i >= 0; --i) {
                MessageInfo m = this.messages.get(i);
                if (this.compareType != 0 && !new Boolean(this.compareType == 1).equals(m.getType() != 8)) continue;
                messageInfo1 = m;
                break;
            }
            SessionInfo sessionInfo2 = (SessionInfo)object;
            MessageInfo messageInfo2 = null;
            for (int i = sessionInfo2.messages.size() - 1; i >= 0; --i) {
                MessageInfo m = sessionInfo2.messages.get(i);
                if (this.compareType != 0 && !new Boolean(this.compareType == 1).equals(m.getType() != 8)) continue;
                messageInfo2 = m;
                break;
            }
            long time1 = messageInfo1 == null ? this.lastUpdated : messageInfo1.getTime();
            long time2 = messageInfo2 == null ? ((SessionInfo)object).lastUpdated : messageInfo2.getTime();
            return time2 > time1 ? 1 : -1;
        }
        return this.toString().compareToIgnoreCase(object.toString());
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionInfo)) {
            return false;
        }
        return this.sessionid != null && this.sessionid.equals(((SessionInfo)object).getSessionId());
    }

    public boolean equalsContacts(Collection<ContactInfo> contacts) {
        for (ContactInfo next : contacts) {
            if (this.parties.contains(next)) continue;
            return false;
        }
        for (int i = 0; i < this.parties.size(); ++i) {
            if (contacts.contains(this.parties.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean matches(List<String> numbers) {
        for (int i = 0; i < this.parties.size(); ++i) {
            if (this.parties.get(i).matches(numbers)) continue;
            return false;
        }
        return true;
    }

    public int getPartyState() {
        if (this.parties.isEmpty()) {
            return 0;
        }
        int state = this.parties.get(0).getState();
        for (int i = 1; i < this.parties.size(); ++i) {
            if (this.parties.get(i).getState() == state) continue;
            state = -1;
            break;
        }
        return state;
    }

    public int getPartyStatus() {
        if (this.parties.isEmpty()) {
            return -1;
        }
        if (this.parties.size() > 1) {
            return 4;
        }
        return this.parties.get(0).getStatus();
    }

    public String getPartyName() {
        if (this.parties.isEmpty()) {
            return "";
        }
        return this.parties.get(0).getName();
    }

    public boolean hasName() {
        if (this.name != null && this.name.length() > 0) {
            return true;
        }
        String str = this.getPartyName();
        return str != null && str.length() > 0;
    }

    public boolean isExternal() {
        return this.status < 0 || this.type == 1 || this.parties.size() == 1 && this.parties.get(0).getState() == -1;
    }

    public boolean isInternal() {
        return this.status >= 0 && this.status < 4 && this.type == 0;
    }

    protected void messageNotLoaded() {
        this.nomore = true;
        this.notifySessionListeners(6);
    }

    protected boolean needMore() {
        return this.messages.size() < 2 && !this.nomore;
    }

    @Override
    public void statusChanged(ContactInfo contact) {
        this.notifySessionListeners(5);
    }

    @Override
    public void stateChanged(ContactInfo contact) {
        this.notifySessionListeners(2);
    }

    @Override
    public void imageLoaded(ContactInfo contact) {
        this.notifySessionListeners(3);
    }

    @Override
    public void dataChanged(ContactInfo contact) {
        this.notifySessionListeners(4);
    }

    public boolean isNotificationEnabled() {
        Boolean nodisturb = (Boolean)this.getProperty(NODISTURB);
        return this.status < 4 && (nodisturb == null || nodisturb == false);
    }

    public boolean isNotificationSoundEnabled() {
        Boolean nosound = (Boolean)this.getProperty(NOSOUND);
        return nosound == null || nosound == false;
    }

    public boolean canMakeVideoCall() {
        if (this.isChannel() || this.isPublic() || this.status == -6) {
            return false;
        }
        if (this.isGroup() && this.status != 3 && this.status != 1 && this.conferenceState != 2) {
            return false;
        }
        Iterator<ContactInfo> it = this.parties.iterator();
        while (it.hasNext()) {
            if (!it.next().canReceiveVideoCalls()) continue;
            return true;
        }
        return false;
    }

    public boolean canMakeCall() {
        if (this.isChannel() || this.isPublic() || this.status == -6) {
            return false;
        }
        if (this.isGroup() && this.status != 3 && this.status != 1 && this.conferenceState == 0) {
            return false;
        }
        Iterator<ContactInfo> it = this.parties.iterator();
        while (it.hasNext()) {
            if (!it.next().canMakeCalls()) continue;
            return true;
        }
        return false;
    }

    public boolean canChat() {
        ContactInfo contact;
        if (this.type >= 2 && this.status > 0 && this.status < 4) {
            return true;
        }
        if (this.type == 1 || this.status == 4 || this.status == -3 || this.status == -6 || this.parties.isEmpty() || this.status == -1) {
            return false;
        }
        if (this.status == -5) {
            int type = this.messages.get(0).getType();
            return type == 1 || type == 15;
        }
        return this.status != 0 || (contact = this.parties.get(0)).canReceiveMessages();
    }

    public boolean canMail() {
        if (this.parties.isEmpty() || this.status != -3 && this.status != -4) {
            return false;
        }
        return this.parties.get(0).hasEmail();
    }

    public boolean canSMS() {
        if (this.parties.isEmpty()) {
            return false;
        }
        return this.status == -3 || this.status == -4 || this.parties.get(0).isPhone() || this.type == 3;
    }

    public boolean canUpdateMessage() {
        return this.status != -3 && this.type != 3;
    }

    public boolean canGroup() {
        return this.status == 0 || this.status == 1 || this.status == 3 || (this.status == -3 || this.status == -4) && this.getLastChatMessage() != null;
    }

    public boolean hasInfo() {
        return !this.isSlot() && !this.isFeature();
    }

    protected File getImageFile() {
        return this.imageFile;
    }

    public boolean hasAvatar() {
        return this.imageFile != null;
    }

    protected void setImageFile(File file) {
        this.imageFile = file;
        long l = this.imgdate = file != null ? file.lastModified() : -1L;
        if (this.parties.size() == 1 && this.status < 0) {
            this.parties.get(0).setImageFile(file);
        }
        this.notifySessionListeners(3);
    }

    public void addFileTransferListener(FileTransferListener listener) {
        if (!this.filelisteners.contains(listener)) {
            this.filelisteners.add(listener);
        }
    }

    public void removeFileTransferListener(FileTransferListener listener) {
        this.filelisteners.remove(listener);
    }

    public List<String> getAdmins() {
        return this.admins;
    }

    public void setAdmins(List<String> list) {
        this.admins = list;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long time) {
        this.created = time;
    }

    public boolean isGroup() {
        return this.status > 0 && (this.status < 4 || this.parties.size() > 1);
    }

    public boolean hasNewMessage() {
        if (this.messages.isEmpty()) {
            return false;
        }
        int lastMessageStatus = this.getLastMessage().getStatus();
        return lastMessageStatus == 1 || lastMessageStatus == 12;
    }

    protected boolean isEmpty() {
        return this.messages.isEmpty();
    }

    protected void setImageTimestamp(long ts) {
        this.imgdate = ts;
    }

    protected long getImageTimestamp() {
        return this.imgdate;
    }

    protected void setImageId(String id) {
        this.imageid = id;
    }

    protected String getImageId() {
        return this.imageid;
    }

    protected void setDialogType(int c) {
        this.type = c;
    }

    public int getDialogType() {
        return this.type;
    }

    public boolean isChannel() {
        return this.type == 1;
    }

    public boolean isPublic() {
        return this.type >= 2;
    }

    public boolean isSlot() {
        return this.parties.size() == 1 && this.parties.get(0).isSlot();
    }

    public boolean isFeature() {
        return this.parties.size() == 1 && this.parties.get(0).isFeature();
    }

    public boolean isAutoPlayback() {
        Boolean b = (Boolean)this.getProperty(AUTOPLAY);
        if (b == null) {
            b = this.status == -1;
        }
        return b;
    }

    public String getPostId() {
        String postid = (String)this.properties.get("postid");
        if (postid != null) {
            return postid;
        }
        return this.getCommentParameter("postid");
    }

    public String getPostLink() {
        String postid = (String)this.properties.get("post");
        if (postid != null) {
            return postid;
        }
        return this.getCommentParameter("post");
    }

    private String getCommentParameter(String key) {
        if (this.messages.isEmpty() || this.messages.get(0).getType() != 15) {
            return null;
        }
        String content = this.messages.get(0).getContent();
        int p = content.indexOf("\"" + key + "\":\"");
        if (p == -1) {
            return null;
        }
        return content.substring(p += key.length() + 4, content.indexOf(34, p));
    }

    @Override
    public void transferStarted(FileInfo fileInfo) {
        Iterator<FileTransferListener> it = this.filelisteners.iterator();
        while (it.hasNext()) {
            it.next().transferStarted(fileInfo);
        }
    }

    @Override
    public void transferProgress(FileInfo fileInfo) {
        Iterator<FileTransferListener> it = this.filelisteners.iterator();
        while (it.hasNext()) {
            it.next().transferProgress(fileInfo);
        }
    }

    @Override
    public void transferEnded(FileInfo fileInfo) {
        Iterator<FileTransferListener> it = this.filelisteners.iterator();
        while (it.hasNext()) {
            it.next().transferEnded(fileInfo);
        }
    }

    public List<String> getPartyNumbers() {
        int i;
        if (this.parties.isEmpty()) {
            return new ArrayList<String>();
        }
        ContactInfo contactInfo = this.parties.get(0);
        MessageInfo messageInfo = null;
        for (i = this.messages.size() - 1; i >= 0; --i) {
            MessageInfo m = this.messages.get(i);
            if (m.getType() != 8 && m.getType() != 20) continue;
            messageInfo = m;
            break;
        }
        if (this.parties.size() > 1 && this.type == 3) {
            for (i = 1; i < this.parties.size(); ++i) {
                if (this.parties.get(i).isUser()) continue;
                contactInfo = this.parties.get(i);
                break;
            }
        }
        return contactInfo.getPhoneNumbersList(messageInfo);
    }
}

