/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone;

import com.smile.sound.WavAudioFormat;
import com.smile.sound.WaveParser;
import com.smile.sound.wavFormatHeader;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.AudioConverter;
import com.smile.telephony.CTIPort;
import com.smile.telephony.PipeRecorder;
import com.smile.telephony.Recorder;
import com.smile.telephony.Resource;
import com.smile.telephony.ResourceProvider;
import com.smile.telephony.audio.MixedInputStream;
import com.smile.telephony.video.FrameBuffer;
import com.smile.telephony.video.VideoCapability;
import com.smile.telephony.video.VideoResource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import smile.cti.client.LineEventListener;
import smile.cti.client.LineInfo;
import smile.cti.phone.DeviceListener;
import smile.cti.phone.PhoneApplication;
import smile.cti.phone.PhoneLine;
import smile.cti.phone.audio.AudioDevice;
import smile.cti.phone.audio.AudioSystem;
import smile.cti.phone.video.DisplayPane;
import smile.cti.phone.video.VideoDevice;
import smile.util.ResourceStore;

public class PhoneDevice
implements ResourceProvider,
LineEventListener {
    static final AudioCodec[] audio_codecs = new AudioCodec[]{AudioCodec.PCM16LINEAR, AudioCodec.T38UDP};
    static final WavAudioFormat[] wav_formats = new WavAudioFormat[]{WavAudioFormat.PCM_LINEAR16};
    public static final String CHANNEL_NAME = "line";
    public static final int RING_NO = 0;
    public static final int RING_SND = 1;
    public static final int RING_SPK = 2;
    private Vector lines = new Vector();
    private AudioDevice audioDevice;
    private VideoDevice videoDevice;
    private File faxfile;
    private PhoneLine activeLine;
    private String soundsDir = System.getProperty("user.dir") + "/sounds";
    private String ringback = "ringback.wav";
    private String ringtone = "ringin.wav";
    private String beeptone = "beep.wav";
    private String dialtone = "ptt.wav";
    private String greeting;
    private String holdgreeting;
    private String holdmusic;
    private String ansmprompt;
    private int ansmtime = 60;
    private int ringMode = 1;
    private int pbufsize = 150;
    private HashMap applications = new HashMap();
    private int channels = 1;
    private InputStream current = null;
    private PhoneLine playingLine = null;
    private File userDir;
    public static final String PHONE_POPUP = "Popup phone image";
    public static final String CALL_ALERT = "Show call alert";
    public static final String PHONE_DEVICE = "Phone device";
    public static final String RING_DEVICE = "Ring device";
    public static final String PLAYBACK_LEVEL = "Playback level";
    public static final String RECORD_LEVEL = "Record level";
    public static final String RING_LEVEL = "Ring level";
    public static final String MSG_NOTIFY_PROMPT = "Message notification prompt";
    public static final String CONNECTION_SPEED = "Connection speed";
    public static final String TOS = "TOS value";
    public static final String VAD = "VAD";
    public static final String AGC_IN = "AGC IN";
    public static final String AGC_OUT = "AGC OUT";
    public static final String AEC = "AEC";
    public static final String AEC_TAIL = "AEC tail";
    public static final String MINJITTER = "minjitter";
    public static final String ALWAYS_ON_TOP = "Always on top";
    public static final String CAMERA_DEVICE = "Camera device";
    public static final String CAMERA_FORMAT = "Camera format";
    public static final String VIDEO_BITRATE = "Video bitrate";
    public static final String CAMERA_FRAMERATE = "Camers framerate";
    public static final String VIDEO_CAPABILITIES = "Video capabilities";
    public static final String[] BITRATE = new String[]{"128000", "256000", "512000", "1024000", "2048000", "4096000", "10000000"};
    public static final String SPEAKER_DEVICE = "Speaker device";
    public static final String MICROPHONE_DEVICE = "Microphone device";
    public static final String SOUNDS = "Sounds";
    public static final String AUTOLOGIN = "Autologin";
    public static final String AUTOANSWER = "Autoanswer";
    public static final String AUTOANSWER_ON = "Autoanswer On";
    public static final String AUTOANSWER_OFF = "Autoanswer Off";

    public PhoneDevice() throws Exception {
        AudioSystem audio;
        String osname = System.getProperty("os.name").toLowerCase();
        String osversion = System.getProperty("os.version").toLowerCase();
        String jvendor = System.getProperty("java.vendor");
        if (jvendor.contains("Android")) {
            audio = (AudioSystem)Class.forName("smile.android.api.audio.AudioDevice").newInstance();
            this.ringMode = 0;
        } else if (osname.contains("ios")) {
            audio = new net.sipsnet.client.ios.AudioDevice();
            this.ringMode = 0;
        } else {
            audio = new smile.cti.phone.audio.impl.AudioDevice();
        }
        this.audioDevice = new AudioDevice(audio);
        this.videoDevice = new VideoDevice();
        Vector<VideoCapability> vcaps = new Vector<VideoCapability>();
        int vc = 4;
        if (jvendor.contains("Android")) {
            if (Runtime.getRuntime().availableProcessors() <= 2) {
                vc = 3;
            }
        } else if (osname.contains("ios")) {
            this.audioDevice.setSourceLine("Receiver");
            if (osversion.startsWith("9")) {
                vc = 3;
            } else {
                this.setRingtone("silence.wav");
            }
        }
        vcaps.add(VideoCapability.getDefaultCapabilities(vc));
        this.videoDevice.setVideoCapabilities(vcaps);
    }

    public void setDeviceListener(DeviceListener listener) {
        this.audioDevice.setDeviceListener(listener);
        this.videoDevice.setDeviceListener(listener);
    }

    public void setSystemSoundsDir(String dir) {
        this.soundsDir = dir;
    }

    public void closeAudioLines() {
        this.audioDevice.closeLines();
    }

    public void resetAudioLines() throws Exception {
        this.audioDevice.resetLines();
    }

    public int getLinesCount() {
        return this.lines.size();
    }

    @Override
    public String getDeviceName() {
        return "SmilePhone";
    }

    public Vector getLineChannels() {
        return this.lines;
    }

    public Enumeration getAudioSourceLines() {
        return this.audioDevice.getSourceLines();
    }

    public Enumeration getAudioTargetLines() {
        return this.audioDevice.getTargetLines();
    }

    public String getAudioSourceLine() {
        return this.audioDevice.getSourceLineName();
    }

    public String getAudioTargetLine() {
        return this.audioDevice.getTargetLineName();
    }

    public void setAudioSourceLine(String name) throws Exception {
        this.audioDevice.setSourceLine(name);
    }

    public void setAudioTargetLine(String name) throws Exception {
        this.audioDevice.setTargetLine(name);
    }

    public void setPagingLine(String name) throws Exception {
        this.audioDevice.setPagingLine(name);
    }

    public String getPagingLine() {
        return this.audioDevice.getPagingLineName();
    }

    public void startSpeakerphone(InputStream stream) {
        this.current = this.audioDevice.getInputStream();
        this.audioDevice.setInputStream(stream);
    }

    public void stopSpeakerphone() {
        this.audioDevice.setInputStream(this.current);
        this.current = null;
    }

    public void setAudioSessionState(boolean b) {
        this.audioDevice.setState(b);
    }

    public void setAEC(int mode) {
        if (this.audioDevice != null) {
            this.audioDevice.setAEC(mode);
        }
    }

    public void setAGCPlayback(boolean mode) {
        if (this.audioDevice != null) {
            this.audioDevice.setAGCPlayback(mode);
        }
    }

    public void setAGCRecord(boolean mode) {
        if (this.audioDevice != null) {
            this.audioDevice.setAGCRecord(mode);
        }
    }

    public void setVAD(boolean mode) {
        this.audioDevice.setVAD(mode);
    }

    public void setRingMode(int mode) {
        this.ringMode = mode;
    }

    public void setRingtone(String r) {
        this.ringtone = r;
    }

    public void setPlayGreeting(String r) {
        this.greeting = r;
    }

    public void setHoldGreeting(String r) {
        this.holdgreeting = r;
    }

    public void setHoldMusic(String r) {
        this.holdmusic = r;
    }

    public void setAnsmPrompt(String r) {
        this.ansmprompt = r;
    }

    public AudioCodec[] getAudioCodecs(int mode) {
        return audio_codecs;
    }

    public WavAudioFormat[] getAvailableCodecs(int direction) {
        return wav_formats;
    }

    public synchronized void callArrived(PhoneLine line) {
        if (this.activeLine == null && this.applications.isEmpty()) {
            this.activeLine = line;
        }
    }

    public int callRinging(PhoneLine line, int timeout) {
        Ring rng = new Ring(line);
        this.applications.put(line, rng);
        int result = rng.callRinging(timeout);
        return result;
    }

    public void cancelRinging(PhoneLine line) {
        Object obj = this.applications.get(line);
        if (obj instanceof Ring) {
            ((Ring)obj).stopRinging(8);
            this.applications.remove(line);
        }
    }

    public synchronized void callDropped(PhoneLine line) {
        if (this.activeLine == line) {
            this.audioDevice.stopOperation();
            this.activeLine = null;
        } else if (this.activeLine != null && this.activeLine.getInputStream() != null) {
            this.audioDevice.setInputStream(this.activeLine.getInputStream());
        }
        PhoneApplication application = (PhoneApplication)this.applications.remove(line);
        if (application != null) {
            application.terminate();
        }
    }

    public void autoAnswered(PhoneLine line) {
        if (line == this.activeLine) {
            this.playPagingLine(this.soundsDir + "/dindon.wav");
        }
    }

    @Override
    public void startBoard(String board, byte[] data) {
        this.channels = data.length;
    }

    private int getChannelsCount() {
        return this.channels;
    }

    public Map getProperties() {
        return new HashMap();
    }

    private PhoneLine getLine(String lineName) {
        Enumeration en = this.lines.elements();
        while (en.hasMoreElements()) {
            PhoneLine line = (PhoneLine)en.nextElement();
            if (!line.getName().equals(lineName)) continue;
            return line;
        }
        return null;
    }

    public void clearLine(String lineName) {
        PhoneLine line = this.getLine(lineName);
        if (line != null) {
            line.setState(1);
        }
    }

    public synchronized void setActiveLine(String lineName) {
        ResourceStore.toLog("Device setActiveLine " + lineName + " activeLine=" + this.activeLine);
        if (lineName == null) {
            if (this.activeLine != null) {
                this.audioDevice.setInputStream(null);
                this.audioDevice.setOutputStream(null);
                this.activeLine.setState(7);
            }
            this.activeLine = null;
        } else {
            PhoneLine line;
            PhoneLine oldActiveLine = this.activeLine;
            this.activeLine = line = this.getLine(lineName);
            switch (line.getState()) {
                case 1: {
                    line.setState(11);
                    break;
                }
                case 8: {
                    this.answerCall();
                    break;
                }
                case 4: {
                    PhoneApplication application = (PhoneApplication)this.applications.remove(line);
                    if (application != null) {
                        application.terminate();
                    }
                    this.audioDevice.setInputStream(line.getInputStream());
                    this.audioDevice.setOutputStream(line.getOutputStream());
                    if (oldActiveLine == null || oldActiveLine == line) break;
                    this.videoDevice.setActiveLine(line);
                    break;
                }
            }
        }
    }

    public void makeCall(String number) {
        if (this.activeLine == null) {
            this.activeLine = (PhoneLine)this.lines.elementAt(0);
        }
        this.activeLine.setCall(number);
    }

    public void makeCall(String number, String lineName) {
        PhoneLine line = this.getLine(lineName);
        if (this.activeLine == null) {
            this.activeLine = line;
        }
        line.setCall(number);
    }

    public void answerCall() {
        Object app = this.applications.remove(this.activeLine);
        if (app instanceof Ring) {
            ((Ring)app).stopRinging(256);
            if (this.greeting != null && this.greeting.length() > 0) {
                this.applications.put(this.activeLine, new Greeting(this.activeLine));
            }
        } else if (this.activeLine != null) {
            this.activeLine.setState(4);
        }
    }

    public void answerMachine(String lineName, boolean screening, int maxtime) {
        PhoneLine line = this.getLine(lineName);
        Ring ring = (Ring)this.applications.remove(line);
        AnsweringMachine mach = new AnsweringMachine(line, screening, maxtime);
        this.applications.put(line, mach);
        if (ring != null) {
            ring.stopRinging(256);
        }
    }

    public void answerOnHold(String lineName) {
        PhoneLine line = this.getLine(lineName);
        Ring ring = (Ring)this.applications.remove(line);
        this.applications.put(line, new Hold(line));
        if (ring != null) {
            ring.stopRinging(256);
        }
    }

    public void dropCall(String lineName, String number) {
        PhoneLine line = this.getLine(lineName);
        if (line != null) {
            line.transmitDigits("|!");
        }
    }

    public void dropCall() {
        if (this.activeLine != null) {
            this.activeLine.setState(7);
        }
    }

    public void dropCall(String lineName) {
        PhoneLine line = this.getLine(lineName);
        line.setState(7);
    }

    public void rejectCall(String lineName) {
        PhoneLine line = this.getLine(lineName);
        if (line != null) {
            line.setState(-1);
        }
    }

    public void forwardCall(String lineName, String number) {
        PhoneLine line = this.getLine(lineName);
        line.forwardCall(number);
        Object app = this.applications.remove(line);
        if (app instanceof Ring) {
            ((Ring)app).stopRinging(8);
        }
    }

    public void transferCall(String lineName, String number) {
        PhoneLine line = this.getLine(lineName);
        this.transferCall(line, number);
    }

    public void transferCall(String number) {
        this.transferCall(this.activeLine, number);
    }

    private void transferCall(PhoneLine line, String number) {
        line.transferCall(number);
    }

    public void holdCall(String lineName) {
        PhoneLine line = this.getLine(lineName);
        line.holdCall();
    }

    public void swapCall(String lineName) {
        PhoneLine line = this.getLine(lineName);
        line.swapCall();
    }

    public void makeConference() {
        if (this.activeLine != null) {
            this.activeLine.makeConference();
        }
    }

    public boolean join(String portName1, String portName2) {
        PhoneLine line1 = this.getLine(portName1);
        PhoneLine line2 = this.getLine(portName2);
        return line1.join(line2);
    }

    public boolean reinvite(String lineName) {
        PhoneLine line = this.getLine(lineName);
        return line != null && line.reinvite();
    }

    public void sendChar(char key) {
        if (this.activeLine != null) {
            this.activeLine.transmitDigit(key);
            if (!this.audioDevice.isPlaying()) {
                this.playTone(String.valueOf(key));
            }
        }
    }

    public void transmitDigits(String digits, String lineName) {
        PhoneLine line = this.getLine(lineName);
        for (int i = 0; i < digits.length(); ++i) {
            line.transmitDigit(digits.charAt(i));
        }
    }

    public void startFax(String lineName) {
    }

    public void stopFax(String lineName) {
        PhoneLine line = this.getLine(lineName);
    }

    public void setFaxFile(File file) {
        this.faxfile = file;
    }

    public File getFaxFile() {
        return this.faxfile;
    }

    public int getFileDuration(File file) {
        return 0;
    }

    public boolean playFile(File file, int fromSecond, int maxtime, String lineName) throws Exception {
        return this.audioDevice.playFile(file, fromSecond, maxtime, lineName);
    }

    public void playFile(File file) throws Exception {
        this.audioDevice.playFile(file, 0, 0, "");
    }

    public void stopPlay(String lineName) {
        this.audioDevice.stopPlay();
    }

    public void stopPlay() {
        this.audioDevice.stopPlay();
    }

    public int play(String filename) {
        return this.audioDevice.playSourceLine(filename, -1);
    }

    public int play(String filename, int maxtime) {
        return this.audioDevice.playSourceLine(filename, maxtime);
    }

    public int playPagingLine(String filename) {
        return this.audioDevice.playPagingLine(filename, -1);
    }

    public int playPagingLine(String filename, int maxtime) {
        return this.audioDevice.playPagingLine(filename, maxtime);
    }

    public int play(InputStream stream, PhoneLine line, int timeout) {
        ResourceStore.toLog("PhoneDevice play line=" + line + " active=" + this.activeLine + " playingLine=" + this.playingLine);
        if (this.playingLine != null) {
            return -1;
        }
        int result = -1;
        this.playingLine = line;
        try {
            InputStream input = this.audioDevice.getInputStream();
            if (input == null || line == this.activeLine) {
                result = this.audioDevice.play(stream, timeout);
            } else {
                MixedInputStream mstream = new MixedInputStream();
                mstream.addInputStream(stream);
                mstream.addInputStream(input);
                result = this.audioDevice.play(mstream, timeout);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.playingLine = null;
        ResourceStore.toLog("PhoneDevice play line=" + line + " result=" + result + " active=" + this.activeLine);
        return result;
    }

    public void stopOperation(PhoneLine line) {
        ResourceStore.toLog("PhoneDevice stopOperation line=" + line + " active=" + this.activeLine + " playingLine=" + this.playingLine);
        if (line == this.playingLine || this.playingLine == null) {
            this.audioDevice.stopOperation();
        }
    }

    public void startPlayback(InputStream stream, PhoneLine line) {
        PhoneApplication application = (PhoneApplication)this.applications.get(line);
        ResourceStore.toLog("startPlayback line=" + line + " activeLine=" + this.activeLine + " stream=" + stream + " application=" + application);
        if (application != null) {
            application.setInputStream(stream);
        } else if (line == this.activeLine && this.audioDevice != null) {
            this.audioDevice.setInputStream(stream);
        }
    }

    public void startRecord(OutputStream stream, PhoneLine line) {
        PhoneApplication application = (PhoneApplication)this.applications.get(line);
        ResourceStore.toLog("startRecord line=" + line + " activeLine=" + this.activeLine + " stream=" + stream + " application=" + application);
        if (application != null) {
            application.setOutputStream(stream);
        } else if (line == this.activeLine && this.audioDevice != null) {
            this.audioDevice.setOutputStream(stream);
        }
    }

    public void stopPlayback(PhoneLine line) {
        ResourceStore.toLog("stopPlayback line=" + line + " activeLine=" + this.activeLine);
        if (line == this.activeLine && this.audioDevice != null) {
            this.audioDevice.setInputStream(null);
        }
    }

    public void stopRecord(PhoneLine line) {
        ResourceStore.toLog("stopRecord line=" + line + " activeLine=" + this.activeLine);
        if (line == this.activeLine && this.audioDevice != null) {
            this.audioDevice.setOutputStream(null);
        }
    }

    public void startScreening() {
        Object application;
        if (this.activeLine != null && (application = this.applications.get(this.activeLine)) instanceof AnsweringMachine) {
            ((AnsweringMachine)application).setScreening(true);
        }
    }

    public void stopScreening() {
        for (Object application : this.applications.values()) {
            if (!(application instanceof AnsweringMachine)) continue;
            ((AnsweringMachine)application).setScreening(false);
        }
    }

    public void startRecording(String lineName, String filename) throws IOException {
        PhoneLine line = this.getLine(lineName);
        VoiceRecorder rec = new VoiceRecorder(line, filename);
    }

    public VideoDevice getVideoDevice() {
        return this.videoDevice;
    }

    public Vector getVideoChannels() {
        return this.videoDevice.findVideoDevices();
    }

    public String[] getCaptureDeviceNames() {
        return this.videoDevice.getCaptureDeviceNames();
    }

    public String setCaptureChannel(String chname, boolean landscape) throws Exception {
        return this.videoDevice.setCaptureChannel(chname, landscape);
    }

    public void setCaptureChannel(String chname, String format, String bitrate) throws Exception {
        this.videoDevice.setCaptureChannel(chname, format, bitrate);
    }

    public int getVideoMode() {
        return this.videoDevice.getVideoMode();
    }

    public Vector getVideoCapabilities() {
        return this.videoDevice.getVideoCapabilities();
    }

    public void setVideoCapabilities(Vector caps) {
        this.videoDevice.setVideoCapabilities(caps);
    }

    public void startReceiver(PhoneLine line, VideoCapability cap, FrameBuffer output) {
        this.videoDevice.startReceiver(line, cap, output);
    }

    public void startTransmitter(PhoneLine line, VideoCapability cap, FrameBuffer input) {
        this.videoDevice.startTransmitter(line, cap, input);
    }

    public void stopReceiver(PhoneLine line) {
        this.videoDevice.stopReceiver(line);
    }

    public void stopTransmitter(PhoneLine line) {
        this.videoDevice.stopTransmitter(line);
    }

    public double adjustRate(VideoResource line, double rate) {
        return this.videoDevice.adjustRate(line, rate);
    }

    public int adjustFormat(VideoResource line, int seq, int index) {
        return this.videoDevice.adjustFormat(line, seq, index);
    }

    public void keyFrameRequest() {
        this.videoDevice.keyFrameRequest();
    }

    public void decoderRefreshRequest() {
        this.videoDevice.decoderRefreshRequest();
    }

    public void setDisplayChannel(DisplayPane videoPanel) {
        this.videoDevice.setDisplayChannel(videoPanel);
    }

    public void setLocalPicture(boolean on) {
        this.videoDevice.setLocalPicture(on);
    }

    public void setShowDesktop(boolean on) {
        this.videoDevice.setShowDesktop(on);
    }

    public boolean isShowing() {
        return this.videoDevice.isShowing();
    }

    public boolean isCapturing() {
        return this.videoDevice.isCapturing();
    }

    public void setCapturing(boolean mode) {
        this.videoDevice.setCapturing(mode);
    }

    public void setVideoMode(int mode) {
        this.videoDevice.setVideoMode(mode);
    }

    public List getCameraFormats(String chname) {
        return this.videoDevice.getAvailableFormats(chname);
    }

    public String getCaptureFormat() {
        return this.videoDevice.getCaptureFormat();
    }

    public void setMessagesDir(File dir) {
        this.userDir = dir;
    }

    @Override
    public void stateChanged(LineInfo lineInfo) {
        if (lineInfo.getState() == 0) {
            this.clearLine(lineInfo.getName());
        }
    }

    @Override
    public void identityChanged(LineInfo lineInfo) {
    }

    @Override
    public void setRecording(LineInfo lineInfo, boolean b) {
    }

    @Override
    public Resource[] getResources() {
        ResourceStore.toLog(this.getChannelsCount() + " PhoneDevice");
        for (int i = 0; i < this.getChannelsCount(); ++i) {
            this.lines.addElement(new PhoneLine(this, CHANNEL_NAME + (i + 1)));
        }
        Object[] r = new Resource[this.lines.size()];
        this.lines.copyInto(r);
        return r;
    }

    public void setPlaybackLevel(float level) {
        this.audioDevice.setPlaybackLevel(level);
    }

    public void setRecordLevel(float level) {
        this.audioDevice.setRecordLevel(level);
    }

    public float getPlaybackLevel() {
        return this.audioDevice.getPlaybackLevel();
    }

    public float getRecordLevel() {
        return this.audioDevice.getRecordLevel();
    }

    public boolean getMute() {
        return this.audioDevice.getMute();
    }

    public void setMute(boolean state) {
        this.audioDevice.setMute(state);
    }

    public float getRingLevel() {
        return this.audioDevice.getRingLevel();
    }

    public void setRingLevel(float level) {
        this.audioDevice.setRingLevel(level);
    }

    public void setAudioCaptureTest(boolean mode) {
        this.audioDevice.setCaptureTest(mode);
    }

    public int getAudioCaptureLevel() {
        return this.audioDevice.getCaptureStreamLevel();
    }

    public int getAudioSpeechLevel() {
        return this.audioDevice.getPlaybackStreamLevel();
    }

    public void setLocalView(DisplayPane pane) {
        this.videoDevice.setLocalView(pane);
    }

    public int playTone(String tone) {
        return this.audioDevice.playTone(tone, 0);
    }

    public int playPagingTone(String tone) {
        return this.audioDevice.playTone(tone, 1);
    }

    public int playBeep(int timeout) {
        return this.audioDevice.playPagingLine(this.soundsDir + "/" + this.beeptone, timeout);
    }

    public int playDial(int timeout) {
        return this.audioDevice.playPagingLine(this.soundsDir + "/" + this.dialtone, timeout);
    }

    public int playRing(int timeout) {
        return this.audioDevice.playPagingLine(this.soundsDir + "/" + this.ringtone, timeout);
    }

    public int playRingback(int timeout) {
        return this.audioDevice.playFile(this.soundsDir + "/" + this.ringback, 0, timeout);
    }

    public void stopPlayRing() {
        for (Object line : this.applications.keySet()) {
            Object obj = this.applications.get(line);
            if (!(obj instanceof Ring)) continue;
            ((Ring)obj).stopPlayRing();
        }
    }

    public boolean hasSoundDevices() {
        return this.getAudioSourceLines().hasMoreElements();
    }

    public void setPagingMode(boolean on) {
    }

    class AnsweringMachine
    extends PhoneApplication {
        boolean screening;
        int maxtime;

        AnsweringMachine(PhoneLine line, boolean s, int time) {
            super(line);
            this.screening = s;
            this.maxtime = time;
        }

        public void setScreening(boolean mode) {
            if (!mode && this.screening) {
                this.screening = false;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PhoneDevice.this.audioDevice.stopSourceLine();
            } else if (mode && !this.screening) {
                this.screening = PhoneDevice.this.audioDevice.startSourceLine();
            }
        }

        @Override
        public void run() {
            if (this.line == PhoneDevice.this.activeLine) {
                PhoneDevice.this.audioDevice.setInputStream(null);
                PhoneDevice.this.audioDevice.setOutputStream(null);
            }
            try {
                this.playFile(PhoneDevice.this.ansmprompt, this.output);
            }
            catch (Exception e) {
                ResourceStore.toLog("ANSM:  " + e.toString());
            }
            if (!this.running) {
                return;
            }
            if (this.screening) {
                PhoneDevice.this.stopScreening();
                this.screening = PhoneDevice.this.audioDevice.startSourceLine();
            }
            String error = null;
            try {
                int n;
                wavFormatHeader hdr = new wavFormatHeader(wav_formats[0]);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bos.write(hdr.toByteArray());
                byte[] data = new byte[160];
                long endtime = System.currentTimeMillis() + (long)this.maxtime;
                while (this.running && endtime > System.currentTimeMillis() && (n = this.input.read(data)) != -1) {
                    if (n == 0) {
                        Thread.sleep(10L);
                        continue;
                    }
                    if (this.screening) {
                        PhoneDevice.this.audioDevice.writeToLine(data);
                    }
                    bos.write(data);
                }
                bos.close();
                byte[] image = bos.toByteArray();
                wavFormatHeader.updateHeader(image);
                String filename = System.currentTimeMillis() + "_" + this.line.getOriginNumber() + ".wav";
                File recfile = new File(PhoneDevice.this.userDir, filename);
                FileOutputStream fos = new FileOutputStream(recfile);
                fos.write(image);
                fos.close();
                recfile.setReadOnly();
            }
            catch (Exception e) {
                e.printStackTrace();
                error = e.toString();
            }
            if (this.screening) {
                PhoneDevice.this.audioDevice.stopSourceLine();
            }
            if (this.line == PhoneDevice.this.activeLine) {
                PhoneDevice.this.audioDevice.setInputStream(this.input);
                PhoneDevice.this.audioDevice.setOutputStream(this.output);
            }
            if (this.running) {
                this.getLine().setState(7);
            }
            if (error != null) {
                // empty if block
            }
        }
    }

    class Hold
    extends PhoneApplication {
        Hold(PhoneLine line) {
            super(line);
        }

        @Override
        public void run() {
            try {
                this.playFile(PhoneDevice.this.holdgreeting, this.output);
            }
            catch (Exception e) {
                ResourceStore.toLog("HOLD:  " + e.toString());
                try {
                    Hold.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.running) {
                this.line.swapCall();
            }
        }
    }

    class Ring
    extends PhoneApplication {
        private int result;
        private boolean playring;

        Ring(PhoneLine line) {
            super(line);
            this.result = 32;
            this.playring = true;
        }

        public int callRinging(int timeout) {
            this.running = true;
            ResourceStore.toLog("callRinging line=" + this.line + " activeLine=" + PhoneDevice.this.activeLine + " playring=" + this.playring + " timeout=" + timeout);
            if (this.line != PhoneDevice.this.activeLine) {
                long end = System.currentTimeMillis() + (long)(timeout * 1000);
                int t = 7;
                while (this.running && System.currentTimeMillis() < end) {
                    if (this.playring && t == 9) {
                        int r = PhoneDevice.this.playTone("Call Waiting");
                        if (r != 512 && r != 256 && r != 32) {
                            this.result = r;
                            break;
                        }
                        t = 0;
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++t;
                }
            } else if ((PhoneDevice.this.ringMode & 1) != 0) {
                long end = System.currentTimeMillis() + (long)(timeout * 1000);
                while (this.running) {
                    if (this.playring) {
                        int r = PhoneDevice.this.playRing(timeout);
                        if (r != 512) {
                            if (r == 256) break;
                            this.result = r;
                            break;
                        }
                    } else {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if ((timeout = (int)((end - System.currentTimeMillis()) / 1000L)) >= 1) continue;
                }
                if (this.result == -1 || this.result == 16384) {
                    end = System.currentTimeMillis() + (long)(timeout * 1000);
                    do {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (this.running && System.currentTimeMillis() < end);
                }
            } else if ((PhoneDevice.this.ringMode & 2) != 0) {
                long end = System.currentTimeMillis() + (long)(timeout * 1000);
                while (this.running) {
                    System.out.write(7);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() <= end) continue;
                    break;
                }
            } else {
                long end = System.currentTimeMillis() + (long)(timeout * 1000);
                do {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.running && System.currentTimeMillis() < end);
            }
            return this.result;
        }

        public void stopPlayRing() {
            this.playring = false;
        }

        public void stopRinging(int res) {
            this.result = res;
            this.running = false;
            if (this.line == PhoneDevice.this.activeLine) {
                PhoneDevice.this.audioDevice.stopOperation();
            }
        }
    }

    class Greeting
    extends PhoneApplication {
        Greeting(PhoneLine line) {
            super(line);
        }

        @Override
        public void run() {
            try {
                InputStream voicedata = new FileInputStream(PhoneDevice.this.greeting);
                wavFormatHeader hdr = new wavFormatHeader();
                voicedata = new WaveParser().parseWavHeader(voicedata, hdr);
                WavAudioFormat codec = hdr.getAudioFormat();
                if (!codec.equals(WavAudioFormat.PCM_LINEAR16)) {
                    voicedata = new AudioConverter().getInputStream(voicedata, codec, wav_formats);
                }
                PhoneDevice.this.audioDevice.setInputStream(null);
                PhoneDevice.this.audioDevice.setOutputStream(null);
                PhoneDevice.this.audioDevice.startSourceLine();
                byte[] data = new byte[160];
                while (this.running && voicedata.read(data) != -1) {
                    this.output.write(data);
                    PhoneDevice.this.audioDevice.writeToLine(data);
                }
                voicedata.close();
                PhoneDevice.this.audioDevice.stopSourceLine();
            }
            catch (Exception e) {
                ResourceStore.toLog("GREETING: " + e.toString());
            }
            PhoneDevice.this.audioDevice.setInputStream(this.input);
            PhoneDevice.this.audioDevice.setOutputStream(this.output);
        }
    }

    class VoiceRecorder
    implements Recorder {
        PhoneLine line;
        String filename;
        ByteArrayOutputStream bos;

        VoiceRecorder(PhoneLine line, String filename) throws IOException {
            this.line = line;
            this.filename = filename;
            this.bos = new ByteArrayOutputStream(128000);
            PipeRecorder recorder = new PipeRecorder();
            recorder.setRecorder(this, this.bos, "");
            line.setRecorder(recorder);
        }

        @Override
        public void stopRecording(String id) {
            byte[] data = this.bos.toByteArray();
            wavFormatHeader hdr = new wavFormatHeader(WavAudioFormat.PCM_LINEAR16);
            hdr.setDataLength(data.length);
            byte[] header = hdr.toByteArray();
            try {
                FileOutputStream out = new FileOutputStream(this.filename);
                out.write(header);
                out.write(data);
                out.close();
            }
            catch (Exception e) {
                ResourceStore.toLog(e.toString());
            }
            this.line.setRecorder(null);
        }

        @Override
        public void startRecording(CTIPort port, String id, Hashtable table) {
        }
    }
}

