/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone;

import com.smile.sound.WavAudioFormat;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.CallInfo;
import com.smile.telephony.Mixer;
import com.smile.telephony.PipeRecorder;
import com.smile.telephony.PipeSocket;
import com.smile.telephony.Port;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.VoiceResource;
import com.smile.telephony.sip.SipPort;
import com.smile.telephony.video.FrameBuffer;
import com.smile.telephony.video.VideoCapability;
import com.smile.telephony.video.VideoResource;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import smile.cti.phone.PhoneDevice;
import smile.util.ResourceStore;

public class PhoneLine
extends PipeSocket
implements Port,
VoiceResource,
VideoResource {
    private PhoneDevice device;
    private RouteSocket rs;
    private String name;
    private int state;
    private int cause;
    private boolean released;
    private boolean answered;
    private boolean autoAnswer;
    private boolean spkmode;
    private long callTimestamp;
    private String callInfo;
    private String origNumber;
    private String incomingNumber;
    private String errorMessage = "";
    private Vector digitBuffer;
    private PipeRecorder recorder;
    private boolean confmode;
    private byte[] image;
    private boolean faxrx;
    private boolean faxtx;

    public PhoneLine(PhoneDevice device, String name) {
        this.device = device;
        this.name = name;
        this.blockingRead = false;
        this.digitBuffer = new Vector();
        this.state = 1;
    }

    public PhoneDevice getDevice() {
        return this.device;
    }

    public void setConferenceMode(boolean local) {
        this.confmode = local;
    }

    public void setSpeakerphoneMode() {
        this.spkmode = true;
    }

    @Override
    public int acceptCall(int rings) {
        return 1;
    }

    @Override
    public boolean answerCall(int rings) {
        this.state = 4;
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    protected boolean routeReceiver(RouteSocket rs) {
        this.rs = rs;
        return super.routeReceiver(rs);
    }

    public void setRouteSocket(RouteSocket rs) {
        this.rs = rs;
    }

    @Override
    public void dropCall(int cause) {
        this.device.callDropped(this);
        if (this.recorder != null) {
            this.recorder.release();
        }
        this.digitBuffer.clear();
        this.rs = null;
        this.image = null;
        cause = 0;
        this.state = 1;
    }

    @Override
    public AudioCodec[] getAudioCodecs(int mode) {
        return this.device.getAudioCodecs(mode);
    }

    @Override
    public WavAudioFormat[] getAvailableCodecs(int direction) {
        return this.device.getAvailableCodecs(direction);
    }

    public synchronized void setCall(String number) {
        ResourceStore.toLog("setCall to " + this.getName() + " state=" + this.state);
        this.callInfo = number;
        if (this.state != 4) {
            if (this.state == 8) {
                this.answered = true;
                this.released = true;
                this.notify();
            } else {
                this.state = 3;
            }
        }
    }

    public String getIncomingNumber() {
        return this.incomingNumber;
    }

    public void setCommand(char command) {
        this.digitBuffer.clear();
        this.digitBuffer.add(Character.valueOf(command));
        if (command == '&') {
            this.callInfo = String.valueOf('!');
        }
        if (command == '\u001b') {
            this.dropCall(0);
        }
    }

    public void setCommand(char command, String info) {
        this.callInfo = info;
        this.digitBuffer.clear();
        this.digitBuffer.add(Character.valueOf(command));
    }

    public void setState(int s) {
        ResourceStore.toLog(this + " setState: " + s + " state=" + this.state);
        if (s == 7 || s == -1) {
            if (this.state == 8) {
                this.device.cancelRinging(this);
                this.cause = 21;
            } else if (s == -1) {
                s = 7;
            } else {
                if (this.state == 1) {
                    return;
                }
                if (this.state == 11) {
                    s = 1;
                }
            }
        }
        this.state = s;
    }

    public void setImage(byte[] img) {
        this.image = img;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void forwardCall(String number) {
        ResourceStore.toLog(this + " forwardCall: " + number);
        this.callInfo = number;
        this.cause = 23;
        this.state = 7;
    }

    @Override
    public Hashtable getCallInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("cti.Timestamp", this.callTimestamp);
        if (this.image != null) {
            info.put("cti.CalledUserIcon", this.image);
        }
        return info;
    }

    @Override
    public String getCalledNumber() {
        this.origNumber = this.callInfo;
        this.callInfo = "";
        return this.origNumber;
    }

    @Override
    public String getCallingNumber() {
        return "";
    }

    @Override
    public String getConnectedNumber() {
        return this.callInfo;
    }

    @Override
    public int getDisconnectCause() {
        return this.state == 4 ? 16 : (this.cause != 0 ? this.cause : 17);
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPortId() {
        return this.name;
    }

    public String getOriginNumber() {
        return this.origNumber;
    }

    @Override
    public int getPlayBufferDepth() {
        return 1;
    }

    @Override
    public int getPortType() {
        return 5;
    }

    @Override
    public Map getProperties() {
        return this.device.getProperties();
    }

    @Override
    public int getRecBufferDepth() {
        return 1;
    }

    @Override
    public RouteSocket getRouteSocket() {
        return this;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getStatus() {
        return 1;
    }

    @Override
    public int getType() {
        return 2055;
    }

    @Override
    public void hold() {
    }

    @Override
    public boolean isCallDisconnected() {
        return this.state == 7 || this.state == 1;
    }

    @Override
    public String makeCall(String number, int timeout, CallInfo info) {
        ResourceStore.toLog("makeCall=" + number + " autoAnswer=" + this.autoAnswer + " state=" + this.state);
        this.callTimestamp = System.currentTimeMillis();
        this.incomingNumber = number;
        this.released = false;
        if (this.state == 7) {
            return "BUSY";
        }
        if (this.state == 4) {
            this.device.autoAnswered(this);
            return "VOICE";
        }
        this.device.callArrived(this);
        if (this.autoAnswer || this.spkmode || this.state == 11) {
            this.state = 4;
            return "VOICE";
        }
        this.answered = false;
        this.state = 8;
        return "ALERTED";
    }

    @Override
    public boolean open() {
        return true;
    }

    @Override
    public int play(String filename, char[] signal_mask, int maxtime) {
        return 0;
    }

    @Override
    public int play(java.io.InputStream stream, char[] signal_mask, int maxtime, WavAudioFormat codec) {
        ResourceStore.toLog(this.name + ": play released=" + this.released);
        if (this.released) {
            return 256;
        }
        return this.device.play(stream, this, maxtime);
    }

    public int playTone(String tone) {
        return this.device.playTone(tone);
    }

    @Override
    public boolean proceed() {
        return true;
    }

    @Override
    public boolean progress(int progressDesc) {
        return true;
    }

    @Override
    public synchronized String progressCall(int timeout) {
        if (this.state == 7) {
            return "BUSY";
        }
        if (this.state == 4) {
            return "VOICE";
        }
        int result = this.device.callRinging(this, timeout);
        ResourceStore.toLog(this.name + " progressCall result=" + result + " state=" + this.state);
        if (this.state == 7) {
            return "BUSY";
        }
        if (result == 256) {
            this.state = 4;
            return "VOICE";
        }
        if (result == 8) {
            return "STOPPED";
        }
        return "NO ANSWER";
    }

    @Override
    public String progressCallAnalyse(int timeout) {
        return "VOICE";
    }

    @Override
    public int record(java.io.OutputStream voicestream, char[] signal_mask, int maxsilence, int maxtime, WavAudioFormat codec) {
        return 0;
    }

    @Override
    public int record(String filename, char[] signal_mask, int maxsilence, int maxtime, WavAudioFormat codec) {
        return 0;
    }

    @Override
    public void release() {
        this.released = true;
        if (this.state == 8) {
            this.device.cancelRinging(this);
        }
        this.device.stopOperation(this);
        ResourceStore.toLog(this.name + " release");
    }

    @Override
    public void resume() {
    }

    public void transferCall(String number) {
        this.transmitDigits(number + "!");
    }

    public void holdCall() {
        if (!this.confmode) {
            this.transmitDigit('!');
        }
    }

    public void swapCall() {
        if (!this.confmode) {
            this.transmitDigit('!');
        }
    }

    public void makeConference() {
        if (!this.confmode) {
            this.transmitDigit('^');
        }
    }

    protected void clearDigitBuffer() {
        this.digitBuffer.removeAllElements();
    }

    public synchronized void setDigitBuffer(String chars) {
        this.digitBuffer.removeAllElements();
        for (int i = 0; i < chars.length(); ++i) {
            this.digitBuffer.addElement(new Character(chars.charAt(i)));
        }
        this.notify();
    }

    @Override
    public char retriveSignal(int timeout) {
        this.released = false;
        long endTime = System.currentTimeMillis() + (long)(timeout * 1000);
        do {
            if (!this.digitBuffer.isEmpty()) {
                return ((Character)this.digitBuffer.remove(0)).charValue();
            }
            if (this.state == 7) {
                return '\u001d';
            }
            if (this.released) {
                return '\u001c';
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (endTime > System.currentTimeMillis());
        return '\u001a';
    }

    @Override
    public boolean seize() {
        return false;
    }

    @Override
    public void sendDigits(String digits) {
        if (digits.charAt(0) == '\u001e') {
            this.faxrx = true;
        } else if (digits.charAt(0) == '\u001f') {
            this.faxtx = true;
        }
    }

    @Override
    public void sendSignal(int freq1, int freq2, int duration) {
    }

    @Override
    public void setOriginNumber(String number) {
        this.origNumber = number;
        this.autoAnswer = number.endsWith("***");
    }

    @Override
    public void setProperties(Map table) {
    }

    @Override
    public boolean startPlayback(AudioCodec codec) {
        if (this.spkmode) {
            this.device.startSpeakerphone(this.in);
        } else if (!codec.equals(AudioCodec.T38UDP)) {
            this.device.startPlayback(this.in, this);
        }
        return true;
    }

    @Override
    public boolean startRecord(AudioCodec codec) {
        if (!codec.equals(AudioCodec.T38UDP) && !this.spkmode) {
            this.device.startRecord(this.out, this);
        }
        return true;
    }

    @Override
    public void stopPlayback() {
        if (this.spkmode) {
            this.device.stopSpeakerphone();
        } else {
            this.device.stopPlayback(this);
            if (this.recorder != null) {
                this.recorder.cancelRecord(this.slave);
            }
        }
    }

    @Override
    public void stopRecord() {
        if (!this.spkmode) {
            this.device.stopRecord(this);
            if (this.recorder != null) {
                this.recorder.cancelRecord(this);
            }
        }
    }

    @Override
    public int waitCall(int timeout) {
        this.released = false;
        if (this.state == 3) {
            this.callTimestamp = System.currentTimeMillis();
            return 1;
        }
        return 0;
    }

    public boolean join(PhoneLine line) {
        ResourceStore.toLog(this.name + " join " + line.getName() + " rs=" + this.rs + " line.rs=" + line.rs + " confmode=" + this.confmode);
        if (this.confmode) {
            if (line.rs instanceof Mixer) {
                line.setDigitBuffer(this.rs.toString() + "^");
            } else {
                this.setDigitBuffer(line.rs.toString() + "^");
            }
            return true;
        }
        if (line.rs instanceof SipPort) {
            SipPort port2 = (SipPort)line.rs;
            SipPort port1 = null;
            if (this.rs instanceof SipPort) {
                port1 = (SipPort)this.rs;
            } else if (this.rs instanceof Mixer) {
                port1 = (SipPort)((Mixer)this.rs).getMainTarget();
            }
            ResourceStore.toLog(this.name + " join " + line.getName() + " p1=" + port1 + " p2=" + port2);
            if (port1 != null) {
                return port1.joinCall(port2);
            }
        }
        return false;
    }

    public boolean reinvite() {
        ResourceStore.toLog(this.name + " reinvite");
        return this.isConnected(1) && this.connectSocket(1, this.playCodec) && this.isConnected(2) && this.connectSocket(2, this.recCodec);
    }

    public void playHold(String prompt, String music) {
    }

    @Override
    public void setDisplayName(String dname) {
    }

    public void setRedirectingNumber(String str) {
    }

    public void setRecorder(PipeRecorder rec) {
        this.recorder = rec;
        if (this.recorder != null) {
            this.recorder.startRecord(this.slave, this.recCodec);
            this.recorder.startRecord(this, this.playCodec);
        }
    }

    @Override
    public int getVideoMode() {
        return this.device.getVideoMode();
    }

    @Override
    public Vector getVideoCapabilities() {
        return this.device.getVideoCapabilities();
    }

    public void setVideoCapabilities(Vector caps) {
        this.device.setVideoCapabilities(caps);
    }

    @Override
    public void startReceiver(Object ps, VideoCapability cap, FrameBuffer output) {
        this.device.startReceiver(this, cap, output);
    }

    @Override
    public void startTransmitter(Object ps, VideoCapability cap, FrameBuffer input) {
        this.device.startTransmitter(this, cap, input);
    }

    @Override
    public void stopReceiver(Object ps) {
        this.device.stopReceiver(this);
    }

    @Override
    public void stopTransmitter(Object ps) {
        this.device.stopTransmitter(this);
    }

    @Override
    public double adjustRate(Object ps, int ssrc, int rsrc, double rate) {
        return this.device.adjustRate(this, rate);
    }

    @Override
    public int adjustFormat(Object ps, int ssrc, int rsrc, int seq, int index) {
        return this.device.adjustFormat(this, seq, index);
    }

    @Override
    public void keyFrameRequest(Object ps, int ssrc, int rsrc) {
        this.device.keyFrameRequest();
    }

    @Override
    public void decoderRefreshRequest(Object ps, int ssrc, int rsrc) {
        this.device.decoderRefreshRequest();
    }

    public String toString() {
        return this.name;
    }

    class OutputStream
    extends java.io.OutputStream {
        java.io.OutputStream output;

        OutputStream(java.io.OutputStream o) {
            this.output = o;
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.output.write(b, 0, b.length);
            if (PhoneLine.this.recorder != null) {
                try {
                    PhoneLine.this.recorder.write(PhoneLine.this, b, off, len);
                }
                catch (Exception e) {
                    ResourceStore.toLog(e.toString());
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }
    }

    class InputStream
    extends java.io.InputStream {
        java.io.InputStream input;

        InputStream(java.io.InputStream i) {
            this.input = i;
        }

        @Override
        public int read() throws IOException {
            return this.input.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.input.read(b, off, len);
            if (n > 0 && PhoneLine.this.recorder != null) {
                try {
                    PhoneLine.this.recorder.write(PhoneLine.this.slave, b, off, len);
                }
                catch (Exception e) {
                    ResourceStore.toLog(e.toString());
                }
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }

        @Override
        public int available() throws IOException {
            return this.input.available();
        }
    }
}

