/*
 * Decompiled with CFR 0.152.
 */
package smile.cti.phone.audio;

import com.smile.sound.WavAudioFormat;
import com.smile.sound.WaveParser;
import com.smile.sound.wavFormatHeader;
import com.smile.telephony.AudioConverter;
import com.smile.telephony.PipeInputStream;
import com.smile.telephony.ToneGenerator;
import com.smile.telephony.codec.ConvertedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import smile.cti.phone.DeviceListener;
import smile.cti.phone.audio.AudioSystem;
import smile.util.ResourceStore;

public class AudioDevice {
    public static final int MAIN_LINE = 0;
    public static final int PAGING_LINE = 1;
    private AudioSystem audio;
    private InputStream in;
    private String sLineName;
    private String tLineName;
    private String pLineName;
    private boolean released;
    private boolean playing;
    private boolean playbreak;
    private float ringLevel;
    private float playLevel;
    private boolean agcPlayback;
    private boolean agcRecord;
    private boolean aecEnabled;
    private boolean capturing;

    public AudioDevice(AudioSystem audio) {
        this.audio = audio;
        Enumeration<String> lines = audio.getCaptureLines();
        if (lines.hasMoreElements()) {
            this.tLineName = lines.nextElement();
        }
        if ((lines = audio.getPlaybackLines()).hasMoreElements()) {
            this.sLineName = lines.nextElement();
        }
        this.pLineName = this.sLineName;
        this.ringLevel = audio instanceof smile.cti.phone.audio.impl.AudioDevice ? 1.0f : -1.0f;
        ResourceStore.toLog(this + " sLineName=" + this.sLineName + " tLineName=" + this.tLineName);
    }

    public void resetLines() throws Exception {
        this.audio.closeCaptureLine();
        this.setTargetLine(this.tLineName);
        this.audio.closePlaybackLine();
        this.setSourceLine(this.sLineName);
    }

    public void closeLines() {
        this.audio.closeCaptureLine();
        this.audio.closePlaybackLine();
    }

    public Enumeration getSourceLines() {
        return this.audio.getPlaybackLines();
    }

    public Enumeration getTargetLines() {
        return this.audio.getCaptureLines();
    }

    public String getSourceLineName() {
        return this.sLineName;
    }

    public String getTargetLineName() {
        return this.tLineName;
    }

    public String getPagingLineName() {
        return this.pLineName;
    }

    public void setSourceLine(String linename) throws Exception {
        this.audio.openPlaybackLine(linename);
        this.sLineName = linename;
    }

    public void setTargetLine(String linename) throws Exception {
        this.audio.openCaptureLine(linename);
        this.tLineName = linename;
    }

    public void setPagingLine(String name) throws Exception {
        this.pLineName = name;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setInputStream(InputStream stream) {
        this.in = stream;
        if (this.playing) {
            this.released = true;
        }
        if (stream != null) {
            try {
                this.audio.openPlaybackLine(this.sLineName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.audio.startPlayback(stream);
        } else {
            this.audio.stopPlayback();
        }
    }

    public void setOutputStream(OutputStream stream) {
        if (stream != null) {
            this.audio.startCapture(stream);
            this.capturing = true;
        } else {
            this.audio.stopCapture();
            this.capturing = false;
        }
    }

    public void setPlaybackLevel(float level) {
        this.audio.setPlaybackLevel(level);
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.contains("windows")) {
            this.playLevel = level;
        }
    }

    public float getPlaybackLevel() {
        return this.audio.getPlaybackLevel();
    }

    public void setRecordLevel(float level) {
        this.audio.setCaptureLevel(level);
    }

    public float getRecordLevel() {
        return this.audio.getCaptureLevel();
    }

    public void setMute(boolean state) {
        this.audio.setMute(state);
    }

    public boolean getMute() {
        return this.audio.getMute();
    }

    public void release() {
        this.released = true;
    }

    private InputStream getAudioFileInputStream(File file) throws Exception {
        InputStream voicedata = file.exists() ? new FileInputStream(file) : this.getClass().getClassLoader().getResourceAsStream("sounds/" + file.getName());
        wavFormatHeader hdr = new wavFormatHeader();
        voicedata = new WaveParser().parseWavHeader(voicedata, hdr);
        WavAudioFormat codec = hdr.getAudioFormat();
        if (codec.equals(WavAudioFormat.PCM_LINEAR16)) {
            return voicedata;
        }
        AudioConverter acv = new AudioConverter();
        WavAudioFormat[] wav_formats = new WavAudioFormat[]{WavAudioFormat.PCM_LINEAR16};
        ConvertedInputStream cin = acv.getInputStream(voicedata, codec, wav_formats);
        if (cin == null) {
            voicedata.close();
            throw new Exception("Unsupported media format");
        }
        return cin;
    }

    public boolean playFile(File file, int fromSecond, int maxtime, String lineName) throws Exception {
        InputStream voicedata = this.getAudioFileInputStream(file);
        if (fromSecond > 0) {
            try {
                voicedata.skip(fromSecond * 16000);
            }
            catch (Exception e) {
                voicedata.close();
                throw e;
            }
        }
        int lineType = this.sLineName.equals(lineName) ? 0 : 1;
        int result = this.play(lineType, voicedata, maxtime);
        return result == 512 || result == 32;
    }

    public void stopPlay() {
        this.released = true;
    }

    public int playSourceLine(String filename, int maxtime) {
        return this.play(0, filename, maxtime);
    }

    public int playPagingLine(String filename, int maxtime) {
        return this.play(1, filename, maxtime);
    }

    public int play(int lineType, String filename, int maxtime) {
        return this.play(lineType, new File(filename), maxtime, 0);
    }

    public int play(int lineType, File file, int maxtime, int fromSecond) {
        int result = -1;
        InputStream voicedata = null;
        try {
            voicedata = this.getAudioFileInputStream(file);
            if (fromSecond > 0) {
                voicedata.skip(fromSecond * 16000);
            }
            result = this.play(lineType, voicedata, maxtime);
        }
        catch (Exception e) {
            ResourceStore.toLog("play line=" + lineType + " file=" + file + " maxtime=" + maxtime + " error: " + e);
        }
        try {
            voicedata.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private int play(int lineType, InputStream stream, int maxtime) throws Exception {
        ResourceStore.toLog("play line=" + lineType + " stream=" + stream + " maxtime=" + maxtime);
        return this.play(stream, maxtime, lineType == 0 || this.sLineName.equals(this.pLineName));
    }

    private int play(InputStream stream, int maxtime, boolean mainline) throws Exception {
        return this.play(stream, maxtime, mainline, this.ringLevel);
    }

    private int play(InputStream stream, int maxtime, boolean mainline, float level) throws Exception {
        ResourceStore.toLog("play mainline=" + mainline + " playing=" + this.playing + " sLineName=" + this.sLineName + " pLineName=" + this.pLineName + " ringLevel=" + this.ringLevel);
        try {
            this.audio.openPlaybackLine(mainline ? this.sLineName : this.pLineName);
        }
        catch (Exception e) {
            ResourceStore.toLog("openPlaybackLine error - " + e);
        }
        if (level != -1.0f) {
            this.audio.setPlaybackLevel(level);
        }
        int result = this.play(stream, maxtime);
        if (level != -1.0f) {
            this.audio.setPlaybackLevel(this.playLevel > 0.0f ? this.playLevel : 1.0f / level);
        }
        return result;
    }

    public int playFile(String filename, int lineType, int maxtime) {
        int result = -1;
        InputStream stream = null;
        boolean mainline = lineType == 0;
        float level = mainline ? -1.0f : this.ringLevel;
        try {
            stream = this.getAudioFileInputStream(new File(filename));
            result = this.play(stream, maxtime, mainline, level);
        }
        catch (Exception e) {
            ResourceStore.error("playFile", e);
        }
        try {
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public int play(InputStream stream, int maxtime) {
        if (this.playing) {
            this.playbreak = true;
            try {
                Thread.sleep(30L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.playing = true;
        this.released = false;
        long timeout = maxtime * 1000;
        if (timeout <= 0L) {
            try {
                timeout = stream.available() / 8;
            }
            catch (Exception e) {
                timeout = 10000L;
            }
        }
        long end = System.currentTimeMillis() + timeout;
        ResourceStore.toLog("play line start: timeout=" + timeout + " in=" + this.in);
        this.audio.startPlayback(stream);
        try {
            do {
                Thread.sleep(10L);
            } while (!this.playbreak && !this.released && System.currentTimeMillis() < end && stream.available() > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int result = this.released || this.playbreak ? 256 : (System.currentTimeMillis() >= end ? 32 : 512);
        ResourceStore.toLog("play line end: result=" + result + " playbreak=" + this.playbreak + " released=" + this.released + " in=" + this.in);
        if (this.playbreak) {
            this.playbreak = false;
        } else {
            this.playing = false;
            if (this.in == null) {
                if (this.released) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.in == null) {
                    this.audio.stopPlayback();
                }
            } else if (this.in instanceof PipeInputStream) {
                this.audio.startPlayback(this.in);
            }
        }
        return result;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public int playTone(String tone, int lineType) {
        try {
            if (tone != null || this.in != null) {
                return this.play(new ByteArrayInputStream(ToneGenerator.get(tone)), -1, lineType == 0);
            }
            this.audio.startPlayback(null);
            Thread.sleep(15L);
            this.audio.stopPlayback();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public boolean startSourceLine() {
        return true;
    }

    public void stopSourceLine() {
    }

    public void writeToLine(byte[] data) {
    }

    public void stopOperation() {
        if (!(this.in instanceof PipeInputStream)) {
            this.audio.stopPlayback();
            this.released = true;
        }
    }

    public void setAGCRecord(boolean mode) {
        this.audio.setCaptureAGC(mode);
        this.agcRecord = mode;
    }

    public void setAGCPlayback(boolean mode) {
        this.audio.setPlaybackAGC(mode);
        this.agcPlayback = mode;
    }

    public void setAEC(int value) {
        this.audio.setAEC(value);
        this.aecEnabled = value != -1;
    }

    public boolean getAEC() {
        return this.aecEnabled;
    }

    public boolean getAGCPlayback() {
        return this.agcPlayback;
    }

    public boolean getAGCRecord() {
        return this.agcRecord;
    }

    public void setCaptureTest(boolean mode) {
        if (this.capturing) {
            return;
        }
        if (mode) {
            this.audio.startCapture(new ByteArrayOutputStream());
        } else {
            this.audio.stopCapture();
        }
    }

    public float getRingLevel() {
        return this.ringLevel;
    }

    public void setRingLevel(float level) {
        this.ringLevel = level;
    }

    public int getPlaybackStreamLevel() {
        return this.audio.getPlaybackStreamLevel();
    }

    public int getCaptureStreamLevel() {
        return this.audio.getCaptureStreamLevel();
    }

    public void setVAD(boolean mode) {
        this.audio.setVAD(mode);
    }

    public void setState(boolean b) {
        this.audio.setState(b);
    }

    public void setDeviceListener(DeviceListener listener) {
        this.audio.setDeviceListener(listener);
    }
}

