/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.HashMap;

public class CountryCodes {
    private static HashMap codes;
    private static HashMap prefixes;
    private static int format;

    public static String getCode(String countryCode) {
        return (String)codes.get(countryCode);
    }

    public static String getIntPrefix(String countryCode) {
        String prefix = (String)prefixes.get(countryCode);
        if (prefix == null) {
            prefix = "00";
        }
        return prefix;
    }

    public static String getE164(String number, String countryCode) {
        if (countryCode == null || ((String)number).length() < 9) {
            return number;
        }
        if (((String)number).startsWith("+")) {
            return number;
        }
        if (((String)number).length() > 11) {
            String prefix = CountryCodes.getIntPrefix(countryCode);
            if (((String)number).startsWith(prefix)) {
                number = ((String)number).substring(prefix.length());
            }
            return number;
        }
        String code = CountryCodes.getCode(countryCode);
        if (code == null) {
            return number;
        }
        if (((String)number).charAt(0) == '0') {
            number = code + ((String)number).substring(1);
        } else if (((String)number).length() < 11 && !((String)number).startsWith(code)) {
            number = code + (String)number;
        }
        return number;
    }

    public static String formatToString(String number, String countryCode) {
        String prefix;
        if (number.length() < 9) {
            return number;
        }
        char ch = number.charAt(0);
        if (ch == '+') {
            number = number.substring(1);
        } else if (!Character.isDigit(ch)) {
            return number;
        }
        Object s = number;
        Object p = "";
        int d = 0;
        if (number.length() > 11 && number.startsWith(prefix = CountryCodes.getIntPrefix(countryCode))) {
            number = number.substring(prefix.length());
        }
        if (number.length() > 10) {
            String cc;
            if (number.length() < 14) {
                p = "+";
            }
            if ((cc = CountryCodes.getCode(countryCode)) != null && number.startsWith(cc)) {
                d = cc.length();
            } else {
                for (String c : codes.values()) {
                    if (!number.startsWith(c) || c.length() <= d) continue;
                    d = c.length();
                }
                if (d == 0) {
                    d = 2;
                }
            }
            p = (String)p + number.substring(0, d);
            s = number.substring(d);
        }
        if ((d = ((String)s).length() - 7) <= 0) {
            Object s2 = ((String)s).substring(3);
            if (format == 1 && ((String)s2).length() > 3) {
                s2 = ((String)s2).substring(0, 2) + " " + ((String)s2).substring(2);
            }
            s = ((String)s).substring(0, 3) + " " + (String)s2;
        } else {
            if (d > 3) {
                d = 3;
            }
            Object s1 = ((String)s).substring(0, d);
            if (format == 1) {
                s1 = "(" + (String)s1 + ")";
            }
            Object s2 = ((String)s).substring(d + 3);
            if (format == 1 && ((String)s2).length() > 3) {
                s2 = ((String)s2).substring(0, 2) + " " + ((String)s2).substring(2);
            }
            s = (String)s1 + " " + ((String)s).substring(d, d + 3) + " " + (String)s2;
        }
        if (((String)p).length() > 0) {
            s = (String)p + " " + (String)s;
        }
        return s;
    }

    static {
        format = 0;
        prefixes = new HashMap();
        prefixes.put("US", "011");
        prefixes.put("CA", "011");
        prefixes.put("AS", "011");
        prefixes.put("AI", "011");
        prefixes.put("AG", "011");
        prefixes.put("BS", "011");
        prefixes.put("BB", "011");
        prefixes.put("BM", "011");
        prefixes.put("KY", "011");
        prefixes.put("DM", "011");
        prefixes.put("DO", "011");
        prefixes.put("GD", "011");
        prefixes.put("GU", "011");
        prefixes.put("JM", "011");
        prefixes.put("FM", "011");
        prefixes.put("MS", "011");
        prefixes.put("MP", "011");
        prefixes.put("PR", "011");
        prefixes.put("KN", "011");
        prefixes.put("LC", "011");
        prefixes.put("VC", "011");
        prefixes.put("TT", "011");
        prefixes.put("TC", "011");
        prefixes.put("VG", "011");
        prefixes.put("VI", "011");
        prefixes.put("SG", "001");
        prefixes.put("TH", "001");
        prefixes.put("MN", "001");
        prefixes.put("HK", "001");
        prefixes.put("KR", "001");
        prefixes.put("JP", "010");
        prefixes.put("TW", "002");
        prefixes.put("PY", "002");
        prefixes.put("GL", "009");
        prefixes.put("NG", "009");
        prefixes.put("CU", "119");
        prefixes.put("CO", "005");
        prefixes.put("BO", "0010");
        prefixes.put("BR", "0014");
        prefixes.put("AU", "0011");
        prefixes.put("CX", "0011");
        prefixes.put("CC", "0011");
        prefixes.put("MU", "020");
        prefixes.put("PG", "05");
        prefixes.put("ZA", "09");
        prefixes.put("WF", "19");
        prefixes.put("ME", "99");
        prefixes.put("BY", "810");
        prefixes.put("KZ", "810");
        prefixes.put("RU", "810");
        prefixes.put("TJ", "810");
        prefixes.put("TM", "810");
        prefixes.put("UZ", "810");
        codes = new HashMap();
        codes.put("US", "1");
        codes.put("CA", "1");
        codes.put("BS", "1242");
        codes.put("BB", "1246");
        codes.put("AI", "1264");
        codes.put("AG", "1268");
        codes.put("VG", "1284");
        codes.put("VI", "1340");
        codes.put("KY", "1345");
        codes.put("BM", "1441");
        codes.put("GD", "1473");
        codes.put("TC", "1649");
        codes.put("MS", "1664");
        codes.put("MP", "1670");
        codes.put("GU", "1671");
        codes.put("AS", "1684");
        codes.put("SX", "1721");
        codes.put("LC", "1758");
        codes.put("DM", "1767");
        codes.put("VC", "1784");
        codes.put("PR", "1787");
        codes.put("DO", "1809");
        codes.put("TT", "1868");
        codes.put("KN", "1869");
        codes.put("JM", "1876");
        codes.put("EG", "20");
        codes.put("SS", "211");
        codes.put("EH", "212");
        codes.put("MA", "212");
        codes.put("DZ", "213");
        codes.put("TN", "216");
        codes.put("LY", "218");
        codes.put("GM", "220");
        codes.put("SN", "221");
        codes.put("MR", "222");
        codes.put("ML", "223");
        codes.put("GN", "224");
        codes.put("CI", "225");
        codes.put("BF", "226");
        codes.put("NE", "227");
        codes.put("TG", "228");
        codes.put("BJ", "229");
        codes.put("MU", "230");
        codes.put("LR", "231");
        codes.put("SL", "232");
        codes.put("GH", "233");
        codes.put("NG", "234");
        codes.put("TD", "235");
        codes.put("CF", "236");
        codes.put("CM", "237");
        codes.put("CV", "238");
        codes.put("ST", "239");
        codes.put("GQ", "240");
        codes.put("GA", "241");
        codes.put("CG", "242");
        codes.put("CD", "243");
        codes.put("AO", "244");
        codes.put("GW", "245");
        codes.put("IO", "246");
        codes.put("SC", "248");
        codes.put("SD", "249");
        codes.put("RW", "250");
        codes.put("SO", "252");
        codes.put("DJ", "253");
        codes.put("KE", "254");
        codes.put("TZ", "255");
        codes.put("UG", "256");
        codes.put("BI", "257");
        codes.put("MZ", "258");
        codes.put("ZM", "260");
        codes.put("MG", "261");
        codes.put("YT", "262");
        codes.put("RE", "262");
        codes.put("ZW", "263");
        codes.put("NA", "264");
        codes.put("MW", "265");
        codes.put("LS", "266");
        codes.put("BW", "267");
        codes.put("SZ", "268");
        codes.put("KM", "269");
        codes.put("ZA", "27");
        codes.put("SH", "290");
        codes.put("ER", "291");
        codes.put("AW", "297");
        codes.put("FO", "298");
        codes.put("GL", "299");
        codes.put("GR", "30");
        codes.put("NL", "31");
        codes.put("BE", "32");
        codes.put("FR", "33");
        codes.put("ES", "34");
        codes.put("GI", "350");
        codes.put("PT", "351");
        codes.put("LU", "352");
        codes.put("IE", "353");
        codes.put("IS", "354");
        codes.put("AL", "355");
        codes.put("MT", "356");
        codes.put("CY", "357");
        codes.put("FI", "358");
        codes.put("AX", "358");
        codes.put("BG", "359");
        codes.put("HU", "36");
        codes.put("LT", "370");
        codes.put("LV", "371");
        codes.put("EE", "372");
        codes.put("MD", "373");
        codes.put("AM", "374");
        codes.put("ON", "374");
        codes.put("BY", "375");
        codes.put("AD", "376");
        codes.put("MC", "377");
        codes.put("SM", "378");
        codes.put("VA", "379");
        codes.put("UA", "380");
        codes.put("RS", "381");
        codes.put("ME", "382");
        codes.put("XK", "383");
        codes.put("HR", "385");
        codes.put("SI", "386");
        codes.put("BA", "387");
        codes.put("EU", "388");
        codes.put("MK", "389");
        codes.put("IT", "39");
        codes.put("RO", "40");
        codes.put("CH", "41");
        codes.put("CZ", "420");
        codes.put("SK", "421");
        codes.put("LI", "423");
        codes.put("AT", "43");
        codes.put("UK", "44");
        codes.put("GB", "44");
        codes.put("GG", "441481");
        codes.put("JE", "441534");
        codes.put("IM", "441624");
        codes.put("DK", "45");
        codes.put("SE", "46");
        codes.put("NO", "47");
        codes.put("SJ", "47");
        codes.put("PL", "48");
        codes.put("DE", "49");
        codes.put("FK", "500");
        codes.put("BZ", "501");
        codes.put("GT", "502");
        codes.put("SV", "503");
        codes.put("HN", "504");
        codes.put("NI", "505");
        codes.put("CR", "506");
        codes.put("PA", "507");
        codes.put("PM", "508");
        codes.put("HT", "509");
        codes.put("PE", "51");
        codes.put("MX", "52");
        codes.put("CU", "53");
        codes.put("AR", "54");
        codes.put("BR", "55");
        codes.put("CL", "56");
        codes.put("CO", "57");
        codes.put("VE", "58");
        codes.put("BL", "590");
        codes.put("MF", "590");
        codes.put("BO", "591");
        codes.put("GY", "592");
        codes.put("EC", "593");
        codes.put("PY", "595");
        codes.put("SR", "597");
        codes.put("UY", "598");
        codes.put("CW", "599");
        codes.put("AN", "599");
        codes.put("MY", "60");
        codes.put("AU", "61");
        codes.put("CX", "61");
        codes.put("CC", "61");
        codes.put("ID", "62");
        codes.put("PH", "63");
        codes.put("NZ", "64");
        codes.put("PN", "64");
        codes.put("SG", "65");
        codes.put("TH", "66");
        codes.put("TL", "670");
        codes.put("AQ", "672");
        codes.put("BN", "673");
        codes.put("NR", "674");
        codes.put("PG", "675");
        codes.put("TO", "676");
        codes.put("SB", "677");
        codes.put("VU", "678");
        codes.put("FJ", "679");
        codes.put("PW", "680");
        codes.put("WF", "681");
        codes.put("CK", "682");
        codes.put("NU", "683");
        codes.put("WS", "685");
        codes.put("KI", "686");
        codes.put("NC", "687");
        codes.put("TV", "688");
        codes.put("PF", "689");
        codes.put("TK", "690");
        codes.put("FM", "691");
        codes.put("MH", "692");
        codes.put("RU", "7");
        codes.put("KZ", "7");
        codes.put("JP", "81");
        codes.put("KR", "82");
        codes.put("VN", "84");
        codes.put("KP", "850");
        codes.put("HK", "852");
        codes.put("MO", "853");
        codes.put("KH", "855");
        codes.put("LA", "856");
        codes.put("CN", "86");
        codes.put("BD", "880");
        codes.put("TW", "886");
        codes.put("TR", "90");
        codes.put("IN", "91");
        codes.put("PK", "92");
        codes.put("AF", "93");
        codes.put("LK", "94");
        codes.put("MM", "95");
        codes.put("MV", "960");
        codes.put("LB", "961");
        codes.put("JO", "962");
        codes.put("SY", "963");
        codes.put("IQ", "964");
        codes.put("KW", "965");
        codes.put("SA", "966");
        codes.put("YE", "967");
        codes.put("OM", "968");
        codes.put("PS", "970");
        codes.put("AE", "971");
        codes.put("IL", "972");
        codes.put("BH", "973");
        codes.put("QA", "974");
        codes.put("BT", "975");
        codes.put("MN", "976");
        codes.put("NP", "977");
        codes.put("IR", "98");
        codes.put("TJ", "992");
        codes.put("TM", "993");
        codes.put("AZ", "994");
        codes.put("GE", "995");
        codes.put("KG", "996");
        codes.put("UZ", "998");
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.indexOf("ios") != -1) {
            format = 1;
        }
    }
}

