/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import smile.cti.client.ServiceManager;
import smile.util.ResourceStore;

public class MyLogger
implements Runnable {
    private static MyLogger myLogger;
    private String mVersion = "";
    private ExecutorService executorService;
    private final BlockingQueue<String> queueOfLogMessages = new ArrayBlockingQueue<String>(20000);
    private boolean down = false;
    private ServiceManager serviceManager;

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    private MyLogger() {
    }

    public MyLogger setVersionName(String mVersion) {
        this.mVersion = mVersion;
        return myLogger;
    }

    public void startLogger() {
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.execute(this);
    }

    public static synchronized MyLogger getInstance() {
        if (myLogger == null) {
            myLogger = new MyLogger();
        }
        return myLogger;
    }

    public void toLog(String tag, String message) {
        this.addMessage(tag + " " + this.mVersion + ": " + message + "\r\n");
    }

    public void toLog(String message) {
        this.addMessage(message + "\r\n");
    }

    private void addMessage(String message) {
        try {
            String str = ResourceStore.sdf.format(new Date()) + "\t" + message;
            this.queueOfLogMessages.add(str);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void shutdown() {
        this.down = true;
    }

    public void stopMyLogger() {
        if (myLogger != null) {
            this.shutdown();
            myLogger = null;
        }
    }

    @Override
    public void run() {
        while (!this.down) {
            String message;
            if (!this.queueOfLogMessages.isEmpty() && (message = (String)this.queueOfLogMessages.poll()) != null) {
                this.sendToLog(message);
                if (this.serviceManager != null) {
                    this.serviceManager.sendLogFile();
                }
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.queueOfLogMessages.clear();
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToLog(String text) {
        try {
            File file = ResourceStore.LOG_FILE;
            synchronized (file) {
                FileOutputStream fos = new FileOutputStream(ResourceStore.LOG_FILE, true);
                fos.write(text.getBytes());
                fos.close();
            }
        }
        catch (Exception e) {
            System.out.println(text + " - " + e.getMessage());
        }
        System.out.println(text);
    }
}

