/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Timer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.smile.Utility;
import smile.util.Base64;
import smile.util.CountryCodes;
import smile.util.ResourceStore;

public class Utils {
    private static Random rnd = new Random(System.currentTimeMillis());
    private static SecureRandom srandom = new SecureRandom();
    private static Timer timer = new Timer();
    private static Pattern pattern = Pattern.compile("<[^>]*>");
    private static final char[] DCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static DateFormat rfc1121 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.UK);

    public static Timer getTimer() {
        return timer;
    }

    public static String generateString(int length) {
        int i = 0;
        byte[] b = new byte[length];
        while (i < length) {
            long number = rnd.nextLong();
            int n = Math.min(8, length - i);
            int j = 0;
            while (j < n) {
                b[i] = (byte)(0x7FL & number >> i * 8);
                if (b[i] < 48) {
                    b[i] = (byte)(b[i] + 48);
                }
                if (b[i] > 57 && b[i] < 65) {
                    b[i] = (byte)(b[i] + 7);
                }
                if (b[i] == 79) {
                    b[i] = 80;
                }
                if (b[i] > 90 && b[i] < 97) {
                    b[i] = (byte)(b[i] + 6);
                }
                if (b[i] > 122) {
                    b[i] = (byte)(b[i] - 5);
                }
                ++j;
                ++i;
            }
        }
        return new String(b);
    }

    public static String generateDigitString(int length) {
        Object s = String.valueOf(rnd.nextLong() & Long.MAX_VALUE);
        while (((String)s).length() < length) {
            s = (String)s + String.valueOf(rnd.nextLong() & Long.MAX_VALUE);
        }
        return ((String)s).substring(0, length);
    }

    public static String generateGUID(long timestamp) {
        return timestamp + "-" + Utils.createGUID(9);
    }

    public static String createGUID(int length) {
        byte[] b = new byte[length];
        rnd.nextBytes(b);
        Object guid = "";
        for (int i = 0; i < length; ++i) {
            Object s = Integer.toHexString(b[i] & 0xFF);
            if (((String)s).length() == 1) {
                s = "0" + (String)s;
            }
            guid = (String)guid + (String)s;
        }
        return guid;
    }

    public static int getIPv4(String str) throws Exception {
        int ip = 0;
        StringTokenizer stz = new StringTokenizer(str, ".");
        for (int i = 3; i >= 0; --i) {
            int n = Integer.parseInt(stz.nextToken());
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException();
            }
            ip += n << i * 8;
        }
        return ip;
    }

    public static boolean isValidIPv4Subnet(int ip) {
        boolean zero = true;
        for (int i = 0; i < 32; ++i) {
            if ((ip >> i & 1) == 0) {
                if (zero) continue;
                return false;
            }
            zero = false;
        }
        return true;
    }

    public static boolean checkIPv4List(String address, Hashtable list) {
        if (list.containsKey(address)) {
            return true;
        }
        try {
            int addr = Utils.getIPv4(address);
            Enumeration en = list.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                if (!(key instanceof Integer)) continue;
                Object val = list.get(key);
                int ip = (Integer)key;
                int sm = (Integer)val;
                if ((addr & sm) != ip) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isHostLocalAddress(String addr) {
        return addr.startsWith("10.") || addr.startsWith("192.168.") || addr.startsWith("172.16.");
    }

    public static String[] getParametersArray(String prms) {
        StringTokenizer stz;
        Vector<String> v = new Vector<String>();
        String str = prms;
        int n = str.indexOf(34);
        while (n != -1) {
            if (n > 0 && str.charAt(n - 1) != ' ') {
                n = str.indexOf(34, n + 1);
                continue;
            }
            stz = new StringTokenizer(str.substring(0, n), " ");
            while (stz.hasMoreTokens()) {
                v.addElement(stz.nextToken());
            }
            if ((n = (str = str.substring(n)).indexOf(34, 1)) == -1) break;
            v.addElement(str.substring(1, n));
            str = str.substring(n + 1);
            n = str.indexOf(34);
        }
        stz = new StringTokenizer(str, " ");
        while (stz.hasMoreTokens()) {
            v.addElement(stz.nextToken());
        }
        Object[] array = new String[v.size()];
        v.copyInto(array);
        return array;
    }

    public static byte[] generateCryptoKey(int size) {
        byte[] b = new byte[size / 8];
        srandom.nextBytes(b);
        return b;
    }

    public static String generateBase64CryptoKey(int size) {
        return Utils.encodeBase64String(Utils.generateCryptoKey(size));
    }

    public static String encodeBase64String(byte[] b) {
        return Base64.encode(b);
    }

    public static byte[] decodeBase64String(String str) throws Exception {
        return Base64.decode(str);
    }

    public static byte[] decodeBase64Text(String text) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int d = 0;
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '=': {
                    ++d;
                }
                default: {
                    bos.write(c);
                }
            }
        }
        byte[] input = bos.toByteArray();
        byte[] output = new byte[input.length * 3 / 4 - d];
        Base64.decode(input, output);
        return output;
    }

    public static final byte[] decodeQuotedPrintable(String str) throws Exception {
        return Utils.decodeQuotedPrintable(str.getBytes());
    }

    public static final byte[] decodeQuotedPrintable(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 61) {
                int u = Character.digit((char)bytes[++i], 16);
                int l = Character.digit((char)bytes[++i], 16);
                buffer.write((char)((u << 4) + l));
                continue;
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    public static String makePassword(int len) {
        long number = (long)(rnd.nextDouble() * Math.pow(10.0, 16.0));
        byte[] b = new byte[len];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            if (j == 5) {
                j = 0;
                number = (long)(rnd.nextDouble() * Math.pow(10.0, 16.0));
            }
            b[i] = (byte)(0x7FL & number >> j++ * 8);
            if (b[i] < 48) {
                b[i] = (byte)(b[i] + 48);
            }
            if (b[i] > 57 && b[i] < 64) {
                b[i] = (byte)(b[i] + 7);
            }
            if (b[i] == 79) {
                b[i] = 80;
            }
            if (b[i] > 90 && b[i] < 97) {
                b[i] = (byte)(b[i] + 6);
            }
            if (b[i] <= 122) continue;
            b[i] = (byte)(b[i] - 5);
        }
        return new String(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int intRandom() {
        Random random = rnd;
        synchronized (random) {
            return rnd.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int intRandom(int n) {
        Random random = rnd;
        synchronized (random) {
            return rnd.nextInt(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int intRandom(int m, int n) {
        Random random = rnd;
        synchronized (random) {
            return m + rnd.nextInt(n - m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long longRandom() {
        Random random = rnd;
        synchronized (random) {
            return rnd.nextLong();
        }
    }

    public static byte[] bytesRandom(int size) {
        byte[] b = new byte[size];
        rnd.nextBytes(b);
        return b;
    }

    public static String createCallId() {
        return Long.toHexString(System.nanoTime()) + Long.toHexString(Utils.longRandom());
    }

    public static String toHexString(byte[] b) {
        StringBuffer stringbuffer = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            stringbuffer.append(DCHAR[b[i] >>> 4 & 0xF]);
            stringbuffer.append(DCHAR[b[i] & 0xF]);
        }
        return stringbuffer.toString();
    }

    public static String decodeBase64(String s) {
        return new String(Base64.decode(s));
    }

    public static String encodeBase64(String str) {
        return Base64.encode(str.getBytes());
    }

    public static String removeFromTokenizedString(String string, String subj, char token) {
        int n = 0;
        int m = 0;
        do {
            String str;
            String string2 = str = (n = ((String)string).indexOf(token, m)) != -1 ? ((String)string).substring(m, n) : ((String)string).substring(m);
            if (!str.equals(subj)) continue;
            if (m > 0) {
                string = ((String)string).substring(0, m - 1) + (n != -1 ? ((String)string).substring(n) : "");
                break;
            }
            if (n != -1) {
                string = ((String)string).substring(n + 1);
                break;
            }
            string = "";
            break;
        } while (n != -1 && (m = n + 1) < ((String)string).length());
        return string;
    }

    public static Iterator getSortedObjects(Iterator iterator) {
        ArrayList al = new ArrayList();
        while (iterator.hasNext()) {
            al.add(iterator.next());
        }
        Collections.sort(al);
        return al.iterator();
    }

    public static Iterator getSortedObjects(Enumeration objects) {
        ArrayList al = new ArrayList();
        while (objects.hasMoreElements()) {
            al.add(objects.nextElement());
        }
        Collections.sort(al);
        return al.iterator();
    }

    public static boolean copyFile(File source, File targer) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int r;
            fis = new FileInputStream(source);
            fos = new FileOutputStream(targer);
            byte[] b = new byte[4096];
            while ((r = fis.read(b)) != -1) {
                fos.write(b, 0, r);
            }
            fis.close();
            fos.close();
            return true;
        }
        catch (Exception e) {
            ResourceStore.error("copyFile", e);
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static String[] makeCmdArray(String str) {
        StringTokenizer stz;
        Vector<String> v = new Vector<String>();
        int n = str.indexOf(34);
        while (n != -1) {
            if (n > 0 && str.charAt(n - 1) != ' ') {
                n = str.indexOf(34, n + 1);
                continue;
            }
            stz = new StringTokenizer(str.substring(0, n), " ");
            while (stz.hasMoreTokens()) {
                v.addElement(stz.nextToken());
            }
            if ((n = (str = str.substring(n)).indexOf(34, 1)) == -1) break;
            v.addElement(str.substring(1, n));
            str = str.substring(n + 1);
            n = str.indexOf(34);
        }
        stz = new StringTokenizer(str, " ");
        while (stz.hasMoreTokens()) {
            v.addElement(stz.nextToken());
        }
        Object[] array = new String[v.size()];
        v.copyInto(array);
        return array;
    }

    public static Map fromJSONString(String str) throws IOException {
        try {
            return Utility.parseJson(str).getMap();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static SecureRandom getSecureRandom() {
        return srandom;
    }

    public static String getTerminalId() {
        String termid = null;
        String osname = System.getProperty("os.name").toLowerCase();
        try {
            if (osname.indexOf("linux") != -1) {
                termid = Utils.getSerialNumberLinux();
            } else if (osname.indexOf("windows") != -1) {
                termid = Utils.getSerialNumberWindows();
            } else if (osname.indexOf("mac os x") != -1) {
                termid = Utils.getSerialNumberMac();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            ResourceStore.error(osname, t);
        }
        return termid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getSerialNumberWindows() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(new String[]{"wmic", "bios", "get", "serialnumber"});
        OutputStream os = process.getOutputStream();
        InputStream is = process.getInputStream();
        os.close();
        Scanner sc = new Scanner(is);
        String sn = null;
        try {
            while (sc.hasNext()) {
                String next = sc.next();
                if (!"SerialNumber".equals(next)) continue;
                sn = sc.next().trim();
                break;
            }
        }
        finally {
            is.close();
        }
        return sn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getSerialNumberMac() throws Exception {
        String sn = null;
        BufferedReader br = null;
        try {
            br = Utils.getReader("/usr/sbin/system_profiler SPHardwareDataType");
            String marker = "Serial Number";
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.contains(marker)) continue;
                sn = line.split(":")[1].trim();
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return sn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getSerialNumberLinux() throws Exception {
        String line;
        String marker2;
        String sn = null;
        BufferedReader br = null;
        try {
            br = Utils.getReader("dmidecode -t system");
            marker2 = "Serial Number:";
            line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf(marker2) == -1) continue;
                sn = line.split(marker2)[1].trim();
                break;
            }
        }
        catch (IOException marker2) {
        }
        finally {
            try {
                br.close();
            }
            catch (Exception marker2) {}
        }
        if (sn != null) {
            return sn;
        }
        try {
            br = Utils.getReader("lshal");
            marker2 = "system.hardware.serial =";
            line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf(marker2) == -1) continue;
                sn = line.split(marker2)[1].replaceAll("\\(string\\)|(\\')", "").trim();
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        return sn;
    }

    private static BufferedReader getReader(String command) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(command.split(" "));
        OutputStream os = process.getOutputStream();
        InputStream is = process.getInputStream();
        os.close();
        return new BufferedReader(new InputStreamReader(is));
    }

    public static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        Object newstr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            newstr = Character.isLetterOrDigit(c) ? (String)newstr + c : (String)newstr + "%" + Integer.toHexString(c);
        }
        return newstr;
    }

    public static String urlDecode(String str) {
        if (str == null) {
            return null;
        }
        Object newstr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '%') {
                c = (char)Integer.parseInt(str.substring(i + 1, i + 3), 16);
                i += 2;
            }
            newstr = (String)newstr + c;
        }
        return newstr;
    }

    public static String getRFC1121Date(long timestamp) {
        return rfc1121.format(timestamp);
    }

    public static long parseRFC1121Date(String date) throws ParseException {
        return rfc1121.parse(date).getTime();
    }

    public static String decodeRFC2047(String str) throws Exception {
        int n = str.indexOf("=?");
        if (n == -1) {
            return str;
        }
        int k = str.indexOf("?", n + 2);
        if (k == -1) {
            return str;
        }
        String c = str.substring(n + 2, k);
        boolean b = str.charAt(k + 1) == 'B' || str.charAt(k + 1) == 'b';
        int m = str.indexOf("?=", k + 3);
        if (m == -1) {
            return str;
        }
        Object s = str.substring(k + 3, m);
        if (c.equalsIgnoreCase("utf")) {
            c = "utf-8";
        }
        byte[] data = b ? Utils.decodeBase64String((String)s) : Utils.decodeQuotedPrintable((String)s);
        try {
            s = new String(data, c);
        }
        catch (UnsupportedEncodingException e) {
            s = new String(data);
        }
        if (m < str.length() - 2) {
            s = str.substring(0, n) + (String)s + Utils.decodeRFC2047(str.substring(m + 2));
        }
        return s;
    }

    public static String formatDuration(long millis) {
        int sec = (int)(millis / 1000L);
        int h = 0;
        int m = 0;
        if (sec >= 3600) {
            h = sec / 3600;
            sec -= h * 3600;
        }
        if (sec >= 60) {
            m = sec / 60;
            sec -= m * 60;
        }
        return (String)(h > 0 ? h + ":" : "") + (Serializable)(m < 10 ? "0" + m : Integer.valueOf(m)) + ":" + (Serializable)(sec < 10 ? "0" + sec : Integer.valueOf(sec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWindowsAllPermissions(File dir) {
        Utils.setWindowsAllPermissions(dir, System.getProperty("user.name"));
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(new String[]{"net", "user"});
            OutputStream os = process.getOutputStream();
            InputStream is = process.getInputStream();
            os.close();
            Scanner sc = new Scanner(is, "utf8");
            try {
                while (sc.hasNext()) {
                    String next = sc.next();
                    Utils.setWindowsAllPermissions(dir, next);
                }
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File userHome = new File(System.getProperty("user.home"));
        File usersDir = userHome.getParentFile();
        File[] users = usersDir.listFiles();
        for (int j = 0; j < users.length; ++j) {
            Utils.setWindowsAllPermissions(dir, users[j].getName());
        }
    }

    public static void setWindowsAllPermissions(File dir, String user) {
        try {
            UserPrincipal principal = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(user);
            Utils.setWindowsPermissions(dir, principal);
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Utils.setWindowsPermissions(files[i], principal);
            }
            System.err.println(user + " setFilesPermissions " + dir);
            ResourceStore.toLog(user + " setFilesPermissions " + dir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setWindowsPermissions(File file, UserPrincipal principal) throws Exception {
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        AclFileAttributeView aclView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        EnumSet<AclEntryPermission[]> permissions = file.isDirectory() ? EnumSet.of(AclEntryPermission.READ_DATA, new AclEntryPermission[]{AclEntryPermission.WRITE_DATA, AclEntryPermission.DELETE_CHILD, AclEntryPermission.ADD_FILE, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.READ_ACL}) : EnumSet.of(AclEntryPermission.READ_DATA, new AclEntryPermission[]{AclEntryPermission.WRITE_DATA, AclEntryPermission.DELETE, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.READ_ACL, AclEntryPermission.APPEND_DATA, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.WRITE_ACL, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_OWNER});
        AclEntry.Builder builder = AclEntry.newBuilder();
        builder.setPrincipal(principal);
        builder.setType(AclEntryType.ALLOW);
        builder.setPermissions(permissions);
        AclEntry newEntry = builder.build();
        List<AclEntry> aclEntries = aclView.getAcl();
        aclEntries.add(newEntry);
        aclView.setAcl(aclEntries);
    }

    public static String normalizePhoneNumber(String phoneNumber) {
        return Utils.normalizePhoneNumber(phoneNumber, null);
    }

    public static String normalizePhoneNumber(String phoneNumber, String countryCode) {
        if (phoneNumber.length() == 0 || phoneNumber.length() > 30) {
            return "";
        }
        boolean s = false;
        Object number = "";
        for (int i = 0; i < phoneNumber.length(); ++i) {
            char c = phoneNumber.charAt(i);
            if (c > '/' && c < ':' || c == '*' || c == '#' || c == '+' || c == ',') {
                number = (String)number + phoneNumber.charAt(i);
                continue;
            }
            if ((c <= '@' || c >= '[') && (c <= '`' || c >= '{')) continue;
            number = (String)number + phoneNumber.charAt(i);
            s = true;
        }
        if (s || countryCode == null) {
            return number;
        }
        return CountryCodes.getE164((String)number, countryCode);
    }

    public static boolean equalPhoneNumbers(String number1, String number2) {
        int l1 = number1.length();
        int l2 = number2.length();
        if (number1.charAt(0) == '0') {
            number1 = number1.substring(1);
            --l1;
        }
        if (number2.charAt(0) == '0') {
            number2 = number2.substring(1);
            --l2;
        }
        if (l1 == l2) {
            return number1.equals(number2);
        }
        if (l1 < 9 || l2 < 9) {
            return false;
        }
        if (l1 > l2) {
            return number1.substring(l1 - l2).equals(number2);
        }
        return number2.substring(l2 - l1).equals(number1);
    }

    public static String htmlToText(String html) {
        int n = html.indexOf("</head>");
        if (n != -1) {
            html = html.substring(n + 7);
        }
        if ((n = html.indexOf("</body>")) != -1) {
            html = html.substring(0, n);
        }
        html = html.replace("</p>", "\r\n");
        html = html.replace("<br", "\r\n<br");
        Matcher matcher = pattern.matcher(html);
        StringBuffer sb = new StringBuffer(html.length());
        while (matcher.find()) {
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        String txt = sb.toString().trim();
        txt = txt.replace("&nbsp;", " ");
        txt = txt.replaceAll(" +", " ");
        txt = txt.replace("&amp;", "&");
        txt = txt.replace("&lt;", "<");
        txt = txt.replace("&gt;", ">");
        return txt;
    }

    public static Object readObject(File file) throws Exception {
        int readBytes;
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((readBytes = fis.read(buffer)) != -1) {
            bos.write(buffer, 0, readBytes);
        }
        fis.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Object obj = ois.readObject();
        ois.close();
        return obj;
    }

    public static void stackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static long getTotalPhysicalMemorySize() {
        try {
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return os.getTotalPhysicalMemorySize();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long getFreePhysicalMemorySize() {
        try {
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return os.getFreePhysicalMemorySize();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long getCommittedVirtualMemorySize() {
        try {
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return os.getCommittedVirtualMemorySize();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static long getFreeSwapSpaceSize() {
        try {
            OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return os.getFreeSwapSpaceSize();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    static {
        rfc1121.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }
}

