/*
 * Decompiled with CFR 0.152.
 */
package smile.web.client;

import com.smile.net.WebSocket;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.json.smile.JSONException;
import org.json.smile.JSONObject;
import org.json.smile.Utility;
import smile.web.client.WebSocketListener;

public class ClientWebSocket
extends WebSocket {
    private WebSocketListener listener;
    private HashMap rpcs = new HashMap();
    private Random random = new Random();

    public ClientWebSocket(String url, String username, String password, String proxy, WebSocketListener listener) throws Exception {
        super(url, "json.api.smile-soft.com", username, password, proxy);
        this.listener = listener;
    }

    public Object sendCommand(String method, Map params, long timeout) throws Exception {
        RPC rpc = new RPC(method, params, timeout);
        Object result = rpc.call();
        return result;
    }

    public void sendIndication(String method, Map params) throws Exception {
        JSONObject jobj = new JSONObject();
        jobj.put("method", method);
        jobj.put("params", params);
        this.sendTextFrame(jobj.toString().getBytes("UTF-8"));
    }

    @Override
    protected void onTextFrame(byte[] content) {
        String str;
        try {
            str = new String(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            str = new String(content);
        }
        try {
            JSONObject json = Utility.parseJson(str);
            Object id = json.get("id");
            if (id != null) {
                RPC rpc = (RPC)this.rpcs.remove(id);
                Object result = json.get("result");
                if (result != null) {
                    rpc.setResult(result);
                } else {
                    JSONObject error = (JSONObject)json.get("error");
                    rpc.setError(error != null ? error.get("message") : null);
                }
            } else {
                new CommandHandler(json);
            }
        }
        catch (Throwable e) {
            System.out.println(e + ": " + str);
        }
    }

    @Override
    protected void onClose(int code, int cause) {
        for (RPC rpc : this.rpcs.values()) {
            rpc.setError("socket closed");
        }
        this.rpcs.clear();
    }

    class RPC {
        int id = -1;
        private String message;
        private Object result;
        private boolean error;
        private long timeout;

        public RPC(String method, Map params, long timeout) throws Exception {
            JSONObject jobj = new JSONObject();
            jobj.put("method", method);
            jobj.put("params", params);
            this.id = ClientWebSocket.this.random.nextInt();
            jobj.put("id", this.id);
            this.message = jobj.toString();
            this.timeout = timeout;
        }

        public synchronized void setResult(Object result) {
            this.result = result;
            this.notify();
        }

        public synchronized void setError(Object result) {
            this.result = result;
            this.error = true;
            this.notify();
        }

        public synchronized Object call() throws Exception {
            ClientWebSocket.this.sendTextFrame(this.message.getBytes("UTF-8"));
            ClientWebSocket.this.rpcs.put(this.id, this);
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ClientWebSocket.this.rpcs.remove(this.id);
            if (this.error) {
                throw new Exception(this.result.toString());
            }
            return this.result;
        }
    }

    class CommandHandler
    implements Runnable {
        String method;
        Map parameters;

        public CommandHandler(JSONObject json) throws JSONException {
            this.method = (String)json.get("method");
            JSONObject jobj = (JSONObject)json.get("params");
            this.parameters = jobj.getMap();
            new Thread(this).start();
        }

        @Override
        public void run() {
            ClientWebSocket.this.listener.processCommand(this.method, this.parameters);
        }
    }
}

