/*
 * Decompiled with CFR 0.152.
 */
package smile.web.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import smile.util.MimeTypes;
import smile.util.Utils;
import smile.web.client.SocketChannel;
import smile.web.client.Tracker;

public class HttpRequest {
    private SocketChannel channel;
    private boolean ssl;
    private String host;
    private String proxy;
    private String username;
    private String password;
    private String encodedURI;
    private Vector requestHeaders = new Vector();
    private Map responseHeaders;
    private boolean closed;
    public static int MAX_REDIRECTS = 20;
    public static int IO_BUFFER_SIZE = 1024;
    public static DateFormat TIME_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);

    public HttpRequest(String url) throws Exception {
        this(url, null);
    }

    public HttpRequest(String url, String proxy) throws Exception {
        this.proxy = proxy;
        this.parseURL(url);
    }

    private void parseURL(String url) throws Exception {
        String uri = url;
        int k = uri.indexOf("://");
        if (k != -1) {
            String protocol = uri.substring(0, k);
            this.ssl = protocol.equalsIgnoreCase("https") || protocol.equalsIgnoreCase("wss");
            uri = uri.substring(k + 3);
        }
        this.host = uri;
        k = uri.indexOf("/");
        if (k != -1) {
            this.host = uri.substring(0, k);
            uri = uri.substring(k);
        } else {
            uri = "/";
        }
        this.setResourceUri(uri);
    }

    public void setResourceUri(String uri) {
        this.encodedURI = "/";
        if (uri.length() > 1) {
            int n = uri.indexOf(63);
            if (n == -1) {
                n = uri.length();
            }
            for (int k = 1; k < n; ++k) {
                char c = uri.charAt(k);
                this.encodedURI = c == '/' || Character.isLetterOrDigit(c) ? this.encodedURI + c : this.encodedURI + "%" + Integer.toHexString(c);
            }
            if (n < uri.length()) {
                this.encodedURI = this.encodedURI + uri.substring(n);
            }
        }
        if (this.proxy != null && this.proxy.length() > 0) {
            this.encodedURI = (this.ssl ? "https" : "http") + "://" + this.host + this.encodedURI;
        }
        this.requestHeaders.clear();
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setChannel(SocketChannel channel) {
        this.channel = channel;
    }

    public SocketChannel getChannel() {
        return this.closed ? null : this.channel;
    }

    public String getHost() {
        return this.host;
    }

    public String getProxy() {
        return this.proxy;
    }

    public boolean useSSL() {
        return this.ssl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public void setHeader(String name, String value) {
        this.requestHeaders.add(name + ": " + value + "\r\n");
    }

    public String getResponseHeader(String name) {
        return (String)this.responseHeaders.get(name);
    }

    public Map getResponseHeaders() {
        return this.responseHeaders;
    }

    public OutputStream getOutputStream() {
        return this.channel.getOutputStream();
    }

    public InputStream getInputStream() {
        return this.channel.getInputStream();
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    public void connect() throws Exception {
        if (!this.isConnected()) {
            this.channel = new SocketChannel(this);
        }
    }

    public int get(File file) throws Exception {
        return this.get(file, null);
    }

    public int get(File file, Tracker tracker) throws Exception {
        return this.get(file, tracker, null);
    }

    public int get(File file, Tracker tracker, Cipher cipher) throws Exception {
        int status;
        if (file.exists() && file.length() > 0L) {
            this.setHeader("If-Modified-Since", TIME_FORMAT.format(file.lastModified()));
        }
        if ((status = this.get()) == 200) {
            String ch;
            long length;
            if (file.exists()) {
                file.delete();
            }
            OutputStream fos = new FileOutputStream(file);
            if (cipher != null) {
                fos = new CipherOutputStream(fos, cipher);
            }
            long l = length = (ch = (String)this.responseHeaders.get("Content-Length")) != null ? Long.parseLong(ch) : Long.MAX_VALUE;
            if (ch != null && tracker != null) {
                tracker.setFileLength(length);
            }
            try {
                int len;
                int readBytes;
                byte[] buffer = new byte[IO_BUFFER_SIZE];
                while ((readBytes = this.channel.read(buffer, 0, len = (int)Math.min(length, (long)IO_BUFFER_SIZE))) != -1) {
                    fos.write(buffer, 0, readBytes);
                    length -= (long)readBytes;
                    if (tracker != null) {
                        tracker.onload(readBytes);
                    }
                    if (length > 0L) continue;
                }
                fos.close();
            }
            catch (Exception e) {
                fos.close();
                throw e;
            }
        }
        return status;
    }

    public int get() throws Exception {
        int status = 0;
        for (int i = 0; i < MAX_REDIRECTS; ++i) {
            String location;
            this.connect();
            status = this.doGet();
            if (status != 301 && status != 302 && status != 303 && status != 305 && status != 307 || (location = (String)this.responseHeaders.get("Location")) == null) break;
            this.close();
            if (status == 305) {
                this.proxy = location;
                continue;
            }
            this.proxy = null;
            this.parseURL(location);
        }
        return status;
    }

    private int doGet() throws Exception {
        String method = "GET";
        String requestLine = method + " " + this.encodedURI + " HTTP/1.1\r\n";
        byte[] b1 = requestLine.getBytes("UTF-8");
        String headerLines = "Host: " + this.host + "\r\n";
        for (int i = 0; i < this.requestHeaders.size(); ++i) {
            headerLines = headerLines + (String)this.requestHeaders.get(i);
        }
        byte[] b2 = headerLines.getBytes();
        this.channel.write(b1);
        this.channel.write(b2);
        if (this.username != null && this.password != null) {
            this.channel.write(("Authorization: Basic " + Utils.encodeBase64(this.username + ":" + this.password) + "\r\n").getBytes("UTF-8"));
        }
        this.channel.write("\r\n".getBytes());
        int status = this.getResponse();
        if (status != 401) {
            return status;
        }
        this.connect();
        String auth = this.getResponseHeader("WWW-Authenticate");
        auth = this.makeAuthorizationHeader(method, this.encodedURI, auth);
        this.channel.write(b1);
        this.channel.write(b2);
        this.channel.write((auth + "\r\n").getBytes("UTF-8"));
        return this.getResponse();
    }

    public int post(String data) throws Exception {
        this.connect();
        String method = "POST";
        String requestLine = method + " " + this.encodedURI + " HTTP/1.1\r\n";
        byte[] b1 = requestLine.getBytes("UTF-8");
        byte[] b3 = data.getBytes("UTF-8");
        String headerLines = "Host: " + this.host + "\r\n";
        for (int i = 0; i < this.requestHeaders.size(); ++i) {
            headerLines = headerLines + (String)this.requestHeaders.get(i);
        }
        headerLines = headerLines + "Content-Length: " + b3.length + "\r\n";
        byte[] b2 = headerLines.getBytes();
        this.channel.write(b1);
        this.channel.write(b2);
        if (this.username != null && this.password != null) {
            this.channel.write(("Authorization: Basic " + Utils.encodeBase64(this.username + ":" + this.password) + "\r\n").getBytes("UTF-8"));
        }
        this.channel.write("\r\n".getBytes());
        this.channel.write(b3);
        this.channel.write("\r\n".getBytes());
        int status = this.getResponse();
        if (status != 401) {
            return status;
        }
        this.connect();
        String auth = this.getResponseHeader("WWW-Authenticate");
        auth = this.makeAuthorizationHeader(method, this.encodedURI, auth);
        this.channel.write(b1);
        this.channel.write(b2);
        this.channel.write((auth + "\r\n").getBytes("UTF-8"));
        this.channel.write(b3);
        this.channel.write("\r\n".getBytes());
        return this.getResponse();
    }

    public int postFile(Map params) throws Exception {
        byte[] b;
        String boundary = "----" + Utils.generateString(20);
        ArrayList<byte[]> plist = new ArrayList<byte[]>();
        HashMap<File, byte[]> fmap = new HashMap<File, byte[]>();
        for (String name : params.keySet()) {
            Object value = params.get(name);
            String hdr = "--" + boundary + "\r\n";
            if (value instanceof File) {
                File file = (File)value;
                hdr = hdr + "Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + file.getName() + "\"\r\n";
                hdr = hdr + "Content-Type: " + MimeTypes.get(file) + "\r\n\r\n";
                fmap.put(file, hdr.getBytes());
                continue;
            }
            hdr = hdr + "Content-Disposition: form-data; name=\"" + name + "\"\r\n\r\n" + value + "\r\n";
            plist.add(hdr.getBytes());
        }
        byte[] crlf = "\r\n".getBytes();
        String lastBoundary = "--" + boundary + "--";
        long contentLength = 0L;
        for (int i = 0; i < plist.size(); ++i) {
            contentLength += (long)((byte[])plist.get(i)).length;
        }
        for (File file : fmap.keySet()) {
            byte[] b2 = (byte[])fmap.get(file);
            contentLength += (long)b2.length + file.length() + (long)crlf.length;
        }
        byte[] bLast = lastBoundary.getBytes();
        contentLength += (long)bLast.length;
        this.connect();
        String method = "POST";
        String requestLine = method + " " + this.encodedURI + " HTTP/1.1\r\n";
        byte[] b1 = requestLine.getBytes("UTF-8");
        String headerLines = "Host: " + this.host + "\r\n";
        for (int i = 0; i < this.requestHeaders.size(); ++i) {
            headerLines = headerLines + (String)this.requestHeaders.get(i);
        }
        headerLines = headerLines + "Content-Length: " + contentLength + "\r\n";
        headerLines = headerLines + "Content-Type: multipart/form-data; boundary=" + boundary + "\r\n";
        if (this.username != null && this.password != null) {
            headerLines = headerLines + "Authorization: Basic " + Utils.encodeBase64(this.username + ":" + this.password) + "\r\n";
        }
        headerLines = headerLines + "\r\n";
        byte[] b2 = headerLines.getBytes();
        this.channel.write(b1);
        this.channel.write(b2);
        for (int i = 0; i < plist.size(); ++i) {
            b = (byte[])plist.get(i);
            this.channel.write(b);
        }
        for (File file : fmap.keySet()) {
            int readBytes;
            b = (byte[])fmap.get(file);
            this.channel.write(b);
            FileInputStream is = new FileInputStream(file);
            byte[] buffer = new byte[IO_BUFFER_SIZE];
            while ((readBytes = ((InputStream)is).read(buffer)) != -1) {
                this.channel.write(buffer, 0, readBytes);
            }
            this.channel.write(crlf);
        }
        this.channel.write(bLast);
        return this.getResponse();
    }

    public int put(File file) throws Exception {
        return this.put(file, null);
    }

    public int put(File file, Tracker tracker) throws Exception {
        this.connect();
        String method = "PUT";
        String requestLine = method + " " + this.encodedURI + " HTTP/1.1\r\n";
        byte[] b1 = requestLine.getBytes("UTF-8");
        String headerLines = "Host: " + this.host + "\r\n";
        for (int i = 0; i < this.requestHeaders.size(); ++i) {
            headerLines = headerLines + (String)this.requestHeaders.get(i);
        }
        String ctype = MimeTypes.get(file);
        headerLines = headerLines + "Content-Type: " + ctype + "\r\n";
        headerLines = headerLines + "Content-Length: " + file.length() + "\r\n";
        byte[] b2 = headerLines.getBytes();
        this.channel.write(b1);
        this.channel.write(b2);
        if (this.username != null && this.password != null) {
            this.channel.write(("Authorization: Basic " + Utils.encodeBase64(this.username + ":" + this.password) + "\r\n").getBytes("UTF-8"));
        }
        this.channel.write("\r\n".getBytes());
        this.writeFile(file, tracker);
        int status = this.getResponse();
        if (status != 401) {
            return status;
        }
        this.connect();
        String auth = this.getResponseHeader("WWW-Authenticate");
        auth = this.makeAuthorizationHeader(method, this.encodedURI, auth);
        this.channel.write(b1);
        this.channel.write(b2);
        this.channel.write((auth + "\r\n").getBytes("UTF-8"));
        this.writeFile(file, tracker);
        return this.getResponse();
    }

    private void writeFile(File file, Tracker tracker) throws Exception {
        FileInputStream fis = null;
        try {
            int readBytes;
            fis = new FileInputStream(file);
            byte[] buffer = new byte[IO_BUFFER_SIZE];
            while ((readBytes = fis.read(buffer)) != -1) {
                this.channel.write(buffer, 0, readBytes);
                if (tracker == null) continue;
                tracker.onload(readBytes);
            }
            fis.close();
        }
        catch (IOException e) {
            try {
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public int delete() throws Exception {
        this.connect();
        String method = "DELETE";
        String requestLine = method + " " + this.encodedURI + " HTTP/1.1\r\n";
        byte[] b1 = requestLine.getBytes("UTF-8");
        String headerLines = "Host: " + this.host + "\r\n";
        for (int i = 0; i < this.requestHeaders.size(); ++i) {
            headerLines = headerLines + (String)this.requestHeaders.get(i);
        }
        byte[] b2 = headerLines.getBytes();
        this.channel.write(b1);
        this.channel.write(b2);
        if (this.username != null && this.password != null) {
            this.channel.write(("Authorization: Basic " + Utils.encodeBase64(this.username + ":" + this.password) + "\r\n").getBytes("UTF-8"));
        }
        this.channel.write("\r\n".getBytes());
        int status = this.getResponse();
        if (status != 401) {
            return status;
        }
        this.connect();
        String auth = this.getResponseHeader("WWW-Authenticate");
        auth = this.makeAuthorizationHeader(method, this.host, auth);
        this.channel.write(b1);
        this.channel.write(b2);
        this.channel.write((auth + "\r\n").getBytes("UTF-8"));
        return this.getResponse();
    }

    private String makeAuthorizationHeader(String method, String uri, String auth) throws Exception {
        if (auth.startsWith("Basic")) {
            return "Authorization: Basic " + Utils.encodeBase64(this.username + ":" + this.password) + "\r\n";
        }
        int n = auth.indexOf("realm=\"") + 7;
        String realm = auth.substring(n, auth.indexOf("\"", n));
        n = auth.indexOf("nonce=\"") + 7;
        String nonce = auth.substring(n, auth.indexOf("\"", n));
        MessageDigest md = MessageDigest.getInstance("MD5");
        String a1 = this.username + ":" + realm + ":" + this.password;
        String a2 = method + ":" + uri;
        String r1 = HttpRequest.encode(a1, md);
        String r2 = HttpRequest.encode(a2, md);
        String r3 = r1 + ":" + nonce + ":" + r2;
        String digest = HttpRequest.encode(r3, md);
        return "Authorization: Digest username=\"" + this.username + "\",uri=\"" + uri + "\",realm=\"" + realm + "\",nonce=\"" + nonce + "\",response=\"" + digest + "\"\r\n";
    }

    private static String encode(String str, MessageDigest md) throws Exception {
        md.update(str.getBytes("UTF-8"));
        return Utils.toHexString(md.digest());
    }

    private int getResponse() throws IOException {
        int b;
        this.responseHeaders = new HashMap();
        Vector<String> lines = new Vector<String>();
        byte[] buf = new byte[4096];
        boolean crlf = false;
        int i = 0;
        int j = 0;
        while ((b = this.channel.read()) != -1) {
            buf[i] = (byte)b;
            if (b == 10 && i > 0 && buf[i - 1] == 13) {
                if (crlf) break;
                crlf = true;
            } else if (crlf) {
                if (b == 32 || b == 9) {
                    buf[i -= 2] = (byte)b;
                    crlf = false;
                } else {
                    String line = new String(buf, j, i - j).trim();
                    lines.add(line);
                    j = i;
                    if (b != 13) {
                        crlf = false;
                    }
                }
            }
            ++i;
        }
        if (lines.isEmpty()) {
            throw new IOException();
        }
        String statusLine = (String)lines.get(0);
        String s = statusLine.substring(statusLine.indexOf(32)).trim();
        int n = s.indexOf(32);
        if (n != -1) {
            s = s.substring(0, n);
        }
        int status = Integer.parseInt(s);
        for (int k = 1; k < lines.size(); ++k) {
            String line = (String)lines.get(k);
            n = line.indexOf(":");
            if (n == -1) continue;
            this.responseHeaders.put(line.substring(0, n), line.substring(n + 1).trim());
        }
        this.closed = "close".equals(this.responseHeaders.get("Connection"));
        return status;
    }

    public void close() {
        this.closed = true;
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }
}

