/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.util.Duration;

public final class JavaFxScheduler
extends Scheduler {
    private static final JavaFxScheduler INSTANCE = new JavaFxScheduler();

    JavaFxScheduler() {
    }

    public static JavaFxScheduler platform() {
        return INSTANCE;
    }

    private static void assertThatTheDelayIsValidForTheJavaFxTimer(long delay) {
        if (delay < 0L || delay > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("The JavaFx timer only accepts non-negative delays up to %d milliseconds.", Integer.MAX_VALUE));
        }
    }

    public Scheduler.Worker createWorker() {
        return new JavaFxWorker();
    }

    private static class JavaFxWorker
    extends Scheduler.Worker
    implements Runnable {
        private volatile QueuedRunnable head = new QueuedRunnable(null);
        private final AtomicReference<QueuedRunnable> tail = new AtomicReference<QueuedRunnable>(this.head);

        private JavaFxWorker() {
        }

        public void dispose() {
            this.tail.set(null);
            for (QueuedRunnable qr = this.head; qr != null; qr = (QueuedRunnable)qr.getAndSet(null)) {
                qr.dispose();
            }
        }

        public boolean isDisposed() {
            return this.tail.get() == null;
        }

        public Disposable schedule(Runnable action, long delayTime, TimeUnit unit) {
            long delay = Math.max(0L, unit.toMillis(delayTime));
            JavaFxScheduler.assertThatTheDelayIsValidForTheJavaFxTimer(delay);
            QueuedRunnable queuedRunnable = new QueuedRunnable(action);
            if (delay == 0L) {
                return this.schedule(queuedRunnable);
            }
            Timeline timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), event -> this.schedule(queuedRunnable), new KeyValue[0])});
            timer.play();
            return Disposables.fromRunnable(() -> {
                queuedRunnable.dispose();
                timer.stop();
            });
        }

        public Disposable schedule(Runnable action) {
            QueuedRunnable tailPivot;
            QueuedRunnable queuedRunnable;
            if (this.isDisposed()) {
                return Disposables.disposed();
            }
            QueuedRunnable queuedRunnable2 = queuedRunnable = action instanceof QueuedRunnable ? (QueuedRunnable)action : new QueuedRunnable(action);
            while ((tailPivot = this.tail.get()) != null && !tailPivot.compareAndSet(null, queuedRunnable)) {
            }
            if (tailPivot == null) {
                queuedRunnable.dispose();
            } else {
                this.tail.compareAndSet(tailPivot, queuedRunnable);
                if (tailPivot == this.head) {
                    if (Platform.isFxApplicationThread()) {
                        this.run();
                    } else {
                        Platform.runLater((Runnable)this);
                    }
                }
            }
            return queuedRunnable;
        }

        @Override
        public void run() {
            for (QueuedRunnable qr = (QueuedRunnable)this.head.get(); qr != null; qr = (QueuedRunnable)qr.get()) {
                qr.run();
                this.head = qr;
            }
        }

        private static class QueuedRunnable
        extends AtomicReference<QueuedRunnable>
        implements Disposable,
        Runnable {
            private volatile Runnable action;

            private QueuedRunnable(Runnable action) {
                this.action = action;
            }

            public void dispose() {
                this.action = null;
            }

            public boolean isDisposed() {
                return this.action == null;
            }

            @Override
            public void run() {
                Runnable action = this.action;
                if (action != null) {
                    action.run();
                }
                this.action = null;
            }
        }
    }
}

