/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.sources;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.rxjavafx.sources.Flag;
import io.reactivex.rxjavafx.sources.ListChange;
import io.reactivex.rxjavafx.subscriptions.JavaFxSubscriptions;
import java.util.HashMap;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public final class ObservableListSource {
    private ObservableListSource() {
    }

    public static <T> Observable<ObservableList<T>> fromObservableList(ObservableList<T> source) {
        return Observable.create(subscriber -> {
            ListChangeListener listener = c -> subscriber.onNext((Object)source);
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).startWith(source).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T> Observable<T> fromObservableListAdds(ObservableList<T> source) {
        return Observable.create(subscriber -> {
            ListChangeListener listener = c -> {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    c.getAddedSubList().forEach(arg_0 -> ((ObservableEmitter)subscriber).onNext(arg_0));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T> Observable<T> fromObservableListRemovals(ObservableList<T> source) {
        return Observable.create(subscriber -> {
            ListChangeListener listener = c -> {
                while (c.next()) {
                    if (!c.wasRemoved()) continue;
                    c.getRemoved().forEach(arg_0 -> ((ObservableEmitter)subscriber).onNext(arg_0));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T> Observable<T> fromObservableListUpdates(ObservableList<T> source) {
        return Observable.create(subscriber -> {
            ListChangeListener listener = c -> {
                while (c.next()) {
                    if (!c.wasUpdated()) continue;
                    for (int i = c.getFrom(); i < c.getTo(); ++i) {
                        subscriber.onNext(c.getList().get(i));
                    }
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T> Observable<ListChange<T>> fromObservableListChanges(ObservableList<T> source) {
        return Observable.create(subscriber -> {
            ListChangeListener listener = c -> {
                while (c.next()) {
                    if (c.wasAdded()) {
                        c.getAddedSubList().forEach(v -> subscriber.onNext(ListChange.of(v, Flag.ADDED)));
                    }
                    if (c.wasRemoved()) {
                        c.getRemoved().forEach(v -> subscriber.onNext(ListChange.of(v, Flag.REMOVED)));
                    }
                    if (!c.wasUpdated()) continue;
                    for (int i = c.getFrom(); i < c.getTo(); ++i) {
                        subscriber.onNext(ListChange.of(c.getList().get(i), Flag.UPDATED));
                    }
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T> Observable<ListChange<T>> fromObservableListDistinctChanges(ObservableList<T> source) {
        return Observable.create(subscriber -> {
            DupeCounter dupeCounter = new DupeCounter();
            source.forEach(dupeCounter::add);
            ListChangeListener listener = c -> {
                while (c.next()) {
                    if (c.wasAdded()) {
                        c.getAddedSubList().stream().filter(v -> dupeCounter.add(v) == 1).forEach(v -> subscriber.onNext(ListChange.of(v, Flag.ADDED)));
                    }
                    if (!c.wasRemoved()) continue;
                    c.getRemoved().stream().filter(v -> dupeCounter.remove(v) == 0).forEach(v -> subscriber.onNext(ListChange.of(v, Flag.REMOVED)));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T, R> Observable<ListChange<T>> fromObservableListDistinctChanges(ObservableList<T> source, Function<T, R> mapper) {
        return Observable.create(subscriber -> {
            DupeCounter dupeCounter = new DupeCounter();
            source.stream().map(mapper).forEach(dupeCounter::add);
            ListChangeListener listener = c -> {
                while (c.next()) {
                    if (c.wasAdded()) {
                        c.getAddedSubList().stream().filter(v -> dupeCounter.add(mapper.apply(v)) == 1).forEach(v -> subscriber.onNext(ListChange.of(v, Flag.ADDED)));
                    }
                    if (!c.wasRemoved()) continue;
                    c.getRemoved().stream().filter(v -> dupeCounter.remove(mapper.apply(v)) == 0).forEach(v -> subscriber.onNext(ListChange.of(v, Flag.REMOVED)));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T, R> Observable<ListChange<R>> fromObservableListDistinctMappings(ObservableList<T> source, Function<T, R> mapper) {
        return Observable.create(subscriber -> {
            DupeCounter dupeCounter = new DupeCounter();
            source.stream().map(mapper).forEach(dupeCounter::add);
            ListChangeListener listener = c -> {
                while (c.next()) {
                    if (c.wasAdded()) {
                        c.getAddedSubList().stream().map(mapper).filter(v -> dupeCounter.add(v) == 1).forEach(v -> subscriber.onNext(ListChange.of(v, Flag.ADDED)));
                    }
                    if (!c.wasRemoved()) continue;
                    c.getRemoved().stream().map(mapper).filter(v -> dupeCounter.remove(v) == 0).forEach(v -> subscriber.onNext(ListChange.of(v, Flag.REMOVED)));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    private static final class DupeCounter<T> {
        private final HashMap<T, Integer> counts = new HashMap();

        private DupeCounter() {
        }

        public int add(T value) {
            Integer prev = this.counts.get(value);
            int newVal = 0;
            if (prev == null) {
                newVal = 1;
                this.counts.put(value, newVal);
            } else {
                newVal = prev + 1;
                this.counts.put(value, newVal);
            }
            return newVal;
        }

        public int remove(T value) {
            Integer prev = this.counts.get(value);
            if (prev != null && prev > 0) {
                int newVal = prev - 1;
                if (newVal == 0) {
                    this.counts.remove(value);
                } else {
                    this.counts.put(value, newVal);
                }
                return newVal;
            }
            throw new IllegalStateException();
        }
    }
}

