/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.sources;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.rxjavafx.sources.Change;
import io.reactivex.rxjavafx.subscriptions.JavaFxSubscriptions;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class ObservableValueSource {
    public static <T> Observable<T> fromObservableValue(ObservableValue<T> fxObservable) {
        return Observable.create(emitter -> {
            if (fxObservable.getValue() != null) {
                emitter.onNext(fxObservable.getValue());
            }
            ChangeListener listener = (observableValue, prev, current) -> {
                if (current != null) {
                    emitter.onNext(current);
                }
            };
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }

    public static <T> Observable<T> fromObservableValue(ObservableValue<T> fxObservable, T nullSentinel) {
        if (nullSentinel == null) {
            throw new NullPointerException("The null value sentinel must not be null.");
        }
        return Observable.create(emitter -> {
            if (fxObservable.getValue() != null) {
                emitter.onNext(fxObservable.getValue());
            }
            ChangeListener listener = (observableValue, prev, current) -> {
                if (current != null) {
                    emitter.onNext(current);
                } else {
                    emitter.onNext(nullSentinel);
                }
            };
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }

    public static <T> Observable<Optional<T>> fromNullableObservableValue(ObservableValue<T> fxObservable) {
        return Observable.create(emitter -> {
            emitter.onNext(Optional.ofNullable(fxObservable.getValue()));
            ChangeListener listener = (observableValue, prev, current) -> emitter.onNext(Optional.ofNullable(current));
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }

    public static <T> Observable<Change<T>> fromObservableValueChanges(ObservableValue<T> fxObservable) {
        return Observable.create(emitter -> {
            ChangeListener listener = (observableValue, prev, current) -> {
                if (current != null) {
                    emitter.onNext(new Change<Object>(prev, current));
                }
            };
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }

    public static Observable<javafx.beans.Observable> fromInvalidations(javafx.beans.Observable fxObservable) {
        return Observable.create(emitter -> {
            InvalidationListener listener = arg_0 -> ((ObservableEmitter)emitter).onNext(arg_0);
            fxObservable.addListener(listener);
            emitter.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> fxObservable.removeListener(listener)));
        });
    }
}

