/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javafx.scene.control.IndexRange;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import org.fxmisc.richtext.ClipboardHelper;
import org.fxmisc.richtext.EditActions;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.util.Tuple2;

public interface ClipboardActions<PS, SEG, S>
extends EditActions<PS, SEG, S> {
    public Optional<Tuple2<Codec<PS>, Codec<StyledSegment<SEG, S>>>> getStyleCodecs();

    public void setStyleCodecs(Codec<PS> var1, Codec<StyledSegment<SEG, S>> var2);

    @Override
    public SegmentOps<SEG, S> getSegOps();

    default public void cut() {
        this.copy();
        IndexRange selection = this.getSelection();
        this.deleteText(selection.getStart(), selection.getEnd());
    }

    default public void copy() {
        IndexRange selection = this.getSelection();
        if (selection.getLength() > 0) {
            ClipboardContent content = new ClipboardContent();
            content.putString(this.getSelectedText());
            this.getStyleCodecs().ifPresent(codecs -> {
                Codec codec = ReadOnlyStyledDocument.codec((Codec)codecs._1, (Codec)codecs._2, this.getSegOps());
                DataFormat format = ClipboardHelper.dataFormat(codec.getName());
                StyledDocument doc = this.subDocument(selection.getStart(), selection.getEnd());
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(os);
                try {
                    codec.encode(dos, doc);
                    content.put((Object)format, (Object)os.toByteArray());
                }
                catch (IOException e) {
                    System.err.println("Codec error: Exception in encoding '" + codec.getName() + "':");
                    e.printStackTrace();
                }
            });
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    default public void paste() {
        String text;
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (this.getStyleCodecs().isPresent()) {
            Tuple2<Codec<PS>, Codec<StyledSegment<SEG, S>>> codecs = this.getStyleCodecs().get();
            Codec codec = ReadOnlyStyledDocument.codec((Codec)codecs._1, (Codec)codecs._2, this.getSegOps());
            DataFormat format = ClipboardHelper.dataFormat(codec.getName());
            if (clipboard.hasContent(format)) {
                byte[] bytes = (byte[])clipboard.getContent(format);
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                DataInputStream dis = new DataInputStream(is);
                StyledDocument doc = null;
                try {
                    doc = codec.decode(dis);
                }
                catch (IOException e) {
                    System.err.println("Codec error: Failed to decode '" + codec.getName() + "':");
                    e.printStackTrace();
                }
                if (doc != null) {
                    this.replaceSelection(doc);
                    return;
                }
            }
        }
        if (clipboard.hasString() && (text = clipboard.getString()) != null) {
            this.replaceSelection(text);
        }
    }
}

