/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event.template;

import java.util.Objects;
import java.util.function.BiFunction;
import javafx.event.Event;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputHandler;
import org.fxmisc.wellbehaved.event.template.InputHandlerTemplate;
import org.fxmisc.wellbehaved.event.template.InputHandlerTemplateMap;
import org.fxmisc.wellbehaved.event.template.InputMapTemplate;

class PatternActionTemplate<S, T extends Event, U extends T>
extends InputMapTemplate<S, U> {
    static final BiFunction<Object, Object, InputHandler.Result> CONST_IGNORE = (x, y) -> InputHandler.Result.IGNORE;
    private final EventPattern<T, ? extends U> pattern;
    private final BiFunction<? super S, ? super U, InputHandler.Result> action;

    PatternActionTemplate(EventPattern<T, ? extends U> pattern, BiFunction<? super S, ? super U, InputHandler.Result> action) {
        this.pattern = pattern;
        this.action = action;
    }

    @Override
    protected InputHandlerTemplateMap<S, U> getInputHandlerTemplateMap() {
        InputHandlerTemplateMap ihtm = new InputHandlerTemplateMap();
        InputHandlerTemplate<Object, Event> iht = (s, t) -> this.pattern.match(t).map(u -> this.action.apply((S)s, (Event)u)).orElse(InputHandler.Result.PROCEED);
        this.pattern.getEventTypes().forEach(et -> ihtm.insertAfter(et, iht));
        return ihtm;
    }

    public boolean equals(Object other) {
        if (other instanceof PatternActionTemplate) {
            PatternActionTemplate that = (PatternActionTemplate)other;
            return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.action, that.action);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.action);
    }
}

