/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.Deque;
import java.util.LinkedList;
import org.reactfx.collection.ListChangeAccumulator;
import org.reactfx.collection.ListModificationSequence;
import org.reactfx.collection.QuasiListChange;

public interface AccumulationFacility<T, A> {
    public A initialAccumulator(T var1);

    public A reduce(A var1, T var2);

    public static interface ListChangeAccumulation<E>
    extends AccumulationFacility<QuasiListChange<? extends E>, ListModificationSequence<E>> {
        @Override
        default public ListModificationSequence<E> initialAccumulator(QuasiListChange<? extends E> value) {
            return QuasiListChange.safeCast(value);
        }

        @Override
        default public ListChangeAccumulator<E> reduce(ListModificationSequence<E> accum, QuasiListChange<? extends E> value) {
            return accum.asListChangeAccumulator().add(value);
        }
    }

    public static interface RetainOldest<T>
    extends HomotypicAccumulation<T> {
        @Override
        default public T reduce(T accum, T value) {
            return accum;
        }
    }

    public static interface RetainLatest<T>
    extends HomotypicAccumulation<T> {
        @Override
        default public T reduce(T accum, T value) {
            return value;
        }
    }

    public static interface Queuing<T>
    extends AccumulationFacility<T, Deque<T>> {
        @Override
        default public Deque<T> initialAccumulator(T value) {
            LinkedList<T> res = new LinkedList<T>();
            res.add(value);
            return res;
        }

        @Override
        default public Deque<T> reduce(Deque<T> accum, T value) {
            accum.addLast(value);
            return accum;
        }
    }

    public static interface NoAccumulation<T>
    extends IllegalAccumulation<T, T>,
    HomotypicAccumulation<T> {
    }

    public static interface HomotypicAccumulation<T>
    extends AccumulationFacility<T, T> {
        @Override
        default public T initialAccumulator(T value) {
            return value;
        }
    }

    public static interface IllegalAccumulation<T, A>
    extends AccumulationFacility<T, A> {
        @Override
        default public A reduce(A accum, T value) {
            throw new IllegalStateException();
        }
    }
}

