/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.observers;

import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.rxjavafx.observers.BindingObserver;
import java.util.Optional;
import javafx.beans.binding.Binding;

public enum JavaFxObserver {


    public static <T> Binding<T> toBinding(Observable<T> obs) {
        return JavaFxObserver.toBinding(obs, (Consumer<Throwable>)((Consumer)JavaFxObserver::onError));
    }

    public static <T> Binding<T> toBinding(Observable<T> obs, Consumer<Throwable> onErrorAction) {
        BindingObserver bindingObserver = new BindingObserver(t -> t, onErrorAction);
        obs.subscribe(bindingObserver);
        return bindingObserver;
    }

    public static <T> Binding<T> toNullBinding(Observable<T> obs, T nullSentinel) {
        return JavaFxObserver.toNullBinding(obs, nullSentinel, (Consumer<Throwable>)((Consumer)JavaFxObserver::onError));
    }

    public static <T> Binding<T> toNullBinding(Observable<T> obs, T nullSentinel, Consumer<Throwable> onErrorAction) {
        if (nullSentinel == null) {
            throw new NullPointerException("The null value sentinel must not be null.");
        }
        BindingObserver bindingObserver = new BindingObserver(t -> t == nullSentinel ? null : t, onErrorAction);
        obs.subscribe(bindingObserver);
        return bindingObserver;
    }

    public static <T> Binding<T> toNullableBinding(Observable<Optional<T>> obs) {
        return JavaFxObserver.toNullableBinding(obs, (Consumer<Throwable>)((Consumer)JavaFxObserver::onError));
    }

    public static <T> Binding<T> toNullableBinding(Observable<Optional<T>> obs, Consumer<Throwable> onErrorAction) {
        BindingObserver bindingObserver = new BindingObserver(o -> o.orElse(null), onErrorAction);
        obs.subscribe(bindingObserver);
        return bindingObserver;
    }

    public static <T> Binding<T> toLazyBinding(Observable<T> obs) {
        return JavaFxObserver.toLazyBinding(obs, (Consumer<Throwable>)((Consumer)JavaFxObserver::onError));
    }

    public static <T> Binding<T> toLazyBinding(Observable<T> obs, Consumer<Throwable> onErrorAction) {
        ConnectableObservable published = obs.publish();
        BindingObserver bindingObserver = new BindingObserver(t -> t, published, onErrorAction);
        published.subscribe(bindingObserver);
        return bindingObserver;
    }

    public static <T> Binding<T> toLazyNullBinding(Observable<T> obs, T nullSentinel) {
        return JavaFxObserver.toLazyNullBinding(obs, nullSentinel, (Consumer<Throwable>)((Consumer)JavaFxObserver::onError));
    }

    public static <T> Binding<T> toLazyNullBinding(Observable<T> obs, T nullSentinel, Consumer<Throwable> onErrorAction) {
        if (nullSentinel == null) {
            throw new NullPointerException("The null value sentinel must not be null.");
        }
        ConnectableObservable published = obs.publish();
        BindingObserver bindingObserver = new BindingObserver(t -> t == nullSentinel ? null : t, published, onErrorAction);
        published.subscribe(bindingObserver);
        return bindingObserver;
    }

    public static <T> Binding<T> toLazyNullableBinding(Observable<Optional<T>> obs) {
        return JavaFxObserver.toLazyNullableBinding(obs, (Consumer<Throwable>)((Consumer)JavaFxObserver::onError));
    }

    public static <T> Binding<T> toLazyNullableBinding(Observable<Optional<T>> obs, Consumer<Throwable> onErrorAction) {
        ConnectableObservable published = obs.publish();
        BindingObserver bindingObserver = new BindingObserver(o -> o.orElse(null), published, onErrorAction);
        published.subscribe(bindingObserver);
        return bindingObserver;
    }

    private static void onError(Throwable t) {
    }
}

