/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.sources;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.rxjavafx.sources.NodeEventSource;
import io.reactivex.rxjavafx.subscriptions.JavaFxSubscriptions;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

public final class ActionEventSource {
    private ActionEventSource() {
    }

    public static Observable<ActionEvent> fromActionEvents(Node node) {
        return NodeEventSource.fromNodeEvents(node, ActionEvent.ACTION);
    }

    public static Observable<ActionEvent> fromActionEvents(ContextMenu source) {
        return Observable.create(subscriber -> {
            EventHandler handler = arg_0 -> ((ObservableEmitter)subscriber).onNext(arg_0);
            source.addEventHandler(ActionEvent.ANY, handler);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeEventHandler(ActionEvent.ANY, handler)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static Observable<ActionEvent> fromActionEvents(MenuItem source) {
        return Observable.create(subscriber -> {
            EventHandler handler = arg_0 -> ((ObservableEmitter)subscriber).onNext(arg_0);
            source.addEventHandler(ActionEvent.ANY, handler);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeEventHandler(ActionEvent.ANY, handler)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }
}

