/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.sources;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.rxjavafx.sources.Flag;
import io.reactivex.rxjavafx.sources.SetChange;
import io.reactivex.rxjavafx.subscriptions.JavaFxSubscriptions;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

public final class ObservableSetSource {
    private ObservableSetSource() {
    }

    public static <T> Observable<ObservableSet<T>> fromObservableSet(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> subscriber.onNext((Object)source);
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).startWith(source).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T> Observable<T> fromObservableSetAdds(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> {
                if (c.wasAdded()) {
                    subscriber.onNext(c.getElementAdded());
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T> Observable<T> fromObservableSetRemovals(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(c.getElementRemoved());
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <T> Observable<SetChange<T>> fromObservableSetChanges(ObservableSet<T> source) {
        return Observable.create(subscriber -> {
            SetChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new SetChange<Object>(c.getElementRemoved(), Flag.REMOVED));
                }
                if (c.wasAdded()) {
                    subscriber.onNext(new SetChange<Object>(c.getElementAdded(), Flag.ADDED));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }
}

