/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.impl.ios;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.VideoFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AVCaptureStream
implements CaptureStream {
    private String deviceId;
    private long sessionId;
    private VideoFormat format;
    private List<VideoFormat> formats;
    private CaptureObserver observer;

    public AVCaptureStream(String deviceId) throws CaptureException {
        this.deviceId = deviceId;
        this.sessionId = this.open(deviceId);
        if (this.sessionId == 0L) {
            throw new CaptureException();
        }
    }

    @Override
    public List<VideoFormat> enumVideoFormats() throws CaptureException {
        if (this.formats != null) {
            return this.formats;
        }
        this.formats = new ArrayList<VideoFormat>();
        String[] values = this.getVideoFormats();
        HashSet<String> set = new HashSet<String>();
        if (values != null) {
            for (int i = 0; i < values.length && values[i] != null && values[i].length() != 0; ++i) {
                if (!set.add(values[i])) continue;
                int n = values[i].indexOf(32);
                String f = values[i].substring(0, n);
                int fps = Integer.parseInt(values[i].substring(n + 1));
                n = f.indexOf(120);
                int width = Integer.parseInt(f.substring(0, n));
                int height = Integer.parseInt(f.substring(n + 1));
                String format = "NV12";
                this.formats.add(new VideoFormat(format, width, height, (float)fps));
                this.formats.add(new VideoFormat(format, height, width, (float)fps));
            }
        }
        return this.formats;
    }

    private String[] getVideoFormats() {
        return this.getVideoFormats(this.deviceId);
    }

    @Override
    public void setVideoFormat(VideoFormat f) throws CaptureException {
        this.format = f;
    }

    @Override
    public VideoFormat getVideoFormat() throws CaptureException {
        if (this.format == null) {
            List<VideoFormat> list = this.enumVideoFormats();
            for (int i = 0; i < list.size(); ++i) {
                this.format = list.get(i);
                if (this.format.getWidth() >= 320) break;
            }
        }
        return this.format;
    }

    @Override
    public void start() throws CaptureException {
        this.start(this.sessionId, this.format.getWidth(), this.format.getHeight());
    }

    @Override
    public void stop() throws CaptureException {
        this.stop(this.sessionId);
    }

    @Override
    public void dispose() throws CaptureException {
        this.close(this.sessionId);
    }

    @Override
    public void setObserver(CaptureObserver observer) {
        this.observer = observer;
    }

    public void onNewImage(byte[] data, int width, int height, int bytesPerRow) {
        if (this.observer != null) {
            this.observer.onNewImage(data, width, height, bytesPerRow);
        }
    }

    private native long open(String var1);

    private native void close(long var1);

    private native void start(long var1, int var3, int var4);

    private native void stop(long var1);

    private native String[] getVideoFormats(String var1);
}

