/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.impl.ios;

import com.lti.civil.CaptureDeviceInfo;
import com.lti.civil.CaptureException;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.impl.ios.AVCaptureStream;
import com.smile.telephony.audio.SignalProcessor;
import java.util.ArrayList;
import java.util.List;
import smile.util.ResourceStore;

public class AVCaptureSystem
implements CaptureSystem {
    @Override
    public native void init() throws CaptureException;

    @Override
    public native void dispose() throws CaptureException;

    @Override
    public List getCaptureDeviceInfoList() throws CaptureException {
        String[] info = this.getVideoCaptureDevices();
        ArrayList<CaptureDeviceInfo> result = new ArrayList<CaptureDeviceInfo>();
        for (int i = 0; i < info.length; ++i) {
            int n = info[i].indexOf(59);
            String devid = info[i].substring(0, n);
            String name = info[i].substring(n + 1);
            ResourceStore.toLog("getCaptureDeviceInfoList devid=" + devid + " name=" + name);
            if (i == 0) {
                name = "Back Camera";
            }
            if (i == 1) {
                name = "Front Camera";
            }
            result.add(new CaptureDeviceInfo(devid, name));
        }
        return result;
    }

    @Override
    public CaptureStream openCaptureStream(CaptureDeviceInfo deviceInfo) throws CaptureException {
        return new AVCaptureStream(deviceInfo.getDeviceID());
    }

    private native String[] getVideoCaptureDevices();

    static {
        try {
            System.load(SignalProcessor.nativeLibraryPathPrefix + "vcap" + SignalProcessor.nativeLibrarySuffix);
            ResourceStore.syslog("Library : " + SignalProcessor.nativeLibraryPathPrefix + "vcap" + SignalProcessor.nativeLibrarySuffix + " is loaded");
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            try {
                System.loadLibrary("vcap");
            }
            catch (Throwable err) {
                System.out.println(err);
            }
        }
    }
}

