/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.impl.jni;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.VideoFormat;
import com.lti.civil.impl.jni.Peered;
import java.util.List;

public class NativeCaptureStream
extends Peered
implements CaptureStream {
    private NativeCaptureStreamThread thread;
    private boolean started;

    public NativeCaptureStream(long ptr) {
        super(ptr);
    }

    @Override
    public synchronized native List<VideoFormat> enumVideoFormats() throws CaptureException;

    @Override
    public synchronized native void setVideoFormat(VideoFormat var1) throws CaptureException;

    @Override
    public synchronized native VideoFormat getVideoFormat() throws CaptureException;

    @Override
    public synchronized native void setObserver(CaptureObserver var1);

    @Override
    public synchronized void start() throws CaptureException {
        if (this.started) {
            return;
        }
        if (this.thread == null) {
            this.thread = new NativeCaptureStreamThread();
            this.thread.setName("NativeCaptureStreamThread " + this.getPeerPtr());
            this.thread.start();
        }
        this.nativeStart();
        this.started = true;
    }

    @Override
    public synchronized void stop() throws CaptureException {
        if (!this.started) {
            return;
        }
        this.nativeStop();
        this.started = false;
    }

    @Override
    public synchronized void dispose() throws CaptureException {
        this.nativeDispose();
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized native void nativeStart() throws CaptureException;

    private synchronized native void nativeStop() throws CaptureException;

    private synchronized native void nativeDispose() throws CaptureException;

    public native void threadMain();

    class NativeCaptureStreamThread
    extends Thread {
        NativeCaptureStreamThread() {
        }

        @Override
        public void run() {
            try {
                NativeCaptureStream.this.threadMain();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            NativeCaptureStream.this.thread = null;
        }
    }
}

