/*
 * Decompiled with CFR 0.152.
 */
package com.lti.civil.impl.mac;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureObserver;
import com.lti.civil.CaptureStream;
import com.lti.civil.VideoFormat;
import java.util.ArrayList;
import java.util.List;

public class AVCaptureStream
implements CaptureStream {
    private String deviceId;
    private long sessionId;
    private VideoFormat format;
    private List<VideoFormat> formats;
    private CaptureObserver observer;
    private boolean bigEndian = "big".equals(System.getProperty("sun.cpu.endian"));

    public AVCaptureStream(String deviceId) throws CaptureException {
        this.deviceId = deviceId;
        this.sessionId = this.open(deviceId);
        if (this.sessionId == 0L) {
            throw new CaptureException();
        }
    }

    @Override
    public List<VideoFormat> enumVideoFormats() throws CaptureException {
        if (this.formats != null) {
            return this.formats;
        }
        this.formats = new ArrayList<VideoFormat>();
        String[] values = this.getVideoFormats(this.deviceId);
        for (int i = 0; i < values.length; ++i) {
            int n = values[i].indexOf(32);
            String f = values[i].substring(0, n);
            int fps = Integer.parseInt(values[i].substring(n + 1));
            n = f.indexOf(120);
            int width = Integer.parseInt(f.substring(0, n));
            int height = Integer.parseInt(f.substring(n + 1));
            if (width < 320) continue;
            this.formats.add(new VideoFormat("RGB24", width, height, (float)fps));
        }
        return this.formats;
    }

    @Override
    public void setVideoFormat(VideoFormat f) throws CaptureException {
        this.format = f;
    }

    @Override
    public VideoFormat getVideoFormat() throws CaptureException {
        if (this.format == null) {
            this.format = this.enumVideoFormats().get(0);
        }
        return this.format;
    }

    @Override
    public void start() throws CaptureException {
        this.start(this.sessionId, this.format.getWidth(), this.format.getHeight());
    }

    @Override
    public void stop() throws CaptureException {
        this.stop(this.sessionId);
    }

    @Override
    public void dispose() throws CaptureException {
        this.close(this.sessionId);
    }

    @Override
    public void setObserver(CaptureObserver observer) {
        this.observer = observer;
    }

    public void onNewImage(byte[] data) {
        if (this.observer != null) {
            if (this.bigEndian) {
                this.observer.onNewImage(data, this.format.getWidth(), this.format.getHeight(), this.format.getWidth() * 3);
            } else {
                int length = data.length / 3 * 3;
                byte[] image = new byte[length];
                for (int i = 0; i < length; i += 3) {
                    image[i] = data[i + 2];
                    image[i + 1] = data[i + 1];
                    image[i + 2] = data[i];
                }
                this.observer.onNewImage(image, this.format.getWidth(), this.format.getHeight(), this.format.getWidth() * 3);
            }
        }
    }

    private native long open(String var1);

    private native void close(long var1);

    private native void start(long var1, int var3, int var4);

    private native void stop(long var1);

    private native String[] getVideoFormats(String var1);

    private native void setVideoFormat(String var1, int var2, int var3);
}

