/*
 * Decompiled with CFR 0.152.
 */
package com.smile.mail;

import java.util.ArrayList;
import java.util.List;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import smile.util.Utils;

public class MimeMessageParser {
    private List<MimePart> plainContent = new ArrayList<MimePart>();
    private List<MimePart> htmlContent = new ArrayList<MimePart>();
    private List<MimePart> attachments = new ArrayList<MimePart>();
    private boolean multipart = false;

    public MimeMessageParser(MimeMessage mimeMessage) throws Exception {
        this.parse((MimePart)mimeMessage);
    }

    protected void parse(MimePart part) throws Exception {
        String contentType = part.getContentType().toLowerCase();
        String disposition = part.getDisposition();
        if (contentType.startsWith("multipart/")) {
            Multipart mp = (Multipart)part.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                this.parse((MimePart)((MimeBodyPart)mp.getBodyPart(i)));
            }
            this.multipart = true;
        } else if (contentType.startsWith("text/plain") && !"attachment".equalsIgnoreCase(disposition)) {
            this.plainContent.add(part);
        } else if (contentType.startsWith("text/html") && !"attachment".equalsIgnoreCase(disposition)) {
            this.htmlContent.add(part);
        } else if (contentType.equals("message/rfc822") && !"attachment".equalsIgnoreCase(disposition)) {
            MimePart message = (MimePart)part.getContent();
            this.plainContent.add(message);
            this.parse(message);
        } else {
            this.attachments.add(part);
        }
    }

    public List<MimePart> getAttachments() {
        return this.attachments;
    }

    public boolean isTextOnly() {
        return this.htmlContent == null && this.attachments.isEmpty();
    }

    public String getPlainContent() throws Exception {
        Object str = "";
        for (int i = 0; i < this.plainContent.size(); ++i) {
            MimePart part = this.plainContent.get(i);
            str = this.multipart && part instanceof MimeMessage ? (String)str + this.getHeaders((MimeMessage)part) + "\r\n" : (String)str + (String)part.getContent() + "\r\n";
        }
        return str;
    }

    public boolean isHtml() {
        return this.htmlContent.size() >= this.plainContent.size();
    }

    public String getBodyText() throws Exception {
        if (this.plainContent.size() > this.htmlContent.size()) {
            return this.getPlainContent();
        }
        if (this.htmlContent.size() == 0) {
            return "";
        }
        return (String)this.htmlContent.get(0).getContent();
    }

    public String getHtmlAsText(MimePart part) throws Exception {
        String html = (String)part.getContent();
        return Utils.htmlToText(html);
    }

    private String getHeaders(MimeMessage part) throws Exception {
        return "To: " + Utils.decodeRFC2047(part.getHeader("To", ";")) + "\r\nFrom: " + Utils.decodeRFC2047(part.getHeader("From", ";")) + "\r\nDate: " + part.getHeader("Date", ";") + "\r\nSubject: " + Utils.decodeRFC2047(part.getSubject()) + "\r\n";
    }
}

