/*
 * Decompiled with CFR 0.152.
 */
package com.smile.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class TCPSocketChannel {
    protected SocketChannel socketChannel = SocketChannel.open();
    protected ByteBuffer readBuffer;
    protected ByteBuffer writeBuffer;
    private InputStream inputStream;
    private OutputStream outputStream;

    public TCPSocketChannel(InetSocketAddress remote, int timeout) throws Exception {
        this.socketChannel.socket().connect(remote, timeout);
        this.socketChannel.configureBlocking(false);
        this.readBuffer = ByteBuffer.allocate(4096);
        this.readBuffer.flip();
        this.writeBuffer = ByteBuffer.allocate(4096);
    }

    public InetAddress getInetAddress() {
        return this.socketChannel.socket().getInetAddress();
    }

    public int getPort() {
        return this.socketChannel.socket().getPort();
    }

    public InetAddress getLocalAddress() {
        return this.socketChannel.socket().getLocalAddress();
    }

    public int getLocalPort() {
        return this.socketChannel.socket().getLocalPort();
    }

    public InputStream getInputStream() {
        if (this.inputStream == null) {
            this.inputStream = new BufferInputStream();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new BufferOutputStream();
        }
        return this.outputStream;
    }

    public void close() {
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    protected int readChannel() throws IOException {
        return this.socketChannel.read(this.readBuffer);
    }

    protected int writeChannel() throws IOException {
        return this.socketChannel.write(this.writeBuffer);
    }

    class BufferOutputStream
    extends OutputStream {
        BufferOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.flush();
        }

        @Override
        public void write(int b) throws IOException {
            if (!TCPSocketChannel.this.writeBuffer.hasRemaining()) {
                this.flush();
            }
            TCPSocketChannel.this.writeBuffer.put((byte)b);
        }

        @Override
        public void flush() throws IOException {
            TCPSocketChannel.this.writeBuffer.flip();
            while (TCPSocketChannel.this.writeBuffer.hasRemaining()) {
                int n = TCPSocketChannel.this.writeChannel();
                if (n == -1) {
                    throw new IOException("Connection closed");
                }
                if (n != 0) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TCPSocketChannel.this.writeBuffer.clear();
        }
    }

    class BufferInputStream
    extends InputStream {
        BufferInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (!TCPSocketChannel.this.readBuffer.hasRemaining()) {
                int readBytes;
                TCPSocketChannel.this.readBuffer.clear();
                while ((readBytes = TCPSocketChannel.this.readChannel()) <= 0) {
                    if (readBytes == -1) {
                        TCPSocketChannel.this.readBuffer.flip();
                        return -1;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                TCPSocketChannel.this.readBuffer.flip();
            }
            return 0xFF & TCPSocketChannel.this.readBuffer.get();
        }
    }
}

