/*
 * Decompiled with CFR 0.152.
 */
package com.smile.net;

import com.smile.net.TCPSocketChannel;
import com.smile.security.TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import smile.util.ResourceStore;

public class TLSSocketChannel
extends TCPSocketChannel {
    public static final String[] CIPHERSUITES = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA"};
    private SSLEngine engine;
    private ByteBuffer wrapBuffer;
    private ByteBuffer unwrapBuffer;
    private SSLEngineResult.HandshakeStatus handshakeStatus;

    public TLSSocketChannel(InetSocketAddress remote, int timeout) throws Exception {
        super(remote, timeout);
    }

    public void createEngine(String remoteAddress) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager trustManager = new TrustManager(InetAddress.getByName(remoteAddress));
        javax.net.ssl.TrustManager[] trustManagers = new javax.net.ssl.TrustManager[]{trustManager};
        context.init(null, trustManagers, null);
        this.engine = context.createSSLEngine();
        this.engine.setUseClientMode(true);
        int psize = this.engine.getSession().getPacketBufferSize();
        this.wrapBuffer = ByteBuffer.allocate(psize);
        this.unwrapBuffer = ByteBuffer.allocate(psize);
        int asize = this.engine.getSession().getApplicationBufferSize();
        this.readBuffer = ByteBuffer.allocate(asize * 2);
        this.readBuffer.flip();
        this.writeBuffer = ByteBuffer.allocate(asize);
    }

    @Override
    protected int readChannel() throws IOException {
        if (this.engine == null) {
            return super.readChannel();
        }
        int n = this.unwrap(this.readBuffer);
        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshakeStatus = this.processHandshake();
        }
        return n;
    }

    private int unwrap(ByteBuffer dst) throws IOException {
        this.unwrapBuffer.flip();
        if (!this.unwrapBuffer.hasRemaining()) {
            this.unwrapBuffer.clear();
            int n = this.socketChannel.read(this.unwrapBuffer);
            if (n <= 0) {
                return n;
            }
            this.unwrapBuffer.flip();
        }
        int r = 0;
        while (this.unwrapBuffer.hasRemaining()) {
            SSLEngineResult result = this.engine.unwrap(this.unwrapBuffer, dst);
            r += result.bytesProduced();
            this.handshakeStatus = result.getHandshakeStatus();
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    this.unwrapBuffer.compact();
                    return r;
                }
                case BUFFER_UNDERFLOW: {
                    this.unwrapBuffer.compact();
                    if (dst.position() == dst.capacity()) {
                        return r;
                    }
                    if (this.socketChannel.read(this.unwrapBuffer) <= 0) {
                        return r;
                    }
                    this.unwrapBuffer.flip();
                    break;
                }
                case CLOSED: {
                    throw new IOException("readChannel: SSLEngine closed");
                }
            }
            if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            this.engine.getDelegatedTask().run();
        }
        this.unwrapBuffer.clear();
        return r;
    }

    @Override
    protected int writeChannel() throws IOException {
        if (this.engine == null) {
            return super.writeChannel();
        }
        SSLEngineResult result = this.wrap(this.writeBuffer);
        this.handshakeStatus = result.getHandshakeStatus();
        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshakeStatus = this.processHandshake();
        }
        return result.bytesConsumed();
    }

    private SSLEngineResult wrap(ByteBuffer src) throws IOException {
        this.wrapBuffer.clear();
        SSLEngineResult result = this.engine.wrap(src, this.wrapBuffer);
        this.wrapBuffer.flip();
        if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
            throw new IOException("SSLEngine closed on wrap");
        }
        while (this.wrapBuffer.hasRemaining()) {
            int n = this.socketChannel.write(this.wrapBuffer);
            if (n == -1) {
                throw new IOException("Connection closed");
            }
            if (n != 0) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return result;
    }

    private SSLEngineResult.HandshakeStatus processHandshake() throws IOException {
        ByteBuffer tmp;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable = this.engine.getDelegatedTask();
            runnable.run();
            this.handshakeStatus = this.engine.getHandshakeStatus();
        }
        int i = 0;
        while (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && i++ < 100) {
            tmp = ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize());
            int result = this.unwrap(tmp);
            if (result == -1) {
                throw new IOException("Connection closed");
            }
            if (result != 0) continue;
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            throw new IOException("TLS Handshake error");
        }
        while (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            tmp = ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize());
            tmp.flip();
            SSLEngineResult result = this.wrap(tmp);
            this.handshakeStatus = result.getHandshakeStatus();
        }
        ResourceStore.toLog(this + " processHandshake: handshakeStatus=" + this.handshakeStatus);
        return this.handshakeStatus;
    }
}

