/*
 * Decompiled with CFR 0.152.
 */
package com.smile.sound;

import com.smile.sound.WavAudioFormat;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class wavFormatHeader {
    private int wavType = 0;
    private double sampleRate = -1.0;
    private int sampleSizeInBits = -1;
    private int channels = -1;
    private int dataLength = -1;
    static final byte[] G7231_CHUNK = new byte[]{28, 0, 0, 0, 66, 0, 1, 0, 64, 31, 0, 0, 32, 3, 0, 0, 24, 0, 0, 0, 10, 0, 2, 0, -50, -102, 50, -9, -94, -82, -34, -84};
    static final byte[] TRUESPEECH_CHUNK = new byte[]{50, 0, 0, 0, 34, 0, 1, 0, 64, 31, 0, 0, 43, 4, 0, 0, 32, 0, 1, 0, 32, 0, 1, 0, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] G729_CHUNK = new byte[]{28, 0, 0, 0, 73, 0, 1, 0, 64, 31, 0, 0, -24, 3, 0, 0, 73, 0, 0, 0, 10, 0, 2, 0, -50, -102, 50, -9, -94, -82, -34, -84};
    static final byte[] MS_GSM610_CHUNK = new byte[]{20, 0, 0, 0, 49, 0, 1, 0, 64, 31, 0, 0, 89, 6, 0, 0, 65, 0, 0, 0, 2, 0, 64, 1};
    static final byte[] GSM610_CHUNK = new byte[]{20, 0, 0, 0, 50, 0, 1, 0, 64, 31, 0, 0, 89, 6, 0, 0, 65, 0, 0, 0, 2, 0, 64, 1};

    public wavFormatHeader() {
    }

    public wavFormatHeader(WavAudioFormat format) {
        this.wavType = wavFormatHeader.fromAudioFormat(format.getFormat());
        this.sampleRate = format.getSRate();
        this.channels = format.getChans();
        this.sampleSizeInBits = format.equals(WavAudioFormat.PCM_LINEAR16) ? 16 : format.getBitPerSample();
    }

    public WavAudioFormat getAudioFormat() {
        return new WavAudioFormat((int)this.sampleRate, this.channels, 2, wavFormatHeader.toAudioFormat(this.wavType, this.sampleSizeInBits));
    }

    public int getWavType() {
        return this.wavType;
    }

    public void setWavType(int type) {
        this.wavType = type;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(double rate) {
        this.sampleRate = rate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public void setSampleSizeInBits(int size) {
        this.sampleSizeInBits = size;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int ch) {
        this.channels = ch;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public boolean equals(Object o) {
        try {
            wavFormatHeader test = (wavFormatHeader)o;
            return test.getWavType() == this.wavType && test.getSampleRate() == this.sampleRate && test.getSampleSizeInBits() == this.sampleSizeInBits && test.getChannels() == this.channels;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(buffer);
        try {
            data.writeInt(1380533830);
            data.writeInt(-1);
            data.writeInt(1463899717);
            data.writeInt(1718449184);
            int avgBytesPerSec = this.channels * this.sampleSizeInBits * (int)this.sampleRate / 8;
            short blockAlign = (short)(this.sampleSizeInBits / 8 * this.channels);
            switch (this.wavType) {
                case 34: {
                    data.write(TRUESPEECH_CHUNK, 0, TRUESPEECH_CHUNK.length);
                    avgBytesPerSec = 1067;
                    break;
                }
                case 66: {
                    data.write(G7231_CHUNK, 0, G7231_CHUNK.length);
                    avgBytesPerSec = 800;
                    break;
                }
                case 73: {
                    data.write(G729_CHUNK, 0, G729_CHUNK.length);
                    avgBytesPerSec = 1000;
                    break;
                }
                case 49: {
                    data.write(MS_GSM610_CHUNK, 0, MS_GSM610_CHUNK.length);
                    avgBytesPerSec = 1625;
                    break;
                }
                case 50: {
                    data.write(GSM610_CHUNK, 0, GSM610_CHUNK.length);
                    avgBytesPerSec = 1635;
                    break;
                }
                default: {
                    int fmtLength = 18;
                    data.writeInt(this.big2little(fmtLength));
                    data.writeShort(this.big2littleShort((short)this.wavType));
                    data.writeShort(this.big2littleShort((short)this.channels));
                    data.writeInt(this.big2little((short)this.sampleRate));
                    data.writeInt(this.big2little(avgBytesPerSec));
                    data.writeShort(this.big2littleShort(blockAlign));
                    data.writeShort(this.big2littleShort((short)this.sampleSizeInBits));
                    data.writeShort(0);
                }
            }
            data.writeInt(1717658484);
            data.writeInt(0x4000000);
            int numberOfSamples = (int)((double)this.dataLength * this.sampleRate / (double)avgBytesPerSec);
            data.writeInt(this.big2little(numberOfSamples));
            data.writeInt(1684108385);
            data.writeInt(this.big2little(this.dataLength));
            data.flush();
            data.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] header = buffer.toByteArray();
        if (this.dataLength != -1) {
            int tlength = this.dataLength + header.length - 8;
            header[4] = (byte)(tlength & 0xFF);
            header[5] = (byte)((tlength & 0xFF00) >> 8);
            header[6] = (byte)((tlength & 0xFF0000) >> 16);
            header[7] = (byte)((tlength & 0xFF000000) >> 24);
        }
        return header;
    }

    public static void updateHeader(byte[] wavimage) {
        int fmsize = wavimage[16] & 0xFF | wavimage[17] << 8 & 0xFF00 | wavimage[18] << 16 & 0xFF0000 | wavimage[19] << 24 & 0xFF000000;
        int hdrsize = 20 + fmsize + 20;
        int dlength = wavimage.length - hdrsize;
        int tlength = wavimage.length - 8;
        int fmtype = wavimage[20] & 0xFF | wavimage[21] << 8 & 0xFF00;
        int srate = wavimage[24] & 0xFF | wavimage[25] << 8 & 0xFF00 | wavimage[26] << 16 & 0xFF0000 | wavimage[27] << 24 & 0xFF000000;
        int fmbps = wavimage[28] & 0xFF | wavimage[29] << 8 & 0xFF00 | wavimage[30] << 16 & 0xFF0000 | wavimage[31] << 24 & 0xFF000000;
        int rlength = dlength / fmbps * srate;
        wavimage[4] = (byte)(tlength & 0xFF);
        wavimage[5] = (byte)((tlength & 0xFF00) >> 8);
        wavimage[6] = (byte)((tlength & 0xFF0000) >> 16);
        wavimage[7] = (byte)((tlength & 0xFF000000) >> 24);
        int n = 20 + fmsize + 8;
        wavimage[n] = (byte)(rlength & 0xFF);
        wavimage[n + 1] = (byte)((rlength & 0xFF00) >> 8);
        wavimage[n + 2] = (byte)((rlength & 0xFF0000) >> 16);
        wavimage[n + 3] = (byte)((rlength & 0xFF000000) >> 24);
        wavimage[n += 8] = (byte)(dlength & 0xFF);
        wavimage[n + 1] = (byte)((dlength & 0xFF00) >> 8);
        wavimage[n + 2] = (byte)((dlength & 0xFF0000) >> 16);
        wavimage[n + 3] = (byte)((dlength & 0xFF000000) >> 24);
    }

    public static void updateHeader(File recordingFile) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(recordingFile, "rw");
        raf.seek(16L);
        int fmsize = raf.readByte() & 0xFF | raf.readByte() << 8 & 0xFF00 | raf.readByte() << 16 & 0xFF0000 | raf.readByte() << 24 & 0xFF000000;
        int hdrsize = 20 + fmsize + 20;
        int dlength = (int)raf.length() - hdrsize;
        int tlength = (int)raf.length() - 8;
        int fmtype = raf.readByte() & 0xFF | raf.readByte() << 8 & 0xFF00;
        raf.skipBytes(2);
        int srate = raf.readByte() & 0xFF | raf.readByte() << 8 & 0xFF00 | raf.readByte() << 16 & 0xFF0000 | raf.readByte() << 24 & 0xFF000000;
        int fmbps = raf.readByte() & 0xFF | raf.readByte() << 8 & 0xFF00 | raf.readByte() << 16 & 0xFF0000 | raf.readByte() << 24 & 0xFF000000;
        int rlength = dlength / fmbps * srate;
        raf.seek(4L);
        raf.writeByte(tlength & 0xFF);
        raf.writeByte((tlength & 0xFF00) >> 8);
        raf.writeByte((tlength & 0xFF0000) >> 16);
        raf.writeByte((tlength & 0xFF000000) >> 24);
        int n = 20 + fmsize + 8;
        raf.seek(n);
        raf.writeByte(rlength & 0xFF);
        raf.writeByte((rlength & 0xFF00) >> 8);
        raf.writeByte((rlength & 0xFF0000) >> 16);
        raf.writeByte((rlength & 0xFF000000) >> 24);
        raf.skipBytes(4);
        raf.writeByte(dlength & 0xFF);
        raf.writeByte((dlength & 0xFF00) >> 8);
        raf.writeByte((dlength & 0xFF0000) >> 16);
        raf.writeByte((dlength & 0xFF000000) >> 24);
        raf.close();
    }

    protected int big2little(int i) {
        int b1 = (i & 0xFF) << 24;
        int b2 = (i & 0xFF00) << 8;
        int b3 = (i & 0xFF0000) >> 8;
        int b4 = (i & 0xFF000000) >>> 24;
        i = b1 | b2 | b3 | b4;
        return i;
    }

    protected short big2littleShort(short i) {
        short high = (short)((i & 0xFF) << 8);
        short low = (short)((i & 0xFF00) >>> 8);
        i = (short)(high | low);
        return i;
    }

    public static int fromAudioFormat(int format) {
        switch (format) {
            case 3: 
            case 7: 
            case 10: {
                return 1;
            }
            case 2: {
                return 7;
            }
            case 6: {
                return 6;
            }
            case 23: {
                return 23;
            }
            case 66: {
                return 66;
            }
            case 50: {
                return 50;
            }
            case 49: {
                return 49;
            }
            case 73: {
                return 73;
            }
        }
        return format;
    }

    public static int toAudioFormat(int format, int bitPerSample) {
        switch (format) {
            case 1: {
                if (bitPerSample == 8) {
                    return 7;
                }
                return 10;
            }
            case 7: {
                return 2;
            }
            case 6: {
                return 6;
            }
            case 23: {
                return 23;
            }
            case 66: {
                return 66;
            }
            case 50: {
                return 50;
            }
            case 49: {
                return 49;
            }
            case 73: {
                return 73;
            }
        }
        return format;
    }
}

