/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.sound.WavAudioFormat;
import com.smile.telephony.Resource;
import com.smile.telephony.RouteSocket;
import java.io.Serializable;
import java.util.Map;

public class AudioCodec
implements Serializable,
Resource {
    public static final AudioCodec TRUESPEECH85 = new AudioCodec(0, 8000, 32, 30);
    public static final AudioCodec TRUESPEECH63 = new AudioCodec(1, 8000, 24, 30);
    public static final AudioCodec TRUESPEECH53 = new AudioCodec(2, 8000, 20, 30);
    public static final AudioCodec TRUESPEECH48 = new AudioCodec(3, 8000, 18, 30);
    public static final AudioCodec TRUESPEECH41 = new AudioCodec(4, 8000, 16, 30);
    public static final AudioCodec G728 = new AudioCodec(6, 8000, 96, 30);
    public static final AudioCodec G729A = new AudioCodec(12, 8000, 10, 10);
    public static final AudioCodec PCM16LINEAR = new AudioCodec(11, 8000, 160, 10);
    public static final AudioCodec PCM8WSS = new AudioCodec(7, 8000, 80, 10);
    public static final AudioCodec PCM8 = new AudioCodec(8, 8000, 80, 10);
    public static final AudioCodec ULAW = new AudioCodec(9, 8000, 80, 10);
    public static final AudioCodec ALAW = new AudioCodec(5, 8000, 80, 10);
    public static final AudioCodec PCM11 = new AudioCodec(14, 11025, 240, 30);
    public static final AudioCodec MSGSM = new AudioCodec(49, 8000, 65, 40);
    public static final AudioCodec GSM610 = new AudioCodec(50, 8000, 33, 20);
    public static final AudioCodec T38TCP = new AudioCodec(97, 14400, 240, 30);
    public static final AudioCodec T38UDP = new AudioCodec(98, 14400, 240, 30);
    public static final AudioCodec OPUSNB = new AudioCodec(110, 48000, 160, 10);
    public static final AudioCodec OPUSWB = new AudioCodec(111, 48000, 320, 10);
    public static final AudioCodec PCM16LINEAR_A = new AudioCodec(10, 8000, 160, 10);
    public static final int DECODER = 0;
    public static final int ENCODER = 1;
    public static final int BOTH = 2;
    private int id;
    private int khz;
    private int frame_size;
    private int frame_time;
    private int payload_type;
    private int depth = 1;
    private Map params;
    protected int state = 0;

    public static AudioCodec getAudioCodec(WavAudioFormat wcodec) {
        if (wcodec.equals(WavAudioFormat.PCM_LINEAR16)) {
            return new AudioCodec(PCM16LINEAR);
        }
        if (wcodec.equals(WavAudioFormat.PCM_LINEAR8)) {
            return new AudioCodec(PCM8);
        }
        if (wcodec.equals(WavAudioFormat.PCM_8KHZ)) {
            return new AudioCodec(PCM8WSS);
        }
        if (wcodec.equals(WavAudioFormat.PCM8_ALAW)) {
            return new AudioCodec(ALAW);
        }
        if (wcodec.equals(WavAudioFormat.PCM8_ULAW)) {
            return new AudioCodec(ULAW);
        }
        if (wcodec.equals(WavAudioFormat.TRUESPEECH)) {
            return new AudioCodec(TRUESPEECH85);
        }
        if (wcodec.equals(WavAudioFormat.G7231)) {
            return new AudioCodec(TRUESPEECH53);
        }
        if (wcodec.equals(WavAudioFormat.GSM610)) {
            return new AudioCodec(GSM610);
        }
        if (wcodec.equals(WavAudioFormat.MSGSM)) {
            return new AudioCodec(MSGSM);
        }
        if (wcodec.equals(WavAudioFormat.G729)) {
            return new AudioCodec(G729A);
        }
        if (wcodec.equals(WavAudioFormat.OPUSNB)) {
            return new AudioCodec(OPUSNB);
        }
        if (wcodec.equals(WavAudioFormat.OPUSWB)) {
            return new AudioCodec(OPUSWB);
        }
        return null;
    }

    public static WavAudioFormat getWavAudioFormat(AudioCodec codec) {
        if (codec.equals(PCM16LINEAR)) {
            return WavAudioFormat.PCM_LINEAR16;
        }
        if (codec.equals(PCM8)) {
            return WavAudioFormat.PCM_LINEAR8;
        }
        if (codec.equals(PCM8WSS)) {
            return WavAudioFormat.PCM_8KHZ;
        }
        if (codec.equals(ALAW)) {
            return WavAudioFormat.PCM8_ALAW;
        }
        if (codec.equals(ULAW)) {
            return WavAudioFormat.PCM8_ULAW;
        }
        if (codec.equals(TRUESPEECH85)) {
            return WavAudioFormat.TRUESPEECH;
        }
        if (codec.equals(TRUESPEECH63)) {
            return WavAudioFormat.G7231;
        }
        if (codec.equals(TRUESPEECH53)) {
            return WavAudioFormat.G7231;
        }
        if (codec.equals(GSM610)) {
            return WavAudioFormat.GSM610;
        }
        if (codec.equals(MSGSM)) {
            return WavAudioFormat.MSGSM;
        }
        if (codec.equals(G729A)) {
            return WavAudioFormat.G729;
        }
        if (codec.equals(OPUSNB)) {
            return WavAudioFormat.OPUSNB;
        }
        if (codec.equals(OPUSWB)) {
            return WavAudioFormat.OPUSWB;
        }
        return null;
    }

    public static AudioCodec getAudioCodec(int codecID) {
        switch (codecID) {
            case 0: {
                return new AudioCodec(TRUESPEECH85);
            }
            case 1: {
                return new AudioCodec(TRUESPEECH63);
            }
            case 2: {
                return new AudioCodec(TRUESPEECH53);
            }
            case 3: {
                return new AudioCodec(TRUESPEECH48);
            }
            case 4: {
                return new AudioCodec(TRUESPEECH41);
            }
            case 5: {
                return new AudioCodec(ALAW);
            }
            case 6: {
                return new AudioCodec(G728);
            }
            case 7: {
                return new AudioCodec(PCM8WSS);
            }
            case 8: {
                return new AudioCodec(PCM8);
            }
            case 9: {
                return new AudioCodec(ULAW);
            }
            case 10: {
                return new AudioCodec(PCM16LINEAR_A);
            }
            case 11: {
                return new AudioCodec(PCM16LINEAR);
            }
            case 12: {
                return new AudioCodec(G729A);
            }
            case 14: {
                return new AudioCodec(PCM11);
            }
            case 49: {
                return new AudioCodec(MSGSM);
            }
            case 50: {
                return new AudioCodec(GSM610);
            }
            case 97: {
                return new AudioCodec(T38TCP);
            }
            case 98: {
                return new AudioCodec(T38UDP);
            }
            case 110: {
                return new AudioCodec(OPUSNB);
            }
            case 111: {
                return new AudioCodec(OPUSWB);
            }
        }
        return null;
    }

    public AudioCodec(int id, int khz, int frame_size, int frame_time) {
        this.id = id;
        this.khz = khz;
        this.frame_size = frame_size;
        this.frame_time = frame_time;
        this.payload_type = this.getRTPPayloadType();
    }

    public AudioCodec(AudioCodec codec) {
        this(codec.getId(), codec.getKhz(), codec.getFrameSize(), codec.getFrameTime());
    }

    @Override
    public String getName() {
        switch (this.id) {
            case 0: {
                return "DSPGroup TrueSpeech 8,5 Kbps";
            }
            case 1: {
                return "ITU-T G.723.1 6,3 Kbps";
            }
            case 2: {
                return "ITU-T G.723.1 5,3 Kbps";
            }
            case 3: {
                return "DSPGroup TrueSpeech 4,8 Kbps";
            }
            case 4: {
                return "DSPGroup TrueSpeech 4,1 Kbps";
            }
            case 5: {
                return "ITU-T G.711 a-Law ";
            }
            case 6: {
                return "ITU G.728 16 Kbps LD-CELP";
            }
            case 7: {
                return "PCM 8KHz Windows Standart";
            }
            case 8: {
                return "PCM 8KHz 8 bit linear";
            }
            case 9: {
                return "ITU-T G.711 u-Law ";
            }
            case 10: {
                return "PCM 8KHz 16 bit linear with AGC";
            }
            case 11: {
                return "PCM 8KHz 16 bit linear";
            }
            case 12: {
                return "ITU-T G.729";
            }
            case 14: {
                return "PCM 11KHz";
            }
            case 49: {
                return "Microsoft GSM";
            }
            case 50: {
                return "GSM 6.10";
            }
            case 97: {
                return "T38 fax TCP";
            }
            case 98: {
                return "T38 fax UDP";
            }
            case 110: {
                return "Opus 8000";
            }
            case 111: {
                return "Opus 16000";
            }
        }
        return "Unknown";
    }

    private int getRTPPayloadType() {
        switch (this.id) {
            case 1: 
            case 2: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 15;
            }
            case 9: {
                return 0;
            }
            case 12: {
                return 18;
            }
            case 49: {
                return 3;
            }
            case 97: 
            case 98: {
                return 256;
            }
        }
        return this.id;
    }

    public void setPayloadType(int ptype) {
        this.payload_type = ptype;
    }

    public int getPayloadType() {
        return this.payload_type;
    }

    public void setBufferDepth(int depth) {
        this.depth = depth;
    }

    public int getBufferDepth() {
        return this.depth;
    }

    public int getId() {
        return this.id;
    }

    public int getKhz() {
        return this.khz;
    }

    public int getFrameSize() {
        return this.frame_size;
    }

    public int getFrameTime() {
        return this.frame_time;
    }

    public int getFrameSize(int fpp) {
        return this.frame_size * fpp;
    }

    public int getFrameTime(int fpp) {
        return this.frame_time * fpp;
    }

    public boolean equals(AudioCodec codec) {
        if (codec == null) {
            return false;
        }
        return this.id == codec.id || this.id == 1 && codec.id == 2 || this.id == 2 && codec.id == 1;
    }

    public int encode(byte[] input, byte[] output) {
        return -1;
    }

    public int decode(byte[] input, byte[] output) {
        return -1;
    }

    @Override
    public RouteSocket getRouteSocket() {
        return null;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public synchronized boolean seize() {
        if (this.state != 0) {
            return false;
        }
        this.state = 1;
        return true;
    }

    @Override
    public void release() {
        this.state = 0;
    }

    public boolean seize(AudioCodec codec, int direction) {
        return codec.equals(this) && this.seize();
    }

    public boolean match(AudioCodec[] codecs) {
        for (int i = 0; i < codecs.length; ++i) {
            if (!this.equals(codecs[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isFax() {
        return this.id == 97 || this.id == 98;
    }

    public String toString() {
        return this.getName();
    }

    public Map getParameters() {
        return this.params;
    }

    public void setParameters(Map params) {
        this.params = params;
    }
}

