/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.enterprise.cti.portDriver;
import com.smile.sound.WavAudioFormat;
import com.smile.sound.WaveParser;
import com.smile.sound.wavFormatHeader;
import com.smile.telephony.AudioConverter;
import com.smile.telephony.CallInfo;
import com.smile.telephony.CyclePlaybackStream;
import com.smile.telephony.DisconnectListener;
import com.smile.telephony.Mixer;
import com.smile.telephony.MulticastSocket;
import com.smile.telephony.PipeRecorder;
import com.smile.telephony.PipeSocket;
import com.smile.telephony.Port;
import com.smile.telephony.PortEventListener;
import com.smile.telephony.Resource;
import com.smile.telephony.ResourceManager;
import com.smile.telephony.RouteRequest;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.SoftPort;
import com.smile.telephony.codec.ConvertedOutputStream;
import com.smile.telephony.sip.SipPort;
import com.smile.telephony.video.VideoResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import smile.util.ResourceStore;

public class CTIPort
implements portDriver {
    private static final String PRP_DIR = System.getProperty("user.dir") + "/properties/port/";
    public static final String AUTOCONNECT = "***";
    public static final String SILENT = "**#";
    public static int activity_maxtime = Short.MAX_VALUE;
    public static int noanswer_timeout = 60;
    public static int routing_timeout = 1000;
    public static int switching_timeout = 1000;
    private Port port;
    private ResourceManager manager;
    private Hashtable properties;
    private PrintWriter prn;
    private OutputStream out;
    private String status = "";
    private DisconnectListener disconnectListener;
    private String calling_number = "";
    private String called_number = "";
    private String routing_number = "";
    private String fwd_number = "";
    private String connected_number;
    private String calling_user;
    private String applicationName = "";
    private String lastError = "";
    private String lastResult;
    private boolean started = false;
    private boolean incoming = false;
    private boolean onHook = true;
    private boolean disconnected = true;
    private boolean terminated = false;
    private boolean conference = false;
    private boolean recording = false;
    boolean accepted = false;
    boolean answered = false;
    boolean connecting = false;
    boolean picked = false;
    private int lastCause = 0;
    private int sessionTime = 0;
    private long lastConnect = 0L;
    private CTIPort routed_port = null;
    private Vector held_port = new Vector();
    private CallInfo call_info;
    private boolean visualcti;
    private String holdFile;
    private int icd = 0;
    private long timeEdge;
    private int pollInterval = 200;
    private long lastHold = 0L;
    String breakDigit = "";
    String digitsBuffer = "";
    String faxHeader = "";
    String faxLocalID = "";
    String faxRemoteID = "";
    int transferredPages = 0;
    Port connecting_port = null;
    private Hashtable sessionProperties = new Hashtable();
    private PortEventListener portEventListener;
    public static final String STATUS_STARTED = "started";
    public static final String STATUS_STOPPED = "stopped";
    public static final String STATUS_SEIZED = "seized";
    public static final String STATUS_RELEASED = "released";
    public static final String STATUS_MAKING_CALL = "making call";
    public static final String STATUS_WAITING_CALL = "waiting call";
    public static final String STATUS_CALL_OFFERED = "call arrived";
    public static final String STATUS_CALL_ACCEPTED = "call accepted";
    public static final String STATUS_CALL_ANSWERED = "call answered";
    public static final String STATUS_GETTING_DIGITS = "getting digits";
    public static final String STATUS_DIALING = "dialing";
    public static final String STATUS_RECORDING = "recording";
    public static final String STATUS_PLAYING = "playing";
    public static final String STATUS_PLAYING_TONE = "playing tone";
    public static final String STATUS_DISCONNECTED = "disconnected";
    public static final String STATUS_TERMINATED = "terminated";
    public static final String STATUS_ROUTING = "routing call";
    public static final String STATUS_ROUTED = "routed";
    public static final String STATUS_FAX_RX = "receiving fax";
    public static final String STATUS_FAX_TX = "sending fax";
    public static final String STATUS_WAITING = "waiting";
    public static final String STATUS_ON_HOLD = "on hold";
    public static final String STATUS_RESUMED = "resumed";
    public static final String STATUS_MAINTAINANCE = "maintainance";

    public CTIPort(Port port, ResourceManager manager) {
        this.port = port;
        this.manager = manager;
        this.visualcti = true;
        this.loadPortProperties();
    }

    ResourceManager getResourceManager() {
        return this.manager;
    }

    public CTIPort getPort(String portName) {
        return this.manager.getPortByLabel(portName);
    }

    public Port getPort() {
        return this.port;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOpened() {
        if (!this.started) return false;
        if (this.port.getStatus() != 1) return false;
        return true;
    }

    @Override
    public boolean isDisconnected() {
        return this.disconnected;
    }

    public boolean isIncomingCall() {
        return this.incoming;
    }

    @Override
    public String getPortName() {
        return this.port.getName();
    }

    @Override
    public String getPortStatus() {
        return this.status;
    }

    @Override
    public int getPortType() {
        return this.port.getPortType();
    }

    @Override
    public Object getLowLevelDriver() {
        return this.port;
    }

    public String getLastError() {
        return this.lastError;
    }

    public RouteSocket getRouteSocket() {
        return this.port.getRouteSocket();
    }

    @Override
    public boolean isRoutable() {
        return this.port.getRouteSocket() != null;
    }

    boolean isRoutable(CTIPort ctiport) {
        return this.isRoutable() && this.port.getRouteSocket().isRoutable(ctiport.port);
    }

    public String getPortErrorMessage() {
        return this.port.getErrorMessage();
    }

    public Hashtable getSessionProperties() {
        return this.sessionProperties;
    }

    public Object getSessionProperty(String pname) {
        return this.sessionProperties.get(pname);
    }

    public void setSessionProperty(String pname, Object pvalue) {
        this.sessionProperties.put(pname, pvalue);
    }

    public void setEndpointProperties(Hashtable props) {
        if (this.port instanceof SoftPort) {
            ((SoftPort)this.port).setEndpointProperties(props);
        }
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void setApplicationName(String n) {
        if (n != null && !n.startsWith("$transfer$")) {
            this.applicationName = n;
        }
    }

    public void setOriginationNumber(String number) {
        this.port.setOriginNumber(number);
        this.port.setDisplayName(this.calling_user);
    }

    public String getRoutingLabel() {
        String routingLabel = (String)this.getProperty("Internal routing number");
        return routingLabel != null ? routingLabel : this.getPortName();
    }

    @Override
    public void setPortStatusOutputStream(OutputStream stream) {
        this.prn = new PrintWriter(stream, true);
    }

    @Override
    public void setOutputStream(OutputStream stream) {
        this.out = stream;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int i) {
        this.pollInterval = i;
    }

    public void display(String mess) {
        if (this.out != null) {
            try {
                this.out.write(mess.getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setStatus(String string) {
        this.status = string;
        if (this.prn != null) {
            this.prn.println(this.status);
        }
    }

    public void setPortEventListener(PortEventListener listener) {
        this.portEventListener = listener;
        this.manager.addEventListener(this);
    }

    void processEvent(int event, RouteRequest request) {
        this.toLog("processEvent " + event + " request=" + request);
        this.setStatus(STATUS_SEIZED);
        if (request != null && event == 1) {
            event = request.process(this);
        }
        switch (event) {
            case 1: {
                this.setStatus(STATUS_CALL_OFFERED);
                this.incoming = true;
                this.disconnected = false;
                this.onHook = false;
                this.called_number = this.port.getCalledNumber();
                this.calling_number = this.port.getCallingNumber();
                this.port.proceed();
                break;
            }
            case 2: {
                this.disconnected = false;
                this.setDisconnectListener();
                this.answered = true;
                this.accepted = true;
                this.lastConnect = System.currentTimeMillis();
                this.setStatus(STATUS_ROUTED);
                break;
            }
            case 4: {
                this.disconnect(16);
            }
        }
        this.portEventListener.processEvent(event);
        this.setStatus(STATUS_RELEASED);
    }

    public void toLog(String string) {
        ResourceStore.toLog(this.getRoutingLabel() + ": " + string);
    }

    @Override
    public synchronized void start() throws IOException {
        this.openPort();
        this.toLog("Started");
    }

    @Override
    public void shutdown() {
    }

    @Override
    public synchronized boolean remount() {
        if (this.status.equals(STATUS_STOPPED)) {
            return false;
        }
        try {
            this.toLog("maintenance state");
            this.closePort();
            this.setStatus(STATUS_MAINTAINANCE);
            try {
                this.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.status.equals(STATUS_MAINTAINANCE)) {
                return false;
            }
            this.openPort();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized void stop() throws IOException {
        this.closePort();
        this.setStatus(STATUS_STOPPED);
        this.notifyAll();
        this.toLog("Stopped");
    }

    private void openPort() throws IOException {
        if (this.started) {
            return;
        }
        if (!this.port.open()) {
            throw new IOException(this.port.getErrorMessage());
        }
        this.setStatus(STATUS_STARTED);
        this.started = true;
        this.disconnected = true;
        this.onHook = true;
        this.answered = false;
        this.accepted = false;
        this.conference = false;
        this.timeEdge = System.currentTimeMillis();
        this.toLog("Port opened");
    }

    private void closePort() throws IOException {
        if (this.started) {
            this.close();
            this.port.close();
            this.started = false;
            this.toLog("Port closed");
        }
    }

    @Override
    public void open() throws IOException {
        if (!this.started || this.port.getStatus() == 0) {
            String err = this.port.getErrorMessage();
            if (err == null || err.length() == 0) {
                err = "Out of service";
            }
            this.toLog(err);
            throw new IOException(err);
        }
        this.setStatus(STATUS_SEIZED);
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
        this.setStatus(STATUS_RELEASED);
    }

    public void dropCall(int causeValue) {
        this.toLog("dropCall. Cause=" + causeValue);
        this.port.dropCall(causeValue);
        this.call_info = null;
    }

    public void disconnect() {
        int cause = 16;
        if (this.incoming && !this.disconnected && !this.answered) {
            cause = this.lastCause > 0 ? this.lastCause : (this.accepted ? 19 : 17);
        }
        this.disconnect(cause);
    }

    public void release(int causeValue) {
        this.onHook = false;
        this.disconnect(causeValue);
    }

    public void disconnect(int causeValue) {
        this.disconnect(causeValue, "");
    }

    @Override
    public void disconnect(int causeValue, String description) {
        this.disconnected = true;
        if (this.onHook) {
            return;
        }
        this.onHook = true;
        this.answered = false;
        this.accepted = false;
        this.removeDisconnectListener();
        this.toLog("Disconnect from application. Cause=" + causeValue);
        this.port.release();
        try {
            this.terminateConnections();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conference = false;
        this.routed_port = null;
        this.held_port.removeAllElements();
        this.port.dropCall(causeValue);
        this.manager.dropCall(this, causeValue, description);
        this.incoming = false;
        this.setStatus(STATUS_DISCONNECTED);
        this.toLog("Release resources");
        this.manager.releaseResources(this.port, true);
        this.sessionProperties.clear();
        this.digitsBuffer = "";
        this.breakDigit = "";
        this.terminated = false;
        this.connecting = false;
        this.picked = false;
        this.recording = false;
        this.routed_port = null;
        this.lastCause = 0;
        this.calling_number = "";
        this.called_number = "";
        this.connected_number = null;
        this.fwd_number = "";
        this.calling_user = null;
        this.routing_number = "";
        this.holdFile = null;
        this.applicationName = "";
        this.faxLocalID = "";
        this.lastResult = null;
        this.call_info = null;
        this.lastConnect = 0L;
        this.sessionTime = 0;
        this.lastHold = 0L;
        this.timeEdge = System.currentTimeMillis();
        this.toLog("------------------------------------------------------");
    }

    private void terminateConnections() {
        Object obj;
        int i2;
        this.toLog("terminateConnections routed_port=" + this.routed_port + " held_port=" + this.held_port + " conference=" + this.conference);
        Mixer mixer = null;
        if (this.conference) {
            mixer = (Mixer)this.port.getRouteSocket().findResource(32);
        } else {
            for (i2 = 0; i2 < this.held_port.size(); ++i2) {
                obj = this.held_port.elementAt(i2);
                if (!(obj instanceof Mixer)) continue;
                mixer = (Mixer)obj;
                break;
            }
        }
        if (mixer != null) {
            this.resumeWithMixer(mixer);
        } else {
            if (this.routed_port != null) {
                try {
                    this.routed_port.terminateConnection(this);
                }
                catch (Exception i2) {
                    // empty catch block
                }
            }
            for (i2 = 0; i2 < this.held_port.size(); ++i2) {
                obj = this.held_port.elementAt(i2);
                if (!(obj instanceof CTIPort)) continue;
                CTIPort cti2 = (CTIPort)obj;
                cti2.terminateConnection(this);
                if (this.routed_port == null) continue;
                try {
                    this.routed_port.route(cti2, 3);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void resumeWithMixer(Mixer mixer) {
        mixer.onResume(this);
        if (this.routed_port != null) {
            this.routed_port.terminateConnection(this);
            this.routed_port.conference = this.routed_port.port.getRouteSocket().route(mixer, 3);
        }
        for (int i = 0; i < this.held_port.size(); ++i) {
            Object obj = this.held_port.elementAt(i);
            if (!(obj instanceof CTIPort)) continue;
            CTIPort cti = (CTIPort)obj;
            cti.held_port.remove(this);
            cti.terminate();
            cti.routeToMixer(null, mixer, 3);
        }
        this.manager.releaseResource(this.getPort(), mixer);
        HashSet names = mixer.getRoutedNames();
        Vector holds = mixer.getHolds();
        this.toLog("releaseResources routed_port=" + this.routed_port + " held_port=" + this.held_port + " names=" + names + " holds=" + holds);
        if (names.size() == 0) {
            Enumeration en = holds.elements();
            while (en.hasMoreElements()) {
                CTIPort ct1 = (CTIPort)en.nextElement();
                ct1.terminate();
            }
        } else if (names.size() == 1 && !mixer.isManaged()) {
            CTIPort ct1 = this.manager.getPortByLabel((String)names.iterator().next());
            if (holds.isEmpty() && !this.held_port.contains(ct1)) {
                this.manager.releaseResource(ct1.getPort(), mixer);
                ct1.conference = false;
                ct1.terminate();
            }
        } else if (names.size() == 2 && !mixer.isManaged()) {
            Iterator it = names.iterator();
            CTIPort ct1 = this.manager.getPortByLabel((String)it.next());
            CTIPort ct2 = this.manager.getPortByLabel((String)it.next());
            this.manager.releaseResource(ct1.getPort(), mixer);
            ct1.conference = false;
            this.manager.releaseResource(ct2.getPort(), mixer);
            ct2.conference = false;
            ct1.route(ct2, 3);
        }
    }

    private void terminateConnection(CTIPort cti) {
        this.manager.unroute(this.port, cti.port);
        if (this.routed_port == cti) {
            this.routed_port = null;
        } else {
            this.held_port.removeElement(cti);
        }
        if (!this.connecting) {
            this.terminate();
        }
        this.toLog("Terminate connection from " + cti + "[" + cti.getPortName() + "] routed_port=" + (this.routed_port == null ? "null" : this.routed_port.getPortName()) + " hold=" + this.held_port);
    }

    public void stopCurrentOperation() {
        this.connecting = false;
        try {
            this.terminate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getCause() {
        return this.lastCause;
    }

    @Override
    public int getCause(String res) {
        if (res.equals("DISCONNECT")) {
            return 16;
        }
        if (res.equals("TERMINATION")) {
            return -1;
        }
        if (this.lastCause > 0) {
            return this.lastCause;
        }
        if (res.equals("BUSY")) {
            return this.port.getDisconnectCause();
        }
        if (res.equals("NO ANSWER")) {
            return 19;
        }
        if (res.equals("NO DIAL TONE")) {
            return -3;
        }
        if (res.equals("NOT AVAILABLE")) {
            return -4;
        }
        if (res.equals("NO RINGBACK")) {
            return 102;
        }
        if (res.equals("COMPATIBILITY")) {
            return 88;
        }
        if (res.equals("ERROR")) {
            return -1;
        }
        return 31;
    }

    public void setCause(int cause) {
        this.lastCause = cause;
    }

    public void setConnectionTime() {
        this.lastConnect = System.currentTimeMillis();
    }

    public int getConnectionTime() {
        return this.lastConnect != 0L ? (int)Math.round((double)(System.currentTimeMillis() - this.lastConnect) / 1000.0) : 0;
    }

    public int getSessionTime() {
        if (this.sessionTime == 0) {
            this.sessionTime = this.getConnectionTime();
        }
        return this.sessionTime;
    }

    synchronized void remoteDisconnect() {
        this.disconnected = true;
        this.lastCause = this.answered ? 16 : this.port.getDisconnectCause();
        this.sessionTime = this.getConnectionTime();
        this.toLog("Disconnect from line. cause=" + this.lastCause);
        this.port.release();
        this.notifyAll();
        this.setStatus(STATUS_DISCONNECTED);
    }

    public void setDisconnected() {
        this.disconnected = true;
        this.terminate();
    }

    @Override
    public void terminate() {
        this.setStatus(STATUS_TERMINATED);
        this.stopOperation(false);
        this.toLog("Stop operation");
    }

    private synchronized void stopOperation(boolean all) {
        this.terminated = true;
        this.manager.stopOperation(this.port, all);
        this.notifyAll();
    }

    @Override
    public String waitForCall(int rings, int timeout, boolean answer) {
        boolean routing;
        this.lastError = "";
        if (!this.started) {
            return "DISCONNECT";
        }
        this.setStatus(this.onHook ? STATUS_WAITING_CALL : STATUS_WAITING);
        int portType = this.port.getPortType();
        boolean inbound = (Boolean)this.getProperty("Use for inbound calls");
        boolean bl = routing = this.isRoutable() && (Boolean)this.getProperty("Use for outbound calls") != false;
        if (portType == 6) {
            boolean bl2 = routing = routing && System.currentTimeMillis() - this.timeEdge >= (long)this.icd;
        }
        if (inbound && this.onHook && rings > 0) {
            this.terminated = false;
            int result = this.manager.waitCall(this, timeout, true, routing);
            switch (result) {
                case 1: {
                    this.setStatus(STATUS_CALL_OFFERED);
                    this.incoming = true;
                    this.disconnected = false;
                    this.onHook = false;
                    if (this.visualcti) {
                        if (!(portType != 4 && portType != 7 || this.port.proceed())) {
                            this.lastCause = this.port.getDisconnectCause();
                            this.disconnect(this.lastCause);
                            return "DISCONNECT";
                        }
                        this.called_number = portType == 0 || portType == 1 ? "" : this.port.getCalledNumber();
                        this.calling_number = this.port.getCallingNumber();
                    }
                    if (answer || rings > 1 || portType == 1) {
                        if (!this.acceptCall(rings)) {
                            this.disconnect(42);
                            return "DISCONNECT";
                        }
                    } else if (!this.accepted) {
                        this.progressIncomingCall(1);
                    }
                    this.toLog("Incoming call. Called Number = " + this.called_number + " Calling Number = " + this.calling_number);
                    if (answer) {
                        if (!this.answerCall()) {
                            this.disconnect(42);
                            return "DISCONNECT";
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    return "RINGS";
                }
                case 2: {
                    if (this.onHook) {
                        return "DISCONNECT";
                    }
                    this.disconnected = false;
                    this.setDisconnectListener();
                    this.answered = true;
                    this.accepted = true;
                    this.lastConnect = System.currentTimeMillis();
                    this.setStatus(STATUS_ROUTED);
                    this.toLog("Connected as resource");
                    return "CONNECT";
                }
                case 4: {
                    this.disconnect(16);
                    return "DISCONNECT";
                }
                case 5: {
                    return "TERMINATION";
                }
                case -1: {
                    return "DISCONNECT";
                }
            }
            return "TIMEOUT";
        }
        if (routing && this.onHook) {
            int result = this.manager.waitCall(this, timeout, false, true);
            switch (result) {
                case 1: {
                    this.called_number = this.port.getCalledNumber();
                    this.calling_number = this.port.getCallingNumber();
                    if (portType == 1) {
                        this.port.answerCall(0);
                    }
                    this.disconnect(44);
                    return "DISCONNECT";
                }
                case 4: {
                    this.disconnect(31);
                    return "DISCONNECT";
                }
                case 2: {
                    if (this.onHook) {
                        return "DISCONNECT";
                    }
                    this.disconnected = false;
                    this.setDisconnectListener();
                    this.answered = true;
                    this.accepted = true;
                    this.lastConnect = System.currentTimeMillis();
                    this.toLog("Connected as resource");
                    this.setStatus(STATUS_ROUTED);
                    if (!answer && timeout == Short.MAX_VALUE) {
                        return this.waitForTermination(Integer.MAX_VALUE, true);
                    }
                    return "CONNECT";
                }
            }
            return "TIMEOUT";
        }
        if (!this.onHook && !this.answered) {
            if (!(this.accepted || !answer && rings <= 1 && portType != 1 || this.acceptCall(rings))) {
                return "DISCONNECT";
            }
            if (rings < 1 && timeout > 0) {
                this.waitForTermination(timeout * 1000, true);
            }
            if (answer && !this.answerCall()) {
                this.disconnect(42);
                return "DISCONNECT";
            }
            return rings < 1 && this.answered ? "CONNECT" : "RINGS";
        }
        if (this.answered && rings > 0) {
            return "RINGS";
        }
        if (inbound && rings > 0 && this.disconnected) {
            this.disconnect();
            return "DISCONNECT";
        }
        if (this.onHook) {
            return this.waitForTermination(timeout * 1000, false);
        }
        return this.waitForDisconnect(timeout);
    }

    protected synchronized String waitForTermination(long timeout, boolean waitfordisc) {
        long starttime;
        if (this.terminated) {
            this.terminated = false;
            return "TERMINATION";
        }
        if (waitfordisc && this.disconnected) {
            return "DISCONNECT";
        }
        do {
            starttime = System.currentTimeMillis();
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (waitfordisc && this.disconnected) {
                return "DISCONNECT";
            }
            if (!this.terminated) continue;
            this.terminated = false;
            if (this.status.equals(STATUS_ON_HOLD)) {
                return "HOLD";
            }
            if (this.status.equals(STATUS_RESUMED)) {
                return "RESUME";
            }
            return "TERMINATION";
        } while ((timeout -= System.currentTimeMillis() - starttime) > 0L);
        return "TIMEOUT";
    }

    protected String waitForDisconnect(int timeout) {
        return this.waitForTermination(timeout * 1000, true);
    }

    public String collectDigits() {
        String result = this.playTone("Dial Tone", "1,2,3,4,5,6,7,8,9,0,*,#", 10);
        if (!result.equals("DTMF")) {
            return "";
        }
        this.getDigits(20, 10, "#");
        return this.getDigitsBuffer();
    }

    public String collectDigits(int maxdigits, int timeout, String termmask) {
        if (!this.answered) {
            this.port.acceptCall(0);
            if (!this.port.answerCall(0)) {
                return "";
            }
            this.accepted = true;
            this.answered = true;
            this.lastConnect = System.currentTimeMillis();
            this.setStatus(STATUS_CALL_ANSWERED);
            this.setDisconnectListener();
            String result = this.playTone("Dial Tone", "1,2,3,4,5,6,7,8,9,0,*,#", timeout);
            if (!result.equals("DTMF")) {
                return "";
            }
        }
        this.getDigits(maxdigits, timeout, termmask);
        return this.getDigitsBuffer();
    }

    public boolean proceedCall() {
        if (!this.port.proceed()) {
            return false;
        }
        this.onHook = false;
        this.disconnected = false;
        return true;
    }

    @Override
    public boolean acceptCall(int rings) {
        if (this.onHook) {
            return false;
        }
        if (this.answered) {
            return true;
        }
        this.accepted = this.manager.acceptCall(this, rings);
        if (!this.accepted) {
            this.toLog("Inbound call not accepted");
        } else {
            if (this.onHook) {
                this.accepted = false;
                return false;
            }
            this.onHook = false;
            this.toLog("Inbound call accepted");
            this.setStatus(STATUS_CALL_ACCEPTED);
            if (this.port.getPortType() != 1) {
                this.setDisconnectListener();
            }
        }
        return this.accepted;
    }

    @Override
    public boolean answerCall() {
        if (this.onHook) {
            return false;
        }
        if (this.answered) {
            return true;
        }
        this.answered = this.manager.answerCall(this);
        if (!this.answered) {
            this.toLog("Error while answering inbound call");
        } else {
            if (this.onHook) {
                this.accepted = false;
                this.answered = false;
                return false;
            }
            this.toLog("Inbound call answered");
            this.onHook = false;
            this.accepted = true;
            this.lastConnect = System.currentTimeMillis();
            this.setStatus(STATUS_CALL_ANSWERED);
            this.setDisconnectListener();
        }
        return this.answered;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public boolean isAnswered() {
        return this.answered;
    }

    @Override
    public String getCallingNumber() {
        return this.calling_number;
    }

    @Override
    public String getCalledNumber() {
        return this.called_number;
    }

    @Override
    public String getConnectedNumber() {
        if (this.connected_number != null) {
            return this.connected_number;
        }
        return this.incoming ? this.calling_number : this.called_number;
    }

    public String getConnectedPartyNumber() {
        return this.port.getConnectedNumber();
    }

    public String getForwardedNumber() {
        return this.fwd_number;
    }

    public CallInfo getCallInfo() {
        if (this.call_info != null) {
            return this.call_info;
        }
        this.call_info = new CallInfo(this.getRoutingLabel());
        Hashtable portInfo = this.port.getCallInfo();
        if (portInfo == null) {
            return this.call_info;
        }
        this.call_info.setAttributes(portInfo);
        String calledNumber = this.port.getCalledNumber();
        if (calledNumber.length() == 0 && this.getPortType() == 4 && (calledNumber = (String)this.call_info.getAttribute("cti.CalledName")) == null) {
            calledNumber = "";
        }
        this.call_info.setCalledNumber(calledNumber);
        String callingNumber = this.port.getCallingNumber();
        if (callingNumber.length() == 0 && this.getPortType() == 4 && (callingNumber = (String)this.call_info.getAttribute("cti.CallingName")) == null) {
            callingNumber = "";
        }
        this.call_info.setCallingNumber(callingNumber);
        this.toLog("CallInfo: " + this.call_info);
        return this.call_info;
    }

    @Override
    public Hashtable getCallProperties() {
        Hashtable callProperties;
        Hashtable portInfo = this.port.getCallInfo();
        if (portInfo == null) {
            return new Hashtable();
        }
        if (this.call_info == null) {
            callProperties = portInfo;
        } else {
            callProperties = this.call_info.getAttributes();
            Enumeration en = portInfo.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                if (this.routed_port != null && callProperties.containsKey(key)) continue;
                callProperties.put(key, portInfo.get(key));
            }
        }
        if (this.routed_port != null) {
            callProperties.put("cti.CalledNumber2", this.routed_port.getCalledNumber());
            callProperties.put("cti.CallingNumber2", this.routed_port.getCallingNumber());
            Hashtable cp2 = this.routed_port.getPort().getCallInfo();
            Enumeration en = cp2.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                callProperties.put(key + "2", cp2.get(key));
            }
        }
        callProperties.put("cti.OffHook", this.answered);
        callProperties.put("cti.ConnectTimestamp", this.lastConnect);
        return callProperties;
    }

    public String getRoutingNumber() {
        return this.routing_number;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routing_number = routingNumber;
    }

    public void setCallingNumber(String callingNumber) {
        this.calling_number = callingNumber;
    }

    public void setCalledNumber(String calledNumber) {
        this.called_number = calledNumber;
    }

    public void setConnectedNumber(String number) {
        this.connected_number = number;
    }

    public void setForwardedNumber(String number) {
        this.fwd_number = number;
    }

    @Override
    public String makeCall(String number, int timeout, String callingNumber) {
        return this.makeCall(number, timeout, callingNumber, new CallInfo(this.getRoutingLabel()));
    }

    public String makeCall(String number, int timeout, String callingNumber, CallInfo info) {
        return this.makeCall(number, timeout, callingNumber, info, null);
    }

    public String makeCall(String number, int timeout, String callingNumber, CallInfo info, CTIPort routingPort) {
        Hashtable portInfo;
        if (!this.disconnected) {
            return "VOICE";
        }
        if (this.lastResult != null) {
            return this.lastResult;
        }
        if (!((Boolean)this.getProperty("Use for outbound calls")).booleanValue()) {
            return "NOT AVAILABLE";
        }
        this.terminated = false;
        this.onHook = false;
        this.setStatus(STATUS_MAKING_CALL);
        int n = callingNumber.indexOf(59);
        if (n != -1 && n < callingNumber.length() - 1) {
            this.calling_number = callingNumber.substring(0, n);
            this.calling_user = callingNumber.substring(n + 1);
        } else {
            this.calling_number = callingNumber;
            this.calling_user = null;
        }
        this.port.setOriginNumber(this.calling_number);
        n = number.indexOf(124);
        this.called_number = n == -1 ? number : number.substring(0, n);
        this.toLog("makeCall: called=" + this.called_number + ", calling=" + callingNumber);
        if (routingPort == null) {
            this.call_info = info;
        }
        String result = this.manager.makeCall(this, number, timeout, info, routingPort);
        this.setStatus(result);
        if (result.equals("VOICE") || result.equals("FAX") || result.equals("ANSWERED")) {
            this.disconnected = false;
            this.setDisconnectListener();
            this.accepted = true;
            this.answered = true;
            if (this.lastConnect == 0L) {
                this.lastConnect = System.currentTimeMillis();
            }
            if (result.equals("ANSWERED")) {
                if (routingPort == null) {
                    this.toLog("ProgressCallAnalyse start.");
                    result = this.progressCallAnalyse(timeout);
                    this.toLog("ProgressCallAnalyse result=" + result);
                } else {
                    result = "VOICE";
                }
            }
        } else if (this.port instanceof SipPort) {
            SipPort sip = (SipPort)this.port;
            this.setSessionProperty("call-disconnect-code", sip.getStatusCode());
            this.setSessionProperty("call-disconnect-description", sip.getReasonPhrase());
        } else if (result.equals("BUSY")) {
            this.setSessionProperty("call-disconnect-code", this.port.getDisconnectCause());
        }
        this.toLog("Outbound call to " + this.called_number + ". Result: " + result);
        if (result.equals("STOPPED") && routingPort != null) {
            result = "NO ANSWER";
        }
        if (this.calling_number.endsWith(AUTOCONNECT)) {
            this.calling_number = this.calling_number.substring(0, this.calling_number.length() - AUTOCONNECT.length());
        }
        if ((n = this.called_number.indexOf(64)) != -1) {
            this.called_number = this.called_number.substring(0, n);
        }
        this.lastResult = result;
        if (routingPort == null && this.call_info != null && (portInfo = this.port.getCallInfo()) != null) {
            Enumeration en = portInfo.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                this.call_info.setAttribute(key, portInfo.get(key));
            }
        }
        this.toLog("makeCall result=" + result + " calling_number=" + this.calling_number + " called_number=" + this.called_number);
        return result;
    }

    @Override
    public synchronized String getRoutedPortName() {
        Mixer mixer;
        if (this.routed_port != null) {
            return this.routed_port.getRoutingLabel();
        }
        if (this.conference && (mixer = (Mixer)this.port.getRouteSocket().findResource(32)) != null) {
            Iterator names = mixer.getRoutedNames().iterator();
            Object str = "";
            try {
                while (names.hasNext()) {
                    String name = (String)names.next();
                    if (name.equals(this.getPortName())) continue;
                    str = (String)str + name + " ";
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return ((String)str).trim();
        }
        return "";
    }

    public Mixer getMixer() {
        return this.conference ? (Mixer)this.port.getRouteSocket().findResource(32) : null;
    }

    public boolean isRouted() {
        if (!this.answered) {
            return false;
        }
        if (this.routed_port != null) {
            return true;
        }
        return this.conference;
    }

    public boolean hasHold() {
        return !this.held_port.isEmpty();
    }

    protected boolean needHoldRemind(int holdRemindTime) {
        if (this.held_port.isEmpty() || !this.isRouted()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if ((now - this.lastHold) / 1000L < (long)holdRemindTime) {
            return false;
        }
        this.lastHold = now;
        return true;
    }

    public Vector getHoldingPorts() {
        return this.held_port;
    }

    public CTIPort findRoutedPort(String label) {
        Mixer mixer;
        if (this.routed_port != null && label.equals(this.routed_port.getRoutingLabel())) {
            return this.routed_port;
        }
        if (this.conference && (mixer = (Mixer)this.port.getRouteSocket().findResource(32)) != null) {
            for (String name : mixer.getRoutedNames()) {
                if (!name.equals(label)) continue;
                return this.manager.getPortByLabel(name);
            }
        }
        Enumeration en = this.held_port.elements();
        while (en.hasMoreElements()) {
            Object obj = en.nextElement();
            if (obj instanceof CTIPort) {
                CTIPort cti = (CTIPort)obj;
                if (!label.equals(cti.getRoutingLabel())) continue;
                return cti;
            }
            if (!(obj instanceof Mixer)) continue;
            Mixer mixer2 = (Mixer)obj;
            for (String name : mixer2.getRoutedNames()) {
                if (!name.equals(label)) continue;
                return this.manager.getPortByLabel(name);
            }
        }
        return null;
    }

    public Vector getConferencePorts() {
        Mixer mixer;
        Vector<CTIPort> ports = new Vector<CTIPort>();
        if (this.conference && (mixer = (Mixer)this.port.getRouteSocket().findResource(32)) != null) {
            for (String name : mixer.getRoutedNames()) {
                CTIPort ctiport = this.manager.getPortByLabel(name);
                if (ctiport == null || ctiport == this) continue;
                ports.add(ctiport);
            }
        }
        return ports;
    }

    public boolean dropConnectedParty(String number) {
        Mixer mixer;
        if (this.routed_port != null) {
            if (number.equals(this.routed_port.getConnectedNumber())) {
                this.routed_port.disconnect();
                return true;
            }
        } else if (this.conference && (mixer = (Mixer)this.port.getRouteSocket().findResource(32)) != null) {
            for (String name : mixer.getRoutedNames()) {
                CTIPort ctiport = this.manager.getPortByLabel(name);
                if (ctiport == null || ctiport == this || !number.equals(ctiport.getConnectedNumber())) continue;
                ctiport.disconnect();
                return true;
            }
        }
        return false;
    }

    public CTIPort getRoutedPort() {
        return this.routed_port;
    }

    public CTIPort getRoutingPort() {
        return this.routed_port;
    }

    public String getRoutedPartyNumber() {
        if (this.routed_port != null) {
            return this.routed_port.getConnectedPartyNumber();
        }
        if (this.conference) {
            Object str = "";
            Enumeration en = this.getConferencePorts().elements();
            while (en.hasMoreElements()) {
                CTIPort port = (CTIPort)en.nextElement();
                if (port == this) continue;
                str = (String)str + port.getConnectedPartyNumber() + " ";
            }
            return str;
        }
        return this.called_number;
    }

    public Vector getRoutedPorts() {
        Vector<CTIPort> list = new Vector<CTIPort>();
        if (this.conference) {
            Enumeration en = this.getConferencePorts().elements();
            while (en.hasMoreElements()) {
                CTIPort port = (CTIPort)en.nextElement();
                if (port == this) continue;
                list.add(port);
            }
        } else if (this.routed_port != null) {
            list.add(this.routed_port);
        }
        return list;
    }

    public boolean inRoute() {
        return this.routed_port != null || this.conference;
    }

    public boolean inConference() {
        return this.conference;
    }

    public boolean inStandalone() {
        return !this.inRoute() && this.held_port.isEmpty();
    }

    public String progressCall(int timeout) {
        String res = this.manager.progressCall(this, timeout, false);
        if (res.equals("VOICE")) {
            this.disconnected = false;
        }
        this.toLog("progressCall result=" + res + " (t=" + timeout + ")");
        return res;
    }

    public String progressCallAnalyse(int timeout) {
        return this.manager.progressCallAnalyse(this.port, timeout);
    }

    public boolean progressIncomingCall(int progressDesc) {
        if (this.onHook || !this.port.progress(progressDesc)) {
            return false;
        }
        this.setDisconnectListener();
        return true;
    }

    void setDisconnectListener() {
        if (this.disconnectListener == null) {
            this.disconnectListener = new DisconnectListener(this, activity_maxtime);
            this.manager.addDisconnectListener(this.disconnectListener);
        }
    }

    private synchronized void removeDisconnectListener() {
        if (this.disconnectListener != null) {
            this.manager.removeDisconnectListener(this.disconnectListener);
            this.disconnectListener = null;
        }
        this.notifyAll();
    }

    public String connect(String number, int timeout, String filename, String termmask) {
        return this.connect(number, timeout, filename, termmask, "");
    }

    public String connect(String called, int timeout, String filename, String termmask, String calling) {
        return this.connect(called, timeout, filename, termmask, calling, "");
    }

    @Override
    public String connect(String called, int timeout, String playfile, String termmask, String calling, String resourceApplication) {
        if (!this.onHook && this.disconnected) {
            return "DISCONNECT";
        }
        this.onHook = false;
        this.disconnected = false;
        this.toLog("connecting to " + called + " calling=" + calling + " timeout=" + timeout + " ra=" + resourceApplication + " file=" + playfile + " mask=" + termmask + " routed_port=" + this.routed_port);
        String dialed_number = called;
        if (dialed_number == null || dialed_number.length() == 0) {
            try {
                this.terminateConnections();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.terminated = false;
            this.routed_port = null;
            this.conference = false;
            this.held_port.removeAllElements();
            return "TERMINATION";
        }
        if (dialed_number.equals(String.valueOf('|'))) {
            if (this.routed_port == null) {
                this.terminate();
            } else {
                this.routed_port.terminateConnection(this);
                this.routed_port = null;
            }
            this.terminated = false;
            return "TERMINATION";
        }
        String filename = playfile;
        if (dialed_number.startsWith(String.valueOf('!'))) {
            if (this.routed_port != null) {
                this.routed_port.holdFile = filename;
                filename = "";
            }
            if (dialed_number.length() == 1) {
                return this.swapConnection(filename) ? "VOICE" : "TERMINATION";
            }
            if (!this.holdConnection(filename)) {
                return "ERROR";
            }
            dialed_number = dialed_number.substring(1);
        } else if (this.routed_port != null && this.hasHold() && !dialed_number.startsWith(String.valueOf('^'))) {
            this.routed_port.holdFile = filename;
            filename = "";
            if (!this.holdConnection(filename)) {
                return "ERROR";
            }
        }
        boolean conf = dialed_number.endsWith(String.valueOf('^'));
        if (conf) {
            if (dialed_number.length() == 1) {
                return this.resumeConnection() ? "VOICE" : "TERMINATION";
            }
            dialed_number = dialed_number.substring(0, dialed_number.length() - 1);
        }
        this.setStatus(STATUS_ROUTING);
        CTIPort internal = this.manager.getPortByLabel(dialed_number);
        this.toLog("connecting to " + dialed_number + " internal=" + internal + " dis=" + (internal != null ? Boolean.valueOf(internal.isDisconnected()) : null) + " res=" + resourceApplication);
        if (internal != null && !internal.isDisconnected()) {
            Mixer mixer;
            int mode = 3;
            if ("$LISTEN$".equals(resourceApplication)) {
                mode = 1;
            } else if ("$NOLISTEN$".equals(resourceApplication)) {
                mode = 2;
            }
            String result = this.routeTo(internal, mode);
            if (result.equals("VOICE") && "$TARGET$".equals(resourceApplication) && (mixer = (Mixer)this.getRouteSocket().findResource(32)) != null) {
                Iterator names = mixer.getRoutedNames().iterator();
                while (names.hasNext()) {
                    CTIPort ctiPort = this.manager.getPortByLabel((String)names.next());
                    if (ctiPort == internal || ctiPort == this) continue;
                    mixer.setMute(this.getRouteSocket(), ctiPort.getRouteSocket());
                }
            }
            return result;
        }
        String result = this.manager.routeCall(this, dialed_number, timeout, filename, termmask, calling, resourceApplication, this.getCallInfo(), this.port.getProperties());
        this.toLog("Connection result=" + result + " cause=" + this.lastCause + " dis=" + this.disconnected);
        this.setStatus(result);
        if (result.equals("OK")) {
            return result;
        }
        if (this.disconnected) {
            return "DISCONNECT";
        }
        if (result.equals("DISCONNECT")) {
            this.disconnected = true;
        } else if (conf && result.equals("VOICE")) {
            this.resumeConnection();
        } else {
            this.terminated = false;
        }
        return result;
    }

    public boolean holdConnection(String file) {
        this.toLog("HOLD Connection: " + (this.routed_port == null ? "null" : this.routed_port.getPortName()) + " conference=" + this.conference + " file=" + file);
        if (this.routed_port != null && !this.routed_port.remoteHold()) {
            return false;
        }
        if (this.conference) {
            try {
                Mixer mixer = (Mixer)this.port.getRouteSocket().findResource(32);
                if (mixer.onHold(this, file) == 2) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.holdSocket(3);
    }

    private boolean remoteHold() {
        if (!this.holdSocket(3)) {
            return false;
        }
        this.setStatus(STATUS_ON_HOLD);
        this.stopOperation(false);
        this.port.hold();
        this.toLog("Set on hold");
        return true;
    }

    private boolean holdSocket(int mode) {
        Object obj;
        if (this.routed_port == null && !this.conference) {
            return true;
        }
        RouteSocket socket = this.port.getRouteSocket();
        if (socket == null) {
            return true;
        }
        this.toLog("HOLD " + (this.routed_port == null ? "null" : this.routed_port.getPortName()) + " conference=" + this.conference + "...");
        Object object = obj = this.conference ? socket.findResource(32) : this.routed_port;
        if (!socket.holdConnection(mode)) {
            return false;
        }
        this.held_port.addElement(obj);
        this.lastHold = System.currentTimeMillis();
        this.conference = false;
        this.routed_port = null;
        return true;
    }

    public synchronized boolean swapConnection(String file) {
        this.toLog("swapConnection held_port=" + this.held_port);
        Object resumed = null;
        try {
            resumed = this.held_port.lastElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (this.connecting) {
            this.stopCurrentOperation();
        } else if (!this.holdConnection(file)) {
            return false;
        }
        if (resumed == null) {
            return true;
        }
        if (resumed instanceof CTIPort) {
            if (!((CTIPort)resumed).remoteResume(this)) {
                this.held_port.removeElement(resumed);
                return false;
            }
        } else if (resumed instanceof Mixer) {
            ((Mixer)resumed).onResume(this);
        }
        return this.resumeSocket(resumed);
    }

    public synchronized boolean resumeConnection() {
        this.toLog("RESUME Connection: " + this.held_port);
        if (this.disconnected) {
            return false;
        }
        if (this.held_port.isEmpty()) {
            return true;
        }
        Object resumed = this.held_port.lastElement();
        if (resumed instanceof CTIPort) {
            if (!((CTIPort)resumed).remoteResume(this)) {
                this.held_port.removeElement(resumed);
                return false;
            }
        } else if (resumed instanceof Mixer) {
            ((Mixer)resumed).onResume(this);
        }
        return this.resumeSocket(resumed);
    }

    public synchronized boolean resumeConnection(String portName) {
        this.toLog("RESUME Connection: portName=" + portName);
        if (this.disconnected) {
            return false;
        }
        CTIPort cti = this.manager.getPortByName(portName);
        if (cti == null || !this.held_port.contains(cti)) {
            return true;
        }
        if (!cti.remoteResume(this)) {
            this.held_port.removeElement(cti);
            return false;
        }
        return this.resumeSocket(cti);
    }

    private boolean remoteResume(CTIPort cti) {
        this.toLog("Remote Resume port=" + cti);
        if (this.disconnected) {
            return false;
        }
        this.setStatus(STATUS_RESUMED);
        this.stopOperation(false);
        if (cti.inRoute()) {
            this.held_port.removeElement(cti);
        } else if (!this.resumeSocket(cti)) {
            this.setStatus(STATUS_TERMINATED);
            return false;
        }
        this.port.resume();
        this.toLog("Resume connection " + cti.getRoutingLabel());
        return true;
    }

    private boolean resumeSocket(Object resumed) {
        this.toLog("RESUME " + resumed + " conference=" + this.conference + " routed_port=" + this.routed_port);
        this.held_port.removeElement(resumed);
        boolean result = true;
        if (resumed instanceof CTIPort) {
            CTIPort cti = (CTIPort)resumed;
            if (this.routed_port != null || this.conference) {
                result = this.routeToMixer(cti, null, 3);
            } else {
                result = this.port.getRouteSocket().resumeConnection(cti.port);
                if (result) {
                    this.routed_port = cti;
                }
            }
        } else if (resumed instanceof Mixer) {
            if (this.conference) {
                return false;
            }
            Mixer mix = (Mixer)resumed;
            result = this.routed_port != null ? this.routeToMixer(null, mix, 3) : this.port.getRouteSocket().resumeConnection(mix);
            this.conference = result;
        }
        if (!result) {
            this.held_port.addElement(resumed);
        }
        this.toLog("RESUME result=" + result + " routed_port=" + this.routed_port + " conference=" + this.conference);
        return result;
    }

    private synchronized void resumeSocket() {
        if (this.held_port.isEmpty() || this.inRoute()) {
            return;
        }
        this.resumeSocket(this.held_port.lastElement());
    }

    private boolean canRoute(CTIPort cti) {
        while (!this.disconnected && !cti.disconnected) {
            if (this.routed_port != null || this.conference) {
                return true;
            }
            if (!this.connecting) {
                if (this.held_port.isEmpty()) {
                    this.terminate();
                }
                return true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public String routeTo(CTIPort cti, int mode) {
        if (!this.answered && !this.answerCall()) {
            this.setCause(111);
            return "ERROR";
        }
        if (cti == this) {
            return "VOICE";
        }
        if (!cti.canRoute(this)) {
            return "ERROR";
        }
        if (!cti.answered && !cti.answerCall()) {
            this.setCause(111);
            return "ERROR";
        }
        if (cti.route(this, mode)) {
            while (!cti.isDisconnected()) {
                if (!cti.connecting) {
                    return "VOICE";
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return "ERROR";
        }
        this.setCause(88);
        return "ERROR";
    }

    public boolean pickup(CTIPort cti) {
        this.toLog("pickup port " + cti.getRoutingLabel() + "connecting=" + this.connecting);
        if (!cti.accepted && !cti.acceptCall(0)) {
            return false;
        }
        if (!cti.answered && !cti.answerCall()) {
            return false;
        }
        if (!this.answered && !this.answerCall()) {
            return false;
        }
        this.picked = true;
        if (this.routed_port != null) {
            this.routed_port.terminate();
        }
        this.terminate();
        if (!this.route(cti, 3)) {
            return false;
        }
        this.connecting = false;
        return true;
    }

    public boolean retrieve(Object obj) {
        if (obj instanceof CTIPort) {
            CTIPort cti = (CTIPort)obj;
            cti.terminate();
            return this.route(cti, 3);
        }
        Mixer mixer = (Mixer)obj;
        return this.getRouteSocket().route(mixer, 3);
    }

    public boolean reRoute(boolean full) {
        this.toLog("reRoute routed_port=" + this.routed_port + " conference=" + this.conference + " held=" + this.held_port);
        if (this.conference) {
            Mixer mixer = (Mixer)this.getRouteSocket().findResource(32);
            Iterator names = mixer.getRoutedNames().iterator();
            while (names.hasNext()) {
                CTIPort cti = this.manager.getPortByLabel((String)names.next());
                RouteSocket socket = cti.getRouteSocket();
                if (socket.isRouted(mixer, 3)) continue;
                socket.route(mixer, 3);
                if (full) continue;
                mixer.setMute(socket, this.getRouteSocket());
            }
            if (full) {
                mixer.reRoute();
            }
            return true;
        }
        if (this.routed_port != null) {
            return this.manager.route(this.routed_port.port, this.port, 3);
        }
        return false;
    }

    public boolean route(CTIPort cti, String mode) {
        this.toLog("route cti=" + cti + " mode=" + mode);
        if ("SPKPHONE".equals(mode)) {
            if (!this.holdSocket(1)) {
                return false;
            }
            if (!this.route(cti, 1)) {
                this.resumeSocket();
                return false;
            }
        } else if ("$TARGET$".equals(mode)) {
            if (!this.route(cti, 1)) {
                return false;
            }
            Mixer mixer = (Mixer)this.getRouteSocket().findResource(32);
            if (mixer != null) {
                cti.getRouteSocket().route(mixer, 2);
                mixer.setMute(cti.getRouteSocket(), this.getRouteSocket());
            }
        } else if ("$LISTEN$".equals(mode) ? !this.route(cti, 1) : ("$NOLISTEN$".equals(mode) ? !this.route(cti, 2) : !this.route(cti, 3))) {
            return false;
        }
        this.manager.onRouting(this, cti);
        return true;
    }

    private synchronized boolean route(CTIPort cti, int mode) {
        this.toLog("route disconnected=" + this.disconnected + " cti.disconnected=" + cti.disconnected + " routed_port=" + this.routed_port + " conference=" + this.conference);
        if (this.disconnected) {
            return false;
        }
        if (cti.routed_port == this) {
            return true;
        }
        this.terminated = false;
        cti.terminated = false;
        cti.disconnected = false;
        if (cti.routed_port != null && !cti.routed_port.isDisconnected() && !cti.routeToMixer(null, this.getMixer(), mode)) {
            return false;
        }
        if (cti.conference) {
            Mixer mixer = (Mixer)cti.getRouteSocket().findResource(32);
            return this.routeToMixer(cti, mixer, mode);
        }
        if (this.conference) {
            Mixer mixer = (Mixer)this.getRouteSocket().findResource(32);
            return this.routeToMixer(cti, mixer, mode);
        }
        if (this.routed_port != null && !this.routed_port.isDisconnected() && this.routed_port != cti) {
            return this.routeToMixer(cti, null, mode);
        }
        if (cti == this) {
            this.routed_port = cti;
            return true;
        }
        boolean result = this.manager.route(cti.port, this.port, mode);
        if (!result) {
            this.toLog("Error routing to port " + cti.getRoutingLabel());
            return false;
        }
        this.routed_port = cti;
        cti.routed_port = this;
        this.toLog("Routed to port " + cti.getRoutingLabel());
        cti.toLog("Routed to port " + this.getRoutingLabel());
        this.setStatus(STATUS_ROUTED);
        return true;
    }

    public boolean routeToMixer(Mixer mixer, int mode) {
        this.toLog("routeToMixer conference=" + this.conference + " mixer=" + mixer + " mode=" + mode + " routed_port=" + this.routed_port);
        if (this.routed_port != null) {
            this.manager.unroute(this.port, this.routed_port.port);
            if (this.manager.routeMix(this, this.routed_port, mixer, mode)) {
                this.conference = true;
                if (this.routed_port != null) {
                    this.routed_port.conference = true;
                    this.routed_port.routed_port = null;
                    this.routed_port = null;
                }
                return true;
            }
            this.manager.route(this.port, this.routed_port.port, 3);
        } else if (mixer != null && this.getRouteSocket().route(mixer, mode)) {
            this.conference = true;
            return true;
        }
        return false;
    }

    private boolean routeToMixer(CTIPort cti, Mixer mix, int mode) {
        this.toLog("routeToMixer cti=" + cti + " conf=" + this.conference + " mix=" + mix + " mode=" + mode + " routed_port=" + this.routed_port);
        if (cti != null && cti.disconnected) {
            return false;
        }
        if (mix == null) {
            if (this.recording) {
                mix = (Mixer)this.getRouteSocket().findResource(32);
            } else if (this.routed_port != null && this.routed_port.recording) {
                mix = (Mixer)this.routed_port.getRouteSocket().findResource(32);
            }
        }
        if (!this.conference && this.routed_port != null) {
            this.manager.unroute(this.port, this.routed_port.port);
            if (this.manager.routeMix(this, this.routed_port, mix, 3)) {
                this.toLog("Created conference with " + this.routed_port.getRoutingLabel());
                this.conference = true;
                this.routed_port.conference = true;
            } else if (this.routed_port != null && !this.routed_port.port.isCallDisconnected()) {
                this.toLog("Error route to mixer " + mix + " ports " + this + " & " + this.routed_port);
                try {
                    if (!this.manager.route(this.port, this.routed_port.port, 3)) {
                        this.routed_port.routed_port = null;
                        this.routed_port = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            if (this.routed_port != null) {
                if (mix != null) {
                    mix.conferenceJoined(this.routed_port);
                }
                this.routed_port.routed_port = null;
                this.routed_port = null;
            }
        }
        if (cti != null) {
            Mixer mixer;
            if (!this.manager.routeMix(this, cti, mix, mode)) {
                this.toLog("Error route to mixer " + mix + " ports " + this + " & " + cti + " conf=" + this.conference);
                return false;
            }
            this.toLog("Created conference with " + cti.getRoutingLabel());
            this.conference = true;
            cti.conference = true;
            if (cti.routed_port == this) {
                cti.routed_port = null;
            }
            for (int i = 0; i < cti.held_port.size(); ++i) {
                if (cti.held_port.elementAt(i) != this) continue;
                cti.held_port.removeElementAt(i);
            }
            if (mix != null) {
                mix.conferenceJoined(cti);
            }
            if ((mixer = (Mixer)this.port.getRouteSocket().findResource(32)) != null) {
                mixer.onConnect(this, mode);
            }
        } else if (!this.conference) {
            if (mix == null) {
                return false;
            }
            if (!this.getRouteSocket().route(mix, 3)) {
                this.toLog("Error route to mixer " + mix + " port " + this);
                return false;
            }
            mix.conferenceJoined(this);
            this.toLog("Routed to conference");
            this.conference = true;
        }
        return true;
    }

    public boolean attachToConference(Mixer mixer) {
        RouteSocket socket = this.port.getRouteSocket();
        if (socket == null) {
            return false;
        }
        if (!socket.route(mixer, 3)) {
            return false;
        }
        this.conference = true;
        return true;
    }

    public boolean attachToMulticast(MulticastSocket multicast) {
        RouteSocket socket = this.port.getRouteSocket();
        if (this.routed_port != null) {
            Port mport = this.routed_port.port;
            this.manager.unroute(this.port, mport);
            this.routed_port = null;
            multicast.setConnection(this.port, mport);
        } else if (!socket.route(multicast, 1)) {
            return false;
        }
        return true;
    }

    public void detachFromMulticast(MulticastSocket multicast) {
        RouteSocket socket = this.port.getRouteSocket();
        socket.unroute(multicast, 3);
        multicast.removeConnection(this.port);
    }

    public synchronized CTIPort routeToHold(CTIPort routedPort) {
        if (this.held_port.isEmpty()) {
            return null;
        }
        CTIPort device = null;
        Object obj = this.held_port.lastElement();
        this.toLog("routeToHold obj=" + obj + " routed_port=" + this.routed_port);
        if (obj instanceof CTIPort) {
            device = (CTIPort)obj;
            device.held_port.removeElement(this);
        } else if (obj instanceof Mixer) {
            Mixer mixer = (Mixer)obj;
            HashSet names = mixer.getRoutedNames();
            if (names.size() == 0) {
                Vector nams = mixer.getHolds();
                if (nams.size() == 0) {
                    return null;
                }
                device = (CTIPort)nams.elementAt(0);
            } else {
                device = this.manager.getPortByLabel((String)names.iterator().next());
            }
            mixer.replaceHold(this, device);
        }
        if (device == null) {
            return null;
        }
        if (this.routed_port != null) {
            this.manager.unroute(this.port, this.routed_port.port);
            device.terminate();
            if (this.routed_port != null) {
                this.routed_port.route(device, 3);
                this.routed_port = null;
            }
        } else {
            device.routed_port = routedPort;
        }
        this.held_port.removeElement(obj);
        this.manager.preRoute(device.port, routedPort.port);
        return device;
    }

    public void unrouteFromHold(CTIPort routedPort) {
        this.toLog("unrouteFromHold routedPort=" + routedPort + " routed=" + (routedPort != null ? routedPort.routed_port : "") + " held_port=" + this.held_port);
        if (routedPort != null && routedPort.routed_port != this) {
            this.routed_port = null;
            this.held_port.remove(routedPort);
        }
        this.terminate();
        this.terminated = false;
    }

    @Override
    public void dial(String number) {
        this.toLog("dial number=" + number + " disconnected=" + this.disconnected + " answered=" + this.answered);
        if (this.disconnected) {
            return;
        }
        this.terminated = false;
        this.setStatus(STATUS_DIALING);
        this.manager.sendDigits(this, number);
        this.toLog("Sending DTMF: " + number);
    }

    public void playTone(String toneID, int time) {
        this.playTone(toneID, "", time);
    }

    @Override
    public void playTone(String toneID) {
        this.playTone(toneID, "", -1);
    }

    @Override
    public String playTone(String toneID, String termmask, int time) {
        if (this.disconnected) {
            return "DISCONNECT";
        }
        this.toLog("playing tone " + toneID + " t=" + time);
        this.clearDigitsBuffer();
        if (this.incoming && !this.accepted && !this.progressIncomingCall(8)) {
            return "DISCONNECT";
        }
        if (this.port instanceof VideoResource && ((VideoResource)((Object)this.port)).getVideoMode() != -1 && toneID.equals("Conference")) {
            return "OK";
        }
        this.setStatus(STATUS_PLAYING_TONE);
        boolean resumed = this.inRoute() ? this.holdSocket(1) : false;
        String result = this.manager.playTone(this, toneID, this.translateMask(termmask), time);
        if (resumed && !result.equals("DISCONNECT")) {
            this.resumeSocket();
        }
        this.toLog("playTone " + toneID + " result=" + result);
        if (result.equals("DISCONNECT")) {
            this.disconnected = true;
        }
        return result;
    }

    public String playNoise(String termmask, int time) {
        return this.playTone("Comfort Noise", termmask, time);
    }

    @Override
    public String getBreakDigit() {
        String result = this.breakDigit;
        this.breakDigit = "";
        return result;
    }

    @Override
    public String getDigitsBuffer() {
        String result = this.digitsBuffer;
        if (this.digitsBuffer.length() > 0) {
            this.toLog("Getting digits: " + this.digitsBuffer);
        }
        this.digitsBuffer = "";
        return result;
    }

    @Override
    public String getDigits(int count, int timeout, String termmask) {
        if (this.disconnected) {
            this.digitsBuffer = "";
            this.breakDigit = "";
            return "DISCONNECT";
        }
        if (this.terminated) {
            this.terminated = false;
            return "TERMINATION";
        }
        this.setStatus(STATUS_GETTING_DIGITS);
        int digits = count - this.digitsBuffer.length();
        if (digits <= 0) {
            return this.digitsBuffer.length() > 0 ? "DTMF" : "TIMEOUT";
        }
        String result = this.manager.getDigits(this, digits, timeout, this.translateMask(termmask), false, false);
        if (result.equals("TERMINATION")) {
            this.terminated = false;
            if (this.status.equals(STATUS_ON_HOLD)) {
                result = "HOLD";
            }
            if (this.status.equals(STATUS_RESUMED)) {
                result = "RESUME";
            }
        }
        if (result.equals("DISCONNECT")) {
            this.disconnected = true;
        }
        if (this.disconnected) {
            this.digitsBuffer = "";
            this.breakDigit = "";
            return "DISCONNECT";
        }
        if (result.equals("TIMEOUT") && this.digitsBuffer.length() > 0) {
            return "DTMF";
        }
        return result;
    }

    public void clearDigitsBuffer() {
        String result;
        while ((result = this.manager.getDigits(this, 1, 0, new char[0], false, false)).equals("DTMF")) {
        }
        this.digitsBuffer = "";
        this.breakDigit = "";
    }

    public boolean checkDigit(String termmask) {
        if (this.disconnected) {
            return true;
        }
        if (termmask == null || termmask.length() == 0) {
            return false;
        }
        if (this.digitsBuffer.length() > 0) {
            return true;
        }
        return !this.manager.getDigits(this, 1, 0, this.translateMask(termmask), false, true).equals("TIMEOUT");
    }

    @Override
    public String record(File file, String termmask, int silence, int timeout, WavAudioFormat format) {
        if (this.disconnected) {
            return "DISCONNECT";
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(512000);
            String result = this.record(bos, termmask, silence, timeout, format);
            FileOutputStream fos = new FileOutputStream(file);
            byte[] bodyBytes = bos.toByteArray();
            wavFormatHeader hdr = new wavFormatHeader(format);
            hdr.setDataLength(bodyBytes.length);
            byte[] header = hdr.toByteArray();
            fos.write(header);
            fos.write(bodyBytes);
            fos.close();
            return result;
        }
        catch (IOException e) {
            this.toLog(e.getMessage());
            return "FORMAT";
        }
    }

    @Override
    public String record(OutputStream voicedata, String termmask, int silence, int timeout, WavAudioFormat codec) {
        if (this.disconnected) {
            return "DISCONNECT";
        }
        this.toLog("Record stream " + codec.toString() + "  terminated=" + this.terminated);
        if (this.terminated) {
            this.terminated = false;
            return "TERMINATION";
        }
        this.digitsBuffer = "";
        this.setStatus(STATUS_RECORDING);
        String result = "ERROR";
        try {
            if ((this.routed_port != null || this.conference) && this.routeToMixer(null, null, 3)) {
                Mixer mixer = (Mixer)this.port.getRouteSocket().findResource(32);
                AudioConverter acv = new AudioConverter();
                ConvertedOutputStream cout = acv.getOutputStream(voicedata, codec, mixer.getAvailableCodecs(1));
                this.clearDigitsBuffer();
                mixer.startRecord(this, cout);
                this.toLog("startRecord mixer=" + mixer);
                result = this.manager.getDigits(this, 100, timeout, this.translateMask(termmask), true, false);
                mixer.cancelRecord(this);
                mixer.release();
                this.toLog("cancelRecord mixer=" + mixer);
            } else {
                result = this.manager.record(this, voicedata, this.translateMask(termmask), silence, timeout, codec);
            }
            if (result.equals("TERMINATION")) {
                this.terminated = false;
                if (this.status.equals(STATUS_ON_HOLD)) {
                    result = "HOLD";
                }
                if (this.status.equals(STATUS_RESUMED)) {
                    result = "RESUME";
                }
            }
        }
        catch (Exception e) {
            ResourceStore.error(this.getRoutingLabel(), e);
            this.toLog(e.toString());
        }
        this.toLog("Recording result = " + result);
        if (result.equals("DISCONNECT")) {
            this.disconnected = true;
        }
        return this.disconnected ? "DISCONNECT" : result;
    }

    public PipeRecorder setRecorder(boolean mix, boolean agc) {
        RouteSocket socket = this.getRouteSocket();
        if (!(socket instanceof PipeSocket)) {
            return null;
        }
        PipeRecorder prec = null;
        if (mix && this.attachToRecorder()) {
            prec = (PipeRecorder)socket.findResource(8192, 2);
        }
        if (prec == null) {
            prec = new PipeRecorder();
            prec.setAGC(agc);
        }
        if (!socket.route(prec, 2)) {
            this.toLog("setRecorder FAILED");
            return null;
        }
        this.toLog("setRecorder " + prec + " mix=" + mix + " rec=" + this.recording + " routed_port=" + this.routed_port);
        this.recording = true;
        if (mix && this.routed_port != null) {
            this.routed_port.recording = this.routed_port.getRouteSocket().route(prec, 2);
            this.toLog("setRecorder routed_port.recording=" + this.routed_port.recording);
        }
        return prec;
    }

    public boolean attachToRecorder() {
        this.toLog("attachToRecorder routed_port=" + this.routed_port + " conf=" + this.conference + " rec=" + this.recording);
        Resource prec = null;
        if (this.routed_port != null) {
            if (!this.recording && this.routed_port.recording) {
                prec = this.routed_port.getRouteSocket().findResource(8192, 2);
                this.recording = prec != null && this.getRouteSocket().route(prec, 2);
            } else if (this.recording && !this.routed_port.recording) {
                prec = this.getRouteSocket().findResource(8192, 2);
                this.routed_port.recording = prec != null && this.routed_port.getRouteSocket().route(prec, 2);
            }
            this.toLog("attachToRecorder " + prec + " rec=" + this.recording + " routed_port=" + this.routed_port);
        } else if (this.conference && !this.recording) {
            Mixer mixer = (Mixer)this.port.getRouteSocket().findResource(32);
            if (mixer != null) {
                Iterator names = mixer.getRoutedNames().iterator();
                while (names.hasNext()) {
                    CTIPort cti = this.manager.getPortByLabel((String)names.next());
                    if (cti == null || !cti.recording) continue;
                    prec = cti.getRouteSocket().findResource(8192, 2);
                    this.recording = prec != null && this.getRouteSocket().route(prec, 2);
                    break;
                }
            }
            this.toLog("attachToRecorder " + prec + " rec" + this.recording);
        }
        return this.recording;
    }

    @Override
    public String play(InputStream voicedata, String termmask, int timeout, WavAudioFormat codec, boolean toAll) {
        if (!toAll || this.routed_port == null && !this.conference) {
            return this.play(voicedata, termmask, timeout, codec);
        }
        if (this.disconnected) {
            return "DISCONNECT";
        }
        this.toLog("playMix " + codec.toString() + "  terminated=" + this.terminated);
        if (this.terminated) {
            this.terminated = false;
            return "TERMINATION";
        }
        this.setStatus(STATUS_PLAYING);
        RouteSocket socket = this.port.getRouteSocket();
        if (!(socket instanceof PipeSocket)) {
            return "ERROR";
        }
        CTIPort routedPort = this.routed_port;
        Mixer mixer = (Mixer)socket.findResource(32);
        if (mixer == null) {
            mixer = new Mixer();
        }
        if (!this.routeToMixer(null, mixer, 3)) {
            return "ERROR";
        }
        mixer = (Mixer)socket.findResource(32);
        if (mixer == null) {
            return "ERROR";
        }
        if (!mixer.startPlayPrompt(this, voicedata, codec)) {
            return "FORMAT";
        }
        String result = this.manager.getDigits(this, 100, timeout, this.translateMask(termmask), true, false);
        mixer.stopPlayPrompt(this);
        this.toLog("playMix result = " + result);
        if (result.equals("DISCONNECT")) {
            this.disconnected = true;
        } else if (result.equals("TERMINATION")) {
            result = "EOF";
        }
        if (!this.disconnected && routedPort != null && mixer.getRoutedNames().size() == 2) {
            this.manager.releaseResource(this.port, mixer);
            this.conference = false;
            this.manager.releaseResource(routedPort.port, mixer);
            routedPort.conference = false;
            this.route(routedPort, 3);
        }
        return this.disconnected ? "DISCONNECT" : result;
    }

    @Override
    public String play(File file, String termmask, int timeout) {
        if (this.disconnected) {
            return "DISCONNECT";
        }
        this.toLog("Playback file " + file.getAbsolutePath() + " exists=" + file.exists() + " terminated=" + this.terminated + " routed=" + this.inRoute());
        if (this.terminated) {
            this.terminated = false;
            return "TERMINATION";
        }
        this.digitsBuffer = "";
        if (!this.accepted && !this.progressIncomingCall(8)) {
            return "DISCONNECT";
        }
        this.setStatus(STATUS_PLAYING);
        String result = "ERROR";
        boolean resumed = this.inRoute() ? this.holdSocket(1) : false;
        try {
            result = this.manager.play(this, file, this.translateMask(termmask), timeout);
            if (result.equals("FORMAT")) {
                result = this.manager.play(this, file, this.translateMask(termmask), timeout);
            }
        }
        catch (Exception e) {
            this.toLog(e.toString());
            ResourceStore.error(this.getRoutingLabel(), e);
        }
        if (resumed && !result.equals("DISCONNECT")) {
            this.resumeSocket();
        }
        if (result.equals("TERMINATION")) {
            this.terminated = false;
            if (this.status.equals(STATUS_ON_HOLD)) {
                result = "HOLD";
            }
            if (this.status.equals(STATUS_RESUMED)) {
                result = "RESUME";
            }
        }
        this.toLog("Playback result = " + result);
        if (result.equals("DISCONNECT")) {
            this.disconnected = true;
        }
        return this.disconnected ? "DISCONNECT" : result;
    }

    @Override
    public String play(byte[] array, String termmask, int timeout, boolean toAll) {
        String result = "ERROR";
        try {
            wavFormatHeader hdr = new wavFormatHeader();
            InputStream stream = new WaveParser().parseWavHeader(new ByteArrayInputStream(array), hdr);
            if (timeout > 0) {
                stream = new CyclePlaybackStream(stream);
            } else {
                timeout = activity_maxtime;
            }
            result = this.play(stream, "", timeout, hdr.getAudioFormat(), toAll);
            stream.close();
        }
        catch (Exception e) {
            ResourceStore.error(this.getRoutingLabel(), e);
            this.toLog(e.toString());
        }
        return result;
    }

    @Override
    public String play(InputStream voicedata, String termmask, int timeout, WavAudioFormat codec) {
        if (this.disconnected) {
            return "DISCONNECT";
        }
        this.toLog("Playback stream " + codec.toString() + "  terminated=" + this.terminated);
        if (this.terminated) {
            this.terminated = false;
            return "TERMINATION";
        }
        this.digitsBuffer = "";
        if (!this.accepted && !this.progressIncomingCall(8)) {
            return "DISCONNECT";
        }
        this.setStatus(STATUS_PLAYING);
        String result = "ERROR";
        try {
            boolean resumed = this.inRoute() ? this.holdSocket(1) : false;
            result = this.manager.play(this, voicedata, this.translateMask(termmask), timeout, codec);
            if (resumed && !result.equals("DISCONNECT")) {
                this.resumeSocket();
            }
        }
        catch (Exception e) {
            ResourceStore.error(this.getRoutingLabel(), e);
            this.toLog(e.toString());
        }
        if (result.equals("TERMINATION")) {
            this.terminated = false;
            if (this.status.equals(STATUS_ON_HOLD)) {
                result = "HOLD";
            }
            if (this.status.equals(STATUS_RESUMED)) {
                result = "RESUME";
            }
        }
        this.toLog("Playback result = " + result);
        if (result.equals("DISCONNECT")) {
            this.disconnected = true;
        }
        return this.disconnected ? "DISCONNECT" : result;
    }

    @Override
    public String play(String ttsData, String termmask, int timeout) {
        if (this.disconnected) {
            return "DISCONNECT";
        }
        if (this.terminated) {
            this.terminated = false;
            return "TERMINATION";
        }
        if (ttsData.equals(String.valueOf('!'))) {
            if (this.holdFile == null || this.holdFile.length() == 0) {
                return "FORMAT";
            }
            File file = new File(this.holdFile);
            if (!file.isAbsolute()) {
                file = new File(System.getProperty("user.home"), this.holdFile);
            }
            return this.play(file, termmask, timeout);
        }
        this.digitsBuffer = "";
        this.toLog("Play: " + ttsData);
        if (!this.accepted && !this.progressIncomingCall(8)) {
            return "DISCONNECT";
        }
        this.setStatus(STATUS_PLAYING);
        String result = "ERROR";
        try {
            boolean resumed = this.inRoute() ? this.holdSocket(1) : false;
            result = this.manager.play(this, ttsData, this.translateMask(termmask), timeout);
            if (result.equals("FORMAT")) {
                result = this.manager.play(this, ttsData, this.translateMask(termmask), timeout);
            }
            if (resumed && !result.equals("DISCONNECT")) {
                this.resumeSocket();
            }
        }
        catch (Exception e) {
            ResourceStore.error(this.getRoutingLabel(), e);
            this.toLog(e.toString());
        }
        if (result.equals("TERMINATION")) {
            this.terminated = false;
            if (this.status.equals(STATUS_ON_HOLD)) {
                result = "HOLD";
            }
            if (this.status.equals(STATUS_RESUMED)) {
                result = "RESUME";
            }
        }
        this.toLog("Playback result = " + result);
        if (result.equals("DISCONNECT")) {
            this.disconnected = true;
        }
        return this.disconnected ? "DISCONNECT" : result;
    }

    private char[] translateMask(String string) {
        if (string == null) {
            return new char[0];
        }
        StringTokenizer st = new StringTokenizer(string, ", ");
        char[] mask = new char[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            mask[i] = st.nextToken().charAt(0);
            ++i;
        }
        return mask;
    }

    @Override
    public void setFaxLocalID(String localID) {
        this.faxLocalID = localID;
    }

    @Override
    public void setFaxHeader(String header) {
        this.faxHeader = header;
    }

    @Override
    public int getTransferredPages() {
        return this.transferredPages;
    }

    @Override
    public String getRemoteID() {
        return this.faxRemoteID;
    }

    @Override
    public String sendFax(File file, int startpage, boolean isHighResolution, boolean issueVoiceRequest) {
        boolean resumed;
        if (this.disconnected || !this.answered) {
            return "DISCONNECT";
        }
        this.terminated = false;
        this.setStatus(STATUS_FAX_TX);
        String result = "";
        if (isHighResolution && !(result = this.playTone("Fax CNG", "", 30)).equals("FAX") && !result.equals("FORMAT")) {
            this.toLog("SendFaxTone result = " + result);
            return result;
        }
        boolean bl = resumed = this.inRoute() ? this.holdSocket(3) : false;
        if (this.faxLocalID.length() == 0) {
            String string = this.faxLocalID = this.incoming ? this.called_number : this.calling_number;
        }
        if ((result = this.manager.sendFax(this, file, startpage, false, issueVoiceRequest)).equals("TERMINATION") && this.disconnected) {
            result = "DISCONNECT";
        }
        this.toLog("SendFax result = " + result);
        if (resumed && !result.equals("DISCONNECT")) {
            this.resumeSocket();
        }
        return result;
    }

    @Override
    public String receiveFax(File file, boolean pollingMode, boolean issueVoiceRequest) {
        boolean resumed;
        if (this.disconnected || !this.answered) {
            return "DISCONNECT";
        }
        this.terminated = false;
        this.setStatus(STATUS_FAX_RX);
        String result = "";
        if (pollingMode && !(result = this.playTone("Fax CED", "", 40)).equals("FAX") && !result.equals("FORMAT")) {
            this.toLog("SendFaxTone result = " + result);
            return result;
        }
        boolean bl = resumed = this.inRoute() ? this.holdSocket(3) : false;
        if (this.faxLocalID.length() == 0) {
            String string = this.faxLocalID = this.incoming ? this.called_number : this.calling_number;
        }
        if ((result = this.manager.receiveFax(this, file, true, issueVoiceRequest)).equals("TERMINATION") && this.disconnected) {
            result = "DISCONNECT";
        }
        this.toLog("ReceiveFax result = " + result + " resumed=" + resumed);
        if (resumed && !result.equals("DISCONNECT")) {
            this.resumeSocket();
        }
        return result;
    }

    public void sendCTIAnswer() {
        if (this.connecting_port instanceof SipPort) {
            ((SipPort)this.connecting_port).sendCTIAnswer();
        }
    }

    public void onRoute() {
        if (this.port instanceof SipPort) {
            ((SipPort)this.port).onRoute();
        }
    }

    public String toString() {
        return this.getRoutingLabel();
    }

    void loadPortProperties() {
        if (this.visualcti) {
            try {
                FileInputStream istream = new FileInputStream(PRP_DIR + this.port.getName() + ".ser");
                ObjectInputStream p = new ObjectInputStream(istream);
                Object inputobject = p.readObject();
                istream.close();
                p.close();
                this.properties = (Hashtable)inputobject;
                this.setProperty("Port Device Properties", this.properties.get("Port Device Properties"));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.properties = new Hashtable();
        this.properties.put("Use for inbound calls", new Boolean(true));
        this.properties.put("Use for outbound calls", new Boolean(true));
        this.properties.put("Use for outbound routing", new Boolean(true));
        this.properties.put("Internal routing number", this.port.getName());
        this.properties.put("Port Device Name", this.port.getPortId());
        this.properties.put("Port Device Class", this.port.getClass().getName());
        this.properties.put("Port Device Properties", this.port.getProperties());
    }

    @Override
    public Hashtable getProperties() {
        this.properties.put("Port Device Properties", this.port.getProperties());
        return this.properties;
    }

    @Override
    public void setProperties(Hashtable table) {
        Enumeration en = table.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (key.equals("Port Device Properties")) {
                if (this.port.getPortType() == 7) {
                    this.setSipPortProperties(table);
                } else {
                    this.port.setProperties((Hashtable)table.get("Port Device Properties"));
                }
            }
            if (key.equals("Internal routing number") || key.equals("Port Device Name")) continue;
            this.properties.put(key, table.get(key));
        }
    }

    public Hashtable getPortProperties() {
        return (Hashtable)this.properties.get("Port Device Properties");
    }

    @Override
    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("ORIGINAL CALLED NUMBER")) {
            this.called_number = (String)value;
            return;
        }
        if (propertyName.equals("Port Device Properties")) {
            if (this.port.getPortType() == 7) {
                this.setSipPortProperties((Hashtable)value);
            } else {
                this.port.setProperties((Hashtable)value);
            }
        }
        this.properties.put(propertyName, value);
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals("Port Device Properties")) {
            return this.port.getProperties();
        }
        return this.properties.get(propertyName);
    }

    public void savePortProperties() {
        File dir = new File(PRP_DIR);
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        String file = PRP_DIR + this.port.getName() + ".ser";
        try {
            FileOutputStream ostream = new FileOutputStream(file);
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            p.writeObject(this.properties);
            p.flush();
            p.close();
            ostream.close();
        }
        catch (Exception e) {
            ResourceStore.error(this.getRoutingLabel(), e);
        }
    }

    private void setSipPortProperties(Hashtable value) {
        if (this.visualcti) {
            try {
                ((SipPort)this.port).getEndpoint().setProperties(value);
                this.port.setProperties(value);
            }
            catch (Exception exception) {}
        } else {
            this.port.setProperties(value);
        }
    }

    @Override
    public String getCallProperty(String propertyName) {
        return null;
    }
}

