/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import java.util.Hashtable;
import java.util.Vector;

public class CallInfo {
    public static final String TIMESTAMP = "cti.Timestamp";
    public static final String CALL_ID = "cti.CallID";
    public static final String CONNECT_TIMESTAMP = "cti.ConnectTimestamp";
    public static final String MEDIA_TYPE = "cti.MediaType";
    public static final String CTI_PORT = "cti.Port";
    public static final String CTI_DISCONNECT_CAUSE = "cti.Cause";
    public static final String CTI_DISCONNECT_DESC = "cti.CauseDescription";
    public static final String CALLING_NUMBER = "cti.CallingNumber";
    public static final String CALLING_NAME = "cti.CallingName";
    public static final String CALLING_USER = "cti.CallingUser";
    public static final String CALLING_USER_REG_ID = "cti.CallingUserRegId";
    public static final String CALLED_NUMBER = "cti.CalledNumber";
    public static final String CALLED_NAME = "cti.CalledName";
    public static final String CALLED_USER = "cti.CalledUser";
    public static final String CALLED_USER_ICON = "cti.CalledUserIcon";
    public static final String CALLED_USER_REG_ID = "cti.CalledUserRegId";
    public static final String AUTHORIZED_USER = "cti.Authorized";
    public static final String CALLING_GATEWAY = "cti.CallingGateway";
    public static final String CALLED_GATEWAY = "cti.CalledGateway";
    public static final String CALLING_GATEWAY_ID = "cti.CallingGatewayID";
    public static final String CALLED_GATEWAY_ID = "cti.CalledGatewayID";
    public static final String ORIGINAL_CALLED_NUMBER = "cti.OriginalCalledNumber";
    public static final String ORIGINAL_CALLED_HOST = "cti.OriginalCalledHost";
    public static final String ORIGINAL_CALLED_ROUTE = "cti.OriginalCalledRoute";
    public static final String ORIGINAL_REDIRECTING_REASON = "cti.OriginalRedirectingReason";
    public static final String REDIRECTING_NUMBER = "cti.RedirectingNumber";
    public static final String REDIRECTING_HOST = "cti.RedirectingHost";
    public static final String REDIRECTING_REASON = "cti.RedirectingReason";
    public static final String TRANSFERRER_NUMBER = "cti.TransferrerNumber";
    public static final String CALLING_HOST = "cti.CallingHost";
    public static final String CALLED_HOST = "cti.CalledHost";
    public static final String CALL_SUBJECT = "cti.CallSubject";
    public static final String REMOTE_HOST = "cti.RemoteHost";
    public static final String REMOTE_HOST_LOGIN = "cti.RemoteHostLogin";
    public static final String REMOTE_DEVICE = "cti.RemoteDevice";
    public static final String MEDIA_ADDRESS = "cti.MediaAddress";
    public static final String MEDIA_CODEC = "cti.MediaCodec";
    public static final String VIDEO_CODEC = "cti.VideoCodec";
    public static final String ROUTED_CALL_ID = "cti.CallID2";
    public static final String ROUTED_CTI_PORT = "cti.Port2";
    public static final String ROUTED_HOST = "cti.RemoteHost2";
    public static final String ROUTED_DEVICE = "cti.RemoteDevice2";
    public static final String ROUTED_CALLED_USER = "cti.CalledUser2";
    public static final String ROUTED_CALLED_NUMBER = "cti.CalledNumber2";
    public static final String ROUTED_CALLING_NUMBER = "cti.CallingNumber2";
    public static final String ROUTED_MEDIA_ADDRESS = "cti.MediaAddress2";
    public static final String ROUTED_MEDIA_CODEC = "cti.MediaCodec2";
    public static final String CALLING_BRANCH_ID = "cti.CallingBranchId";
    public static final String CALLING_BRANCH_NAME = "cti.CallingBranchName";
    public static final String CALLING_BRANCH_PREFIX = "cti.CallingBranchPrefix";
    public static final String CALLING_BRANCH_TRUNK = "cti.CallingBranchTrunk";
    public static final String BRANCH_ACC_ID = "cti.AccountID";
    public static final String CALLED_BRANCH_ID = "cti.CalledBranchId";
    public static final String CALLED_BRANCH_NAME = "cti.CalledBranchName";
    public static final String CALLED_BRANCH_PREFIX = "cti.CalledBranchPrefix";
    public static final String CALLED_BRANCH_TRUNK = "cti.CalledBranchTrunk";
    public static final String REDIRECTING_BRANCH = "cti.RedirectingBranch";
    public static final String REDIRECTING_BRANCH_NAME = "cti.RedirectingBranchName";
    public static final String REDIRECTING_PBXID = "cti.RedirectingPbxId";
    public static final String AUTOANSWER = "cti.AUTOANSWER";
    public static final String OFF_HOOK = "cti.OffHook";
    public static final String HUNTING_ON_BUSY = "cti.HuntingOnBusy";
    public static final String HUNTING_ON_NOANSWER = "cti.HuntingOnNoanswer";
    public static final String HUNTING_ON_NOANSWER_TIMEOUT = "cti.HuntingOnNoanswerTimeout";
    public static final String REDIRECT_APPLICATION = "cti.RedirectApplication";
    public static final String AUTHORIZATION_DATA = "cti.AuthorizationData";
    public static final String VIDEO_CAPABILITIES = "cti.VideoCapabilities";
    private long timecode;
    private String lineId;
    private String calledNumber = "";
    private String callingNumber = "";
    private Vector diversionInfo = new Vector();
    private Hashtable attributes = new Hashtable();

    public CallInfo(String port) {
        this.lineId = port;
        this.timecode = System.currentTimeMillis();
    }

    public String getId() {
        return this.timecode + this.lineId;
    }

    public long getTimecode() {
        return this.timecode;
    }

    public String getRoutingLabel() {
        return this.lineId;
    }

    public String getPortName() {
        return this.lineId.substring(this.lineId.lastIndexOf(46) + 1);
    }

    public String getInbound() {
        String callerIP = (String)this.attributes.get(REMOTE_HOST);
        return callerIP == null ? this.lineId : callerIP;
    }

    public void setLineId(String port) {
        this.lineId = port;
    }

    public void setCalledNumber(String number) {
        this.calledNumber = number;
    }

    public String getCalledNumber() {
        return this.calledNumber;
    }

    public void setCallingNumber(String number) {
        this.callingNumber = number;
    }

    public String getCallingNumber() {
        return this.callingNumber;
    }

    public String getCallerIP() {
        return (String)this.attributes.get(REMOTE_HOST);
    }

    public String getInPort() {
        String addr = (String)this.attributes.get(MEDIA_ADDRESS);
        if (addr != null) {
            return addr;
        }
        return this.getPortName();
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttributes(Hashtable table) {
        this.attributes = table;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public Object getCallID() {
        return this.attributes.get(CALL_ID);
    }

    public void addDiversionInfo(String number, int reason) {
        this.diversionInfo.add(number + ":" + reason);
    }

    public Vector getDiversionInfo() {
        return this.diversionInfo;
    }

    public void clearDiversionInfo() {
        this.diversionInfo.clear();
    }

    public String toString() {
        return "{called=" + this.calledNumber + " calling=" + this.callingNumber + " info=" + this.attributes.toString() + "}";
    }
}

