/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import java.io.IOException;
import java.io.InputStream;

public class CyclePlaybackStream
extends InputStream {
    private InputStream in;
    private byte[] buffer;
    private int currentRead;
    private boolean eos = false;

    public CyclePlaybackStream(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IOException("Invalid playback stream");
        }
        this.in = stream;
        this.buffer = new byte[stream.available()];
        if (this.buffer.length == 0) {
            throw new IOException("Invalid playback stream - data not available");
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (!this.eos) {
            int n = this.in.read(buf, off, len);
            if (n != -1) {
                int i = 0;
                for (i = 0; i < n; ++i) {
                    this.buffer[this.currentRead++] = buf[off + i];
                    if (this.currentRead != this.buffer.length) continue;
                    this.eos = true;
                    this.currentRead = 0;
                    break;
                }
                return n;
            }
            this.eos = true;
            this.currentRead = 0;
        }
        for (int i = 0; i < len; ++i) {
            buf[off + i] = this.buffer[this.currentRead++];
            if (this.currentRead != this.buffer.length) continue;
            this.currentRead = 0;
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        if (!this.eos) {
            int n = this.in.read();
            if (n != -1) {
                return n;
            }
            this.eos = true;
            this.currentRead = 0;
        }
        if (this.currentRead == this.buffer.length) {
            this.currentRead = 0;
        }
        return this.buffer[this.currentRead++];
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

