/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.telephony.AudioCodec;
import com.smile.telephony.CTIPort;
import com.smile.telephony.CallInfo;
import com.smile.telephony.PipeSocket;
import com.smile.telephony.Port;
import com.smile.telephony.Resource;
import com.smile.telephony.RouteSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MulticastSocket
extends PipeSocket
implements Resource,
Runnable {
    protected PipeSocket masterSocket;
    protected Hashtable connections = new Hashtable();
    protected boolean closed;
    private InputStream masterInputStream;
    private Hashtable slaveOutputStreams = new Hashtable();
    private Hashtable masterOutputStreams = new Hashtable();
    private Hashtable slaveInputStreams = new Hashtable();
    private Hashtable masterInputStreams = new Hashtable();
    private AudioCodec audioCodec;

    public MulticastSocket() {
        this.buffering = true;
        this.blockingRead = false;
        Thread thrd = new Thread((Runnable)this, "MulticastSocket-" + this);
        thrd.setPriority(9);
        thrd.start();
    }

    public boolean setMasterPort(CTIPort port) {
        this.masterSocket = (PipeSocket)port.getRouteSocket();
        this.masterSocket.unroute(this, 2);
        return this.masterSocket.route(this, 2);
    }

    public void setConnection(Port slave, Port master) {
        this.connections.put(slave, master);
        slave.getRouteSocket().route(this, 3);
        master.getRouteSocket().route(this, 3);
    }

    public void removeConnection(Port port) {
        if (port == this.masterSocket) {
            this.masterSocket.unroute(this, 2);
            this.masterSocket = null;
        } else {
            Port mport = (Port)this.connections.remove(port);
            if (mport != null) {
                mport.getRouteSocket().unroute(this, 1);
                mport.dropCall(16);
            }
        }
    }

    @Override
    protected boolean startRecord(Object ps, OutputStream ostream, AudioCodec codec) {
        if (this.connections.containsValue(ps)) {
            this.masterOutputStreams.put(ps, ostream);
        } else if (ps != this.masterSocket) {
            this.slaveOutputStreams.put(ps, ostream);
        }
        return true;
    }

    @Override
    protected void cancelRecord(Object ps) {
        OutputStream os = (OutputStream)this.slaveOutputStreams.remove(ps);
        if (os == null) {
            os = (OutputStream)this.masterOutputStreams.remove(ps);
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected boolean startPlayback(Object ps, InputStream istream, AudioCodec codec) {
        if (ps == this.masterSocket) {
            this.masterInputStream = istream;
            this.audioCodec = codec;
        } else if (this.connections.containsKey(ps)) {
            this.slaveInputStreams.put(ps, istream);
        } else if (this.connections.containsValue(ps)) {
            this.masterInputStreams.put(ps, istream);
        }
        return true;
    }

    @Override
    protected void cancelPlayback(Object ps) {
        if (ps == this.masterSocket) {
            try {
                this.masterInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.masterInputStream = null;
        } else {
            InputStream is = (InputStream)this.slaveInputStreams.remove(ps);
            if (is == null) {
                is = (InputStream)this.masterInputStreams.remove(ps);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long nextTick = System.currentTimeMillis();
        while (!this.closed) {
            long timeout = (nextTick += 10L) - System.currentTimeMillis();
            if (timeout > 0L) {
                MulticastSocket multicastSocket = this;
                synchronized (multicastSocket) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                byte[] buffer = new byte[this.audioCodec.getFrameSize()];
                Vector<OutputStream> oss = new Vector<OutputStream>();
                Hashtable hashtable = this.connections;
                synchronized (hashtable) {
                    Enumeration en = this.connections.keys();
                    while (en.hasMoreElements()) {
                        Object key = en.nextElement();
                        InputStream is = (InputStream)this.slaveInputStreams.get(key);
                        OutputStream os = (OutputStream)this.masterOutputStreams.get(this.connections.get(key));
                        if (is != null && os != null) {
                            try {
                                if (is.read(buffer) == buffer.length) {
                                    os.write(buffer);
                                }
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        os = (OutputStream)this.slaveOutputStreams.get(key);
                        is = (InputStream)this.masterInputStreams.get(this.connections.get(key));
                        if (is == null || os == null) continue;
                        try {
                            if (is.read(buffer) == buffer.length) {
                                os.write(buffer);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        oss.add(os);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public AudioCodec[] getAudioCodecs(int mode) {
        return this.masterSocket != null ? this.masterSocket.getAudioCodecs(mode) : new AudioCodec[]{};
    }

    public CallInfo getCallInfo() {
        CallInfo info = new CallInfo("");
        return info;
    }

    @Override
    protected int getMinJitter() {
        return 0;
    }

    public void close() {
        this.closed = true;
    }

    @Override
    public boolean seize() {
        return false;
    }

    @Override
    public void release() {
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public boolean startPlayback(AudioCodec codec) {
        return true;
    }

    @Override
    public boolean startRecord(AudioCodec codec) {
        return true;
    }

    @Override
    public void stopPlayback() {
    }

    @Override
    public void stopRecord() {
    }

    @Override
    public boolean isCallDisconnected() {
        return false;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public String getName() {
        return "Mixer";
    }

    @Override
    public RouteSocket getRouteSocket() {
        return this;
    }

    @Override
    public String getErrorMessage() {
        return "";
    }

    @Override
    public int getRecBufferDepth() {
        return 1;
    }

    @Override
    public int getPlayBufferDepth() {
        return 1;
    }
}

