/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.telephony.AudioCodec;
import com.smile.telephony.AudioConverter;
import com.smile.telephony.DspResource;
import com.smile.telephony.MediaSocket;
import com.smile.telephony.Mixer;
import com.smile.telephony.PipeInputStream;
import com.smile.telephony.PipeOutputStream;
import com.smile.telephony.PipeRecorder;
import com.smile.telephony.RTPMediaSocket;
import com.smile.telephony.Resource;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.codec.ConvertedInputStream;
import com.smile.telephony.codec.ConvertedOutputStream;
import com.smile.telephony.video.FrameBuffer;
import com.smile.telephony.video.VideoCapability;
import com.smile.telephony.video.VideoResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import smile.util.ResourceStore;

public abstract class PipeSocket
extends RouteSocket {
    public static final int TX = 1;
    public static final int RX = 2;
    public final int BUFFER_TIME = 960;
    protected boolean blockingRead = false;
    protected boolean fullRouting = true;
    protected boolean connected = false;
    protected boolean buffering = false;
    protected boolean buffered = false;
    protected boolean transdigmode = true;
    protected PipeSocket master;
    protected PipeSocket slave;
    protected AudioCodec playCodec;
    protected AudioCodec recCodec;
    protected PipeRecorder voiceRecorder;
    protected InputStream in;
    protected OutputStream out;
    private char[] digitMask;

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    protected void setInputStream(InputStream i) {
        this.in = i;
    }

    protected void setOutputStream(OutputStream o) {
        this.out = o;
    }

    @Override
    public final int getSocketType() {
        return 2;
    }

    @Override
    protected boolean routeReceiver(RouteSocket rs) {
        ResourceStore.toLog(this + " routeReceiver " + rs + " tread=" + Thread.currentThread().getName());
        PipeSocket socket = (PipeSocket)rs;
        if (!this.connectSocket(socket)) {
            return false;
        }
        socket.master = this;
        this.slave = socket;
        return true;
    }

    @Override
    protected boolean unrouteReceiver(RouteSocket rs) {
        ResourceStore.toLog(this + " unrouteReceiver " + rs + " slave=" + this.slave + " tread=" + Thread.currentThread().getName());
        if (this.slave == (PipeSocket)rs) {
            try {
                this.disconnectSocket(this.slave);
                this.slave.master = null;
                this.slave = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected boolean routeTransmitter(RouteSocket rs) {
        ResourceStore.toLog(this + " routeTransmitter " + rs + " rec=" + this.voiceRecorder + " tread=" + Thread.currentThread().getName());
        if (rs instanceof PipeSocket) {
            PipeSocket socket = (PipeSocket)rs;
            if (!socket.connectSocket(this)) {
                return false;
            }
            socket.slave = this;
            this.master = socket;
            return true;
        }
        if (rs instanceof PipeRecorder) {
            if (this.voiceRecorder != null && rs != this.voiceRecorder) {
                this.voiceRecorder.cancelRecord(this);
            }
            this.voiceRecorder = (PipeRecorder)rs;
            return this.voiceRecorder.startRecord(this, this.recCodec);
        }
        return false;
    }

    @Override
    protected boolean unrouteTransmitter(RouteSocket rs) {
        ResourceStore.toLog(this + " unrouteTransmitter " + rs + " rec=" + this.voiceRecorder + " tread=" + Thread.currentThread().getName());
        if (rs instanceof PipeSocket) {
            if (this.master == (PipeSocket)rs) {
                try {
                    this.master.disconnectSocket(this);
                    this.master.slave = null;
                    this.master = null;
                }
                catch (Exception exception) {}
            }
        } else if (rs instanceof PipeRecorder) {
            ((PipeRecorder)rs).cancelRecord(this);
            this.voiceRecorder = null;
        }
        return true;
    }

    private boolean connectSocket(PipeSocket socket) {
        return this.connectSocket(socket, this.getAudioCodecs(1), socket.getAudioCodecs(2), false, false);
    }

    private boolean connectSocket(PipeSocket socket, AudioCodec codec, boolean isFromRemote) {
        if (codec.isFax() && socket instanceof Mixer) {
            Mixer mixer = (Mixer)socket;
            Hashtable iss = mixer.getInputStreams();
            if (iss.size() != 2) {
                return false;
            }
            Enumeration en = iss.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                if (key == this) continue;
                if (!(key instanceof PipeSocket)) {
                    return false;
                }
                socket = (PipeSocket)key;
                break;
            }
            mixer.cancelPlayback(this);
            mixer.cancelPlayback(socket);
            this.master = socket;
            this.slave = socket;
            socket.master = this;
            socket.slave = this;
            return true;
        }
        AudioCodec[] codecs = new AudioCodec[]{codec};
        if (isFromRemote) {
            return this.connectSocket(socket, this.getAudioCodecs(1), codecs, true, true);
        }
        return this.connectSocket(socket, codecs, socket.getAudioCodecs(2), true, false);
    }

    private boolean connectSocket(PipeSocket socket, AudioCodec[] playCodecs, AudioCodec[] recCodecs, boolean adjustment, boolean isFromRemote) {
        if (!this.connectAudio(socket, playCodecs, recCodecs, adjustment, isFromRemote)) {
            return false;
        }
        if (this instanceof VideoResource && socket instanceof VideoResource) {
            try {
                this.connectVideo(socket);
            }
            catch (Throwable t) {
                ResourceStore.error("connectVideo", t);
            }
        }
        return true;
    }

    private boolean connectAudio(PipeSocket socket, AudioCodec[] playCodecs, AudioCodec[] recCodecs, boolean adjustment, boolean isFromRemote) {
        ResourceStore.toLog(this + " connectSocket " + socket + "  isConnected(TX)=" + this.isConnected(1) + " adj=" + adjustment + " ts=" + this.fullRouting + " sts=" + socket.fullRouting + " playCodecs=" + playCodecs.length + " recCodecs=" + recCodecs.length);
        if (playCodecs == null || recCodecs == null) {
            return false;
        }
        try {
            int i;
            this.buffered = this.buffering;
            PipeOutputStream rpos = new PipeOutputStream();
            if (socket instanceof MediaSocket) {
                for (int i2 = 0; i2 < recCodecs.length; ++i2) {
                    if (recCodecs[i2].isFax() && !adjustment) continue;
                    if (recCodecs[i2].match(playCodecs)) {
                        if (this.isConnected(1)) {
                            this.disconnectSocket(socket);
                        }
                        if (socket.startRecord(this, rpos, recCodecs[i2])) {
                            if (this.startPlayback(socket, new PipeInputStream(rpos), recCodecs[i2])) {
                                this.playCodec = socket.recCodec = recCodecs[i2];
                                rpos.setBuffer(this.playCodec.getFrameSize(), this.playCodec.getFrameTime(), this.blockingRead, socket.getMinJitter(), socket.getMaxJitter());
                                this.connected = true;
                                return true;
                            }
                            socket.cancelRecord(this);
                        }
                        if (adjustment) {
                            return false;
                        }
                    }
                    if (!socket.isCallDisconnected() && !this.isCallDisconnected()) continue;
                    return false;
                }
                if (this instanceof MediaSocket) {
                    AudioCodec[] playCodecsNew;
                    AudioCodec[] recCodecsNew = socket.getAudioCodecs(2);
                    if (recCodecsNew != null) {
                        recCodecs = adjustment && isFromRemote ? new AudioCodec[]{recCodecsNew[0]} : recCodecsNew;
                    }
                    if ((!adjustment || isFromRemote) && (playCodecsNew = this.getAudioCodecs(1)) != null) {
                        playCodecs = playCodecsNew;
                    }
                    for (i = 0; i < recCodecs.length; ++i) {
                        if (recCodecs[i].isFax() && !adjustment) continue;
                        if (recCodecs[i].match(playCodecs)) {
                            if (this.isConnected(1)) {
                                this.disconnectSocket(socket);
                            }
                            if (socket.startRecord(this, rpos, recCodecs[i])) {
                                if (this.startPlayback(socket, new PipeInputStream(rpos), recCodecs[i])) {
                                    this.playCodec = socket.recCodec = recCodecs[i];
                                    rpos.setBuffer(this.playCodec.getFrameSize(), this.playCodec.getFrameTime(), this.blockingRead, socket.getMinJitter(), socket.getMaxJitter());
                                    this.connected = true;
                                    return true;
                                }
                                socket.cancelRecord(this);
                            }
                            if (adjustment) {
                                return false;
                            }
                        }
                        if (!socket.isCallDisconnected() && !this.isCallDisconnected()) continue;
                        return false;
                    }
                }
            } else if (!(socket instanceof Mixer)) {
                this.buffered = true;
                for (int i3 = 0; i3 < playCodecs.length; ++i3) {
                    if (playCodecs[i3].isFax() && !adjustment) continue;
                    if (playCodecs[i3].match(recCodecs)) {
                        if (this.isConnected(1)) {
                            this.disconnectSocket(socket);
                        }
                        if (this.startPlayback(socket, new PipeInputStream(rpos), playCodecs[i3])) {
                            if (socket.startRecord(this, rpos, playCodecs[i3])) {
                                this.playCodec = socket.recCodec = playCodecs[i3];
                                rpos.setBuffer(this.playCodec.getFrameSize(), this.playCodec.getFrameTime(), socket.blockingRead, 0, this.getMaxJitter());
                                this.connected = true;
                                return true;
                            }
                            this.cancelPlayback(socket);
                        }
                    }
                    if (!socket.isCallDisconnected() && !this.isCallDisconnected()) continue;
                    return false;
                }
            }
            if (this.fullRouting && socket.fullRouting) {
                this.buffered = true;
                AudioConverter converter = new AudioConverter();
                if (socket instanceof MediaSocket) {
                    ConvertedOutputStream cout = converter.getOutputStream((OutputStream)rpos, recCodecs);
                    if (cout == null) {
                        return false;
                    }
                    AudioCodec decoder = cout.getDecoder();
                    for (int i4 = 0; i4 < playCodecs.length; ++i4) {
                        InputStream rpis = new PipeInputStream(rpos);
                        if (!AudioCodec.PCM16LINEAR.equals(playCodecs[i4])) {
                            rpis = converter.getInputStream(rpis, playCodecs[i4]);
                        }
                        ResourceStore.toLog(((Resource)((Object)this)).getName() + ": playCodecs[" + i4 + "]=" + playCodecs[i4].getName() + " decoder=" + decoder + " rpis=" + rpis);
                        if (rpis == null) continue;
                        this.disconnectSocket(socket);
                        if (this.startPlayback(socket, rpis, playCodecs[i4])) {
                            if (socket.startRecord(this, cout, decoder)) {
                                this.playCodec = playCodecs[i4];
                                socket.recCodec = decoder;
                                rpos.setBuffer(this.playCodec.getFrameSize(), this.playCodec.getFrameTime(), this.blockingRead, socket.getMinJitter(), socket.getMaxJitter());
                                ResourceStore.toLog(((Resource)((Object)this)).getName() + " piped to " + ((Resource)((Object)socket)).getName() + " encoder=" + playCodecs[i4] + " decoder=" + decoder);
                                this.connected = true;
                                return true;
                            }
                            this.cancelPlayback(socket);
                        }
                        try {
                            rpis.close();
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        cout.close();
                    }
                    catch (IOException i4) {}
                } else {
                    for (i = 0; i < recCodecs.length; ++i) {
                        ConvertedInputStream cin = converter.getInputStream((InputStream)new PipeInputStream(rpos), recCodecs[i], playCodecs);
                        ResourceStore.toLog(((Resource)((Object)this)).getName() + " to " + ((Resource)((Object)socket)).getName() + ": recCodecs[" + i + "]=" + recCodecs[i].getName() + " cin=" + cin);
                        if (cin == null) continue;
                        if (this.isConnected(1)) {
                            this.disconnectSocket(socket);
                        }
                        if (socket.startRecord(this, rpos, recCodecs[i])) {
                            AudioCodec encoder = cin.getEncoder();
                            if (this.startPlayback(socket, cin, encoder)) {
                                this.playCodec = encoder;
                                socket.recCodec = recCodecs[i];
                                rpos.setBuffer(recCodecs[i].getFrameSize(), recCodecs[i].getFrameTime(), this.blockingRead, socket.getMinJitter(), socket.getMaxJitter());
                                ResourceStore.toLog(((Resource)((Object)this)).getName() + " piped to " + ((Resource)((Object)socket)).getName() + " encoder=" + encoder + " decoder=" + recCodecs[i]);
                                this.connected = true;
                                return true;
                            }
                            socket.cancelRecord(this);
                        }
                        try {
                            cin.close();
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ResourceStore.error(((Resource)((Object)this)).getName(), e);
        }
        return false;
    }

    private void disconnectSocket(PipeSocket socket) {
        this.connected = false;
        socket.recCodec = null;
        this.playCodec = null;
        socket.cancelRecord(this);
        this.cancelPlayback(socket);
        if (this instanceof VideoResource && socket instanceof VideoResource) {
            ((VideoResource)((Object)socket)).stopReceiver(this);
            ((VideoResource)((Object)this)).stopTransmitter(socket);
        }
    }

    protected boolean isBuffered() {
        return this.buffered;
    }

    public abstract AudioCodec[] getAudioCodecs(int var1);

    public abstract boolean isCallDisconnected();

    public abstract boolean startPlayback(AudioCodec var1);

    public abstract boolean startRecord(AudioCodec var1);

    public abstract void stopPlayback();

    public abstract void stopRecord();

    public abstract int getPlayBufferDepth();

    public abstract int getRecBufferDepth();

    protected int getMinJitter() {
        return 0;
    }

    protected int getMaxJitter() {
        return 960;
    }

    protected boolean startRecord(Object ps, OutputStream ostream, AudioCodec codec) {
        return this.startRecord(ostream, codec);
    }

    protected boolean startRecord(OutputStream ostream, AudioCodec codec) {
        this.out = ostream;
        return this.startRecord(codec);
    }

    protected void cancelRecord(Object ps) {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stopRecord();
        this.out = null;
    }

    protected boolean startPlayback(Object ps, InputStream istream, AudioCodec codec) {
        return this.startPlayback(istream, codec);
    }

    protected boolean startPlayback(InputStream istream, AudioCodec codec) {
        this.in = istream;
        return this.startPlayback(codec);
    }

    protected void cancelPlayback(Object ps) {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopPlayback();
        this.in = null;
    }

    protected boolean isConnected(int dir) {
        if (dir == 1) {
            return this.connected;
        }
        return this.master != null && (this.master.connected || this.master instanceof Mixer);
    }

    protected boolean connectSocket(int dir, AudioCodec codec) {
        if (dir == 1 && this.slave != null) {
            return this.connectSocket(this.slave, codec, false);
        }
        if (dir == 2 && this.master != null) {
            if (!this.master.connectSocket(this, codec, true)) {
                return false;
            }
            if (this.voiceRecorder != null && !codec.equals(this.recCodec)) {
                this.voiceRecorder.cancelRecord(this);
                this.voiceRecorder.startRecord(this, codec);
            }
        }
        return true;
    }

    protected void disconnectSocket(int dir) {
        if (dir == 1 && this.slave != null && this.connected) {
            this.disconnectSocket(this.slave);
        }
        if (dir == 2 && this.master != null && this.master.connected) {
            this.master.disconnectSocket(this);
        }
    }

    protected boolean isCompatible(int dir, AudioCodec codec) {
        if (dir == 1 && this.slave != null) {
            return codec.match(this.slave.getAudioCodecs(2));
        }
        if (dir == 2 && this.master != null) {
            return codec.match(this.master.getAudioCodecs(1));
        }
        return true;
    }

    public int readBuffer(byte[] buffer) {
        return this.readBuffer(buffer, 0, buffer.length);
    }

    public int readBuffer(byte[] buffer, int offset, int len) {
        try {
            return this.in.read(buffer, offset, len);
        }
        catch (Throwable e) {
            ResourceStore.toLog(((Resource)((Object)this)).getName() + ": readBuffer " + e + " o=" + offset + " l=" + len + " bl=" + buffer.length);
            return -1;
        }
    }

    public void writeBuffer(byte[] buffer, int offset, int len) throws Exception {
        if (this.out != null) {
            this.out.write(buffer, offset, len);
            this.out.flush();
        }
        if (this.voiceRecorder != null) {
            this.voiceRecorder.write(this, buffer, offset, len);
        }
    }

    public void setDigitMask(char[] mask) {
        this.digitMask = mask;
    }

    public void transmitDigit(char digit) {
        ResourceStore.toLog(((Resource)((Object)this)).getName() + ": " + ((Resource)((Object)this)).getName() + ": transmitDigit " + digit + " con=" + this.isConnected(2) + " mode=" + this.transdigmode + " master=" + this.master);
        if (!this.transdigmode || !this.isConnected(2)) {
            return;
        }
        try {
            if (this.digitMask != null) {
                for (int j = 0; j < this.digitMask.length; ++j) {
                    if (digit != this.digitMask[j]) continue;
                    return;
                }
            }
            if (this.master instanceof RTPMediaSocket && this instanceof RTPMediaSocket) {
                ((RTPMediaSocket)this.master).transmitDigit(digit, (RTPMediaSocket)this);
            } else if (this.master instanceof DspResource) {
                ((DspResource)((Object)this.master)).sendDigits(String.valueOf(digit));
                ResourceStore.toLog(((Resource)((Object)this)).getName() + ": " + ((Resource)((Object)this)).getName() + "->" + ((Resource)((Object)this.master)).getName() + " = " + digit);
            } else if (this.master instanceof Mixer) {
                ((Mixer)this.master).transmitDigit(digit, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void transmitDigits(String digits) {
        if (this.master instanceof DspResource) {
            ((DspResource)((Object)this.master)).sendDigits(digits);
        } else {
            for (int i = 0; i < digits.length(); ++i) {
                this.transmitDigit(digits.charAt(i));
            }
        }
    }

    private boolean connectVideo(PipeSocket socket) {
        VideoResource vr1 = (VideoResource)((Object)this);
        VideoResource vr2 = (VideoResource)((Object)socket);
        if (vr1.getVideoMode() == -1) {
            return false;
        }
        Vector caps1 = vr1.getVideoCapabilities();
        if (caps1 == null || caps1.isEmpty()) {
            return false;
        }
        Vector caps2 = vr2.getVideoCapabilities();
        if (caps2 == null || caps2.isEmpty()) {
            return false;
        }
        if (caps2 == null) {
            return false;
        }
        boolean rm = vr1 instanceof MediaSocket && vr2 instanceof MediaSocket;
        Enumeration en = caps1.elements();
        while (en.hasMoreElements()) {
            VideoCapability vc1 = (VideoCapability)en.nextElement();
            Enumeration enu = caps2.elements();
            while (enu.hasMoreElements()) {
                VideoCapability vc2 = (VideoCapability)enu.nextElement();
                if ((!rm || !vc1.equals(vc2)) && (rm || !vc1.isCompatible(vc2))) continue;
                FrameBuffer fb = new FrameBuffer();
                VideoCapability vc = vr1 instanceof MediaSocket ? vc1 : vc2;
                vr2.startReceiver(vr1, vc, fb);
                vr1.startTransmitter(vr2, vc, fb);
                return true;
            }
        }
        return false;
    }
}

