/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

public class RTPMediaSocketPlayer {
    static final int MAXTIME = 10000;
    private int result = 32;
    private char[] sig_mask;
    int maxtime;
    boolean clearbuf = true;

    public RTPMediaSocketPlayer(char[] mask, int timeout) {
        this.sig_mask = mask;
        this.maxtime = timeout > 0 ? timeout * 1000 : 10000000;
    }

    boolean isMaskValid(char digit) {
        if (digit == '\u001f' || digit == '\u001e') {
            this.terminate(8192);
            return false;
        }
        if (this.sig_mask != null) {
            for (int i = 0; i < this.sig_mask.length; ++i) {
                if (digit != this.sig_mask[i]) continue;
                this.terminate(64);
                return true;
            }
        }
        return false;
    }

    boolean needClearDigitBuffer() {
        return this.clearbuf && this.sig_mask != null && this.sig_mask.length > 0;
    }

    synchronized int getTermination() {
        if (this.result != 32) {
            return this.result;
        }
        try {
            this.wait(this.maxtime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.result;
    }

    synchronized void terminate() {
        this.result = 256;
        this.clearbuf = false;
        this.notify();
    }

    synchronized void terminate(int res) {
        this.result = res;
        this.clearbuf = this.result != 64;
        this.notify();
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

