/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.telephony.CTIPort;
import com.smile.telephony.CallInfo;
import com.smile.telephony.MediaSocket;
import com.smile.telephony.Port;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.sip.SipPort;
import java.io.File;
import java.util.Map;
import java.util.Vector;
import smile.cti.phone.PhoneLine;

public class RouteRequest {
    public static final String INTERNAL = "INTERNAL";
    public static final String EXTERNAL = "EXTERNAL";
    private static Vector route_request = new Vector();
    private CTIPort device;
    private CTIPort routedPort;
    private String routingLabel;
    private String calledNumber;
    private String callingNumber;
    private String termmask;
    private String route_result;
    private String routedNumber;
    private String extdigits;
    private CallInfo callInfo;
    private File file;
    private int timeout;
    private String resApp;
    private boolean e164 = true;
    private static int ca1time = 4;
    private static boolean genringback = false;
    private static boolean mrouteonalert = false;
    private static int ca0time = 0;
    private boolean waiting = false;
    private boolean expired = false;
    private boolean playNoise = false;
    private boolean alerting = false;
    private boolean play = false;
    private boolean silent = false;
    private boolean playing = false;
    private boolean digcheck = false;
    private boolean progressAllowed = true;
    private boolean allowMediaConnect = true;
    private boolean acceptedRingback = false;
    private boolean replaced = false;
    private boolean connected = false;
    private boolean routing = false;
    private String ringbackTone;
    private String progressTone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RouteRequest getRouteRequest(CTIPort ctiport) {
        Vector vector = route_request;
        synchronized (vector) {
            for (int i = 0; i < route_request.size(); ++i) {
                RouteRequest request = (RouteRequest)route_request.elementAt(i);
                if (request.expired) {
                    request.setResult("NOT AVAILABLE");
                    route_request.removeElementAt(i);
                    --i;
                    continue;
                }
                if (!request.applyTo(ctiport)) continue;
                route_request.removeElementAt(i);
                return request;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRouteRequest(RouteRequest request) {
        Vector vector = route_request;
        synchronized (vector) {
            route_request.addElement(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeRouteRequest(RouteRequest request) {
        Vector vector = route_request;
        synchronized (vector) {
            return route_request.removeElement(request);
        }
    }

    RouteRequest(CTIPort device, String number, int timeout, String filename, String termmask, String callingNumber, String resApp, CallInfo info, Map parameters) {
        this.device = device;
        this.timeout = timeout;
        this.resApp = resApp;
        this.callingNumber = callingNumber;
        this.termmask = termmask;
        boolean bl = this.digcheck = termmask != null && termmask.length() > 0;
        if (INTERNAL.equals(filename)) {
            this.ringbackTone = "Ringback2";
            this.progressTone = "Progress";
        } else if (EXTERNAL.equals(filename)) {
            this.ringbackTone = "Ringback";
            this.progressTone = "Progress";
        }
        if (device.answered) {
            if ("noise".equals(filename)) {
                this.playNoise = true;
            } else if (filename != null && filename.length() != 0) {
                this.file = new File(filename);
                if (!this.file.isAbsolute()) {
                    this.file = new File(System.getProperty("user.home"), filename);
                }
                this.play = this.file.exists();
            }
        }
        boolean bl2 = this.acceptedRingback = device.answered && !this.play;
        if (device.getPortType() == 4 || device.getPortType() == 7) {
            int[] prms = (int[])parameters.get("H323_PARAMETERS");
            if (prms == null) {
                prms = (int[])parameters.get("h323.parameters");
            }
            if (prms != null) {
                this.allowMediaConnect = (prms[5] & 0x20) == 0;
                boolean bl3 = this.progressAllowed = (prms[5] & 0x40) == 0;
                if (device.getPortType() == 4) {
                    this.acceptedRingback |= (prms[5] & 0x100) != 0;
                }
            }
        } else if (device.getPortType() == 3) {
            this.progressAllowed = false;
            if (genringback) {
                this.acceptedRingback = true;
            }
        }
        this.callInfo = info;
        this.routingLabel = "";
        this.routedNumber = number.trim();
        int mdx = this.routedNumber.indexOf(64);
        int ndx = this.routedNumber.indexOf(58);
        if (ndx > 0 && (mdx == -1 || mdx > ndx)) {
            this.routingLabel = this.routedNumber.substring(0, ndx);
            this.routedNumber = this.routedNumber.substring(ndx + 1);
        }
        this.calledNumber = (ndx = this.routedNumber.indexOf(124)) == -1 ? this.routedNumber : this.routedNumber.substring(0, ndx);
        this.extdigits = "";
        int n = this.calledNumber.indexOf(47);
        if (n != -1) {
            int m = this.calledNumber.indexOf(64);
            if (m == -1) {
                this.extdigits = this.calledNumber.substring(n + 1);
                this.calledNumber = this.calledNumber.substring(0, n);
            } else if (m > n) {
                this.extdigits = this.calledNumber.substring(n + 1, m);
                this.calledNumber = this.calledNumber.substring(0, n) + this.calledNumber.substring(m);
            }
            if (ndx != -1) {
                this.routedNumber = this.calledNumber + this.routedNumber.substring(ndx);
            }
        }
        n = this.calledNumber.length();
        for (int i = 0; i < n; ++i) {
            char c = this.calledNumber.charAt(i);
            if (c <= '9' || c == 'W') continue;
            this.e164 = false;
            break;
        }
        this.route_result = "NO ANSWER";
        RouteRequest.setRouteRequest(this);
    }

    private boolean applyTo(CTIPort ctiport) {
        int portType = ctiport.getPortType();
        String portLabel = ctiport.getRoutingLabel();
        if (!portLabel.startsWith(this.routingLabel)) {
            return false;
        }
        if (portType == 4 || portType == 7) {
            if (this.routingLabel.length() == 0) {
                return !this.calledNumber.startsWith("line");
            }
            if (portLabel.equals(this.routingLabel)) {
                return true;
            }
            char c = portLabel.charAt(this.routingLabel.length());
            return c == '.' || Character.isDigit(c);
        }
        if (portType == 6) {
            if (this.routingLabel.length() == 0) {
                return this.e164;
            }
            char c = this.routingLabel.charAt(this.routingLabel.length() - 1);
            return !Character.isDigit(c) || portLabel.equals(this.routingLabel);
        }
        if (portType == 5) {
            return this.calledNumber.equals(ctiport.getPortName());
        }
        if (portType == 0) {
            if (this.calledNumber.equals("")) {
                return this.routingLabel.length() > 0;
            }
            return ctiport.getRoutingLabel().equals("FXS." + this.calledNumber) || ctiport.getRoutingLabel().equals(this.routingLabel + this.calledNumber);
        }
        if (portType == 1 && this.calledNumber.length() == 0) {
            return true;
        }
        return this.e164;
    }

    private synchronized boolean startPlayback() {
        this.playing = this.play || this.alerting || this.playNoise;
        return this.playing;
    }

    private synchronized void stopPlayback() {
        this.playing = false;
        this.notify();
    }

    private synchronized void startAlerting() {
        if (!this.alerting) {
            this.alerting = true;
            if (this.playNoise) {
                this.playNoise = false;
            }
            if (this.playing) {
                this.device.terminate();
            }
        }
    }

    private synchronized void stopAlerting() {
        if (this.play || this.alerting || this.playNoise) {
            this.play = false;
            this.alerting = false;
            this.playNoise = false;
        }
        if (this.playing) {
            this.device.terminate();
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void notifyRoute() {
        this.notify();
    }

    private synchronized void waitForRoute() {
        try {
            this.wait(CTIPort.routing_timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getRoute() {
        this.device.toLog("getRoute : routingLabel=" + this.routingLabel + " calledNumber=" + this.calledNumber + " callingNumber=" + this.callingNumber + " resapp=" + this.resApp + " callInfo=" + this.callInfo);
        this.device.connecting = true;
        this.device.picked = false;
        this.waiting = true;
        if (this.digcheck && this.device.answered) {
            this.device.clearDigitsBuffer();
        }
        this.waitForRoute();
        if (this.routedPort == null && RouteRequest.removeRouteRequest(this)) {
            this.device.setCause(34);
            return "NOT AVAILABLE";
        }
        boolean p = this.device.getPortType() == 7;
        boolean p2 = false;
        while (this.waiting) {
            String r;
            if (this.play && this.startPlayback()) {
                p = true;
                r = this.device.play(this.file, this.termmask, this.timeout);
                this.stopPlayback();
                if (r.equals("DISCONNECT")) {
                    this.route_result = "DISCONNECT";
                    break;
                }
                if (r.equals("TERMINATION") && this.device.picked) {
                    this.route_result = "TERMINATION";
                    break;
                }
                if (r.equals("EOF") || r.equals("TIMEOUT")) continue;
                this.play = false;
                if (!r.equals("DTMF")) continue;
                this.alerting = false;
                continue;
            }
            if (this.alerting && this.startPlayback()) {
                p = true;
                this.playNoise = false;
                r = this.device.playTone(this.ringbackTone, this.termmask, -1);
                this.stopPlayback();
                if (r.equals("DISCONNECT")) {
                    this.route_result = "DISCONNECT";
                    break;
                }
                if (!r.equals("TERMINATION") || !this.alerting && !this.device.picked) continue;
                this.route_result = this.device.isDisconnected() ? "DISCONNECT" : "TERMINATION";
                break;
            }
            if (this.playNoise && this.startPlayback()) {
                p = true;
                r = this.device.playNoise(this.termmask, 5);
                this.stopPlayback();
                if (r.equals("DISCONNECT")) {
                    this.route_result = "DISCONNECT";
                    break;
                }
                if (r.equals("DTMF")) {
                    this.route_result = "TERMINATION";
                    break;
                }
                if (r.equals("TIMEOUT")) continue;
                this.playNoise = false;
                continue;
            }
            if (!this.device.connecting) {
                this.route_result = "TERMINATION";
                break;
            }
            if (!this.device.answered) {
                if (this.device.getPort().isCallDisconnected()) {
                    this.route_result = "DISCONNECT";
                    break;
                }
            } else {
                if (this.device.isDisconnected()) {
                    this.route_result = "DISCONNECT";
                    break;
                }
                if (!(p || this.connected || this.routing || this.device.isRouted())) {
                    if (p2) {
                        this.playing = true;
                        String result = this.device.playTone(this.progressTone, this.termmask, -1);
                        this.playing = false;
                        if (result.equals("TERMINATION")) {
                            p = true;
                        }
                    } else {
                        p2 = true;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else if (this.digcheck && this.device.checkDigit(this.termmask)) {
                    if (!this.waiting) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.route_result = this.device.isDisconnected() ? "DISCONNECT" : "TERMINATION";
                    break;
                }
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.device.toLog("waiting=" + this.waiting + " route_request=" + route_request + " routedPort=" + this.routedPort + " route_result=" + this.route_result + " connected=" + this.connected + " pick=" + this.device.picked);
        this.play = false;
        this.alerting = false;
        this.playNoise = false;
        this.expired = true;
        this.device.connecting = false;
        this.device.connecting_port = null;
        if (this.waiting && !RouteRequest.removeRouteRequest(this) && this.routedPort != null) {
            if (!this.route_result.equals("DISCONNECT") && this.connected) {
                while (this.route_result.equals("TERMINATION") && !this.device.isDisconnected()) {
                    this.waitForRoute();
                }
                return this.route_result;
            }
            this.routedPort.terminate();
            if (this.device.picked) {
                return "VOICE";
            }
        }
        return this.route_result;
    }

    private boolean route(CTIPort ctiport) {
        this.routing = true;
        if (this.replaced) {
            this.device.terminate();
        } else {
            this.stopAlerting();
        }
        boolean result = false;
        try {
            result = this.device.route(ctiport, this.resApp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.routing = false;
        return result;
    }

    void setResult(String result) {
        this.device.toLog("setResult=" + result);
        this.route_result = result;
        this.waiting = false;
        if (this.replaced) {
            this.device.unrouteFromHold(this.routedPort);
        } else {
            this.stopAlerting();
        }
        this.notifyRoute();
    }

    CTIPort getRoutedPort() {
        return this.routedPort;
    }

    private int clearCall(String result, int cause) {
        if (!this.device.isDisconnected()) {
            Port port;
            this.device.setCause(cause);
            if (result.equals("BUSY") && (cause == 23 || cause == 22)) {
                this.device.setForwardedNumber(this.routedPort.getConnectedPartyNumber());
            }
            if ((port = this.routedPort.getPort()) instanceof SipPort) {
                SipPort sip = (SipPort)port;
                this.device.setSessionProperty("call-disconnect-code", sip.getStatusCode());
                this.device.setSessionProperty("call-disconnect-description", sip.getReasonPhrase());
            } else if (result.equals("BUSY")) {
                this.device.setSessionProperty("call-disconnect-code", cause);
            }
            this.setResult(result);
        }
        this.routedPort.disconnect(cause);
        return 4;
    }

    public int process(CTIPort ctiport) {
        this.routedPort = ctiport;
        Port slavePort = ctiport.getPort();
        int ca_mintime = slavePort instanceof PhoneLine ? 1 : 3;
        long st = System.currentTimeMillis();
        String res = ctiport.makeCall(this.routedNumber, ca_mintime, this.callingNumber, this.callInfo, this.device);
        this.device.toLog("routeCall : device=" + ctiport.getPortName() + " res=" + res);
        if (res.equals("ERROR")) {
            this.routedPort = null;
            return -1;
        }
        if (res.equals("INBOUND")) {
            this.routedPort = null;
            return 1;
        }
        if (res.equals("NO DIAL TONE")) {
            return this.clearCall("NO DIAL TONE", 2);
        }
        if (res.equals("COMPATIBILITY")) {
            return this.clearCall("COMPATIBILITY", 88);
        }
        if (res.equals("BUSY")) {
            return this.clearCall("BUSY", ctiport.getCause(res));
        }
        if (this.device.isDisconnected()) {
            return this.clearCall("DISCONNECT", 16);
        }
        this.device.connecting_port = slavePort;
        this.notifyRoute();
        if (slavePort instanceof PhoneLine) {
            ((PhoneLine)slavePort).setRouteSocket(this.device.getRouteSocket());
        } else if (this.device.getPort() instanceof PhoneLine) {
            ((PhoneLine)this.device.getPort()).setRouteSocket((RouteSocket)((Object)slavePort));
        }
        if (res.equals("ALERTED") || res.equals("PROGRESS") || res.equals("INBAND") || res.equals("NO ANSWER") || res.equals("NO RINGBACK")) {
            boolean transparentPI = false;
            boolean bl = this.allowMediaConnect = !(!this.allowMediaConnect && !this.device.answered || slavePort instanceof MediaSocket && !((MediaSocket)((Object)slavePort)).isMediaConnectAllowed());
            if (res.equals("NO RINGBACK") || res.equals("PROGRESS")) {
                if (this.progressAllowed && !this.device.accepted && !this.device.progressIncomingCall(1)) {
                    return this.clearCall("ERROR", 111);
                }
            } else if (res.equals("NO ANSWER") || res.equals("INBAND")) {
                if (this.progressAllowed) {
                    if (this.allowMediaConnect) {
                        if (!this.device.accepted && !this.device.progressIncomingCall(8)) {
                            return this.clearCall("ERROR", 111);
                        }
                        transparentPI = this.route(ctiport);
                    } else if (!this.device.accepted && !this.device.progressIncomingCall(1)) {
                        return this.clearCall("ERROR", 111);
                    }
                } else {
                    if (!this.device.accepted && !this.device.acceptCall(0)) {
                        return this.clearCall("ERROR", 111);
                    }
                    if (this.allowMediaConnect) {
                        transparentPI = this.route(ctiport);
                    }
                }
            } else if (res.equals("ALERTED")) {
                if (!this.device.accepted && !this.device.acceptCall(0)) {
                    return this.clearCall("ERROR", 111);
                }
                if (slavePort instanceof PhoneLine) {
                    if (this.acceptedRingback) {
                        this.startAlerting();
                    }
                } else if (this.device.getPort() instanceof PhoneLine) {
                    this.startAlerting();
                } else {
                    if (this.allowMediaConnect) {
                        transparentPI = this.route(ctiport);
                    }
                    if (!transparentPI && !this.silent && this.acceptedRingback) {
                        this.startAlerting();
                    }
                }
            }
            do {
                int timeoutLeft;
                if ((timeoutLeft = this.timeout - (int)((System.currentTimeMillis() - st) / 1000L)) <= 0) {
                    return this.clearCall("NO ANSWER", 19);
                }
                res = ctiport.progressCall(timeoutLeft);
                if (res.equals("PROGRESS")) {
                    if (!(this.progressAllowed ? !this.device.accepted && !this.device.progressIncomingCall(1) : !this.device.accepted && !this.device.acceptCall(0))) continue;
                    return this.clearCall("ERROR", 111);
                }
                if (res.equals("INBAND")) {
                    if (transparentPI) continue;
                    if (this.progressAllowed) {
                        if (this.allowMediaConnect) {
                            if (!this.device.answered && !this.device.progressIncomingCall(8)) {
                                return this.clearCall("ERROR", 111);
                            }
                            transparentPI = this.route(ctiport);
                            continue;
                        }
                        if (this.device.accepted || this.device.progressIncomingCall(1)) continue;
                        return this.clearCall("ERROR", 111);
                    }
                    if (!this.device.accepted && !this.device.acceptCall(0)) {
                        return this.clearCall("ERROR", 111);
                    }
                    if (!this.allowMediaConnect) continue;
                    transparentPI = this.route(ctiport);
                    continue;
                }
                if (!res.equals("ALERTED")) continue;
                if (!this.device.answered && !this.device.acceptCall(0)) {
                    return this.clearCall("ERROR", 111);
                }
                if (this.device.getPort() instanceof PhoneLine) {
                    if (this.alerting || transparentPI) continue;
                    this.startAlerting();
                    continue;
                }
                if (!transparentPI && this.allowMediaConnect) {
                    transparentPI = this.route(ctiport);
                }
                if (transparentPI || this.silent || !this.acceptedRingback) continue;
                this.startAlerting();
            } while (res.equals("PROGRESS") || res.equals("INBAND") || res.equals("ALERTED"));
        }
        if (res.equals("ANSWERED") || res.equals("VOICE") || res.equals("FAX") || res.equals("AUTOANSWER")) {
            ctiport.setConnectionTime();
            if (ca0time > 0 && System.currentTimeMillis() - st < (long)ca0time) {
                return this.clearCall("BUSY", 34);
            }
            if (!(this.progressAllowed || this.device.accepted || this.device.acceptCall(0))) {
                return this.clearCall("ERROR", 111);
            }
            boolean wasAnswered = this.device.answered;
            if (!wasAnswered && !this.device.answerCall()) {
                return this.clearCall("ERROR", 111);
            }
            if (res.equals("ANSWERED") || res.equals("FAX")) {
                res = "VOICE";
            }
            this.connected = true;
            if (!this.route(ctiport)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.extdigits.length() > 0 && wasAnswered) {
                ctiport.dial(this.extdigits);
            }
            if (!this.route(ctiport)) {
                return this.clearCall("COMPATIBILITY", slavePort.isCallDisconnected() ? slavePort.getDisconnectCause() : 88);
            }
            this.setResult(res);
            if (this.extdigits.length() > 0 && !wasAnswered) {
                ctiport.dial(this.extdigits);
            }
            ctiport.setApplicationName(this.resApp);
            return 2;
        }
        if (res.equals("DISCONNECT")) {
            ctiport.disconnect(16);
            return 4;
        }
        if (res.equals("NO ANSWER") || res.equals("ALERTED")) {
            ctiport.disconnect(16);
            return this.clearCall("NO ANSWER", 19);
        }
        if (res.equals("STOPPED")) {
            this.clearCall(res, 16);
        }
        if (res.equals("BUSY")) {
            return this.clearCall("BUSY", slavePort.getDisconnectCause());
        }
        if (res.equals("PROGRESS") || res.equals("INBAND")) {
            res = "NO RINGBACK";
        }
        return this.clearCall(res, 18);
    }
}

