/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.telephony.PipeSocket;
import com.smile.telephony.Port;
import com.smile.telephony.RecorderResource;
import com.smile.telephony.Resource;
import com.smile.telephony.ResourceManager;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;
import smile.util.ResourceStore;

public abstract class RouteSocket {
    public static final int RECEIVER = 1;
    public static final int TRANSMITTER = 2;
    public static final int BIDIRECTION = 3;
    public static final int SCBUS = 1;
    public static final int PIPE = 2;
    public static final int PLINE = 3;
    private Vector transmitters = new Vector();
    private Vector receivers = new Vector();
    private Resource transmitter;
    private Resource receiver;
    protected static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");

    protected abstract int getSocketType();

    protected abstract boolean routeTransmitter(RouteSocket var1);

    protected abstract boolean routeReceiver(RouteSocket var1);

    protected abstract boolean unrouteTransmitter(RouteSocket var1);

    protected abstract boolean unrouteReceiver(RouteSocket var1);

    public boolean route(Resource resource, int mode) {
        RouteSocket socket = resource.getRouteSocket();
        ResourceStore.toLog(this + " ROUTE TO " + resource + " mode=" + mode + " transmitter=" + this.transmitter + " receiver=" + this.receiver + " socket=" + socket + " transmitters=" + this.transmitters + " receivers=" + this.receivers);
        boolean routedTx = false;
        if ((mode & 1) != 0 && resource != this.transmitter) {
            if (this.transmitter != null) {
                boolean bl = routedTx = socket == this.transmitter.getRouteSocket();
                if (!routedTx && !this.unrouteReceiver(this.transmitter.getRouteSocket())) {
                    return false;
                }
            }
            if (!routedTx) {
                if (!this.routeReceiver(socket)) {
                    if (this.transmitter != null && !this.routeReceiver(this.transmitter.getRouteSocket())) {
                        this.transmitter = null;
                    }
                    return false;
                }
                if (!this.transmitters.contains(resource)) {
                    this.transmitters.addElement(resource);
                }
                this.transmitter = resource;
                routedTx = true;
            }
        }
        if ((mode & 2) != 0 && resource != this.receiver) {
            if (this.receiver != null) {
                if (socket == this.receiver.getRouteSocket()) {
                    return true;
                }
                if (socket.getSocketType() != 1 && !(resource instanceof RecorderResource) && !this.unrouteTransmitter(this.receiver.getRouteSocket())) {
                    if (routedTx) {
                        this.unroute(resource, 1);
                    }
                    return false;
                }
            }
            if (!this.routeTransmitter(socket)) {
                if (this.receiver != null && !this.routeTransmitter(this.receiver.getRouteSocket())) {
                    this.receiver = null;
                }
                if (routedTx) {
                    this.unroute(resource, 1);
                }
                return false;
            }
            if (!this.receivers.contains(resource)) {
                this.receivers.addElement(resource);
            }
            if (!(resource instanceof RecorderResource)) {
                this.receiver = resource;
            }
        }
        ResourceStore.toLog(this + " ROUTED TO " + resource + " transmitter=" + this.transmitter + " receiver=" + this.receiver + " OK");
        return true;
    }

    public boolean unroute(Resource resource, int mode) {
        RouteSocket socket = resource.getRouteSocket();
        boolean result = true;
        ResourceStore.toLog(this + " UNROUTE FROM " + resource.getName() + " mode=" + mode + " transmitter=" + this.transmitter + " receiver=" + this.receiver);
        if ((mode & 1) != 0) {
            if (resource == this.transmitter) {
                if (!this.unrouteReceiver(socket)) {
                    return false;
                }
                this.transmitter = null;
            }
            this.transmitters.removeElement(resource);
        }
        if ((mode & 2) != 0) {
            if (!this.unrouteTransmitter(socket)) {
                return false;
            }
            if (resource == this.receiver) {
                this.receiver = null;
            }
            this.receivers.removeElement(resource);
        }
        ResourceStore.toLog(this + " UNROUTED FROM " + resource.getName() + " transmitter=" + this.transmitter + " receiver=" + this.receiver + " OK");
        return true;
    }

    public boolean isRouted(Resource resource, int mode) {
        if ((mode & 1) != 0 && resource != this.transmitter) {
            return false;
        }
        return (mode & 2) != 0 && resource == this.receiver;
    }

    public boolean holdConnection() {
        return this.holdConnection(3);
    }

    public boolean holdConnection(int mode) {
        if ((mode & 1) != 0 && this.transmitter != null) {
            if (!this.unrouteReceiver(this.transmitter.getRouteSocket())) {
                return false;
            }
            this.transmitter = null;
        }
        if ((mode & 2) != 0 && this.receiver != null) {
            if (!this.unrouteTransmitter(this.receiver.getRouteSocket())) {
                return false;
            }
            this.receiver = null;
        }
        return true;
    }

    public boolean resumeConnection() {
        return this.resumeConnection(3);
    }

    public boolean resumeConnection(int mode) {
        if ((mode & 1) != 0 && !this.transmitters.isEmpty() && !this.route((Resource)this.transmitters.lastElement(), 1)) {
            return false;
        }
        return (mode & 2) == 0 || this.receivers.isEmpty() || this.route((Resource)this.receivers.lastElement(), 2);
    }

    public boolean resumeConnection(Resource resource) {
        return this.resumeConnection(resource, 3);
    }

    public boolean resumeConnection(Resource resource, int mode) {
        int i;
        if ((mode & 1) != 0 && resource != this.transmitter) {
            for (i = 0; i < this.transmitters.size(); ++i) {
                if (!resource.equals((Resource)this.transmitters.elementAt(i))) continue;
                if (this.route(resource, 1)) break;
                return false;
            }
        }
        if ((mode & 2) != 0 && resource != this.receiver) {
            for (i = 0; i < this.receivers.size(); ++i) {
                if (!resource.equals((Resource)this.receivers.elementAt(i))) continue;
                if (this.route(resource, 2)) break;
                return false;
            }
        }
        return true;
    }

    public Resource findResource(int type) {
        return this.findResource(type, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource findResource(int type, int mode) {
        Resource r;
        int i;
        Vector vector;
        if ((mode & 1) != 0) {
            vector = this.transmitters;
            synchronized (vector) {
                for (i = 0; i < this.transmitters.size(); ++i) {
                    r = (Resource)this.transmitters.elementAt(i);
                    if ((r.getType() & type) == 0) continue;
                    return r;
                }
            }
        }
        if ((mode & 2) != 0) {
            vector = this.receivers;
            synchronized (vector) {
                for (i = 0; i < this.receivers.size(); ++i) {
                    r = (Resource)this.receivers.elementAt(i);
                    if ((r.getType() & type) == 0) continue;
                    return r;
                }
            }
        }
        return null;
    }

    public Resource findResource(Vector resources, int type, int mode) {
        Resource resource = null;
        for (int i = 0; i < resources.size(); ++i) {
            resource = (Resource)resources.elementAt(i);
            if ((resource.getType() & type) == 0 || !this.isRoutable(resource) || !resource.seize()) continue;
            if (this.route(resource, mode)) {
                return resource;
            }
            resource.release();
        }
        return null;
    }

    public Resource attachResource(int type, int mode) {
        int i;
        Resource resource = null;
        for (i = 0; i < this.transmitters.size(); ++i) {
            resource = (Resource)this.transmitters.elementAt(i);
            if ((resource.getType() & type) == 0 || !(resource == this.transmitter ? (resource.getType() & 1) == 0 && this.route(resource, mode) : this.route(resource, mode))) continue;
            return resource;
        }
        for (i = 0; i < this.receivers.size(); ++i) {
            resource = (Resource)this.receivers.elementAt(i);
            if ((resource.getType() & type) == 0 || !(resource == this.receiver ? (resource.getType() & 1) == 0 && this.route(resource, mode) : this.route(resource, mode))) continue;
            return resource;
        }
        return this.findResource(ResourceManager.getResources(), type, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources(boolean all) {
        Resource rc;
        if (all) {
            Resource rc2;
            Enumeration i;
            Vector vector = this.transmitters;
            synchronized (vector) {
                i = this.transmitters.elements();
                while (i.hasMoreElements()) {
                    rc2 = (Resource)i.nextElement();
                    if (rc2 instanceof Port) continue;
                    if (rc2 == this.transmitter) {
                        this.unrouteReceiver(rc2.getRouteSocket());
                        this.transmitter = null;
                    }
                    this.transmitters.removeElement(rc2);
                    if (this.receivers.contains(rc2)) continue;
                    rc2.release();
                }
            }
            vector = this.receivers;
            synchronized (vector) {
                i = this.receivers.elements();
                while (i.hasMoreElements()) {
                    rc2 = (Resource)i.nextElement();
                    if (rc2 instanceof Port) continue;
                    this.unrouteTransmitter(rc2.getRouteSocket());
                    if (rc2 == this.receiver) {
                        this.receiver = null;
                    }
                    this.receivers.removeElement(rc2);
                    if (this.transmitters.contains(rc2)) continue;
                    rc2.release();
                }
            }
        }
        if (this.transmitter != null && !(this.transmitter instanceof Port) && !(this.transmitter instanceof PipeSocket)) {
            rc = this.transmitter;
            this.unrouteReceiver(rc.getRouteSocket());
            this.transmitters.removeElement(rc);
            this.transmitter = null;
            if (this.receiver != rc) {
                rc.release();
            }
        }
        if (this.receiver != null && !(this.receiver instanceof Port) && !(this.receiver instanceof PipeSocket)) {
            rc = this.receiver;
            this.unrouteTransmitter(rc.getRouteSocket());
            this.receivers.removeElement(rc);
            if (rc == this.receiver) {
                this.receiver = null;
            }
            rc.release();
        }
    }

    public boolean isRoutable(Resource resource) {
        RouteSocket socket = resource.getRouteSocket();
        return socket != null && this.getSocketType() == socket.getSocketType();
    }

    public Resource getReceiver() {
        return this.receiver;
    }

    public Resource getTransmitter() {
        return this.transmitter;
    }

    public Vector getReceivers() {
        return this.receivers;
    }

    public Vector getTransmitters() {
        return this.transmitters;
    }
}

