/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.sound.WavAudioFormat;
import com.smile.sound.wavFormatHeader;
import com.smile.telephony.AudioConverter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import smile.util.ResourceStore;

public class ToneGenerator {
    public static final String BEEP = "Beep";
    public static final String ROGER = "Roger";
    public static final String CONFIRM = "Confirmation";
    public static final String CONFERENCE = "Conference";
    public static final String HOLD = "Hold";
    public static final String DIAL = "Dial Tone";
    public static final String BUSY = "Busy";
    public static final String RINGBACK = "Ringback";
    public static final String RINGBACK2 = "Ringback2";
    public static final String PROGRESS = "Progress";
    public static final String PROGRESS2 = "Progress2";
    public static final String REORDER = "Reorder";
    public static final String CALLWAIT = "Call Waiting";
    public static final String DND = "DND Tone";
    public static final String FAX_RX = "Fax CED";
    public static final String FAX_TX = "Fax CNG";
    public static final String SIT = "SIT Tone";
    public static final String NOISE = "Comfort Noise";
    public static final String DTMF1 = "1";
    public static final String DTMF2 = "2";
    public static final String DTMF3 = "3";
    public static final String DTMF4 = "4";
    public static final String DTMF5 = "5";
    public static final String DTMF6 = "6";
    public static final String DTMF7 = "7";
    public static final String DTMF8 = "8";
    public static final String DTMF9 = "9";
    public static final String DTMF0 = "0";
    public static final String DTMFS = "*";
    public static final String DTMFH = "#";
    public static final String DTMFA = "A";
    public static final String DTMFB = "B";
    public static final String DTMFC = "C";
    public static final String DTMFD = "D";
    public static final int[] BEEP_DEF = new int[]{1000, 0, 500, 500, 0};
    public static final int[] ROGER_DEF = new int[]{2520, 0, 250, 0, 0};
    public static final int[] CONFM_DEF = new int[]{620, 0, 500, 500, 2};
    public static final int[] CONF_DEF = new int[]{350, 0, 500, 0, 1};
    public static final int[] HOLD_DEF = new int[]{620, 0, 250, 250, 1};
    public static final int[] DIAL_DEF = new int[]{350, 440, 10000, 0, 0};
    public static final int[] BACK1_DEF = new int[]{440, 480, 2000, 4000, 1};
    public static final int[] BACK2_DEF = new int[]{440, 480, 1000, 3000, 2};
    public static final int[] BACK3_DEF = new int[]{440, 480, 250, 3000, 1};
    public static final int[] BACK4_DEF = new int[]{440, 480, 250, 0, 1};
    public static final int[] BUSY_DEF = new int[]{480, 620, 500, 500, 0};
    public static final int[] RRDER_DEF = new int[]{480, 620, 250, 250, 0};
    public static final int[] REORD_DEF = new int[]{480, 620, 10000, 250, 40};
    public static final int[] CWAIT_DEF = new int[]{440, 0, 300, 0, 1, 16};
    public static final int[] DND_DEF = new int[]{480, 620, 500, 500, 2};
    public static final int[] CNG_DEF = new int[]{1100, 0, 1000, 4000, 0};
    public static final int[] CED_DEF = new int[]{2150, 0, 2000, 3000, 0};
    public static final int[] SIT1_DEF = new int[]{985, 0, 380, 0, 0, 32};
    public static final int[] SIT2_DEF = new int[]{1428, 0, 380, 0, 0, 32};
    public static final int[] SIT3_DEF = new int[]{1777, 0, 380, 1000, 0, 32};
    public static final int[] NOISE_DEF = new int[]{0, 0, 10000, 0, 0};
    public static final int[] DTMF1_DEF = new int[]{697, 1209, 100, 50, 0};
    public static final int[] DTMF2_DEF = new int[]{697, 1336, 100, 50, 0};
    public static final int[] DTMF3_DEF = new int[]{697, 1477, 100, 50, 0};
    public static final int[] DTMF4_DEF = new int[]{770, 1209, 100, 50, 0};
    public static final int[] DTMF5_DEF = new int[]{770, 1336, 100, 50, 0};
    public static final int[] DTMF6_DEF = new int[]{770, 1477, 100, 50, 0};
    public static final int[] DTMF7_DEF = new int[]{852, 1209, 100, 50, 0};
    public static final int[] DTMF8_DEF = new int[]{852, 1336, 100, 50, 0};
    public static final int[] DTMF9_DEF = new int[]{852, 1477, 100, 50, 0};
    public static final int[] DTMF0_DEF = new int[]{941, 1336, 100, 50, 0};
    public static final int[] DTMFS_DEF = new int[]{941, 1209, 100, 50, 0};
    public static final int[] DTMFH_DEF = new int[]{941, 1477, 100, 50, 0};
    public static final int[] DTMFA_DEF = new int[]{697, 1633, 100, 50, 0};
    public static final int[] DTMFB_DEF = new int[]{770, 1633, 100, 50, 0};
    public static final int[] DTMFC_DEF = new int[]{852, 1633, 100, 50, 0};
    public static final int[] DTMFD_DEF = new int[]{941, 1633, 100, 50, 0};
    private static Hashtable tonedefs = new Hashtable();
    private static Hashtable tonetable = new Hashtable();
    private static int amplitude = 64;
    private static int noise = 64;
    private static int sampling = 32000;
    private static float rate = 8000.0f;

    public static void init(Vector formats) {
        Hashtable tones = ToneGenerator.getTones();
        Enumeration e = formats.elements();
        while (e.hasMoreElements()) {
            WavAudioFormat format = (WavAudioFormat)e.nextElement();
            Hashtable<String, byte[]> t = new Hashtable<String, byte[]>();
            Enumeration en = tones.keys();
            while (en.hasMoreElements()) {
                String tone = (String)en.nextElement();
                try {
                    byte[] source = (byte[])tones.get(tone);
                    byte[] data = AudioConverter.convert(source, WavAudioFormat.PCM_LINEAR16, format);
                    if (data == null) continue;
                    t.put(tone, data);
                }
                catch (Exception x) {
                    ResourceStore.error("TGEN", x);
                }
            }
            tonetable.put(format, t);
        }
    }

    public static Hashtable getTones() {
        return (Hashtable)tonetable.get(WavAudioFormat.PCM_LINEAR16);
    }

    public static Hashtable getTones(WavAudioFormat format) {
        return (Hashtable)tonetable.get(format);
    }

    public static int[] getDef(String tone) {
        return (int[])tonedefs.get(tone);
    }

    public static byte[] get(String tone) {
        return (byte[])ToneGenerator.getTones().get(tone);
    }

    public static byte[] get(String tone, WavAudioFormat format) {
        Hashtable t = ToneGenerator.getTones(format);
        if (t == null) {
            return null;
        }
        return (byte[])t.get(tone);
    }

    public static void setTones(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String tone = (String)map.get("tone");
            List tonedef = (List)map.get("def");
            int[] def = new int[tonedef.size()];
            if (tonedef == null) continue;
            for (int n = 0; n < def.length; ++n) {
                def[n] = (Integer)tonedef.get(n);
            }
            Hashtable tones = (Hashtable)tonetable.get(WavAudioFormat.PCM_LINEAR16);
            tones.put(tone, ToneGenerator.generate2(def));
        }
    }

    public static int getTime(String tone) {
        int[] ton = (int[])tonedefs.get(tone);
        return ton != null ? ton[2] + ton[3] : 0;
    }

    public static int getOnTime(String tone) {
        int[] ton = (int[])tonedefs.get(tone);
        return ton != null ? ton[2] : 0;
    }

    public static int getOffTime(String tone) {
        int[] ton = (int[])tonedefs.get(tone);
        return ton != null ? ton[3] : 0;
    }

    private static byte[] concat(Vector data) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < data.size(); ++i) {
            baos.write((byte[])data.elementAt(i));
        }
        return baos.toByteArray();
    }

    private static byte[] generate(int[] args) {
        int samples;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        double tp = Math.PI * 2;
        double c1 = rate / (float)args[0];
        double c2 = args[1] != 0 ? (double)(rate / (float)args[1]) : 0.0;
        int frac = samples = (int)((float)args[2] * rate / 1000.0f);
        if (args[4] > 1) {
            frac = samples / (args[4] * 2 - 1);
        }
        int amp = args.length > 5 ? args[5] : amplitude;
        int cf = 0;
        boolean on = true;
        for (int i = 0; i < samples; ++i) {
            int b = 0;
            if (on) {
                b = c2 != 0.0 ? (int)((byte)((Math.sin((double)i / c1 * tp) + Math.sin((double)i / c2 * tp)) * (double)amp)) : (int)((byte)(Math.sin((double)i / c1 * tp) * (double)amp));
            }
            if (++cf == frac) {
                on = !on;
                cf = 0;
            }
            baos.write(0);
            baos.write(b);
        }
        samples = (int)((float)args[3] * rate / 500.0f);
        for (int n = 0; n < samples; ++n) {
            baos.write(0);
        }
        return baos.toByteArray();
    }

    private static byte[] generate2(int[] args) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        double tp = Math.PI * 2;
        double c1 = rate / (float)args[0];
        double c2 = args[1] != 0 ? (double)(rate / (float)args[1]) : 0.0;
        for (int n = 2; n < args.length; ++n) {
            int samples = (int)((float)args[n] * rate / 1000.0f);
            boolean on = n % 2 == 0;
            for (int i = 0; i < samples; ++i) {
                int b = 0;
                if (on) {
                    b = c2 != 0.0 ? (int)((byte)((Math.sin((double)i / c1 * tp) + Math.sin((double)i / c2 * tp)) * (double)amplitude)) : (int)((byte)(Math.sin((double)i / c1 * tp) * (double)amplitude));
                }
                baos.write(0);
                baos.write(b);
            }
        }
        return baos.toByteArray();
    }

    private static byte[] getNoise(double level, int msec) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Random random = new Random();
        int samples = (int)((float)msec * rate / 500.0f);
        byte[] array = new byte[samples];
        for (int i = 0; i < samples; i += 2) {
            int n = (int)((double)Math.round(level * random.nextDouble()) - level / 2.0);
            array[i] = (byte)n;
            array[i + 1] = (byte)(n >> 8);
        }
        return array;
    }

    public static void toWavFile(String name, byte[] data) {
        try {
            new File(name).delete();
            wavFormatHeader hdr = new wavFormatHeader(WavAudioFormat.PCM_LINEAR16);
            FileOutputStream fos = new FileOutputStream(name);
            hdr.setDataLength(data.length);
            fos.write(hdr.toByteArray());
            fos.write(data);
            fos.close();
        }
        catch (Exception e) {
            ResourceStore.error("TGEN", e);
        }
    }

    public static void makeFiles() {
        Hashtable tones = ToneGenerator.getTones();
        Enumeration en = tones.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String filename = "./tones/" + key + ".wav";
            ToneGenerator.toWavFile(filename, (byte[])tones.get(key));
        }
    }

    static {
        Hashtable<String, byte[]> tones = new Hashtable<String, byte[]>();
        tones.put(DTMF1, ToneGenerator.generate(DTMF1_DEF));
        tones.put(DTMF2, ToneGenerator.generate(DTMF2_DEF));
        tones.put(DTMF3, ToneGenerator.generate(DTMF3_DEF));
        tones.put(DTMF4, ToneGenerator.generate(DTMF4_DEF));
        tones.put(DTMF5, ToneGenerator.generate(DTMF5_DEF));
        tones.put(DTMF6, ToneGenerator.generate(DTMF6_DEF));
        tones.put(DTMF7, ToneGenerator.generate(DTMF7_DEF));
        tones.put(DTMF8, ToneGenerator.generate(DTMF8_DEF));
        tones.put(DTMF9, ToneGenerator.generate(DTMF9_DEF));
        tones.put(DTMF0, ToneGenerator.generate(DTMF0_DEF));
        tones.put(DTMFS, ToneGenerator.generate(DTMFS_DEF));
        tones.put(DTMFH, ToneGenerator.generate(DTMFH_DEF));
        tones.put(DTMFA, ToneGenerator.generate(DTMFA_DEF));
        tones.put(DTMFB, ToneGenerator.generate(DTMFB_DEF));
        tones.put(DTMFC, ToneGenerator.generate(DTMFC_DEF));
        tones.put(DTMFD, ToneGenerator.generate(DTMFD_DEF));
        tones.put(BEEP, ToneGenerator.generate(BEEP_DEF));
        tones.put(ROGER, ToneGenerator.generate(ROGER_DEF));
        tones.put(CONFIRM, ToneGenerator.generate(CONFM_DEF));
        tones.put(CONFERENCE, ToneGenerator.generate(CONF_DEF));
        tones.put(HOLD, ToneGenerator.generate(HOLD_DEF));
        tones.put(DIAL, ToneGenerator.generate(DIAL_DEF));
        tones.put(RINGBACK, ToneGenerator.generate(BACK1_DEF));
        tones.put(RINGBACK2, ToneGenerator.generate(BACK2_DEF));
        tones.put(PROGRESS, ToneGenerator.generate(BACK3_DEF));
        tones.put(PROGRESS2, ToneGenerator.generate(BACK4_DEF));
        tones.put(BUSY, ToneGenerator.generate(BUSY_DEF));
        tones.put(REORDER, ToneGenerator.generate(REORD_DEF));
        tones.put(CALLWAIT, ToneGenerator.generate(CWAIT_DEF));
        tones.put(DND, ToneGenerator.generate(DND_DEF));
        tones.put(FAX_RX, ToneGenerator.generate(CED_DEF));
        tones.put(FAX_TX, ToneGenerator.generate(CNG_DEF));
        byte[] sit1 = ToneGenerator.generate(SIT1_DEF);
        byte[] sit2 = ToneGenerator.generate(SIT2_DEF);
        byte[] sit3 = ToneGenerator.generate(SIT3_DEF);
        Vector<byte[]> v = new Vector<byte[]>();
        v.addElement(sit1);
        v.addElement(sit2);
        v.addElement(sit3);
        try {
            tones.put(SIT, ToneGenerator.concat(v));
        }
        catch (Exception e) {
            System.err.println("SIT Tone: " + e.toString());
        }
        tones.put(NOISE, ToneGenerator.getNoise(noise, NOISE_DEF[2]));
        tonetable.put(WavAudioFormat.PCM_LINEAR16, tones);
        tonedefs.put(BEEP, BEEP_DEF);
        tonedefs.put(ROGER, ROGER_DEF);
        tonedefs.put(CONFIRM, CONFM_DEF);
        tonedefs.put(CONFERENCE, CONF_DEF);
        tonedefs.put(HOLD, HOLD_DEF);
        tonedefs.put(DIAL, DIAL_DEF);
        tonedefs.put(RINGBACK, BACK1_DEF);
        tonedefs.put(RINGBACK2, BACK2_DEF);
        tonedefs.put(PROGRESS, BACK3_DEF);
        tonedefs.put(PROGRESS2, BACK4_DEF);
        tonedefs.put(BUSY, BUSY_DEF);
        tonedefs.put(REORDER, RRDER_DEF);
        tonedefs.put(CALLWAIT, CWAIT_DEF);
        tonedefs.put(DND, DND_DEF);
        tonedefs.put(FAX_RX, CED_DEF);
        tonedefs.put(FAX_TX, CNG_DEF);
        tonedefs.put(SIT, SIT3_DEF);
    }
}

