/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec;

import com.smile.telephony.AudioCodec;
import com.smile.telephony.codec.ALaw;
import com.smile.telephony.codec.Linear16;
import com.smile.telephony.codec.Opus;
import com.smile.telephony.codec.ULaw;
import java.io.IOException;
import java.io.InputStream;

public class ConvertedInputStream
extends InputStream {
    private InputStream istream;
    private AudioCodec decoder;
    private AudioCodec encoder;
    private byte[] de;
    private byte[] ld;
    private byte[] le;
    private byte[] en;
    private int lastRead = 0;
    private int ldOff = 0;
    private int leOff = 0;
    private int delength;
    private int ldlength;
    private int lelength;
    private int enlength;
    private float ec;

    public ConvertedInputStream(InputStream in, AudioCodec dec, AudioCodec enc) {
        this.istream = in;
        int ds = 16;
        int es = 16;
        this.decoder = dec;
        this.encoder = enc;
        this.delength = this.decoder.getFrameSize() * this.decoder.getBufferDepth();
        this.ldlength = this.decoder.getFrameTime() * ds * this.decoder.getBufferDepth();
        this.lelength = this.encoder.getFrameTime() * es * this.encoder.getBufferDepth();
        this.enlength = this.encoder.getFrameSize() * this.encoder.getBufferDepth();
        this.de = new byte[this.delength];
        this.ld = new byte[this.ldlength];
        this.le = new byte[this.lelength];
        this.en = new byte[this.enlength];
        this.ec = (float)this.ldlength / (float)(this.lelength * this.delength);
    }

    public AudioCodec getEncoder() {
        return this.encoder;
    }

    public AudioCodec getDecoder() {
        return this.decoder;
    }

    @Override
    public int available() throws IOException {
        return this.lastRead + (int)Math.floor((float)this.istream.available() * this.ec) * this.enlength;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        if (this.read(buffer) == -1) {
            return -1;
        }
        return buffer[0];
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int result = this.read(buffer, 0, buffer.length);
        return result;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.lastRead == -1) {
            return -1;
        }
        if (this.lastRead > 0) {
            int m = Math.min(len, this.lastRead);
            System.arraycopy(this.en, this.enlength - this.lastRead, buffer, offset, m);
            if (this.lastRead > m) {
                this.lastRead -= m;
                return m;
            }
        }
        if (this.encoder instanceof Opus && this.lelength != len) {
            this.lelength = len;
            this.le = new byte[len];
        } else if (this.decoder instanceof Linear16 && (this.encoder instanceof ALaw || this.encoder instanceof ULaw)) {
            int rd;
            int off = 0;
            int buflength = len * 2;
            byte[] buf = new byte[buflength];
            do {
                if ((rd = this.istream.read(buf, off, buflength - off)) != -1 || off != 0) continue;
                return -1;
            } while (rd > 0 && (off += rd) < buflength);
            if (this.encoder instanceof ALaw) {
                return ((ALaw)this.encoder).encode(buf, buffer, offset, off / 2);
            }
            return ((ULaw)this.encoder).encode(buf, buffer, offset, off / 2);
        }
        int past = len - this.lastRead;
        while (past > 0) {
            int encoded_length;
            if (this.ldOff == 0) {
                int rd;
                int off = 0;
                do {
                    if ((rd = this.istream.read(this.de, off, this.delength - off)) == -1) {
                        this.lastRead = -1;
                        return len - past;
                    }
                    if (rd != 0) continue;
                    return len - past;
                } while ((off += rd) < this.delength);
                if (this.decoder instanceof Linear16) {
                    this.ld = this.de;
                } else if (this.decoder.decode(this.de, this.ld) == -1) break;
            }
            if (this.ldlength == this.lelength) {
                if (this.encoder instanceof Opus) {
                    return this.encodeOpus(this.ld, buffer, offset);
                }
                encoded_length = this.encoder.encode(this.ld, this.en);
            } else if (this.ldlength > this.lelength) {
                System.arraycopy(this.ld, this.ldOff, this.le, 0, this.lelength);
                this.ldOff += this.lelength;
                if (this.ldOff >= this.ldlength) {
                    this.ldOff = 0;
                }
                if (this.encoder instanceof Opus) {
                    return this.encodeOpus(this.le, buffer, offset);
                }
                encoded_length = this.encoder.encode(this.le, this.en);
            } else {
                System.arraycopy(this.ld, 0, this.le, this.leOff, this.ldlength);
                this.leOff += this.ldlength;
                if (this.leOff < this.lelength) continue;
                this.leOff = 0;
                if (this.encoder instanceof Opus) {
                    return this.encodeOpus(this.le, buffer, offset);
                }
                encoded_length = this.encoder.encode(this.le, this.en);
            }
            if (encoded_length == -1) {
                throw new IOException("Encoding error");
            }
            int o = offset + len - past;
            int m = Math.min(past, encoded_length);
            System.arraycopy(this.en, 0, buffer, o, m);
            past -= m;
            if (this.lastRead == -1) break;
            this.lastRead = encoded_length - m;
        }
        return len - past;
    }

    private int encodeOpus(byte[] input, byte[] buffer, int offset) {
        byte[] output = new byte[4000];
        int encoded_length = this.encoder.encode(input, output);
        System.arraycopy(output, 0, buffer, offset, encoded_length);
        return encoded_length;
    }

    public void release() {
        this.decoder.release();
        this.encoder.release();
    }

    @Override
    public void close() throws IOException {
        this.release();
        this.istream.close();
    }
}

