/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec;

import com.smile.telephony.AudioCodec;
import com.smile.telephony.codec.ALaw;
import com.smile.telephony.codec.Linear16;
import com.smile.telephony.codec.Opus;
import com.smile.telephony.codec.ULaw;
import java.io.IOException;
import java.io.OutputStream;

public class ConvertedOutputStream
extends OutputStream {
    private int byteIn = 0;
    private int byteOut = 0;
    private OutputStream ostream;
    private AudioCodec decoder;
    private AudioCodec encoder;
    private byte[] en;
    private byte[] le;
    private byte[] ld;
    private byte[] de;
    private int lastWrite = 0;
    private int leOff = 0;
    private int delength;
    private int ldlength;
    private int lelength;
    private int enlength;
    private byte[] output = new byte[1024];

    public ConvertedOutputStream(OutputStream out, AudioCodec dec, AudioCodec enc) {
        this.ostream = out;
        int ds = 16;
        int es = 16;
        this.decoder = dec;
        this.encoder = enc;
        this.delength = this.decoder.getFrameSize() * this.decoder.getBufferDepth();
        this.ldlength = this.decoder.getFrameTime() * ds * this.decoder.getBufferDepth();
        this.lelength = this.encoder.getFrameTime() * es * this.encoder.getBufferDepth();
        this.enlength = this.encoder.getFrameSize() * this.encoder.getBufferDepth();
        this.de = new byte[this.delength];
        this.ld = new byte[this.ldlength];
        this.le = new byte[this.lelength];
        this.en = new byte[this.enlength];
    }

    public AudioCodec getEncoder() {
        return this.encoder;
    }

    public AudioCodec getDecoder() {
        return this.decoder;
    }

    @Override
    public void write(int i) {
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int len) throws IOException {
        if (this.decoder instanceof Opus) {
            int l;
            byte[] output;
            if (buffer != null) {
                byte[] input = new byte[len];
                System.arraycopy(buffer, offset, input, 0, len);
                output = ((Opus)this.decoder).decode(input);
            } else {
                output = ((Opus)this.decoder).decodePLC(len);
            }
            if (output == null) {
                return;
            }
            int c = 0;
            do {
                l = Math.min(this.le.length - this.lastWrite, output.length - c);
                System.arraycopy(output, c, this.le, this.lastWrite, l);
                this.lastWrite += l;
                if (this.lastWrite != this.le.length) continue;
                if (this.encoder.encode(this.le, this.en) == -1) {
                    throw new IOException("Encoding error");
                }
                this.ostream.write(this.en);
                this.lastWrite = 0;
            } while ((c += l) < output.length);
        } else if (this.encoder instanceof Linear16 && (this.decoder instanceof ALaw || this.decoder instanceof ULaw)) {
            int n = this.decoder instanceof ALaw ? ((ALaw)this.decoder).decode(buffer, offset, len, this.output) : ((ULaw)this.decoder).decode(buffer, offset, len, this.output);
            this.ostream.write(this.output, 0, n);
        } else {
            int past = len - this.lastWrite;
            if (this.lastWrite > 0) {
                int m = Math.min(this.lastWrite, len);
                System.arraycopy(buffer, offset, this.de, this.delength - this.lastWrite, m);
                this.lastWrite -= m;
                if (this.lastWrite == 0) {
                    this.convert();
                }
            }
            while (past > 0) {
                int off = offset + len - past;
                int m = Math.min(past, this.delength);
                System.arraycopy(buffer, off, this.de, 0, m);
                this.lastWrite = this.delength - m;
                past -= m;
                if (this.lastWrite != 0) continue;
                this.convert();
            }
        }
    }

    private int convert() throws IOException {
        if (this.decoder.decode(this.de, this.ld) == -1) {
            throw new IOException("Decoding error");
        }
        int encoded_length = 0;
        if (this.encoder instanceof Opus) {
            byte[] output = new byte[4000];
            encoded_length = this.encoder.encode(this.ld, output);
            if (encoded_length == -1) {
                throw new IOException("Encoding error");
            }
            this.ostream.write(output, 0, encoded_length);
        } else if (this.ld.length > this.le.length) {
            int ldOff = 0;
            do {
                System.arraycopy(this.ld, ldOff, this.le, 0, this.lelength);
                if (this.encoder instanceof Linear16) {
                    this.ostream.write(this.le);
                    encoded_length += this.le.length;
                    continue;
                }
                int length = this.encoder.encode(this.le, this.en);
                if (length == -1) {
                    throw new IOException("Encoding error");
                }
                this.ostream.write(this.en);
                encoded_length += length;
            } while ((ldOff += this.lelength) < this.ld.length);
        } else if (this.ldlength < this.lelength) {
            System.arraycopy(this.ld, 0, this.le, this.leOff, this.ldlength);
            if ((this.leOff += this.ldlength) >= this.lelength) {
                if (this.encoder instanceof Linear16) {
                    this.ostream.write(this.le);
                    encoded_length += this.le.length;
                } else {
                    encoded_length = this.encoder.encode(this.le, this.en);
                    if (encoded_length == -1) {
                        throw new IOException("Encoding error");
                    }
                    this.ostream.write(this.en);
                }
                this.leOff = 0;
            }
        } else if (this.encoder instanceof Linear16) {
            this.ostream.write(this.ld);
            encoded_length += this.ld.length;
        } else {
            encoded_length = this.encoder.encode(this.ld, this.en);
            if (encoded_length == -1) {
                throw new IOException("Encoding error");
            }
            this.ostream.write(this.en);
        }
        return encoded_length;
    }

    @Override
    public void flush() throws IOException {
        this.ostream.flush();
    }

    @Override
    public void close() throws IOException {
        this.release();
        this.ostream.close();
    }

    public void release() {
        this.decoder.release();
        this.encoder.release();
    }
}

