/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec;

import com.smile.telephony.AudioCodec;
import com.smile.telephony.audio.SignalProcessor;
import java.util.Map;
import smile.util.ResourceStore;

public class Opus
extends AudioCodec {
    public static final int MAX_PACKET_SAMPLES = 5760;
    public static final int MAX_PACKET_BUFFER = 4000;
    public static final int MAX_ENCODER_BYTES = 960;
    private long handle;
    private int direction;

    public static AudioCodec getCodec(int dir, AudioCodec ac) {
        return new Opus(dir, ac);
    }

    public Opus(int dir, AudioCodec ac) {
        super(ac);
        int fs = ac.getFrameSize() * 50;
        int ch = 1;
        if (dir == 1) {
            this.handle = Opus.encoder_create(fs, ch);
            Map params = ac.getParameters();
            if (params != null) {
                String maxbitrate;
                Object obj = params.get("stereo");
                if ("1".equals(obj)) {
                    // empty if block
                }
                if ((maxbitrate = (String)params.get("maxaveragebitrate")) != null) {
                    this.setMaxBitrate(Integer.parseInt(maxbitrate));
                }
            }
        } else {
            this.handle = Opus.decoder_create(fs, ch);
        }
        this.direction = dir;
    }

    @Override
    public int getBufferDepth() {
        return 2;
    }

    @Override
    public int getFrameSize(int fpp) {
        return super.getFrameSize(this.checkFrameSize(fpp));
    }

    @Override
    public int getFrameTime(int fpp) {
        return super.getFrameTime(this.checkFrameSize(fpp));
    }

    private int checkFrameSize(int fpp) {
        if (fpp < 2) {
            return 2;
        }
        if (fpp > 6) {
            return 6;
        }
        if ((fpp & 1) != 0) {
            return fpp / 2 * 2;
        }
        return fpp;
    }

    public void setMaxBitrate(int value) {
        Opus.encoder_set_bitrate(this.handle, value);
    }

    @Override
    public int encode(byte[] input, byte[] output) {
        int j;
        short[] pcm = new short[input.length / 2];
        int i = 0;
        for (j = 0; j < pcm.length; ++j) {
            pcm[j] = (short)((input[i++] & 0xFF) + (input[i++] << 8));
        }
        j = Opus.encode(this.handle, pcm, pcm.length, output, output.length);
        return j;
    }

    @Override
    public int decode(byte[] input, byte[] output) {
        short[] pcm = new short[5760];
        int result = Opus.decode(this.handle, input, input.length, pcm, pcm.length, 0);
        if (result < 0) {
            return result;
        }
        int j = 0;
        for (int i = 0; i < result; ++i) {
            output[j++] = (byte)(pcm[i] & 0xFF);
            output[j++] = (byte)(pcm[i] >> 8 & 0xFF);
        }
        return j;
    }

    public byte[] decodePLC(int pcmsamples) {
        short[] pcm = new short[5760];
        return this.pcm2bytes(pcm, Opus.decode(this.handle, null, 0, pcm, pcmsamples / 8, 0));
    }

    public byte[] decode(byte[] input) {
        short[] pcm = new short[5760];
        return this.pcm2bytes(pcm, Opus.decode(this.handle, input, input.length, pcm, 5760, 0));
    }

    private byte[] pcm2bytes(short[] pcm, int samples) {
        if (samples < 0) {
            return null;
        }
        byte[] output = new byte[samples * 2];
        int j = 0;
        for (int i = 0; i < samples; ++i) {
            output[j++] = (byte)(pcm[i] & 0xFF);
            output[j++] = (byte)(pcm[i] >> 8 & 0xFF);
        }
        return output;
    }

    public void finalize() {
        if (this.direction == 1) {
            Opus.encoder_destroy(this.handle);
        } else {
            Opus.decoder_destroy(this.handle);
        }
    }

    public static native long decoder_create(int var0, int var1);

    public static native void decoder_destroy(long var0);

    public static native int decode(long var0, byte[] var2, int var3, short[] var4, int var5, int var6);

    public static native long encoder_create(int var0, int var1);

    public static native void encoder_destroy(long var0);

    public static native int encode(long var0, short[] var2, int var3, byte[] var4, int var5);

    public static native int encoder_set_bitrate(long var0, int var2);

    public static native int encoder_set_complexity(long var0, int var2);

    public static native int encoder_set_dtx(long var0, int var2);

    public static native int encoder_set_inband_fec(long var0, int var2);

    public static native int encoder_set_packet_loss_perc(long var0, int var2);

    public static native int encoder_set_vbr(long var0, int var2);

    public static native int encoder_set_vbr_constraint(long var0, int var2);

    static {
        try {
            System.load(SignalProcessor.nativeLibraryPathPrefix + "opuscodec" + SignalProcessor.nativeLibrarySuffix);
            ResourceStore.syslog("Init codec Opus : " + SignalProcessor.nativeLibraryPathPrefix + "opuscodec" + SignalProcessor.nativeLibrarySuffix + " is loaded");
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            try {
                System.loadLibrary("opuscodec");
                ResourceStore.syslog("Init codec Opus");
            }
            catch (Throwable t) {
                System.out.println(t);
            }
        }
    }
}

